/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.string.hxx
 * Vers: 5.2    Time: 92/08/03, 15:42:30
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/*********************************************************************
* FILE
*	string.hxx - printable strings
*********************************************************************/

extern boolean matches(const char* rp, const char* sp);
		                        //Return true if sp matches the 
		                        //"regular expression" rp.
		                        //The only special char in rp is '*'
		                        //that matches all strings of 0 or
		                        //greater length.

char* nSpaces(sint16 n); 		//return a string of n spaces (max 120)

void bulletLine(Ostream& os, String bullet, String line, 
		sint32 indent, sint32 lineLength);
		                        //Insert bullet and line to os.
		                        //Max length of each output line is 
		                        //lineLength.  Each substring of line
		                        //is indented by indent spaces.
		                        //

boolean leftGreaterThanRight(const String& left, const String& right);
                                        //Return true if the 1st differing
                                        //character of 'left' and 'right'
                                        //is bigger in 'left'.  E.g.
                                        //leftGreaterThanRight("ABD","ABC")
                                        //is true.

/*********************************************************************
Implements a OTSO "string" class for printable strings.
NULL character terminates a string.
Nonprintable characters are not recommended for esthetic reasons.

.SH BUGS
operator[]: no range checking. 

Do not append a char to a string!

.SH MODIFICATIONS
*********************************************************************/

class String: public Object {
private:
  char*	  	    cp;                 //pointer to char table
  sint32            sz;                 //allocated length of cp
  sint32    	    maxLength() const	{return sz;}
			                //allocated length of char table;
                                        // >= length()
public:
  char&		    operator[](sint32 i) const;
                                        //i'th character. 0 is first.
                                        //No range checking. 
  String& 	    operator=(const String& r);
                                        //Deletes old value of this,
                                        //copies r here, returns *this.
  String&   	    operator+=(const String& r);
                                        //Appends r to this, returns *this.
  friend String	    operator+(const String& l, const String& r);
                                        //Returns a new String which is a copy
                                        //l appended by r.

  friend boolean    operator==(const String& l, const String& r);
                                        //True if equal lengths and all 
                                        //characters equal.
  friend boolean    operator!=(const String& l, const String& r)
                                        {return !(l == r);}
                                        //
  friend boolean    operator==(const String& l, char* r);
  friend boolean    operator!=(const String& l, char* r)
	                                {return !(l == r);}
#if 0
  friend boolean    operator==(const String& l, char  r);
  friend boolean    operator!=(const String& l, char  r)
	                                {return !(l == r);}
#endif

  sint32  	    length() const	{return strlen(cp);}
                                        //Current length of this 
                                        //String object (strlen).
  boolean 	    isEmpty();		//True if uninitialized or 0 length.

  void    	    print(Ostream&);
  void    	    ask(Istream&);
  void    	    to(ODump&);
  void    	    from(IDump&);
  String	    className() const;

  String	    withoutWhite();     //Returns a copy with white space
                                        //characters deleted.  The result is
                                        //as long as or shorter than *this.
  operator char*() const            	//type conversion from String to char*
                                        {return cp;}
  String(char* i);			//Copy a null-terminated string to this.
  String(const String& i);		//Copy i to this.
  String(sint32 length = 24); 	        //Construct an empty string.
                                        //Size of the allocated char table
                                        //is given optionally.
                                        //Useful when you roughly know the 
                                        //maximum length of the String but 
                                        //build the String little by little
                                        //starting from a short String.
 ~String();
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(String);
};

extern Ostream& operator<<(Ostream& os, char* s);
extern Istream& operator>>(Istream& is, char* s);
extern ODump&	operator<<(ODump& od, char* s);
extern IDump&	operator>>(IDump& id, char* s);
