/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.statobj.hxx
 * Vers: 5.1    Time: 92/08/03, 15:51:50
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


//	statobj.hxx	- Juha 18.3.92

/**********************************************************************
This file is the combination of 
 - statobj.hxx
 - numobj.hxx
 - statbool.hxx
**********************************************************************/

//#include "tree.hxx"
//#include "simres.hxx"
//#include "object.hxx"
//#include "sampcohg.hxx"


/******************** statobj.hxx **************************/

class SimCtrl;
class SimExp;
class SimObs;
class SampledContHg;

extern SimCtrl	simCtrl;
extern boolean	simCtrlInited;

/**********************************************************************
All the classes for which there is a need to gather statistics
under a simulation experiment are derived from class StatObj.
This class defines some virtual functions for the derived class
to implement.
**********************************************************************/

class StatObj {
private:
	boolean		countExp;
	SimCtrl*	ctl;
	SimExp*		expOfCurObs;
	SimObs*		curObs;
protected:
	boolean		simExpActive;	//
public:
	SimCtrl*	simCtrl()	 { return ctl; }
	virtual void	countSimExp(boolean b = true);
	boolean		countSimExpSet() { return countExp; }
	virtual void	startSimExp();
				// initialization of statistics in the
				// beginning of a simulation experiment
	virtual void	finishSimExp();
				// actions for the end of a simulation
				// experiment
	virtual SimObs*	createSimObs();
				// creation of a simulation observation
				// object
	SimObs*		getSimObs();

	StatObj&	operator=(const StatObj&); 
	                        //cc compilation problem "STASG" fix?
	StatObj(const StatObj& i);
	                        //default behaviour + adds this to list
	                        //of StatObjs
	StatObj();		//adds this to list of StatObjs
	virtual ~StatObj();
};


/******************** numobj.hxx **************************/

class SampledCont;

/**********************************************************************
Class NumObj could be useful as a base for such classes as Int or Boolean. 
It defines basic numeric operations like value() and operator=(),
and implements the gathering of statistics in the simulation environment.
At this moment, class has only been used to implement the RunStatus class.
Notice, how nicely the statistics can be gathered:
Whenever we change e.g. the runStatus, we just use line
.nf

	runStatus = RunStatus::enabled;

.fi
without any explicit updating of statistics, which is done
inside the operator=().
**********************************************************************/

class NumObj

#if SIMULATING
	    : public StatObj
#endif
{
private:
	boolean		counting;
	double		val;
	boolean		ownScp;
	SampledCont*	scp;
public:
	NumObj(const NumObj&);			//Juha added
	NumObj& operator=(const NumObj&);	//Juha added

	NumObj(SampledCont* scp_ = 0);
	~NumObj();
	double	value()	{ return val; }
	void	operator=(double d);
	void		setSampledCont(SampledCont* scp_);
	SampledCont*	sampledCont()	{ return scp; }
#if SIMULATING
	redefined void		startSimExp();
	redefined void		finishSimExp();
	redefined SimObs*	createSimObs();
#endif
};

#if SIMULATING

class SONumObj: public SimObs {
private:
	SampledCont*	scp;
public:
	SONumObj(NumObj* nop);
	~SONumObj();
	SampledCont*	sampledCont()	{ return scp; }
protected:
	SONumObj(const SONumObj&);		//don't use
private:
	void operator=(const SONumObj&);	//don't use
};

#endif


/******************** statbool.hxx **************************/

/**********************************************************************
The StatBool is a boolean class with statistics gathering. 
It has only been used to test some
ideas connected with the NumObj class. Perhaps we should have
the Boolean class derived from NumObj ?
**********************************************************************/

class StatBool: public NumObj {
friend class SOStatBool;
private:
	boolean		val;
	SampledContHg*	schp;
public:
	StatBool();
	~StatBool();
	boolean	value()	{ return val; }
	void	operator=(boolean b);
#if SIMULATING
	redefined SimObs*	createSimObs();
#endif
	StatBool(const StatBool&);		//Juha
	StatBool& operator=(const StatBool&);	//Juha
};

#if SIMULATING

class SOStatBool: public SONumObj {
public:
	SOStatBool(StatBool* sbp) : SONumObj(sbp) {}
	double	perCentOfValue(boolean b);
	redefined void	print(Ostream& os);
private:
	SOStatBool(const SOStatBool&);		//don't use
	void operator=(const SOStatBool&);	//don't use
};

#endif


