/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.runner.hxx
 * Vers: 5.3    Time: 92/08/14, 10:54:37
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
*	FILE runner.hxx
**********************************************************************/

typedef Process Memory;
class ObjectPtr;

// *MJS* from message.hxx
typedef sint32 MsgId;
typedef void* ReturnValue;		//used to be Object*
const sint32 MAX_MSGS_WAITED = 16;	//?

const sint16 MAX_CHILDREN = 16;         // *MJS*

/******************************************************************
RunnerTrace stores the trace settings of a Runner.
Each attribute tells if a piece of trace is printed or not.
******************************************************************/

class RunnerTrace: public Object {
public:
  boolean 	running;		//
  boolean 	variablesBefore;	//
  boolean 	receiving;		//
  boolean 	inputParameters;	//
  boolean 	actions;		//
  boolean 	sending;		//	
  boolean 	outputParameters;	//
  boolean 	variablesAfter;		//
  boolean 	verbose;		//

  virtual async allOn();		//Set all tracing on.
  virtual async allOff();		//Set all tracing off.
  virtual async setDefault();		//Set default tracing on.

  void		print(Ostream&);
  void		ask(Istream&);
  String 	className() const;
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(RunnerTrace);
  RunnerTrace();
  ~RunnerTrace();
};

DECLARE_OTSO_PAED_FOR_OTSO_OBJECT(RunnerTrace);

/**********************************************************************
RunStatus *MJS*
**********************************************************************/

//#include "numobj.hxx"
//#include "sampcohg.hxx"

class RunStatus

#if (SIMULATING || STATISTICS) 
               : public NumObj 
#endif

{
  friend class SORunStatus;
public:
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(RunStatus);

  enum RunStatusValue {
	idle = 0,
	enabled,
	blocking,			//this was added for class Vthread
	running,
	_lastRunStat
  };

//RunStatusValue	value()			{ return val; }
  operator RunStatus::RunStatusValue()		{return val;}
                                    //Defines a type conversion from RunStatus
                                    //to RunStatusValue, I presume. KV
  void operator=(RunStatus::RunStatusValue v);	
                                    //The operator= automatically causes the
                                    //collection of statistics about the
                                    //change in RunStatus object.See comment
                                    //for class NumObj. KV
  void operator=(const RunStatus& v);		//?

#if SIMULATING
  redefined SimObs*	createSimObs();
#endif

  RunStatus();
  RunStatus(RunStatus::RunStatusValue i);	//added by Juha
  RunStatus(const RunStatus&);			//added by Juha
 ~RunStatus();

private:
  RunStatusValue	val;
#if (SIMULATING || STATISTICS)
  SampledContHg*	schp;
#endif
};

#if (SIMULATING || STATISTICS)

class SORunStatus: public SONumObj {
public:
	SORunStatus(RunStatus* rsp) : SONumObj(rsp) {}
	double	perCentOfValue(RunStatus v)
			{ return ((SampledContHg*) sampledCont())->perCentOfSimilar((double) v); }
	redefined void	print(Ostream& os);
};

#endif

#if 0
/************************************************************************
This goes to the OTSO prepro only.  
This is a part of command interpreter implementation.
************************************************************************/
interface class RunnerTrace: public Object {
public:
  boolean 	running;		//
  boolean 	variablesBefore;	//
  boolean 	receiving;		//
  boolean 	inputParameters;	//
  boolean 	actions;		//
  boolean 	sending;		//	
  boolean 	outputParameters;	//
  boolean 	variablesAfter;		//
  boolean 	verbose;		//
  virtual async allOn();		//Set all tracing on.
  virtual async allOff();		//Set all tracing off.
  virtual async setDefault();		//Set default tracing on.
};
#endif

/*Stuff needed to generate command interpreter for inQ()*/
typedef Group* GroupPointer;
DECLARE_OTSO_PAED_FOR(GroupPointer);

/*********************************************************************
RunnerSP declares the part of Runner services that are visible to
command interpreter.
**********************************************************************/

#if 0
interface 
#endif 

class RunnerSP { 
public:
  virtual void run() = 0;	//Activates this to perform actions.
  virtual void run1() = 0;	//Activates this to handle one event.

  enum RunnerPriority {
    highRunnerPriority 		= 0,
    defaultRunnerPriority 	= 1,
    lowRunnerPriority		= 2,
    runImmediately		= 200 
  };

  virtual void setPriority(RunnerSP::RunnerPriority priority) = 0;
                                //Set the priority.

/*************************
  //Time& and Runner* cause a headache for prepro. Fix later!?
  virtual Time& time() = 0;	//Current time; real or virtual.
				// *MJS* changes started - jfr!
  virtual void delay(Time d, Runner* r) = 0;
                                //Simulate the elapsing of time;
                                //turn clock forward.
				// *MJS* changes started - jfr!
*************************/ /* */
  virtual async timeout(sint32 id) = 0;
public:
                                //Timer 'id' has expired.
  RunnerTrace trace;  		//Controls the amount of output that is printed
                                //when this is activated.
  RunnerPriority priority_;	//Scheduling priority in priority queue.
  RunStatus runStatus;		//Scheduling permission
  GroupPointer iQ;		//Queue of input events (Runners, messages).

  /*$OTSO_OFF*/
  RunnerSP& operator=(const RunnerSP& r);
                                //The default behaviour.  Written
                                //explicitly to ensure correct behaviour.
  /*$OTSO_ON*/
  RunnerSP();			//
  RunnerSP(const RunnerSP& r);
                                //The default behaviour.  Written
                                //explicitly to ensure correct behaviour.
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(RunnerSP);
};

DECLARE_OTSO_PAED_FOR(RunnerSP);

class ObjectPtr;
class RunnerPtr;


/**********************************************************************
Runners can be activated for unspecified purposes, or "run".
Running means that Runners are given 
execution time to perform their own local actions.
A Runner often has an input Group for buffering input messages.
Messages are given to Runners through the runOrQueue(Message) operation.

The class Runner gives a default implementation in addition to the
general interface to Runners.  The runOrQueue() operation puts the
message into the input queue if there is one, otherwise processes the
message immediately. Also a high priority may cause the message to be
run immediately. The default run() operation takes one message from
the input queue and runs it.

A single operating system process will probably have many Runners. 
Runners may provide asynchronous services: service requests may be
packaged in messages, inserted into input queue and handled later
when the Runner is run.

A "Scheduler" is a type of runner, and it's Scheduler::run() 
controls execution of other runners in the scheduler's input queue.

A Runner is given execution time if it is "enabled", for example when
it has at least one "event" to be handled.
An event is itself a Runner, usually a message or a derived Runner. 
The base class Runner::run() can be used for handling messages 
in its input queue.
Another example of an event is that something has occured 
on a device associated with the runner that needs handling.
In this case, the runner is probably a derived Runner, and has
it's own unique run() function to handle the device (e.g. see
Istream::run()).

.SH IDEAS

Priorities: 
defaultAsyncMessagePriority = 30, 
defaultParallelMessagePriority = 50
defaultValueMessagePriority = 70,
runWhenEnabled = 100,
enablePriority = 150,
runIfNotRunning	= 170.

.SH BUGS

.SH MODIFICATIONS
**********************************************************************/

class Runner: public NamedObj, public RunnerSP

#if SIMULATING
  , public StatObj              //if SIMULATING
#endif

{
  friend class SORunner;
  friend class Message;		//sync.comm.

/****************
.SH Running
****************/
public:

  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(Runner);

  virtual void	run();		//Activates this to perform actions.
                                //The default run() gets the next Runner
                                //(usually a message) from inQ and handles
                                //(runs) it.
                                //There is no way to pre-empt a run() function.
                                //If it goes into an infinite loop, 
                                //nothing will stop it. Control is returned to
                                //the scheduler when run() returns.
  virtual Group* inQ() const;
                                //An input queue, i.e. 
                                //a container of received events (Runners) to 
                                //be handled later in run().  
                                //Group is not always a Fifo, it may be
                                //Lifo, round-robin etc.  See class Group.
                                //inQ() also determines if this wishes to 
                                //receive service requests as messages
                                //(inQ() != 0), or as direct function
                                //calls (inQ() == 0).
  virtual void	setInQ(Group* q);
                                //Set input queue iQ.
                                //Virtual because of VThread (?).
private:
  friend class Scheduler;	//for efficiency: iQ is read in scheduling loop
  /* */ //Group*	iQ;		//input queue

public:
  virtual void	runOrQueue(Runner& event);
                                //Gives an event for this.
                                //Specifies actions performed this
                                //(the receiver) when receiving an input
                                //event.
                                //This will either
                                //put the event on the inQ() to be handled
                                //later,
                                //or handle the event immediately 
                                //(event->priority >= runImmediately).
                                //Requests scheduling, if inQ was empty.
private:
  virtual void requestScheduling();
				//ask myScheduler() to run this sometimes
public:
  void sendOrQueue(Message& msg);
                                //Actions performed by the sender after 
                                //building an output message msg.
                                //This checks if its ok to send msg to the
                                //destination, or if msg should be for example
                                //put into output queue.
  virtual void run1();		//Activate this to handle one event; by default
                                //the same as run(). The main usage is 
                                //in Scheduler's command interpreter interface.
  virtual void rerun();         // *MJS*
                                //This is called when this Runner is run
                                //recursively.  This is used in synchronous
                                //communication (see also classes Message
                                //and Scheduler).
#if SIMULATING
  virtual VThread* vThread();
                                // *MJS*
                                //Returns the VThread under which this 
                                //(application object) is running.
                                //Useful only when simulating, otherwise
                                //returns 0.
                                //At this moment, every application object 
                                //belongs to one vthread in the simulation 
                                //environment. If two application objects 
                                //residing in different vthreads communicate 
                                //and these vthreads operate under
                                //different virtual address spaces, 
                                //then the message has to be delivered using
                                //the virtual connection between the vthreads.
                                //
#endif
  Runner* myScheduler() const;
                                //Returns the object from which this requests 
                                //scheduling.
  Process*& process() const;
                                //The memory space that this resides in.
protected:
  Runner*       myScheduler_;//
  Memory*  	myMemory_;	//

public:

  /* */ //RunStatus runStatus;		//Tells the current execution state.
                                //Controls if myScheduler() is allowed to run
                                //this or not.
                                //
                                //'idle': This is not currently active.  
                                //In the default Runner implementation,
                                //runStatus is 'idle' when there are
                                //no messages in inQ().
                                //
                                //'enabled': myScheduler() is allowed to run 
                                //this.  In the default Runner implementation,
                                //this is
                                //true when at least one Runner in inQ().
                                //
              			//'running': An operation has begun but 
                                //has not been not completed,
                                //e.g. waiting for a synchronous return value.
                                //In the default Runner implementation,
                                //runStatus is 'running' run() is being 
                                //executed.
                                

/***************
.SH Priority
***************/

public:

  RunnerSP::RunnerPriority priority() const
                                {return priority_;}
                                //The "urgency" of this.  Priority matters
                                //in priority queues, high priority may even
                                //cause immediate handling without queuing
                                //(priority == 'runImmediately').
                                //If myScheduler()->inQ() is a PriorVec,
                                //priority() tells which Group
                                //of PriorVec this will go to.

  void		 setPriority(RunnerSP::RunnerPriority p)
                                {priority_ = p;}
                                //Sets the priority.  Determines the queue
                                //of PriorVec that this goes to.
                                //Check that someone puts someone puts this
                                //back to the queue at a proper time,
                                //if this comes out of the queue.
                                //See also class Message.
private:
  /* */ // RunnerSP::RunnerPriority priority_;

/******************
.SH Time and Simulation
******************/
public:
  virtual async timeout(sint32 id);
  virtual Time& time();		//Returns the current time; real time in real
                                //systems, virtual time in simulation 
  virtual void	delay(Time d, Runner* r = 0);
                                //Consume d units of virtual time in a 
                                //simulation application.
                                //Does nothing in real systems.
                                //r == ?
				// *MJS*
                                //Should be non-virtual inline empty
                                //if not SIMULATING ?.
/*********************
.SH *MJS* Simulation.  Too many public?
*********************/
#if SIMULATING
  redefined void 		countSimExp(boolean b = true);
  redefined void		startSimExp();
  redefined void		finishSimExp();
  redefined SimObs*		createSimObs();

  virtual void startIDel();     
                                //Starts the implicit delay counting.
  virtual void stopIDel(const String& m);
                                //Stops the implicit delay counting.
                                //String m is used for tracing purposes.
                                //
                                //
#endif
  virtual Runner& schedules(Runner* r1  , Runner* r2 = 0, Runner* r3 = 0,
			    Runner* r4=0, Runner* r5 = 0, Runner* r6 = 0);
				//this will be parameters' myScheduler
                                //(see simulation documents)

  virtual void schedule(Runner* r);
                                //
  virtual void initScheduling(Runner* myScheduler);
                                //myScheduler uses this function to initialize
                                //scheduling in its schedules(). ?
  virtual void setMinTimer(Time t); // *MJS*
  virtual Time& getMinTimer();	// *MJS*

  Runner* execRunner;           // *MJS*
                                //Points to the Runner currently run by this.
#if SIMULATING
  boolean useImplDelay;         // *MJS*
                                //Tells if the implicit delay counting
                                //for this Runner is on.
private:
  Time iDelStart;               // *MJS* Time when this started counting
                                //implicit delay.
  boolean counting;             // *MJS* Used in statistic gathering.
public:
  Time toQueue;                 // *MJS*
                                //Time when this was put into the input queue
                                //of another Runner.  Used for calculating
                                //Group statistics.

#endif

protected:
 Runner* children[MAX_CHILDREN];// *MJS*, simu only?
                                //Pointers to children (run by this?).
                                //Class Scheduler touches these variables.
                                //The implementation should be dynamic?.
  uint16 childCount;            // *MJS*, simu only?
                                //

/****************
.SH Return values
*****************/

  virtual MsgId getMsgId();	//
  virtual ReturnValue getReturnValue(MsgId);
                                //
  virtual void setReturnValue(MsgId i, ReturnValue retVal);
                                //
  virtual void suspend();
  virtual void wakeup(Runner* rp);

/****************
.SH Tracing
****************/
public:
  virtual void 	print(Ostream&);//Print name and contents.
  virtual void 	printNameFromTo(Ostream& os); 
                                //Print name and 
                                //for Messages source and destination.
                                //Less verbose than print().
/* */ //RunnerTrace 	trace; 		//What trace is printed when this is run.
private:
  static char	*mybanner;	//shared banner
  void		bannerIt(Ostream&, char*);

/***************
.SH Sync.comm. (should go to Scheduler?)
***************/
protected:
  sint32	numberOfSuspendedMessages;
  MsgId		receivedMessageId;
  virtual Message*&     suspendedMessage(MsgId id);	//?
  virtual void  runUntilIsReturnMsg(Message* m);

/****************
.SH Miscellaneous
****************/
public:
  static Runner* lastConstructedRunner;
                                //the Runner created latest
  virtual boolean greaterThan(Runner&);
  String className() const;

  Runner& operator=(const Runner& r); 
                                //The default behaviour.  Written
                                //explicitly to ensure correct behaviour.
  Runner(Group* i = 0);         //i is input queue inQ() for buffering input
                                //Runners, typically messages. 
                                //0 => no messages, direct function call.
  ~Runner();			//explicit => not inline.
                                //inQ() is NOT deleted, because constructor 
                                //does not allocate it.
                                //The one who allocates inQ() should also 
                                //delete it.
};

DECLARE_OTSO_PAED_FOR(Runner);

extern Runner dummyRunner;



/*********************************************************************
otsoRunnerPriority(Runner*) returns Runner::defaultRunnerPriority.
If other priority is needed for a DerivedRunner,
define otsoRunnerPriority(DerivedRunner*).
The priority of OTSO generated messages is set in each message constructor.
*********************************************************************/

extern RunnerSP::RunnerPriority otsoRunnerPriority(Runner*);

/**********************************************************************
*MJS*
SORunner
**********************************************************************/

#if (SIMULATING || STATISTICS)

class SORunner: public SimObs {
public:
  String		rName;
  SORunStatus*		runStatus;
  SOGroup*		rInQ;
  virtual void		print(Ostream& os); //This is the interesting function
                                        //in SORunner. It prints the statistics
                                        //of Runner to os.
  SORunner(Runner* r);
 ~SORunner();				//makes compiled code smaller
};

#endif

/**********************************************************************
A "Scheduler" is a type of runner, and it's Scheduler::run() 
controls execution of other runners (element runners).
There is one (main) Scheduler in each real process; its name is "scheduler".

If a runner is enabled, and the runner is to be executed, the
scheduler calls the runner's run() function.  The scheduler is
always enabled and should itself run (even if nothing else does).

The list of objects on a scheduler's inQ are Runners to be run.
Some Runners request scheduling and insert themselves into their scheduler's
inQ when they receive events to be processed.
Some Runners should be inserted into the inQ at system initialization time.
The scheduler gets Runners from its input queue, and runs the
ones that are enabled.  

The type of inQ used by the scheduler
is important.  If it is a Fifo, for example, when it gets
the next Runner, the Runner disappears from the 
scheduler's inQ.
This is because Fifo::get() removes the Runner from the queue.
If the inQ is a Ring, however get() operation doesn't remove the
the Runner from the Ring.  A Ring is a permanent list of
Runners to be run therefore.  If a Runner is inserted to the scheduler's
inQ at initialization time, it most likely should go to a Ring in order
to be run more than once.

.SH EXAMPLES
.nf
 main() {
   ...
   Derived_Runner_Class my_runner1, my_runner2;
   scheduler = new Scheduler;
   Ring* r = new Ring;
   r->ringPut(&my_runner, &my_runner2);
   scheduler->setInQ(r);
   scheduler->run();      //round-robin between my_runner1, my_runner2
 }
.fi
**********************************************************************/

class Scheduler : public Runner {

  friend class Message;

/******************
.SH Simulation *MJS*
******************/
  friend class SOScheduler;
private:
  Time		minTimer;
  Time 		started;
  sint16	recLevel;	//Recursion level (synchronous communication).
  Runner* 	suspRunners[MAX_MSGS_WAITED];
  boolean 	calcImplDel;

/******************
.SH Running
******************/
public:
  virtual void	run();          //Runs the inQ() Runners until the last
                                //synchronous "slow" message returns.
  virtual void  rerun();	// *MJS*
  virtual void	run1();		//Activate this to handle one event: get()
                                //and run() one enabled Runner, then return.
  virtual void  schedule(Runner* r);

/****************
.SH Return messages, Synchronous communication.  
****************/
protected:

  Message*	suspendedMessages[MAX_MSGS_WAITED];
                                
public:
  virtual Message*&     suspendedMessage(MsgId id);
  virtual void  runUntilIsReturnMsg(Message* m);
                                //Runs like run() but returns when m has
                                //become a return message (it has received
                                //an answer to a synchronous call).
  /* */
  virtual MsgId getMsgId();
  virtual ReturnValue getReturnValue(MsgId);
  virtual void setReturnValue(MsgId i, ReturnValue retVal);
  virtual void wakeup(Runner* rp);

/*******************
.SH Simulation
*******************/
#if SIMULATING
  virtual VThread* vThread();
  void calcImplDelays(boolean b)
                                {calcImplDel = b;}
  boolean& calcImplDelays()
                                {return calcImplDel;}
                                //& ?
#endif

#if (SIMULATING || STATISTICS)
  virtual void countSimExp(boolean b = true);
  virtual SimObs* createSimObs();
#endif

/********************
.SH Miscellaneous
********************/

#if 0
  Time& time();			//Current real time.
#endif

  virtual void     setMinTimer(Time t);	// *MJS*
  virtual Time&    getMinTimer();	// *MJS*
  virtual void 	   print(Ostream& os);

  String className() const;

  Scheduler();

  Runner*	   blockedRunner;	//1 per recursive call,
                                        //not 1 per Scheduler !?
  Runner*	   enabledBlockedRunner;//was blocked, now enabled
};

extern Scheduler* scheduler;	//The default global scheduler used
				//in OTSO's main() to begin running
				//other runners.

/**********************************************************************

**********************************************************************/

#if (SIMULATING || STATISTICS)

class SOScheduler: public SORunner {
public:
  SORunner*      	children[MAX_CHILDREN];
  uint8		        childCount;
  SOScheduler(Scheduler* s);
  redefined void        print(Ostream& os);
};

#endif

/**********************************************************************
A temporary object, sitting on top of instances of 
any type for which OTSO interface has been defined.
Objectifier is a kind of converter between 
the OTSO Object interface and the interface provided the type.

Objectifier Must be derived from Object.
Derived from Runner only because Objectifiers are put into Groups.
**********************************************************************/

class Objectifier: public Runner {
  void*		instance_;
  Object*	object_;
  Type*		type_;
  boolean	allocatedFromFreeStore_;	//?
  boolean	isMessage_;			//?
public:
  virtual void* otsoMostDerivedPointer();
  void  	setInstance(void*);
  Objectifier& 	operator+=(Offset offset);	//add offset to instance_ ?
  Object* 	object();
  void 		setObject(Object*);
  Type& 	otsoType();
  void 		setType(Type*);
  void		setIsMessage(boolean is);
  boolean	isMessage();

  Member 	runUI(Objectifier sp, String prompt, String memberName);
  void		print(Ostream& os);
  void		ask(Istream& is);
  void		printMsgs(Ostream* os, boolean help);
  String 	className() const;

  Objectifier&	operator=(const Objectifier&);
                                      //The default behaviour.  Written
                                      //explicitly to ensure correct behaviour.

                Objectifier(void* p, Type* type); //allocated from free store
                Objectifier(Object* o);		//not allocated from free store
};

extern Objectifier operator+(const Objectifier& o, Offset offset);
extern Objectifier nullOtsoObjectifier;

/**********************************************************************/


DECLARE_OTSO_PAED_FOR(RunStatus);

