/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.ring.hxx
 * Vers: 5.3    Time: 92/08/27, 11:33:16
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/******************************************************************
FILE ring.hxx
******************************************************************/

/*******************************************************************
A container class implementing a round-robin (a circular list) of GEs.
GE is Runner*.
This is a permanent Group: the elements in the the ring are supposed to 
stay there until the whole Ring is deleted; 
put() does NOT add elements, get() does NOT remove elements.
This is to avoid accidental misuse when used through a Group*.

Operation putAnyway() can be used to really add elements to the Ring
(in the initialisation),
and getAnyway to really remove elements from the Ring.

.SH BUGS
The permanent nature of Ring is clearly different from the other Groups.

******************************************************************/


class Ring: public Fifo 
                                //Implementation reuse only, 
                                //Ring implements Group service.
{
  void*		current;	
public:
  Group& 	myPut(const GE element);
                                //Does NOT add anything, returns *this.
  Group&	myGet(GE& element);
                                //Element will point to the "next" GE,
                                //does not remove the element from ring.
                                //Returns *this.
                                //The next get() gives a different element
                                //(if there are >1 elements in the Ring).
  void		reset();	//reset() all elements, but the elements
                                //remain in the Ring.  Dangerous if the 
                                //element's reset() deletes the element,
                                //which is the case for messages.

  virtual Group& putAnyway(const GE e);
                                //Insert a Runner* into this.
                                //No statistics gathering.
  virtual Group& getAnyway(GE& r);
                                //Extract a Runner* from this.
                                //No statistics gathering.
  Ring&         ringPut(const GE e);
                                //Obsolete, use putAnyway().
  virtual GE	first(GP&);
  virtual sint32 dynamicSize() const;
  String	className() const;
                Ring();
};


