/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.priorvec.hxx
 * Vers: 5.2    Time: 92/08/03, 15:42:19
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* FILE
*	priorvec.hxx
**********************************************************************/


/**********************************************************************
PriorVec is a priority vector of Runners. 
The number of priorities is fixed in the constructor 
by giving a certain number (1..5) of element Group pointers.
PriorVec elements are put into and get from the element Groups.

.SH BUGS
Iteration cannot be done concurrently, e.g. an iteration (first-next-over)
of a PriorVec inside another iteration of the same PriorVec instance
does not work (because of the shared currentGroup element).
**********************************************************************/

static const uint16 priorVecSize = 6;

class PriorVec: public Group {	

#if SIMULATING
friend class SOPriorVec;        // *MJS*
#endif

public:	
  virtual GE	  first(GP&);
  virtual GE	  next(GP&); 
  virtual Group&  myPut(const GE e);
                                //Add e to the Group selected by e->priority().
				// *MJS* changes - jfr!
  virtual Group&  myGet(GE& e);	//Remove one element from the highest-priority
                                //non-empty Group to e.
                                //e is &dummyRunner is all Groups are empty.
				// *MJS* changes - jfr!
  virtual Group&  getAnyway(GE& e);
  virtual Group&  putAnyway(const GE e);

  virtual sint32  dynamicSize() const;
  virtual void    print(Ostream& os);
  virtual String  className() const;

#if SIMULATING
  virtual SimObs* createSimObs();	// *MJS* changes - jfr!
#endif

                PriorVec(Group* g0,
			 Group* g1 = 0,
			 Group* g2 = 0,
			 Group* g3 = 0,
			 Group* g4 = 0); 
                                //Give as many arguments as you wish to have
                                //priorities.  Runners with priority 0 will
                                //go to the first argument Group,
                                //those with priority
                                //1 to the second argument Group etc.
                                //Maximum number 4 == priorVecSize - 2.
protected:
  Group*	gp[priorVecSize];//array of Groups that store the GEs
  sint16	currentGroupIndex;//Index of the element of gp that contains
                                 //the GE that was last returned in iteration.
};


#if SIMULATING
  // *MJS* added class SOPriorVec.
  class SOPriorVec: public SOGroup {
  private:
    String        gClassName;     // *E* gClassName is also in SRGroup
    SOGroup*      gp[priorVecSize];
  public:
    SOPriorVec(PriorVec* pvp);
    redefined void        print(Ostream& os);
  };
#endif


/**********************************************************************
FairPriorVec is a "fair" priority vector of Groups, 
breaking the strict priority every now and then.
This is partly a PriorVec, partly round-robin.
Elements are taken from lower-priority Groups 
even though higher-priority Groups have not exhausted.
The difference 1 in priority value doubles the frequency of 
checking the queue.
.SH BUGS
**********************************************************************/

class FairPriorVec: public PriorVec {
public:
  virtual Group&   myGet(GE& e);	// *MJS* changes - jfr!
  virtual Group&   getAnyway(GE& e);
  virtual String   className() const;
  FairPriorVec(Group* g0,
	   Group* g1 = 0,
	   Group* g2 = 0,
	   Group* g3 = 0,
	   Group* g4 = 0);	//4 == priorVecSize - 2
private:
  sint32	   turn;	//counter, the queue which
                                //is used next depends on turn.
};

/********************************************************************
Heap is an Runner container, a kind of priority queue - it is suitable
for putting Runners in any order and getting the biggest one anytime.
In other words, get() gives the element that is 'greaterThan' all the 
other elements.  'greaterTran' is a virtual function in Runner.
Only Runners that can compare each other with the `greaterThan' 
may be put into one Heap.

.SH BUGS
Print shows the elements in an incorrect order.

Maybe a.greaterThan(b) should be true if a.priority() < b.priority()
by default.

.SH MODIFICATIONS
Updates for simulation version: rm(), heapify() added; argument for adjust().
**********************************************************************/


class Heap: public Group {
public:
  Group&	myPut(const GE e);      // *MJS* changes - jfr!
  Group&	myGet(GE& e); 		// *MJS* changes - jfr!
  virtual Group& rm(const GE e);        // *MJS* changes - juha!
                                        //Remove the given e from heap.
  boolean	isEmpty();
  GE		first(GP&);
  GE		next(GP&);

  void        	print(Ostream& os);
  String	className() const;
                Heap();
               ~Heap();
private:
  GE*		a;		//1..(n-1) in use
  sint32	n;		//first free slot in a
  void		adjust(sint32 i);       // *MJS* changes - jfr!
  void          heapify();              // *MJS* changes - jfr!
  GE		heapElem(sint32 index)
                                {return a[index];}
  Heap(const Heap&);		//don't use
  void operator=(const Heap&);	//don't use
};

