/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.namedobj.hxx
 * Vers: 5.2    Time: 92/08/03, 15:42:14
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/*********************************************************************
* FILE  namedobj.hxx
**********************************************************************/

/*********************************************************************
OTSO takes care of location transparency of NamedObjs.
All NamedObjs defined in the system logical structure definition 
have a global name that is visible in the whole system no matter what
the process structure is.
The names of NamedObjs are collected to a directory namedObjs.

Bare Objects respond to name() by returning their className.
(We don't want every Object instance to contain a pointer to a name string.)
Their setName() does nothing.
When a proper name is needed, NamedObj should be used.
NamedObjs own a name String and they get a name by NamedObj::setName().

.SH BUGS
Tied to DynDir* namedObjs => not very reusable.  

.SH SEE ALSO
class DynDir
**********************************************************************/


class NamedObj : public Multi {
  friend class DataMember;
  friend class PublicBaseClass;
  friend class MethodMember;	//memberObject2
  friend class DynDir;		//Reads name_ in DynDir::pointer().
                                //This is a matter of efficiency.
public:
  void		    setName(char*);
  void		    setName(const String& name);
                                //This will have the given name.
                                //Inserts this into namedObjs.
  virtual String    name() const;
                                //The name given by setName();
                                //className() if no name given.

#if SIMULATING
  virtual VThread* vThread();	//See class Runner.
                                //Needed also here for simu UI.
#endif
  virtual void	    print(Ostream&);
  virtual void	    ask  (Istream&);

  virtual String    className() const	
                                {return "NamedObj";}
  NamedObj();
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(NamedObj);

private:
  String	    name_;
};

DECLARE_OTSO_PAED_FOR_OTSO_OBJECT(NamedObj);
