/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.message.hxx
 * Vers: 5.2    Time: 92/08/03, 15:42:10
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
 FILE message.hxx
**********************************************************************/

/**********************************************************************
Messages are packaged service requests (function calls) 
carrying the parameters of the call along with a service provider
pointer and a service user pointer.
Messages can be put into a queue to be handled later or
sent to a remote service provider (sp).
Messages can be created explicitly,
but usually they are created implicitly by agents.
Derived message classes are generated automatically by the OTSO prepro
for all the functions in interface classes.

Running a message invokes the packaged function call.
Message should be run only in the receiver's memory space.

.SH Priorities
Runner::priority() has an effect only in certain Group types 
such as (Fair)PriorVec, but not Fifo or Ring.  
Priorities, however, could be used also in
derived implementations of Runner::runOrQueue and Runner::sendOrQueue().

By default, messages have the priority RunnerSP::defaultRunnerPriority.
If you wish to have a different priority for all instances of 
a Message class M, define a otsoRunnerPriority() function:
.nf

  //file iface.hx
  interface class IFace {
  public:
    virtual void slowMsg() = 0;
    virtual void fastMsg() = 0;
  };


  //file IFACE.cx
  #include "iface.hxx"
  RunnerSP::RunnerPriority otsoRunnerPriority(IFace_fastMsg*) {
    return RunnerSP::highRunnerPriority; //or some other priority value
  }
  //...
  //generated code goes here ...

.fi
IFace_fastMsg constructors call an otsoRunnerPriority function.
Often there is no need to define a special priority,
so the message constructor gets the priority by calling 
otsoRunnerPriority(Runner*) that returns defaultRunnerPriority.
Another example can be found in /otso/demo/gamble/casinoSP.cx.
The priority of a single Runner instance can be changed by calling
setPriority(), but this is clumsy with messages.

.SH BUGS
Some of publics mbs should be protected/private.

Delay timeLeft for deadline scheduling (?)

**********************************************************************/

class Message : public Runner
{
  friend void Scheduler::run();	//
  friend void IDump::run();	//decodes half of Message
  friend void Runner::sendOrQueue(Message&);
                                //looks at isReturnMsg

public:

/***************
.SH Service user and Service provider
***************/

  Member runUI(Objectifier sp, String prompt, String methodName);
  Object*	source();	//
  Process*	sourceProcess();//
  String	sourceName() const;
                                //
  void		setSourceName(const String& n);
                                //
  Object* 	dest();		//
  Process*	destProcess() 	{
                                 if (isReturnMsg)
				   return agent()->sourceProcess();
				 else
				   return agent()->destProcess();
			        }
                                //

  void setSource(Object* o, Process* p=thisProcess, ConnectionId c=0);
                                //
  void setDest(Object* o, Process* p=thisProcess, ConnectionId c=0);
                                //Sets the receiver of the message
                                //(spObject) that can receive this. 
                                //o must be a Runner (?).
  virtual void setHandlerPart(void*);
                                //Sets the pointer to an instance that can run
                                //a message to a particular interface 
                                //(spInterface). 
                                //spInterface != spObject
                                //Derived Messages have a <interface>Ptr
  MsgId	id() const	        {return id_;}
                                //to get return value to the correct place
private:
  MsgId		id_;             //message identifier, unique in the sender's
                                //node, helps in routing return messages.
/***************
.SH Sending
***************/
public:
  virtual Message* send();      //Deliver this message.  Return 
                                //objectify(returnValue_), or 0 if void or 
                                //async message.
  ReturnValue	sendAndReturnAValue();
                                //Deliver this and wait for a return value.
  void		sendReturnValue(ReturnValue returnValue); 
                                //Deliver return value from the
                                //server to the service user.
  void		sendViaChannel();
                                //

/***************
.SH Return values
***************/

  virtual void 	suspend();
  Runner*	initiator();
  Runner*	responder();
  virtual void	wakeup(Runner* rp);

  virtual ReturnValue	returnValue();
                                //Points to return value if isReturnMsg.
                                //Redefined by derived messages that
                                //return sg else than "void" or "async".
protected:
  boolean	isReturnMsg;    //true if carries a return value 
  virtual MultiPtr* multiPtr() = 0; 
                                //XXXPtr of a derived message.
                                //Used when sending a return value.
  Type*		returnValueType_;
                                //The type of the return value

/***************
.SH Coding, printing
***************/
public:
  virtual Agent* agent();
  void		print(Ostream& os);
  void		ask(Istream&);
  void		printNameFromTo(Ostream& os);
                               //Prints the message name, source, and 
                               //destination, but not the parameters.

  void		printAndDelete(Ostream& os);
                                //Called when there is no receiver

  virtual void	to(ODump& od);
  virtual void	from(IDump& id);
  virtual void	outEncode(ODump& od);
  virtual void	outDecode(IDump& id);

/***************
.SH Miscellaneous
***************/
  String 	className() const;
  String 	name() const;
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(Message);

                Message();
	       ~Message();
};

DECLARE_OTSO_PAED_FOR(Message);		/*see inta.?xx*/

// *MJS*: Runner members instead of global variables
//??: Why not Scheduler members?
//
//extern sint32 msgsWaitedNow;
//extern ReturnValue returnMessages[MAX_MSGS_WAITED];
//extern Message* messagesWaitingForAReturnValue[MAX_MSGS_WAITED];
//extern MsgId receivedAnswerMsgId;
//extern boolean returnMsgConsumed[MAX_MSGS_WAITED];

inline void otsoOutEncode(ODump&, void*) {}
inline void otsoOutDecode(IDump&, void*) {}

