/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/lwp/SCCS/s.thread.hxx
 * Vers: 5.2    Time: 92/08/04, 12:45:23
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


  //Each lightweight process is represented by a procedure of type
  //ThreadFn, that will be converted into a thread.
typedef void(*ThreadFn)();


/**********************************************************************
A lightweight process is a thread of control not bound to an address space.
They are "light" in weight because they tend to operate more efficiently
ordinary UNIX processes.  The major reason for this increased efficiency
is that threads communicate through shared memory and not via the UNIX
filesystem.  Because threads share a common address space (inside a
single UNIX process for example), the costs of : creating tasks, performing
context switches between tasks, communication between tasks, etc is reduced.

Threads are particularly well suited for : asynchronous event servers, 
concurrent systems, models of concurrent systems, etc.

UNIX system calls that block can cause all threads to block.  Use
of the non-blocking I/0 library can provide some relief for this
type of problem.

*****************************************************************************/

class LwpThread {
  friend 	LwpPod;		     //Pod needs to look at tid

public:
  static LwpThread* runningInstance;
  static LwpThread* startingInstance;
  static LwpThread* stoppingInstance;
  thread_t	tid;
  boolean	isValid() const;     //a good thread ?
  static void	yield (LwpThread* starting = 0);

  LwpThread (ThreadFn body, Runner* rp = 0, int prio=MINPRIO);
                                     //Threads are run at minimum priority 
                                     //by default.
                                     //'rp' is the Runner that owns this; it
                                     //is used for tracing purposes if given.
 ~LwpThread ();
  void		print(Ostream&);

protected:
  ThreadFn	bodyFunction;
  boolean	create(ThreadFn=NULL, int prio=MINPRIO);
  boolean	valid;
public: /*?*/
  Runner*	runner_;
};


/*****************************************************************
A collection of threads runs within a single ordinary process
*****************************************************************/

class LwpPod {
#define MINSTKSZ	5000	/* arbitrary */
#define NUMSTKS		5	/* arbitrary */
#define MAXPRIO 10

public:
  int setPri (int maxprio=MAXPRIO);
  int getPri () const;

  LwpPod (int maxprio=MAXPRIO, int min=MINSTKSZ, int num=NUMSTKS);
  ~LwpPod () {}

protected:
  int     maxprio;
};


extern void defaultLwpRunnerBody();
extern void lwpVOPSBody();

/*******************************************************************
LwpRunner owns a thread of control.
run() switches to that thread, handles one message, 
and switches back to an unspecified thread.
********************************************************************/

class LwpRunner : public LwpThread, public Runner {
public:
  static LwpRunner* currentInstance;
  virtual void run();
  String className() const;
  LwpRunner (Group* q = 0,
	     ThreadFn fn = defaultLwpRunnerBody,
	     int prio = MINPRIO);
};


/*******************************************************************
LwpVOPS is a Scheduler that creates a new thread of control in run().
run() is typically called every time a synchronous message is sent
and it takes a while to get the answer message.

When LwpVOPS is used instead of the basic Scheduler,
a new thread is created instead of calling Scheduler::run() recursively.
This makes it possible to handle return messages in the order they are
received (in contrast to the LIFO order in the basic Scheduler).
********************************************************************/

class LwpVOPS : public Scheduler {
  friend void lwpVOPSBody();
public:
  static LwpVOPS* currentInstance;
  virtual void run ();
  virtual void print(Ostream&);
  String className() const;
private:
  LwpThread* suspendedThreads[MAX_MSGS_WAITED]; 
};
