/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/gend/SCCS/s.timerSP.hx
 * Vers: 5.2    Time: 92/08/04, 12:39:46
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


#ifndef TIMERSP_HXX
#define TIMERSP_HXX

/**********************************************************************
 FILE timerSP.hx
**********************************************************************/

typedef sint32 TimerId;
//in object.hxx: typedef sint32 Time;
//in object.hxx: typedef Time Delay;

/**********************************************************************
This interface defines timer services for OTSO Runners.
The single timers are all handled by a timer service provider
such as TimerMan. Only the TimerMan has access to the timers.
Runners using timers can access their timers through the 
services specified in this class. 

A TimerId (sint32) identifies a single timer unit.
create() returns a TimerId, which should be given for the other functions.

.SH BUGS

The time unit is currently a second.  The running time of a timer 
cannot be shorter than a second.

The owner of a timer, to whom the timeout is sent, must be an OTSO Runner.

.SH EXAMPLE
.nf

Runner aRunner;
TimerMan rolex;
TimerSPPtr myTimerSP = rolex;
TimerId id = myTimerSP->create(5, RunnerPtr(&aRunner, &aRunner));
myTimerSP->start(id, 10);

.fi
**********************************************************************/

/*interface*/ class TimerSP { public: DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(TimerSP); private: 
public:
  virtual TimerId create (Time waitFor, RunnerPtr owner) = 0;
                             //Creates a timer and returns its identifier.
                             //When started and not stopped, 
                             //the timer sends a timeout(identifier) to its
                             //owner after a delay.
                             //The initial delay is specified by 'waitFor'.
                             //The value of delay can be changed
                             //by start().

  virtual async	restart (TimerId id) = 0;
                             //Restart a timer (id) with its current delay.
/**********
  virtual async	start (
    TimerId id, uint32 waitForSec=0, uint32 waitForMicrosec=0
  ) = 0;
**********/ /* */
  virtual async start(TimerId id, double waitFor=0.0) = 0;
                             //Start a Timer (id).  'waitFor...' specifies
                             // the running time (i.e. delay) of the Timer.
                             // This delay is used until modified by another
                             // start() call.

                             //BUG: waitFor should be of type Time instead
                             // of double or uint32's, but default initializing
                             // of C++ object args not possible in Cfront 2.1. 

  virtual async	stop (TimerId id) = 0;
                             //Stops a timer.
  virtual async	kill (TimerId id) = 0;
                             //Deletes a timer unit.
  virtual Time	timeLeft (TimerId id) = 0;
                             //Returns the number of time units remaining
                             //before a timer expires and sends a timeout().
}; DECLARE_OTSO_PAED_FOR(TimerSP); 

#endif
#ifndef TimerSP_OTSO_HXX
#define TimerSP_OTSO_HXX

/**********************************************************************
  Generated by OTSO prepro for class TimerSP
**********************************************************************/

/******** _in, _out, _msg macros for function prototypes ********/
/* Do not use both _in and parameter format for one function */

#define create_in create(Time waitFor, RunnerPtr owner)
#define create_out create(waitFor, owner)
#define create_msg TimerSP_create(waitFor, owner)
#define restart_in restart(TimerId id)
#define restart_out restart(id)
#define restart_msg TimerSP_restart(id)
#define start_in start(TimerId id, double waitFor)
#define start_out start(id, waitFor)
#define start_msg TimerSP_start(id, waitFor)
#define stop_in stop(TimerId id)
#define stop_out stop(id)
#define stop_msg TimerSP_stop(id)
#define kill_in kill(TimerId id)
#define kill_out kill(id)
#define kill_msg TimerSP_kill(id)
#define timeLeft_in timeLeft(TimerId id)
#define timeLeft_out timeLeft(id)
#define timeLeft_msg TimerSP_timeLeft(id)

/*********** _interface macro *******************************/

#define TimerSP_interface\
  TimerId create_in; \
  async restart_in; \
  async start_in; \
  async stop_in; \
  async kill_in; \
  Time timeLeft_in

/*****************************************************************
TimerSP interface object class 
*****************************************************************/
class TimerSP_agent: public TimerSP, public Agent {
  friend class TimerSPPtr;
private:
  TimerSP* sPInterface_;
  virtual void setSPInterface(void* p); //if p==0, uses this
  TimerSP_agent(TimerSP* spI, Object* spO, Process* spP,
		Object* suO, Process* suP, Agent::AgentState s);
public:
  redefined TimerSP_interface;
  TimerSP* sPInterface();
  ~TimerSP_agent(); //?
  virtual String className() const;
};

/*****************************************************************
TimerSPPtr is a kind of pointer to an OTSO Object that implements
TimerSP.  It should be used instead of C++ a pointer (*) when
(concurrency-control or) messages are needed to provide support for
asynchronous message passing, tracing, or distribution.
TimerSPPtr is a "user interface" to TimerSP
interface objects (TimerSP_agent).  The agents contain pointers 
to the service provider (SP) and service user (SU) objects.
TimerSPPtr itself consists of two (?) pointers, so it is
not expensive to pass it as a pass-by-value argument in a function call.

Usage examples:
.nf
  SP sp;
  SU su;                  //contains TimerSPPtr ptr;
  su.ptr = sp;            //sp must have operator TimerSPPtr ()
.fi

TimerSP* alone is not enough to build a TimerSPPtr, 
so assigning a TimerSP* to an TimerSPPtr is not possible.
delete an TimerSPPtr is not possible!
C++ pointers should not be used in OTSO system logical description (*.str).

*****************************************************************/

class TimerSPPtr: public MultiPtr {
  friend class TimerSP_agent;
  friend class TimerSP_create;
  friend class TimerSP_restart;
  friend class TimerSP_start;
  friend class TimerSP_stop;
  friend class TimerSP_kill;
  friend class TimerSP_timeLeft;
private:
  TimerSP_agent* dap;
  TimerSPPtr(sint8);	//Used by messages.
			//No agent allocated, setAgent() must be called soon.
  void setAgent(TimerSP_agent*);
  void ifAgentIsSharedCreateANewOne();
public:
  TimerSP* operator->();
  operator TimerSP* ();
  TimerSPPtr& operator=(const String& spName);
  TimerSPPtr& operator=(const TimerSPPtr&);
			//SU part not changed!
  virtual String className() const;
  virtual Agent* agent();
  virtual void ask(Istream&);
  virtual void from(IDump&);
  TimerSPPtr();
			//Default constructor is used mainly by Runners that
			//have member Ptrs to other Runners.
			//By default SU is Runner::lastConstructedRunner.
			//If it is not ok, setAgent() should be called.
  TimerSPPtr(TimerSP* i, Object* o);
			//Called from implementation class
			//operator TimerSPPtr().
  TimerSPPtr(const Agent& sp);
			//Called in main() when sp represents a remote object.
			//NO type checking -- cannot guarantee that sp
			//implements TimerSP!!!
  TimerSPPtr(const TimerSPPtr&);
 ~TimerSPPtr();
};


/************** message class definitions *********/

/*****************************************************************
Creates a timer and returns its identifier. When started and not stopped,  the timer sends a timeout(identifier) to its owner after a delay. The initial delay is specified by 'waitFor'. The value of delay can be changed by start(). 
*****************************************************************/
class TimerSP_create: public Message {
  friend class TimerSP_agent;
private:
  TimerSPPtr otsoPtr;
  virtual Agent* agent(); //shares SU's TimerSPPtr's agent
  virtual void run();
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(TimerSP_create);
  /****** function arguments ******/
  Time waitFor;
  RunnerPtr owner;
public:
  TimerId returnValue_;
  Message* send();
  ReturnValue returnValue();
  virtual String className() const;
  virtual MultiPtr* multiPtr();
  virtual void outEncode(ODump&);
  virtual void outDecode(IDump&);
  TimerSP_create();	//called by Istreams; they must 
			//call setSource(), setSourceName() and setDest().
  TimerSP_create(Time waitFor, RunnerPtr owner); //called by TimerSP_agent
  ~TimerSP_create(); //?
};

DECLARE_OTSO_PAED_FOR_OTSO_OBJECT(TimerSP_create);

NewMsg* new_TimerSP_create(); //?

/*****************************************************************
Restart a timer (id) with its current delay. 
*****************************************************************/
class TimerSP_restart: public Message {
  friend class TimerSP_agent;
private:
  TimerSPPtr otsoPtr;
  virtual Agent* agent(); //shares SU's TimerSPPtr's agent
  virtual void run();
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(TimerSP_restart);
  /****** function arguments ******/
  TimerId id;
public:
  virtual String className() const;
  virtual MultiPtr* multiPtr();
  TimerSP_restart();	//called by Istreams; they must 
			//call setSource(), setSourceName() and setDest().
  TimerSP_restart(TimerId id); //called by TimerSP_agent
  ~TimerSP_restart(); //?
};

DECLARE_OTSO_PAED_FOR_OTSO_OBJECT(TimerSP_restart);

NewMsg* new_TimerSP_restart(); //?

/*****************************************************************
  Start a Timer (id).  'waitFor...' specifies  the running time (i.e. delay) of the Timer.  This delay is used until modified by another  start() call. BUG: waitFor should be of type Time instead  of double or uint32's, but default initializing  of C++ object args not possible in Cfront 2.1.  
*****************************************************************/
class TimerSP_start: public Message {
  friend class TimerSP_agent;
private:
  TimerSPPtr otsoPtr;
  virtual Agent* agent(); //shares SU's TimerSPPtr's agent
  virtual void run();
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(TimerSP_start);
  /****** function arguments ******/
  TimerId id;
  double waitFor;
public:
  virtual String className() const;
  virtual MultiPtr* multiPtr();
  TimerSP_start();	//called by Istreams; they must 
			//call setSource(), setSourceName() and setDest().
  TimerSP_start(TimerId id, double waitFor); //called by TimerSP_agent
  ~TimerSP_start(); //?
};

DECLARE_OTSO_PAED_FOR_OTSO_OBJECT(TimerSP_start);

NewMsg* new_TimerSP_start(); //?

/*****************************************************************
Stops a timer. 
*****************************************************************/
class TimerSP_stop: public Message {
  friend class TimerSP_agent;
private:
  TimerSPPtr otsoPtr;
  virtual Agent* agent(); //shares SU's TimerSPPtr's agent
  virtual void run();
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(TimerSP_stop);
  /****** function arguments ******/
  TimerId id;
public:
  virtual String className() const;
  virtual MultiPtr* multiPtr();
  TimerSP_stop();	//called by Istreams; they must 
			//call setSource(), setSourceName() and setDest().
  TimerSP_stop(TimerId id); //called by TimerSP_agent
  ~TimerSP_stop(); //?
};

DECLARE_OTSO_PAED_FOR_OTSO_OBJECT(TimerSP_stop);

NewMsg* new_TimerSP_stop(); //?

/*****************************************************************
Deletes a timer unit. 
*****************************************************************/
class TimerSP_kill: public Message {
  friend class TimerSP_agent;
private:
  TimerSPPtr otsoPtr;
  virtual Agent* agent(); //shares SU's TimerSPPtr's agent
  virtual void run();
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(TimerSP_kill);
  /****** function arguments ******/
  TimerId id;
public:
  virtual String className() const;
  virtual MultiPtr* multiPtr();
  TimerSP_kill();	//called by Istreams; they must 
			//call setSource(), setSourceName() and setDest().
  TimerSP_kill(TimerId id); //called by TimerSP_agent
  ~TimerSP_kill(); //?
};

DECLARE_OTSO_PAED_FOR_OTSO_OBJECT(TimerSP_kill);

NewMsg* new_TimerSP_kill(); //?

/*****************************************************************
Returns the number of time units remaining before a timer expires and sends a timeout(). 
*****************************************************************/
class TimerSP_timeLeft: public Message {
  friend class TimerSP_agent;
private:
  TimerSPPtr otsoPtr;
  virtual Agent* agent(); //shares SU's TimerSPPtr's agent
  virtual void run();
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(TimerSP_timeLeft);
  /****** function arguments ******/
  TimerId id;
public:
  Time returnValue_;
  Message* send();
  ReturnValue returnValue();
  virtual String className() const;
  virtual MultiPtr* multiPtr();
  virtual void outEncode(ODump&);
  virtual void outDecode(IDump&);
  TimerSP_timeLeft();	//called by Istreams; they must 
			//call setSource(), setSourceName() and setDest().
  TimerSP_timeLeft(TimerId id); //called by TimerSP_agent
  ~TimerSP_timeLeft(); //?
};

DECLARE_OTSO_PAED_FOR_OTSO_OBJECT(TimerSP_timeLeft);

NewMsg* new_TimerSP_timeLeft(); //?

#endif
