/**************************************************************
 *
 *  VALTION TEKNILLINEN TUTKIMUSKESKUS (VTT/TEL/TIV)
 *  Otakaari 7 B
 *  02150 Espoo
 *  FINLAND
 *
 *  OTSO Source Code Control System, 12.7.89
 *
 *  Name:	/home/users/otso/official/otso/dvops/gend/SCCS/s.timekeeper.hx
 *  Version:	1.1
 *  Time:	91/04/23, 10:06:37
 *
 **************************************************************/

#ifndef TIMEKEEPER_HXX
#define TIMEKEEPER_HXX

/**********************************************************************
* NAME	timekeeper.hx
*
* PURPOSE
*	Kirsi's TimerObj, TimerList, TimerMan classes for OTSO.
*	Used with TimerSP interface.
*	See individual comments below.
*
* MODIFICATIONS
*  - I took this from Kirsi's simpletimer.[ch]x files
*    This should replace the other OTSO timer files ???
**********************************************************************/

#ifndef OBJECT_HXX
#include "object.hxx"
#endif
#ifndef VOIDGROUP_HXX
#include "voidgroup.hxx"
#endif
#ifndef SYSTEM_HXX
#include "system.hxx"
#endif
#ifndef TIMERSP_HXX
#include "timerSP.hxx"
#endif


/**********************************************************************
* NAME	class TimerObj
*
* PURPOSE
*  TimerObj is meant to be used by the timer service provider classes.
*  The objects that use timer services should access services through the
*  TimerSP interface.
*
*  Timerobj is a data structure that represents a single timer. 
*  It has timer specific data elements: elapsing time, timer interval
*  and timer id. 
**********************************************************************/

class TimerObj : public Object {
public:
   String	className() const { return "TimerObj"; }
   void		print(Ostream& os);
   TimerObj (ObjectPtr owner, sint32 n=0, sint32 i=0);
                                 //Initializes the interval (=0) and
                                 //id (=0).  owner should be smart RunnerPtr.
   sint32 	elapsing;        //elapsing time
   sint32 	interval;        //timer interval before elapsing
   sint32	id;              //timer id
   ObjectPtr	owner;		 //The object whose timeout() this may call.
};



/**********************************************************************
* NAME	class TimerList
*
* PURPOSE
*  TimerList is a list structure containing TimerObj type items. TimerMan
*  timer service implementation uses this list to keep the single timers
*  in order.
*
*  TimerList is a lifo with certain extra characteristics. In addition to
*  getting the last-in-item with get() there is a remove() function which
*  gets an item specified by id. Also in addition to putting items with
*  lifo's put() there is function insert() which inserts the item
*  in the correct place ordered by the elapsing value.
**********************************************************************/

class TimerList : public VoidLifo {
public:
  String  className () const	 { return "TimerList"; }
  void 	  print (Ostream& os);
                                 // Prints the timerlist structure.
  sint32   readFirst ();
                                 // Returns the elapsing time of the
                                 // first timerobject.
  VoidGroup&  remove (TimerObj*& o, sint32 id);
                                 // Removes object specified by id from
                                 // the timerlist.
  VoidGroup&  insert (TimerObj *o); 	
                                 // Inserts in order by elapsing value
                                 // so that that first elapsing timer
                                 // is the first element in list.
};



/**********************************************************************
* NAME	class TimerMan
*
* PURPOSE
*  TimerMan implements a timer service for OTSO objects. The services
*  are available to OTSO objects through timerSP interface functions.
*  Only TimerMan can access the timer Objects in it's timerlists.
*
*  TimerMan is only one implementation of timerSP service. There could
*  be several implementations of timerSP offering real or virtual time
*  services. Several timer services can run in the same process
*  or also a timer service located in an other process could be used.
*
*  TimerMan is the first version of timer service implementation.
*  It simply keeps up two lists.  One for stopped timers and one for
*  running timers. The run function checks the current time and then
*  goes to see if any of the timer units in the list of running timers
*  has elapsed. If a timer has elapsed it is moved to the list of stopped
*  timers and timeout is sent to the object who owns that timerunit.
*
*  A second run function run2 exists for testing purposes. It makes it
*  possible to call the run function through the user interface. 
*  When a timer service user asks for creation of timer, a new 
*  instance of TimerObj class is made and put to the list of stopped
*  timers.
**********************************************************************/

/*implementation*/ class TimerMan : public TimerSP, public Runner { public: Member member(Channel&, char* = 0); NewMsg* newMsg(String& opName, void* handlerPart); void printMsgs(Ostream* output, boolean help); operator TimerSPPtr(); private: 
public:
  void   	run();	// checks the timerlist for elapsed timers.
  String 	className() const { return "TimerMan"; }
  void		print (Ostream& os);

  async		run2 ();
  async 	create (sint32 id, sint32 value, ObjectPtr owner);
  async 	start (sint32 id);
  async	        stop (sint32 id);
  async 	kill (sint32 id);

  TimerMan ();	// ctor: initilization of the TimerMan class.

private:
  TimerList	runList;
  TimerList	stopList;
};

#endif
#ifndef TimerObjAH
#define TimerObjAH

/**********************************************************************
  Generated by OTSO prepro for class TimerMan
**********************************************************************/

  /************** message class definitions *********/

#endif
