/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.frame.hxx
 * Vers: 5.2    Time: 92/08/03, 15:41:55
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* FILE
*	frame.hxx
**********************************************************************/

/**********************************************************************
Class FrameBlock is used for efficient I/O between files and Frames
without copying.

.SH EXAMPLES
Reading from file to Frame f at most n bytes without copying:
.nf

  FrameBlock fb(n);
  int nRead = ::read(fd, fb, i);
  Frame f(fb, nRead);

  oldFrame.putPrefix(f);

.fi

.SH BUGS 
*********************************************************************/

class FrameBlock {
  friend class Frame;		//Resets bytep in Frame::Frame(FrameBlock...)
private:
  FrameBlock(const FrameBlock&);	//don't use
  void operator=(const FrameBlock&);	//don't use
  Byte* bytep;
  sint32 size_;
public:
  operator Byte* () const;	//Returns a pointer to an array of 'n' bytes.
                                //'n' is given in constructor.
  sint32 size() const;		//max size, i.e. 'n' given in constructor.
  FrameBlock(sint32 n);		//Create a CVOPS DATA_BLOCK of 'n' bytes.
 ~FrameBlock();
};

/**********************************************************************
A Frame is a byte string of arbitrary length.
It hides the memory allocation problems from the user.
Frames are used for carrying binary data, usually encoded user and
protocol data, within the local system.  Most often,
Frames carry data from one protocol layer to another.

Frame is a OTSO object but closely related to the CVOPS FRAME.
Actually, a OTSO Frame object encapsulates a
CVOPS "FRAME struct".

This was necessary to re-use CVOPS/(Nokia CASN) source code 
in OTSO.  Please, don't ever use the fptr variable (CVOPS frame)
directly, it will be made into a "private" variable someday.

Efficient I/O from/to files: see class FrameBlock.

.SH WARNING 
Frame::operator= is not a true assignment operator.  It moves the
the FRAME, it doesn't copy it.  The same is true for Frame
constructors. This is to prevent multiple copies of Frames from
profiliferating like crazy.
The same is also true of the Frame constructor Frame(Frame&):
.nf

  Frame a(20);          -- 20 byte frame
  a.putPrefix('a');     -- add byte to Frame
  Frame b(a);           -- Constructs Frame b from Frame a, 
                        -- by MOVING Frame a to Frame b.

If you want to copy a into b, you need to say so explicitly.

  Frame b(a.copy());	-- Construct Frame b from Frame a, no move.
.fi

.SH BUGS

FRAME* fptr (the CVOPS FRAME) should be private

Juha: operator<< functions could be defined as an alternative (?) syntax
for putSuffix functions.  And each protocol with its own encoding
functions might define its own operator<< functions.
operator>> functions in the same way for decoding.
Therefore Frame should be an IOstream.

.SH MODIFICATIONS
Used to be derived from Ostream, 
but it was inefficient and somewhat misleading.
Actually Frame should inherit from IOstreamSP, but there is no such class.
**********************************************************************/



typedef signed int sint;

class Frame : public Object {
private:
  boolean isAsn;		//Is an ASN.1 Frame - pretty-printing 
				//purposes only.

public:
  FRAME  *fptr;

/**************
.SH Inserting bytes
**************/
  Frame& putPrefix(Bytes& prefix); 
                                //Puts Byte string onto front of this Frame.
                                //Moves bytes, does not copy.
				//Warning: DESTRUCTIVE to argument!
  Frame& putPrefix(Frame& prefix);
                         	//Put Frame (f) onto front of this frame,
				//i.e. combine frames, and empties Frame f.
                                //Moves bytes, does not copy.
				//Warning: DESTRUCTIVE to argument!
  Frame& putPrefix(Byte prefix);//Put one byte onto front of this Frame. 
                                //Use the other two putPrefix() functions
                                //rather than this whenever possible.
#if 0
  Frame& putSuffix(Byte);	//Put a byte onto end of this Frame --
				//Not Implemented.
  Frame& putSuffix(Bytes&);	//Put Byte string onto end of this Frame --
				//Not Implemented.
#endif

  Frame& putSuffix(Frame& f);	//Put Frame f onto end of this Frame, i.e.
				//combine Frames, empties Frame f.
				//Warning: DESTRUCTIVE to argument f!
/********************************
.SH Extracting and deleting bytes
********************************/
  Bytes  getBytes(sint sz);	//Removes sz bytes from front of this Frame
				//and returns the bytes.
                                //The resulting Bytes is 'sz' bytes long
                                //even if this had not that many bytes.
  Frame  getFrame(sint sz);	//Returns a split of sz bytes 
                                //from front of this Frame.
				//Inefficient.
  void   deleteBytes (sint sz);	//Remove sz bytes from front of this Frame.
  void   reset();		//Remove all bytes from this frame.
  FRAME * chop();		//Returns a pointer to the CVOPS FRAME, and 
				//removes the CVOPS FRAME from this Frame.

/**************
.SH Assignment
**************/
  Frame& operator=(Frame& f);	
                                //Takes bytes away from rhs and gives them
				//to this.  No copying.  
				//Previous value of this Frame is deleted.
				//Warning: rhs will get empty!
  Frame& operator=(Bytes& rhs);
                                //Takes bytes away from rhs and gives them
				//to this.  No copying.  
				//Previous value of this Frame is deleted.
				//Warning: rhs will get empty!

/*************
.SH Copying bytes
*************/
  Frame copy();		     	//Return a copy of this frame.
  Bytes copyBytes(sint sz);	//sz bytes copied from the front of this Frame.

/**************
.SH Miscellaneous
**************/
  sint32 length();		//Number of bytes in this Frame.
  Byte&	operator[] (sint32 i);	//Treat Frame as an array of bytes, an index
				//of 0 gives first byte. Inefficient
/***************
.SH Printing, asking
***************/
  void   setAsn(boolean i)	{ isAsn = i; }	
                                //Says if this is ASN.1 structured Frame.
                                //Affects printing format.

  void	 asnPrint(Ostream& os);	//pretty-printing for ASN.1 structured Frames.
  void	 print(Ostream& os);	//Prints out this Frame in hex/ascii by
				//default.  Special pretty-printing of
				//ASN.1 structured frames, see setAsn().
  void	 ask(Istream& is);	//User input of Frame.

  void	 to(ODump& od);	 
  void	 from(IDump& id);


  String className() const;

  Frame(sint32 dbSize = DB_SIZE);//Creates an empty Frame.  Data block size
                                //is determined here, allowing the application
                                //programmer to make a choice between 
                                //time efficiency (big dbSize)
                                //and space efficiency (small dbSize).
  Frame(Frame& f);		//Removes data from f, puts it to this 
                                //without copying.
                                //Warning: this is NOT a copy-constructor, 
                                //DESTRUCTIVE to argument f!
  Frame(FRAME **cFrame);	//Removes data from cFrame, puts it to this 
                                //without copying.
                                //Sets *cFrame = 0.
				//Warning: DESTRUCTIVE to argument f!
  Frame(FrameBlock& fb, sint32 realSize);
                                //Used for efficient I/O.
                                //See example above.
  ~Frame();

};

//See also class Bytes.

extern Frame* dummyFrame;
extern Object* objectify (FRAME *pfrm);	

