/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.fifo.hxx
 * Vers: 5.2    Time: 92/08/03, 15:41:53
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* NAME
*	fifo.hxx
**********************************************************************/


/**********************************************************************
A "first in, first out" queue,
a container of Runner pointers (group element GE is Runner*).
**********************************************************************/

class Fifo : public Group {
protected:
  Link*	fst;
  Link*	last;
public:
  Group& 	myPut(const GE);	// *MJS* changes
  Group& 	myGet(GE& o);		// *MJS* changes
  GE		first(GP&);
  GE		next(GP&);
  String 	className() const;
                Fifo();
               ~Fifo();
};

/********************************************************************
Lifo is a "last in, first out" grouping (container class) 
of group elements GE.
**********************************************************************/

class Lifo : public Fifo                 //implementation reuse only,
                                         //Lifo provides Group service
{
public:
  String	className() const	 {return "Lifo";}
  Group&	myPut(const GE);
                Lifo();
};

/**********************************************************************
MemberObjectList is used in the implementation of OTSO command interpreter.
Contains a list of objects chosen by e.g. command words containing 
wild cards (*).
**********************************************************************/

class MemberObjectList: public Fifo {
public:
  boolean	isAmbiguous() const;	//True only if this contains a Message
                                        //and something else.
  static const sint32 ambiguityLimit;
  MemberObjectList& insert(Runner* mb);	//Add a new element to this list.
  void		addCount(sint32 n);	//increase memberCount by n
  Member	runUI(Objectifier sp, String prompt, String memberName);
                                        //Execute command interpreter for 
                                        //this list of objects.
                MemberObjectList();	//
private:
  sint32	memberCount;
  boolean	isWildCardUsed;
};

