/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.corout.hxx
 * Vers: 5.2    Time: 92/08/03, 15:44:50
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


//corout.hxx	- Juha 18.3.92

/**********************************************************************
This file is the combination of corSP.hxx and cor.hxx
**********************************************************************/

//#include "object.hxx"
//#include "runner.hxx"
//#include "lwp/lwp.h"		/*?*/


/**********************************************************************
Class CorSP defines the service providing interface for the 
centralized coroutine manager. 
The interface has not been defined as an interface class, because
it won't be used distributedly. In this case, SP class just defines
a portable interface.
**********************************************************************/

class CorSU;

class CorSP {
public:
	virtual uint16	corNew(CorSU* su) = 0;
				//create a new coroutine. Returns the id of
				//the new coroutine.
	virtual uint16	corIdCur() = 0;
				//currently running coroutine.
	virtual boolean	corExist(uint16 id) = 0;
				//returns true, if the coroutine specified by
				//id exists.
	virtual String	corName(uint16 id) = 0;
				//returns a documentary name for the coroutine
				//specified by id.
	virtual void	corJump(uint16 id) = 0;
				//yields execution to the coroutine specified
				//by id.
				//Produces an error message, if id is
				//not an existing coroutine.
	virtual void	corDelete(uint16 id) = 0;
				//destroys the coroutine specified by id.
};

/**********************************************************************
Class CorSU defines the service using interface for coroutine classes.
The interface has not been defined as an interface class, because
it won't be used distributedly. In this case, SP class just defines
a portable interface.
**********************************************************************/

class CorSU {
public:
	virtual uint16	corId()	= 0;
				//returns the coroutine id for this.
	virtual void	corRun() = 0;
				//method to be executed when corJump()
				//is called the first time with
				//coroutine id pointing to this.
				//Usually runs in an eternal loop; if,
				//however, exits, control will be returned
				//to coroutine 0.
	virtual String	corName() = 0;
				//returns a documentary name.
	virtual void testingIfThisReducesSpaceConsumption();
};


#define MAX_THREADS     64

typedef enum {
	corFree,
	corInUse,
	corObsolete
} CorStatus;

typedef struct {
	CorStatus	status;
	thread_t	tid;
	CorSU*		corSU;
} CorInfo;

/**********************************************************************
Class CorMan provides the coroutine service needed in e.g. the
simulation environment.
This implementation uses the Sun LWP library.
**********************************************************************/

class CorMan: public CorSP, public Runner {
private:
	CorInfo	ci[MAX_THREADS];
	uint16	count;
	uint16	cix;
	boolean	yieldAllowed;
	void	checkYield();
	uint16	getCorId();
	void	destroy(uint16 id);
public:
	CorMan();
	redefined uint16	corNew(CorSU* sp);
	redefined uint16	corIdCur()	{ return cix; }
	redefined boolean	corExist(uint16 id)
					{ return (ci[id].status == corInUse)
						? true : false; }
	redefined String	corName(uint16 id);
	redefined void		corJump(uint16 id);
	redefined void		corDelete(uint16 id);
	void			corBase(CorSU* sp);
	void			print (Ostream&);
					// JFR - redefined print
};





