/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.asn.hxx
 * Vers: 5.2    Time: 92/08/03, 15:41:47
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


#ifndef ASN_HXX
#define ASN_HXX

/**********************************************************************
* NAME
*	asn.hxx
*
* PURPOSE
*	ASN.1 type definitions from exttypes.typ and asntyp.typ
*	Interface to Modified Nokia CASN (asncodec) code.
*
* BUGS
* MODIFICATIONS
**********************************************************************/

/***********OTSO FRAME TYPES ****************/
#ifndef ASNDEF_DEF
#include "asndef.def"
#endif
#ifndef GENERAL_DEF
#include "general.def"
#endif
#ifndef ASNTYPES_H
#include "asntypes.h"
#endif
#ifndef FRAME_TYP
#include "frame.typ"
#endif

/************ASN.1 types*******************/
typedef double REAL;		// REAL

typedef Int NULLTYPE;		// NULL

typedef Object *ANY;		// ANY ...

typedef BYTE_TYPE BITSTRING;
typedef BYTE_TYPE OCTET;

typedef char NUMERICCHAR;
typedef char PRINTABLECHAR;
typedef char IA5CHAR;
typedef char VISIBLECHAR;
typedef unsigned char T61CHAR;
typedef unsigned char GRAPHICCHAR;
typedef unsigned char GENERALCHAR;
typedef unsigned char VIDEOTEXCHAR;

/********** Strings, undefined length ************************/

struct DYNSTR : public Bytes {
  INT32 n;			/* length: if BITSTRING in bits, otherwise in
				 * bytes */

  /*
   * NOTE: used in encoding and decoding functions generated by CASN. should
   * always be same as Bytes.sz
   */

   DYNSTR & copy ();		// make a real new copy.

  virtual void makeEmpty () {
    if (this -> st != NULL) {
      delete this -> st;
       this -> st = NULL;
    }
    this -> sz = this->n = 0;
  }

  virtual String className () const {
    return "DYNSTR";
  }
  virtual void ask (Istream & is);
  ASNHOME *toASNHOME ();

   DYNSTR & operator = (Bytes &);
   DYNSTR & operator = (DYNSTR &);

   DYNSTR (char *);
   DYNSTR (Bytes &);
   DYNSTR ();

};

/********* Short strings ****************************************/

typedef struct statstr {
  INT32 n;
  BYTE_TYPE st[1];
} STATSTR;

/******** SEQUENCE OF, SET OF (except when small SIZE given) ****/

struct LIST : public Object {	// used to be derived from Group

  INT32 n;
  ASNHOME *ls;

   LIST & put (ASNHOME * o);
   LIST & put (Int i);
   LIST & get (ASNHOME * &o);
  String className () const {
    return "LIST";
  }
  ASNHOME *toASNHOME ();
   LIST & operator = (LIST & rhs);	// empties rhs

   LIST () {
    n = 0;
    ls = 0;
  }
   LIST (LIST & rhs);		// empties rhs

};

/********* Universal time  ****************************************/

/*struct*/
class COMMONTIME : public Object {
 public:
  Int sec;
  Int msec;
  Int zone;
  Int dst;

  String className () const {
    return "COMMONTIME";
  }
  ASNHOME * toASNHOME ();
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(COMMONTIME);

  COMMONTIME() : sec(0), msec(0), zone(0), dst(0) {}
  ~COMMONTIME() {}
};

DECLARE_OTSO_PAED_FOR_OTSO_OBJECT(COMMONTIME);	//not necessarily an Object?

struct OBJECTIDENTIFIER : public Object {
  int n;
  int elem [MAX_OBJIDC_CNT];

  String className () const {
    return "OBJECTIDENTIFIER";
  }
  ASNHOME *toASNHOME ();
  void print (Ostream &);
  void ask (Istream &);

   OBJECTIDENTIFIER () {
    n = 0;
  }
};

typedef DYNSTR OBJECTDESCRIPTOR;


struct EXTERNAL : public Object {
 public:
  INT32 compmask;
  OBJECTIDENTIFIER direct;
  INT32 indirect;
  OBJECTDESCRIPTOR descr;
  struct {
    INT16 choice;
    union {
      FRAME *single;
      FRAME *octet;
      FRAME *arbit;
    } value;
  } encoding;
};

/********* LIST element type is ASNHOME ***************************/

struct ASNHOME : public Object {
  struct {
    NULLTYPE null;
    BOOLEAN bool;
    INT16 i16;
    INT32 i32;
    REAL real;
    DYNSTR dyns;
    ANY any;
    LIST list;
    struct frame *frm;
    COMMONTIME *comt;
    struct statstr *stas;
    EXTERNAL *ext;
    OBJECTIDENTIFIER *obji;
    Object *stru;
  } val;
  MEM_BLOCK *head;
  ASNHOME *prev;
  ASNHOME *next;
  BYTE_TYPE type;

  ASNHOME (BYTE_TYPE t = 0):
   type (t) {
    next = 0;
  }
  String className () const;
};

extern ASNHOME *dummyASNHOME;
Object *objectify (ASNHOME & ah);

/*********** Types for Encoding/DEcoding interface ******************/

typedef BYTE_TYPE EMPTYSTRU;
typedef BYTE_TYPE NOBODYUSESTHISTYPE;
typedef BYTE_TYPE SKIPPED;
typedef unsigned UINT;

#ifndef ASNTYP_TYP
#include "asntyp.typ"
#endif
#ifndef ASNMISC_TYP
#include "asnmisc.typ"
#endif
#ifndef ASNCODEC_EXT
#include "asncodec.ext"
#endif

extern ERR_RET *casnErrorPtr;

 /* the name 'casnErrorPtr' is generated into asnEncode/Decode() */

#endif				/* ASN_HXX */
