/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.agent.hxx
 * Vers: 5.2    Time: 92/08/03, 15:41:45
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* NAME
*	agent.hxx
**********************************************************************/

/*********************************************************************
Agents are "interface objects" that sit between a service user
and a service provider.  Usually an application programmer only uses
the Ptr classes generated for interface classes, not the agents directly.

Agents translate function calls into messages, 
take care of concurrency control etc.
Agents are needed when messages are needed:
in asynchronous communication, in inter-process communication, 
and when the client and server lie in different threads.
To find the object that really provides the service,
an agent has either a pointer to a local service provider,
or the name of a remote service provider.
Agent classes and instance are created by OTSO.
There is one agent for each su.

Instances of class Agent (not derived Agent) represent those remote objects
that are not used by the objects of this process 
-- no local object points to these remote objects.
Derived Agents, generated automatically for each interface class by the 
OTSO prepro, represent those remote objects that are used (pointed to)
by local objects.

**********************************************************************/

class Agent: public NamedObj   //An agent has the same name as the real service
                               //provider it represents.
{
  friend class Message;			//calls setSPInterface
public:
  enum AgentState {notConnected, connectedToAnAgent, connectedToAnSP};
private:
  Object*	spObject;		//points to sp if local
  Process*	spProcess;		//sp's home process
  ConnectionId	spConId;		//not used currently

                                        //In a derived class XXX_agent there
                                        //is also XXX* spInterface;
  virtual void	setSPInterface(void* p);//For a derived class XXX_agent,
                                        //sets the XXX* of a derived class ;
                                        //p must be XXX* (no type checking) !

  Object*	suObject;		//points to su object (sender) if local
  Process* 	suProcess;		//su's home process
  ConnectionId	suConId;		//not used currently
  String 	sourceName_;		//used if remote suObject

  sint16	useCount_;		//number of Ptrs pointing to this
protected:
  AgentState	state_;

public:
  void 		connect();		//A Ptr connects itself to this.
  void		disconnect();		//A Ptr no more points to this.
                                        //Deletes this if no Ptr points to this
                                        //anymore.
  sint16	useCount() const;	//Number of Ptrs pointing to this.
                                        //Ptrs are owned by service users
                                        //or messages.
  AgentState	state()	const		{return state_;}
  virtual Process*& process() const;	//Real SP's home process.  *& ?

  Object*	source() const;		//su if it is local
  Process*	sourceProcess()	const	{return suProcess;}
                                        //su's home process
  void		setSource(Object* suO, Process* suP);
                                        //sets source() and sourceProcess()
  String	sourceName() const;	//name of su
  void 		setSourceName(const String& n);
                                        //sets sourceName()
  Object*	dest() const		{return spObject;}
                                        //sp or agent (?)
  Process*	destProcess() const	{return spProcess;}
                                        //sp's process
  void		setDest(Object* spO, Process* spP);
                                        //sets dest() and destProcess()
  void		setSp(String spName);   //Set spObject and spInterface of a 
                                        //derived class to point to appropriate
                                        //parts of 'spName'.

  virtual VoidPointer memberPointer(String memberName);
  virtual void	print(Ostream&);
  virtual void	ask(Istream&);
  virtual void 	to(ODump&);
  virtual void	from(IDump&);
  virtual String className() const;

protected:
  Agent(Object* spO, Process* spP, Object* suO, Process* suP, AgentState s);
                                    //
  Agent(const Agent& i);	    //The normal copy constructor,
                                    //except that useCount_ will be 0.

public:
  Agent(Process* spP);	            //Represents a remote NamedObj whose type
                                    //is unknown in this memory. 
                                    //spP is the address space of the real 
                                    //service provider object.
                                    //Called in main().
 ~Agent();
};

DECLARE_OTSO_PAED_FOR_ENUM(Agent,AgentState)

#if SIMULATING
extern void setOtsoSimuDest(Agent* dap); //implemented in otso/simsrc/vcon.cxx
#endif

/*********************************************************************
MultiPtr is the abstract base class of concrete Ptr classes 
generated for interface classes.
The usage of Ptr classes is documented in derived classes.

*********************************************************************/

class MultiPtr: public Object 
                        //Future work: MultiPtr could be derived from nothing 
                        //in order to save space.
{
public:
  virtual Agent* agent() = 0;

  virtual void	print(Ostream&);
  virtual void	ask(Istream&);
  virtual void 	to(ODump&);
  virtual void	from(IDump&);
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(MultiPtr);
  MultiPtr();
};

DECLARE_OTSO_PAED_FOR_OTSO_OBJECT(MultiPtr);


