/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/enviros/SCCS/s.env_sel.h
 * Vers: 5.3    Time: 92/08/14, 15:51:04
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


#ifndef ENV_SEL_H
#define ENV_SEL_H

/*********************************************************
 * NAME	- env.h
 *
 * PURPOSE - select the environment you are using.
 *
 * DESCRIPTION - env.h tries to automatically determine (via #defines
 *   set in various compilers) the underlying environment:
 *   i.e. operating system and compiler.
 *
 *   It is preferable for OTSO users to use #defines such as 
 *   COMPILER_GPLUS instead of __GNUG__, since the #defines set here
 *   are defined in a consistent manner #define XXX 1.
 *   e.g. COMPILER_BORLANDCPP (1) is better than __BORLANDCPP__ (0x200)
 *
 * PORTING
 *   Modify this file when porting to new systems.  In Unix systems,
 *   using make, also modify /otso/enviros/system.make, $(ENVFLAGS)
 *
 * BUGS
 *   __OWCCPP__ , __SUNCPP__ , are #defined only in OTSO's
 *   Unix makefile : /otso/enviros/system.make, variable 
 *   $(ENVFLAGS).  It would be better if the compilers had set
 *   them like Borland C++ does.
 *
 *   Support should be added here someday, when someone wants to
 *   use g++ on a non Unix system (e.g. MSDOS).  It's not a supported
 *   configuration now.
 **********************************************************/



/* Borland C++ v. 2.00 on MSDOS v. 3.3 or later; make sure it is! */
#define MSDOS			(__MSDOS__ == 1)
#define COMPILER_BORLANDCPP	(__BCPLUSPLUS__ == 0x200)


/* GNU G++ compiler is used only on UNIX systems for now */
/* g++ version 1.* :	__GNUG__ is 1			 */
/* g++ version 2.* :	__GNUG__ is 2			 */
#define COMPILER_GPLUS		(__GNUG__ == 2)		/*?*/
#define LIB_GPLUS		(COMPILER_GPLUS)
	/* libg++.a can be used w/o G++ compiler, above is default.	*/ 
	/* Change for your local configuration if needed.		*/


/* ObjectWorks C++ compiler is used only on UNIX systems (see system.make) */
#define COMPILER_OWC	(__OWCCPP__ == 1)


/* Sun C++ compiler is used only on UNIX systems (see system.make) */
#define COMPILER_SUNCPLUS (__SUNCPP__ == 1)

/* HPUX C++ compiler is used only on HewlittPackard UNIX systems
   (see system.make) */
#ifdef __hpux
#define COMPILER_HPUX	1
#endif


/* define UNIX and BSD (defaults) for UNIX COMPILERS */
#if ( \
      (!MSDOS) && \
      (COMPILER_OWC || COMPILER_SUNCPLUS || COMPILER_HPUX || COMPILER_GPLUS ) \
    )
#  define UNIX	1
#  define BSD	1
#else
#  define UNIX	0
#  define BSD	0
#endif


/* ------------------------------------------------------------------ */
/* Consistency checks to generate compile errors. Don't delete them ! */
/* ------------------------------------------------------------------ */

/***********
*#ifdef c_plusplus
*  ***FATAL ERROR: cfront version 1.2 not supported!
*#endif
************/

#ifndef __cplusplus
  ***FATAL ERROR: only cfront version 2.0 supported!
#endif

#if MSDOS
# if !COMPILER_BORLANDCPP
  ***FATAL ERROR: currently only Borland C++ supported!
# endif
# ifndef __LARGE__
  ***FATAL ERROR: must use large memory model!
# endif
# if (UNIX || BSD)
  ***FATAL ERROR: UNIX & MSDOS systems are both defined!
# endif
#endif


#endif /* ENV_SEL_H */
