/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/enviros/SCCS/s.envOS.h
 * Vers: 5.2    Time: 92/08/03, 15:13:29
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


#ifndef ENVOS_H
#define ENVOS_H

/*
*/

// basic types
typedef signed long	sint32;	// signed   >= 32 bits (preferable)
typedef unsigned long	uint32;	// unsigned >= 32 bits
typedef signed int	sint16;	// signed   >= 16 bits (preferable)
typedef unsigned int	uint16;	// unsigned >= 16 bits
typedef signed char	sint8;	// signed   >=  8 bits
typedef unsigned char	uint8;	// unsigned >=  8 bits (preferable)


typedef int		boolean;//

typedef signed long	slong;	// remove this some day, use sint32 instead





/* generic OTSO services using OS-specific functions */

#if UNIX || MSDOS
# include <syscall.h>	/* Tells what Unix system calls are available. */
# include <setjmp.h>	/* So we can use setjmp/longjmp if available.  */
# ifndef time_h
#  include <time.h>
# endif
#endif

#if BSD || MSDOS

/* envOS.cxx extern's */
extern void systart();		// OS specific start routine
extern void systop();		// OS specific exit  routine
extern boolean initOTSO();	// OS specific initilization of OTSO
extern void startupOTSO();	// calls initOTSO(); exit if fails


/* interface to system time */
class Time;
extern Time& systime();		/* *MJS* changes - jfr! */

/* #define return values for OTSO for setjmp, longjmp */
#define JMP_NEVER	0	/* setjmp can never return a 0	*/
#define JMP_CASN	1	/* CASN had an exception	*/

extern jmp_buf		glb_environment;	/* OTSO environment */
#if 0
// commented out for *MJS* changes - jfr!
extern struct timeval	global_sys_time;	/* OTSO system timer (secs) */
extern char*		timestamp(int);		/* OTSO timestamp string */
#endif
					
#endif	/* BSD */
    
#if MSDOS
typedef unsigned long fd_set;
#endif


#endif
