/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/enviros/device/bsd/SCCS/s.devsock.cxx
 * Vers: 5.7    Time: 92/09/04, 15:01:17
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)devsock.cxx	5.7 92/09/04";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/******************************************************
 * NAME
 *   devsock.cxx - BSD Socket Driver Code 
 *
 * PURPOSE
 *	OTSO interface to Client/Server BSD sockets.
 *
 * MODIFICATIONS
 *	I rewrote some of this after looking at InterViews
 *	Connection class for sockets. I took some ideas
 *	from there, hopefully this should make it easier for
 *	people who also need to look at the xvops interface,
 *	(InterViews Xwindow interface for OTSO) since
 *	the OTSO and InterViews classes work quite similarly now.
 *	- jfr.
 ********************************************************/


#ifndef OTSO_hxx
#include "OTSO.hxx"
#endif

#if COMPILER_SUNCPLUS
# include <netdb.h>	/* hostent */
#endif
#if COMPILER_OWC	/* netdb.h would be better, but some problems with it */
  struct hostent {
    char  *h_name;
    char **h_aliases;
    int    h_addrtype;
    int    h_length;
    char **h_addr_list;
# define h_addr h_addr_list[0]
  } ;
#endif

#if COMPILER_HPUX
# include <sys/stat.h>	/* for chmod */
#endif

#include <sys/fcntl.h>	/* fcntl() */


extern int errno;
#define CERRNO(s)	cerr << "Error:" << s << ". errno = " << int(errno) << "\n"
#define CERROR(s)	cerr << "Error:" << s << "\n"



/************************************
*	Socket 
*************************************/

int Socket::blocks(boolean doblock=true, int delay=0) {
  int flags = 0;
  if (fd() != NEGATIVE) {
    if ((flags = ::fcntl(fd(), F_GETFL, 0)) == -1) {
      return -1; 
    } else {
      return (::fcntl (fd(), F_SETFL,
        ( doblock == true ? (~O_NDELAY&flags) : (O_NDELAY|flags) ))
      ) ;
    }
  }
  else {
    return -1;
  }
}

int Socket::linger(boolean lgr=true) {
  struct linger linger;
  if (fd() != NEGATIVE) {
   if (lgr == true) { linger.l_onoff = 1; } else { linger.l_onoff = 0; }
   return setsockopt(fd(),SOL_SOCKET,SO_LINGER,(char*)&linger,sizeof(linger));
  } else {
   return -1;
  }
}


/* ctor and dtor */
Socket::Socket(
  Event evnt,
  int fd,
  int portno,
  int domain,
  int type,
  int proto
) : Device (fd, evnt,
            (domain == AF_UNIX ? "unix domain socket" : "inet socket")
    )
{
  this -> domain      = domain;
  this -> type        = type;
  this -> protocol    = proto;
  this -> servname    = NULL;
  this -> portnum     = 0;
  this -> sk_do_wbuf  = false;
  this -> sk_wbuf     = 0;

  /* wait until connect to actually create a local socket */
}

Socket::~Socket() {
  this -> pdeviceTable -> remove(this);
  this -> Close();
  fd() = NEGATIVE;
}

/* shutdown and close actual socket */
void Socket::Close () {
  // if there is any frame buffered at the socket
  // waiting to be written, send it via blocking write.
  if (this -> sk_do_wbuf && sk_wbuf) {
    this -> blocks(true);

    int sd = this -> fd();
    Bytes btmp(sk_wbuf->getBytes(sk_wbuf->length()));
    (void) ::write(sd, (char*)btmp.st, btmp.length());
  }

  // shutdown and close the socket descriptor
  if (this -> fd() != NEGATIVE) {
    this -> pdeviceTable -> remove (this);	/* into dev table */

    if (this -> domain == AF_INET) {
      ::shutdown (this -> fd(), 2);	// 2: no more sends or recvs
    }
    ::close (this -> fd());
  }
}


/* Local internet socket; return success */
boolean Socket::Create(struct sockaddr_in &local) {
  struct hostent* hp = NULL;

  this -> Close();

  /* Create server socket */
  this -> fd() = ::socket(this -> domain, SOCK_STREAM, this -> protocol);
  if (this -> fd() == NEGATIVE) {
    CERRNO("Create - open stream socket");
    return false;
  }

  /* add socket to device table */
  this -> pdeviceTable -> add (this);	/* into dev table */
  
  hp = ::gethostbyname((char*)(this -> servname));
  if (hp == NULL) {
    CERROR ("Create - gethostbyname(" << this -> servname  << ") failed");
    return false;
  }

  /* prepare local socket */
  ::memset ((char*)&local, sizeof(local), 0);	/* zero it out */
  ::memcpy ((char*)(&local.sin_addr), (char*)(hp -> h_addr), hp -> h_length);
  local.sin_family = this -> domain;
  local.sin_port   = ::short_host_to_net(this -> portnum); /* htons */
  return true;
}

/* Local UNIX domain socket; return length of sock addr */
int Socket::LocalCreate(struct sockaddr_un &local) {
  this -> Close();

  /* Create local socket */
  this -> fd() = ::socket(this -> domain, SOCK_STREAM, this -> protocol);
  if (this -> fd() == NEGATIVE) {
    return 0;
  }
  
  /* add socket to device table */
  this -> pdeviceTable -> add (this);

  /* prepare local socket */
  ::memset ((char*)&local, sizeof(local),0);
  local.sun_family = domain;
  ::strncpy(local.sun_path, (char*)this->servname, (sizeof(local.sun_path)-1));

  int r = sizeof(local.sun_family) + sizeof(local.sun_path);
  cerr << "BUG1 len=" << int(r) << "\n";

  return r;
}


//
// !!!! WARNING !!!!
// + This Read is a bit dangerous to use if you don't use it
//   properly.  Since the default is to use non-blocking reads,
//   if *less* than the required (i) number of bytes are read,
//   the bytes are still put into the frame, and i is returned.
// + The number of bytes actually read is returned. The caller 
//   should be aware of this.
// + A -1 is returned on a read error.  The caller should check
//   ::errno to see how serious an error it was, EWOULDBLOCK can probably
//   be ignored, other errors are more serious !!!
// + No attempt is made to multiple reads here, it is better to let
//   OTSO runners be designed to do multiple reads.
//
int Socket::Read (Frame& f, int i) {
  int nRead = 0;
  FrameBlock fb(i);
  if ((nRead = ::read (this->fd(), (char*)(Byte*)fb, i)) > 0) {
    Frame newF(fb, nRead);
    f.putPrefix(newF);	
  } else {
    CERRNO("Socket Read - failed nRead=" << int(nRead)) << " toRead=" << int(i);
    return -1;
  }
  return nRead;
}

/******************************************
 * WARNING: 
 *   Write() is optimized for efficiecy, in
 *   general, you should use frame.getByte(), etc.
 ******************************************/

int Socket::Write(Frame& f) {

  if (sk_do_wbuf == false) {
    int i = 0;
    int nWritten = 0;
    int nWrite = 0;
    int sd = this -> fd();

    Bytes btmp(f.getBytes(f.length()));
    nWrite = ::write(sd, (char*)btmp.st, btmp.length());
    if (nWrite < 0) {
      CERRNO ("Socket Write failed");
    } else {
      nWritten += nWrite;
      if (nWritten < btmp.length()) {
        /* couldn't write whole frame */
	/* save a copy for writing by event handler */
        sk_do_wbuf = true;
	sk_wbuf = new Frame(btmp.length());
	*sk_wbuf = btmp;
	sk_wbuf -> deleteBytes(nWritten);
      }
    }
  } else {
    sk_wbuf -> putSuffix(f);
    // Socket write event handler takes care of trying to write sk_wbuf;
  }
}

boolean Socket::eventHandler() {
  if (this -> pending & ev_write) {
    if (sk_do_wbuf == true && sk_wbuf != 0) {
      int nWritten = 0;
      int nWrite   = 0;
      int sd       = this -> fd();

      Bytes btmp(sk_wbuf -> getBytes(sk_wbuf -> length()));
      if ((nWrite = ::write(sd, (char*)btmp.st, btmp.length())) < 0) {
        CERRNO ("Socket Write failed");
      } else {
        nWritten += nWrite;
        if (nWritten < btmp.length()) { 	// couldn't write whole frame
	  *sk_wbuf = btmp;			// buffer unwritten bytes
          sk_wbuf -> deleteBytes(nWritten);	// (delete written ones)j
		// wrote something, socket is probably blocking again
		// wait for next select to see if device is writable
        }
      }
    }
  }
  return false;
}

/************************************
*	Client Socket
*************************************/

ClientSocket::~ClientSocket() {}

/* connect client to foreign (internet) socket : p@hostname */
boolean ClientSocket::Connect (const char* hostname, int p) {

  struct sockaddr_in local;
  int ret = 0;
  int len = sizeof local;

  /* set for Create and Connect */
  this -> domain   = AF_INET;
  this -> servname = hostname;
  this -> portnum  = p;

  if (this -> Create(local) == false) {
    return false;
  }
  
  if ((ret = ::connect (this -> fd(), (struct sockaddr*)&local, len)) < 0) {
    CERRNO("Connect - connecting to stream socket");
    this -> Close();
    return false;
  }

  this -> blocks (false);

  return true;
}

/* connect client to a Unix Domain socket : filename */
boolean ClientSocket::LocalConnect (const char* filename) {
  struct sockaddr_un local;
  int len;

  this -> domain   = AF_UNIX;
  this -> servname = filename;

  len = this -> LocalCreate (local);
  if (len == 0) {
    return false;
  }

  if (::connect (this -> fd(), (struct sockaddr*)(&local), len) < 0) {
    this -> Close();
    return false;
  }
  
  this -> blocks (false);
  return true;
}

/************************************
*	Server Socket
*************************************/


ServerSocket::ServerSocket (
  Device **pis,
  Event evnt,
  char* name,
  int portnum,
  int domain,
  int type,
  int proto
) : Socket (evnt, NEGATIVE, portnum, domain, type, proto) {
  this -> listener = pis;

  if (this -> domain == AF_INET) {
    this -> Serve (name, portnum);			// portnum@hostname
  } else {
    this -> LocalServe (name);				// unix file name
  }
}

/* 
 * accept a connection from a client socket.
 * create Service socket. don't block.
 * returns 1 if we handled event, 0 if we couldn't handle event
 */
boolean ServerSocket::eventHandler() {
  int nd  = NEGATIVE;
  int len = 0;
  struct sockaddr_in inet;
  struct sockaddr_un file;


  boolean isBlocking = false;


  if (this -> domain == AF_INET) {
    len = sizeof (inet);
    nd = ::accept (this -> fd(), (struct sockaddr*)(&inet), &len); 
  } else {
    len = sizeof (file);
    nd = ::accept (this -> fd(), (struct sockaddr*)(&file), &len); 
  }
 
  if (nd != NEGATIVE) {

    /*
     * Servers generally don't want to block when reading 
     * from a client.  An exception is if there is an Device
     * attached to the Service Socket - then we should block.
     */

    if (this -> pending & ev_read) {
      if (this -> listener == NULL) {
        CERROR ("NULL **listener");
        return true;
      }
      else if (*this ->listener != NULL) {
        CERROR ("warning: removing non-NULL * listener");
        this -> pdeviceTable -> remove (*this->listener);
	*this -> listener = NULL;
      }

      /* Service is deleted by device table ???? JFR  */
      *this->listener = new ServiceSocket (
				ev_bothrw, nd, isBlocking, this -> portnum, 
				this -> domain, this -> type, this -> protocol
                        );	// watched for both reads & writes !
      this -> pdeviceTable -> add (*this->listener);
      /////// JFR FIX BUG: WHO removes it !!! /////////
    }
    //return true;	// we handled event by creating a service
			// socket for reads/writes

    return false;	// !!!! let some external runner handle it !!!!!

  } else {
    CERRNO("fd = " << int (this->fd()) << " -- Accept failed ?");
    return false;	// we couldn't handle the event
  }
}


/* Inet - start serving */
void ServerSocket::Serve(const char* hostname, int p) {
  struct sockaddr_in local;

  this -> domain   = AF_INET;
  this -> servname = hostname;
  this -> portnum  = p;

  if (this -> Create(local) == false) {
    CERRNO("can't create INET server socket");
    exit (1);
  }

#if 1	/*Juha 27.5.92 - check someday !!??*/
  local.sin_addr.s_addr = INADDR_ANY;		//!!??
  local.sin_port       = htons(p);
  local.sin_family     = AF_INET;
#endif

  if (::bind (this -> fd(), (struct sockaddr*)(&local), sizeof(local)) < 0) {
    CERRNO("can't bind INET server socket");
    exit (1);
  }

  if (::listen (this -> fd(), 5) != 0) {
    CERRNO("can't listen to INET server socket");
    exit (1);
  }
}

/* UNIX domain - start serving */
void ServerSocket::LocalServe(const char* sname) {
  struct sockaddr_un local;
  int len=0;

  this -> domain  = AF_UNIX;
  this -> servname = sname;
  this -> portnum = NEGATIVE;

  len = this -> LocalCreate(local);	// fd set
  if (len <= 0) {
    CERRNO("can't create UNIX Domain server socket");
    exit (1);
  }
  ::unlink(local.sun_path);

  if (::bind(this -> fd(), (struct sockaddr*)(&local), len) < 0) {
    CERRNO("can't bind UNIX Domain server socket");
    exit (1);
  }

  if (::listen (this -> fd(), 5) != 0) {
    CERRNO("can't listen to UNIX domain server socket");
    exit (1);
  }

  /* Unix domain sockets need to be mode 777 on 4.3 */
  ::chmod(local.sun_path, 0777);

}

ServiceSocket::~ServiceSocket() {
  /* add socket to device table */
  this -> pdeviceTable -> add (this);	/* into dev table */
}



