/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/enviros/device/bsd/SCCS/s.devbsd.cxx
 * Vers: 5.2    Time: 92/08/04, 11:04:23
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)devbsd.cxx	5.2 92/08/04";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/******************************************************
* NAME
*	devbsd.cxx 
*
* PURPOSE 
*	BSD Unix Devices and DeviceTable classes for OTSO.
*
* MODIFICATIONS
* BUGS
*******************************************************/

#if 0	/* to be deleted */

#include "devbsd.hxx"
#include "device.hxx"
#include "process.hxx"
#include "channel.hxx"

#endif /* #if 0 */

#include "OTSO.hxx" 

/* -- Local Declarations / Definitions -- */


#define DEBUG_THIS	0
#define DEBUG1		0 /* 1 - produces tons of output, when events occur. */
#define DEBUG_FD_SET	0 /* 1 - fd_set debugging */



/*
 * Default DeviceTable Pointer :
 *   OTSO processes must always initialize 'pGlobalDevices' pointer
 *   when the process starts up !   see 'init2.inc' for details.
 *   
 */

DeviceTable	*pGlobalDevices = NULL;	/* init2.inc initializes */



/* -- "Device" Member Functions -- */

Device::Device (int descriptor, Event e, char* n, DeviceTable* d) {
  this -> fDescr = descriptor;
  this -> event  = e;
  this -> pending = ev_none;  /* no outstanding events yet */
  if (n != NULL) {  /* no name was default */
    this -> deviceName = new char [::strlen (n) + 1];
    ::strcpy (deviceName, n);
  }

  /* add Device to a DeviceTable, if it exists */
  if (d == NULL) {
      cerr << "*** Fatal Error: OTSO Device Table doesn't exist.\n";
      exit (1);
  }
  else {
      this -> pdeviceTable = d;
  }


  /*
   * Note: It is the constructor/destructor for a subclass derived 
   *   from class Device (e.g. File_Device), that will add/remove itself 
   *   to/from a device table.  See the subclass File_Device's
   *   constructor as an example.
   */
}

Device::~Device ()
{
  /*
   * Derived Class objects add/remove themselves
   * to/from the device table.
   */

  if (this -> fDescr != NEGATIVE) {
    ::close (this -> fDescr);
    this -> fDescr = NEGATIVE;
  }
  if (this -> deviceName) {
    delete this -> deviceName;
  }
}

/* Other Member Functions */

char* EventToAscii (Event w)
{
  char * retval = "error: bad case";

  switch (w) {
  case ev_none:
    retval = "ev_none";
    break;
  case ev_read:
    retval = "ev_read";
    break;
  case ev_write:
    retval = "ev_write";
    break;
  case ev_bothrw:
    retval = "ev_bothrw";
  default:
    break;
  };

  return retval;
}

void
Device::print (Ostream& os)
{
  os << "Dev";
#if DEBUG_THIS
  os << "{this=" << int((unsigned)this) << "} ";
#endif

  os << " ->  fd:" << int (this -> fDescr);
  os << ", Watched: " << EventToAscii (this -> event);
  os << ", Pending: " << EventToAscii (this -> pending);

  if (this -> deviceName)
    os << "\t(" << this -> deviceName << ") ";

  os << "\n";
}

/* These may be totally unneccesary */
int Device::Read (Frame& , int )
{
  cerr << "devrd not implemented" << "\n";
  return 1;
}

/* These may be totally unneccesary */
int Device::Write (Frame& )
{
  cerr << "devwr not implemented" << "\n";
  return 1;
}


/*  */


void print_fd_set (ostream &os, fd_set* set)
{
    if (set == NULL)
  os << "(NULL)\n";
    else {
  os << "High [";
  for (fd_mask *mask = &set -> fds_bits[howmany(FD_SETSIZE, NFDBITS) - 1];
    mask >= &set -> fds_bits[0];
    mask--
  ){
      //os << form ("0x%lx, ", *mask);
      os << *mask << ", ";		//?
  }
  os << " ] Low\n";
    }
}




/*
 * "Device Table" Member Functions
 *
 * 
 * The Device Table is the OTSO device table.
 * An index into the table is a OTSO device id of
 * a physical device.
 *
 */

/* Constructor */
DeviceTable::DeviceTable ()
{
  this -> runStatus = RunStatus::enabled;
  this -> nactive = 0;
  this -> trace.running = false;		// *MJS* Juha

         //If myScheduler() -> inQ() is PriorVec, this tells which
	 //group of the PriorVec will contain this
  setPriority(lowRunnerPriority);

  for (int i=0; i < ::max_device; i++)
    this -> pdeviceArray[i] = NULL;

#ifdef SYS_getdtablesize	/* <syscall.h> */
  this -> dtablesize	= ::getdtablesize ();
#else
  this -> dtablesize	= 0;	/* getdtablesize not available */
#endif

  FD_ZERO (&this -> readFds);
  FD_ZERO (&this -> writeFds);

#if DEBUG_FD_SET
  cerr << "DEBUG ctor readFds = ";
  print_fd_set (cerr, &readFds);
  cerr << "DEBUG ctor writeFds = ";
  print_fd_set (cerr, &readFds);
#endif
}

/* Other Member functions */

boolean DeviceTable::add (Device* newDevicePtr)
{
  if (!newDevicePtr) {
    OTSO_WARNING("DeviceTable::add() called with Device* 0 : no actions");
    return false;
  }

  if (this -> nactive >= ::max_device) {
    OTSO_ERROR("DeviceTable::add(Device*): pdeviceArray cannot hold more than " << ::max_device << " Devices -- DeviceTable will not look for events on this Device: " << *newDevicePtr ); 
    return false;
  }
  
  //pdeviceArray[0] ... pdeviceArray[nactive-1] are in use,
  //pdeviceArray[nactive] is the first free slot.

  if (pdeviceArray[nactive]) {
    OTSO_ERROR("DeviceTable::add(): pdeviceArray[" << nactive << "] is not free -- DeviceTable will not look for events on this Device: " << *newDevicePtr ); 
    return false;
  }

  //checks passed, add a new entry

  this -> pdeviceArray[nactive] = newDevicePtr; // no copy, same ptr
  this -> nactive++;

  /* add Device's fd to proper fd_set */
  if (newDevicePtr -> fDescr > NEGATIVE) {
    switch (newDevicePtr -> event) {
    case ev_bothrw:
          FD_SET (newDevicePtr -> fDescr, &this -> readFds);
            // and fall thru
    case ev_write:
            FD_SET (newDevicePtr -> fDescr, &this -> writeFds);
            break;
    case ev_read:
            FD_SET (newDevicePtr -> fDescr, &this -> readFds);
            break;
    case ev_none:
    default:
           break;
    };
  }

  return true;
}


/* remove device from device table */
void DeviceTable::remove (Device* olddev)
{
  for (int i=0; i < ::max_device; i++) {

    if (this -> pdeviceArray[i] == olddev && olddev != NULL) {

      /* Remove Device's fd from proper fd_set */

      switch (olddev -> event) {
      case ev_bothrw:
        FD_CLR (olddev -> fDescr, &this -> readFds);
        // and fall thru
      case ev_write:
        FD_CLR (olddev -> fDescr, &this -> writeFds);
        break;
      case ev_read:
        FD_CLR (olddev -> fDescr, &this -> readFds);
        break;
      case ev_none:
      default:
        break;
      };

      //No holes allowed in pdeviceArray:
      //move the last currently used pointer into
      //the hole created by deleting this device.
      if (i < nactive-1) 
        this -> pdeviceArray[i] = pdeviceArray[nactive-1];

      pdeviceArray[nactive-1] = 0;
      this -> nactive--;

      // olddev destructed by ~Device
    }
  }
}

/* print out latest copy of device table */
void DeviceTable::print (Ostream& os)
{
  os << "\nDevice Table { /* Total entries=" << int (::max_device);
  os << ", Active entries=" << int (this -> nactive) << " */ \n";

  os << "  readFds  :\n";
  print_fd_set(os, &this -> readFds);

  os << "  writeFds :\n";
  print_fd_set(os, &this -> writeFds);

  // os << "this = " << int((unsigned)this) << "\n";

        os << "  devices :\n";
  for (int i=0; i < this->nactive; i++) {
    if (this->pdeviceArray[i]) {
      os << "  (" << int(i) << ") ";
      this -> pdeviceArray[i] -> print(os);
    }
  }
  os << "}\n";
}

#if 0  /* moved to general.hxx */
struct timeval {
  long  tv_sec;    /* seconds */
  long  tv_usec;  /* and microseconds */
};
#endif

/* modified from Mayan Moudgill's select.C */
inline int selmax3(int* i1, int* i2, int* i3) {
  int t = 0;

  if (i1 && i2) {
    t = *i1>*i2 ? *i1 : *i2;
  }

  if (i3) {
    return *i3 > t ? *i3 : t;
  } else {
    return t;
  }
}


/*
 * The device table has it's own run function.
 * Its sole purpose in life is to run select (2),
 * then cycle thru devices that have pending events
 * and service them.
 */
void DeviceTable::run()
{
  /* make local copies of 'fd sets' that select() can modify */

  fd_set   rFds = this -> readFds, wFds = this -> writeFds;


  /*
   * select() now waits an arbitrary 0.25 seconds
   * When timers are available, select should wait less than 
   * smallest OTSO timer.  !! FUTURE_WORK !!
   */
  const slong  delay = 0;  
  struct timeval  timeout;
  timeout.tv_sec = delay;
  timeout.tv_usec = 25000;	// 250000;
				// -- I decreased this for my otso sound
				// -- demonstration.

#if DEBUG_FD_SET
  cerr << "  rFds = ";
  print_fd_set(cerr, &rFds);
  cerr << "  wFds = ";
  print_fd_set(cerr, &wFds);
#endif


#ifdef SYS_getdtablesize
  int width = this->dtablesize;
#else
  int width = selmax3 ((int*)&rFds, (int*)&wFds, NULL) + 1;
#endif	/* !SYS_getdtablesize */

  sint16 nEvents = (sint16)(
    process()->select (width, &rFds, &wFds, NULL, &timeout)
  );
  if (nEvents < 0 ) {
    perror ("Error: select failed");

    //cerr << form ("  dtablesize=%d\n", this -> dtablesize);
    OTSO_ERROR( "  dtablesize=" << this->dtablesize );

    cerr << "  rFds = ";
    print_fd_set (cerr, &rFds);

    cerr << "  wFds = ";
    print_fd_set (cerr, &wFds);

    //cerr << form ("  timeout={%d sec, %d usec}\n", timeout.tv_sec, timeout.tv_usec);
    OTSO_ERROR( "  timeout={" << timeout.tv_sec << " sec, " << timeout.tv_usec << "usec}" );

    /*
     * select() errors are fairly serious, we stop the system
     * and report them so that they can be fixed via bug reports to OTSO.
     */
    ::systop ();
  }

#if DEBUG1
  if (nEvents <= 0) {
    cout << "( " << int(nEvents) << " events are pending)\n";
        }
#endif

  /* 
   * FUTURE WORK:
   *   priority for servicing ???
   */

#if 1
  for (sint16 jj=1; jj < ::max_device; jj++) if (pdeviceArray[jj] && !pdeviceArray[jj-1]) OTSO_ERROR("pdeviceArray corrupted: empty slot before non-empty slot " << jj );
  for (jj=0; jj < ::max_device; jj++) if (pdeviceArray[jj] && jj >= nactive || !pdeviceArray[jj] && jj < nactive) OTSO_ERROR("pdeviceArray corrupted: nactive = " << nactive << ", pdeviceArray[" << jj << "] = " << (long)pdeviceArray[jj]);
#endif

  for (sint16 i=0; i < this->nactive && nEvents >0; i++) {
    if (this -> pdeviceArray[i] != NULL) {
      Device* devicePtr = this -> pdeviceArray[i];
      if ((devicePtr -> event & ev_read) &&
        FD_ISSET (devicePtr -> fDescr, &rFds)
      ) {
#if DEBUG1
        cout << "(Read Event Occurred on fd=";
        cout << int(devicePtr -> fDescr) << ")" << "\n";
#endif

        /* TURN ON bits for 'read' */
        devicePtr -> pending = (Event) (devicePtr->pending | ev_read);
        nEvents--;
#if DEBUG1
        cout << "Event for fd: " << int(devicePtr -> fDescr) << "\n";
#endif
        if (devicePtr -> eventHandler() != false) {

          /* TURN OFF bits, assume we've been serviced */
          devicePtr -> pending = (Event) (devicePtr->pending & ~ev_read);

          FD_CLR (devicePtr -> fDescr, &rFds);
          /* user may need to clear "pending" ! */
          /* e.g. for Istreams !!! */
        }
      }
      if ((devicePtr -> event & ev_write) &&
        FD_ISSET (devicePtr -> fDescr, &wFds)
      ) {
        // turn on bits for 'write'
        devicePtr -> pending = (Event) (devicePtr->pending | ev_write);
        nEvents--;

        if (devicePtr -> eventHandler() != false) {

          /* turn off bits, assume we've been serviced */
          devicePtr -> pending = (Event) (devicePtr->pending & ~ev_write);

          FD_CLR (devicePtr -> fDescr, &wFds);
          FD_CLR (devicePtr -> fDescr, &this -> writeFds);
          /* user may need to clear "pending" ! */
        }
      }
    }
  }
  runStatus = RunStatus::enabled;
  
  if (!myScheduler()->inQ())
    OTSO_ERROR("DeviceTable must not be run before " << myScheduler()->name() << " has an input queue");

  myScheduler() -> runOrQueue(*this); // request scheduling
}

