/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/enviros/SCCS/s.channel.hxx
 * Vers: 5.4    Time: 92/08/14, 10:55:05
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/****************** Local Definitions *************************/
typedef char* FileName;

/* alloc'd in channel.cxx - initialized at start of main() : init2.inc */
extern Ostream* doutStream;	//&dout
extern Istream* dinStream;	//&din
extern Ostream* dlogStream;	//&dlog

extern boolean otsoIsExiting;
#if COMPILER_HPUX
#  define NO_IOSTREAM_CLASSES 0
#else
#  define NO_IOSTREAM_CLASSES 1
#endif	/* !COMPILER_HPUX */


/********** output formatting (for 2.0? compatibility) ********************/

/*********
A warning: these form() functions should not be used in new code.
If you use them anyway, be very careful with the argument types!
**********/

extern char* form(char* format, int a1);
extern char* form(char* format, int a1,
                                double a2);
extern char* form(char* format, char* a1);
extern char* form(char* format, double a1, 
                                double a2 = 0.0, 
                                double a3 = 0.0, 
                                double a4 = 0.0);
extern char* form(char* format, double d, 
                                char* cp);

/**********************************************************************
Channels (or Streams) transform objects to byte strings
or byte strings to objects.
Objects can be inserted to OStreams, producing bytes 
(e.g. dout << message), or extracted from IStreams, consuming bytes
and creating an object (e.g. din >> parameter).

Channels are communication pipes, or byte streams.
Istreams and Ostreams are generally used for user input and output.
An OStream prints objects in a human readable form.
An IStream reads terminal input, translating the human readable representation
into an internal object representation.
Derived OStreams take care of encoding objects to some transfer syntax,
while derived IStreams do the decoding.
For each transfer syntax, an OStream-IStream pair is written.

IDumps and ODumps are inter-process communication (IPC) channels, that 
are intended to impose a transfer syntax on the messages passed thru
them by overloading of the << and >> operators.

Printing, asking, encoding, and decoding functions are an important
part of the 'OTSO interface' definition for a type.
Objects are inserted to a Channel by "ch << obj".
Ostream's operator<< calls obj's printing function,
ODump::operator<< calls obj's encoding function.
Objects are extracted from a Channel by "ch >> obj".
Istream's operator>> calls obj's asking function,
IDump::operator>> calls obj's decoding function.

.SH BUGS

The implementation is somewhat tied to the operating system used,
since channels should be watched for activity (some event occurance),
before the body of the Channel's run() function is executed,
to prevent blocking a thread if there is nothing to read, for example.
However, the thread gets blocked if the beginning but not the end of a message
is readable or writable.

Currently, only BSD Unix Devices are supported in OTSO.

#if COMPILER_OWC : Modified for Cfront (2.0) and g++.
Cfront needs to use file streams, not plain streams.  Code
has been ifdef'd to work either Cfront way or g++ way.
(jimmy 22.11.90)

*BSD-NOTE*
  I have added class ServerSocket as a friend to an Istream, because
the Istream should be constructed immediately from a Device, but
this can't happen in this case; because until a client connects to
the ServerSocket, no ServiceSocket exists for the Istream (for reads/writes).
Therefore the ServerSocket must accept a client connection, create a
ServiceSocket to handle the connection, and then modify the appropriate
Istream so it has a pdevice = new ServiceSocket.  This only for BSD UNIX.
(jim 12.11.90)


**********************************************************************/

class Channel : public Runner {
protected:
  FileDescriptor	fDescr;
  Channel();
public:
  FileDescriptor&	fd()			//
                                                {return fDescr;}
  virtual String	className() const;
};


/**********************************************************************
Filebuf is the iostream library filebuf with redefined underflow 
and overflow functions to take care of input/output logging.
**********************************************************************/

class Filebuf: public filebuf {
public:
  virtual int underflow();		//Actions to be performed when input
                                        //buffer has exhausted 
                                        //(read from file etc.).
  virtual int overflow(int c = EOF);	//Actions to be performed when output
                                        //buffer is full  
                                        //(write to file etc.).
  void	      putBack(String& s);	//putback s, even though s may be long.
  boolean     isEmpty();		//true if no chars in the buffer

  Filebuf(int fd): filebuf(fd) {}
  Filebuf(int fd, char* tab, int len): filebuf(fd, tab, len) {}
};

/**********************************************************************
	Istreams and Ostreams
**********************************************************************/

/**********************************************************************
This is just a new type that is used for overloading.
It is needed to implement 'ostream << INDENT'.
**********************************************************************/

class OstreamIndent {
public:	
  OstreamIndent(sint16) {}	//g++ complains without this
  ~OstreamIndent() {}		//g++ complains without this
};
extern const OstreamIndent INDENT;

/************************************************************************
Defines e.g. Istream's interface to command interpreter.
**************************************************************************/
#if 0
interface	/*read by OTSO prepro only*/
#endif
/* */

class IstreamSP {
public:
  virtual void Exit() = 0;		//exit OTSO
  virtual void debug() = 0;		//Go to debugger (set a break
                                        //point in ::debug())
  virtual void outputRedirection(String filename, 
				 boolean isDoutLoggingThereToo) = 0;
                                        //logging: copy input and output 
                                        //to a file
  virtual void inputRedirection(String filename) = 0;
                                        //read command input from a file
  virtual void logInputToFile(boolean yes_1_or_no_0) = 0;
                                        //Set din input logging to file 
                                        //on or off.
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(IstreamSP);
};

DECLARE_OTSO_PAED_FOR(IstreamSP);

/************************************************************************
Defines e.g. Ostream's interface to command interpreter.
**************************************************************************/
#if 0
interface	/*read by OTSO prepro only*/
#endif
/* */

class OstreamSP {
public:
  virtual void outputLogging(String filename,
				 boolean isDinLoggingThereToo) = 0;
                                        //logging: copy (!) output to file
  virtual void logOutputToFile(boolean yes_1_or_no_0) = 0;
                                        //Logging dout output to file:
                                        //set on or off.
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(OstreamSP);
};

DECLARE_OTSO_PAED_FOR(OstreamSP);


/******************************************************
Ostreams encode variables into a byte stream.
There is one derived Ostream for each transfer syntax.
The basic Ostream outputs to a human reader.
******************************************************/

class ClientSocket;

class Ostream : public Channel, public ostream_withassign, public OstreamSP {
public:
  Device*		pdevice; 	//asynchronous OTSO output device.
#if NO_IOSTREAM_CLASSES
  FILE*			fdstream;	//created from fd ... ?
#endif

#if !(COMPILER_GPLUS || LIB_GPLUS)
/*  ostream_withassign		os;	//keep Cfront happy */ /* */
  ofstream*		pofs;		//for Ostream(fd) ctor
#else
/*  ostream&		os;		//keep g++ happy */ /* */
#endif

  virtual void		print(Ostream& os);

  Ostream (ClientSocket*, String hostName, sint16 port);
                                        //

public:
#if !(COMPILER_GPLUS || LIB_GPLUS)
  Ostream (Ostream& O,   Ostream *log=NULL);
  Ostream (ostream& o,   Ostream *log=NULL);
#if !MSDOS
  Ostream (Device* pdev, Ostream *log=NULL);
#endif
  Ostream();
  ~Ostream();
#else
  Ostream (Ostream& O, Ostream *log=NULL)
    : indentLevel_(0), ostream_withassign(O) {initOstream();}
  Ostream (ostream& o, Ostream *log=NULL)
    : indentLevel_(0), ostream_withassign(o) {initOstream();}
  Ostream (Device* pdev, Ostream *log=NULL) 
    : indentLevel_(0), ostream_withassign(pdev->fd()) {initOstream();}
#endif
private:
  Ostream(const Ostream&);		//don't use
  void operator=(const Ostream&);	//don't use

public:
  void 			addIndent(sint16 delta);
                                        //Add or decrease indentLevel_ to 
                                        //change the subsequent indents.
  Ostream&		operator<<(OstreamIndent dummy);
                                        //Print 'indentLevel_' spaces.
  virtual void logOutputToFile(boolean yes_1_or_no_0=false);
                                        //Copying dout output to file:
                                        //set on (true) or off.
/************************
.SH Connection to the receiver
*************************/
  boolean isConnected();		//True if this has a device that is 
                                        //connected to a receiving device.
  boolean connect();			//Attempt to establish a connection,
                                        //return true if successful.

protected:
  int			port_;		//e.g. 4000
  String 		hostName_;	//e.g. "tel2"
  boolean 		isConnected_;	//True if clientSocket->Connect
                                        //was successful.
  ClientSocket* 	clientSocket_;	//the same as pdevice!?
                                        //but of type ClientSocket*
private:
  void			indent();	//Implements op<<(OstreamIndent)
                                        //which is called by "os << INDENT".
  sint32		indentLevel_;	//the number of spaces that indent()
                                        //prints.
public:
  sint32		indentLevel();	//returns indentLevel_

/*******************
.SH Logging
*******************/
public:
  virtual void outputLogging(String filename, boolean isDinLoggingThereToo);
                                        //send output to file=
  boolean logging;			//log state
  Ostream *logger;			//log stream

/*******************
.SH Miscellaneous
*******************/
  void 			initOstream(Ostream*);
  virtual String	className() const;
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(Ostream);
};


/******************************************************
Istreams decode a byte stream into variables.
There is one derived Istream for each transfer syntax.
The basic Istream reads from a human writer.
Istream objects must be run every now and then.
******************************************************/

class Istream : public Channel, public istream_withassign, public IstreamSP {
#if BSD
  friend class ServerSocket;	//See comment above (*BSD-NOTE*).
#endif

private:
  filebuf*	fbp;		//declared before fbis!
  istream*	fbisp;		//???????
public:	
  boolean 	isReadyToRead();//true iff there is something to read in buffer

/*******************
.SH Logging
*******************/
public:
  boolean	logging;	//log state (true: log Istream::operator>>)
  Ostream	*logger;	//log stream
  Ostream*	tiedTo();	//like istream::tie() but Ostream*

public:
  Device*		pdevice; //asynchronous OTSO input device.
#if NO_IOSTREAM_CLASSES
  FILE*			fdstream;	//created from fd ... ?
#endif

#if !(COMPILER_GPLUS || LIB_GPLUS)
  ifstream*		pifs;	//ctor (int fd)
#endif

/******************
.SH Command interpreter
******************/
protected:
  virtual void commandInterpreter();	//Read and interpret a command.

public:
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(Istream);
  virtual void Exit();			//exit OTSO
  virtual void debug();			//Go to debugger (if there is a break
                                        //point in debug() function)
  virtual void outputRedirection(String filename, 
				 boolean isDoutLoggingThereToo);
                                        //send output to file (log?)
  virtual void inputRedirection(String filename);
                                        //read input from file

/*******************
.SH Miscellaneous
*******************/

  virtual void		run();
  virtual String	className() const;
  virtual void		print(Ostream& os);
  virtual void 		logInputToFile(boolean yes_1_or_no_0=false);
                                        //Copying input to log file:
                                        //set on or off.

private:
  void initIstream ();

public:

#if !(COMPILER_GPLUS || LIB_GPLUS)
  Istream (Istream& I, Ostream *log=NULL) ;
  Istream (istream& i, Ostream *log=NULL) ;
#if !MSDOS
  Istream (Device *pdev, Ostream *out=NULL, int skip=0, Ostream *log=NULL);//old
  Istream (istream& i, Device *pdev, Ostream *out=NULL, int skip=0, Ostream *log=NULL);//new
#endif
  Istream(String filename);		//e.g. macro file input
  Istream();
  ~Istream() ; 
#else
  Istream (const Istream& i, Ostream *log=NULL)	: is(i)
    { logger = log; initIstream();}
  Istream (const istream& i, Ostream *log=NULL)	: is(i)
    { logger = log; initIstream();}
  Istream (Device* pdev, Ostream* out=NULL, int skip=0, Ostream *log=NULL) ;
#endif

private:
  Istream(const Istream&);		//don't use
  void operator=(const Istream&);	//don't use
};

// 

/**********************************************************************
       IDumps and ODumps 
**********************************************************************/

/**********************************************************************
ODump and IDump specify the transfer syntax between two address spaces.
ODump and IDump implement a very simple, default version of 
inter-process communication.  It is not fast, reliable, or elegant.

ODump encodes objects by applying their to() operation.
*******************************************************/

class ODump : public Ostream {
public:
  virtual String	className() const;

  ODump (Ostream& O);
  ODump (ostream& o);
#if !MSDOS
  ODump (Device* pdev);
  ODump (ClientSocket*, String hostName, sint16 port);
                                        //
#endif
};

/**********************************************************************
IDump decodes objects by applying their from() operation.
IDump objects must be run every now and then.
**********************************************************************/

class IDump : public Istream {
public:
  virtual String	className() const;
  virtual void		run();

  IDump (Istream& I);
  IDump (istream& i);
#if !MSDOS
  IDump (Device* pdev, ODump *out=NULL, int skip=0);
#endif    
  IDump ();
};
