/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.voidgrp.cxx
 * Vers: 5.2    Time: 92/08/04, 12:24:24
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)voidgrp.cxx	5.2 92/08/04";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* NAME
*	voidgrp.cxx
*
* PURPOSE
*	The OTSO class VoidGroup is the base class for several
*	different types of container classes.  The container
*	classes contain collections of objects, ordered in
*	different ways (fifo, lifo, dyndir, ring, heap, etc).
*
*	The base class "VoidGroup" defines certain shared properties
*	of a generic container class, (e.g. the ability to put,
*	or get a list of objects to/from the container, the ability
*	to find the first object, the ability to iterate through
*	the list, etc.)
*
* BUGS
* MODIFICATIONS
**********************************************************************/


#define CHANNEL_HXX	1
#define GROUP_HXX	1
#define MULTI_HXX	1
#define NAMEDOBJ_HXX	1
#define OBJECT_HXX	1
#define RUNNER_HXX	1
#define SAMPLED_HXX	1
#define STATOBJ_HXX	1
#define STRING_HXX	1
#define TIME_HXX	1
#define TYPE_HXX	1
#define VOIDGRP_HXX	1

#define OTSO_SELECT_INCLUDES	1 /* take only these headers */
#include "OTSO.hxx"	/* include them now */




VoidGroup::VoidGroup(): size_(0) {}

sint32 VoidGroup::size() const {return size_;}

String VoidGroup::className() const {return "VoidGroup";}

VoidGroup& VoidGroup::put(const VGE o1, const VGE o2,
		  const VGE o3, const VGE o4,
		  const VGE o5, const VGE o6) {
  put(o1);
  if (o2) put(o2);
  if (o3) put(o3);
  if (o4) put(o4);
  if (o5) put(o5);
  if (o6) put(o6);
  return *this;
}

boolean VoidGroup::over(const VGP l) {
  return (l == &dummyRunner || l == NULL);
}

void VoidGroup::print(Ostream& os) {
  os << className() << ", " << size() << " elements ";
}

VoidFifo::VoidFifo() {
  fst = last = NULL;
}

VoidFifo::~VoidFifo() {
  while (get() != (VGE)&dummyRunner)
    ;				//get all elements to delete Links.
                                //VGEs are NOT deleted!
}

VGE VoidFifo::get() {
  VGE o;
  VoidLink* l = fst;
  if (l==NULL)
    o = (VGE)&dummyRunner;
  else {
    o = (VGE)l->element;
    fst = fst->next;
    delete l;
    size_++;
  }
  return o;
}

VoidGroup& VoidFifo::put(const VGE o) {
  VoidLink *l = new VoidLink(o, NULL);
  if (fst==NULL) fst = l;
  else last->next = l;
  last = l;
  size_++;
  return *this;
}

String VoidFifo::className() const {return "VoidFifo";}

VGE VoidFifo::first(VGP& link) {
  return (fst==NULL)? (link = &dummyRunner) : ((VoidLink*)(link = fst))->element;
}

VGE VoidFifo::next(VGP& link) {
  return (link == NULL || (link = ((VoidLink*)link)->next) == NULL)?
    &dummyRunner : ((VoidLink*)link)->element;
}

void VoidFifo::reset() {
  OTSO_WARNING( "Sorry, VoidFifo::reset() not implemented" );
}


String VoidLifo::className() const {return "VoidLifo";}

VoidLifo::VoidLifo() {}

VoidGroup& VoidLifo::put(const VGE o) {
  VoidLink *l = new VoidLink(o, NULL);
  if (fst==NULL) fst = l;
  else l->next = fst;
  fst = l;
  size_++;
  return *this;
}
