/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.type.cxx
 * Vers: 5.2    Time: 92/08/04, 12:24:22
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)type.cxx	5.2 92/08/04";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* NAME
*	type.cxx
*
* PURPOSE
*
*
* MODIFICATIONS
* BUGS
**********************************************************************/

#define AGENT_HXX	1	/*inline Message::destProcess()*/
#define CHANNEL_HXX	1
#define GROUP_HXX	1
#define TYPE_HXX	1
#define MESSAGE_HXX	1
#define MULTI_HXX	1
#define NAMEDOBJ_HXX	1
#define OBJECT_HXX	1
#define RUNNER_HXX	1
#define SAMPLED_HXX	1
#define STATOBJ_HXX	1
#define STRING_HXX	1
#define TIME_HXX	1	/* *MJS* changes - jfr! */
#define FIFO_HXX	1	/*MemberObjectList*/

#define OTSO_SELECT_INCLUDES 1	/* take only these headers */
#include "OTSO.hxx"		/* include them now */


/* OTSO tool debugging tracing */
#define BUGOUT(xxx)  /*** dout << "###dbug type.cxx### - " << xxx << "\n" ***/
#define BUGOUT2(xxx) /*** dout << "###dbug type.cxx### - " << xxx << "\n" ***/

/********** predefined types **************************************/

IMPLEMENT_OTSO_PAED_FOR_INTEGRAL(sint32,4,sint32);
IMPLEMENT_OTSO_PAED_FOR_INTEGRAL(uint32,4,uint32);
IMPLEMENT_OTSO_PAED_FOR_INTEGRAL(sint16,2,sint16);
IMPLEMENT_OTSO_PAED_FOR_INTEGRAL(uint16,2,uint16);
IMPLEMENT_OTSO_PAED_FOR_INTEGRAL(sint8,1,sint16);	/*!?*/
IMPLEMENT_OTSO_PAED_FOR_INTEGRAL(uint8,1,uint8);	/*?*/

/*IMPLEMENT_OTSO_PAED_FOR_DOUBLE(double,4)*/

  Object* objectify(double& t) 						
        {return new Objectifier(&t, concat(otsoType_,double));}		
  Ostream& operator<<(Ostream& os, double &  t)				
        {os.ostream_withassign::operator<<(t);				
	 return os;}							
  Istream& operator>>(Istream& is, double & t) 				
	{is.istream_withassign::operator>>(t);				
	 OTSO_WARNING("Got double " << t );
	 return is;}							
  ODump& operator<<(ODump& od, double &  t)				
        {OTSO_ERROR(stringize(double) "encoding not implemented");	
	 return od;}							
  IDump& operator>>(IDump& id, double & t)				
        {OTSO_ERROR(stringize(double) "decoding not implemented");	
	 return id;}							
  Istream& concat(otsoAsk,double) (Istream& is, double *t)
        {is >> *t; return is;}						
  Ostream& concat(otsoPrint,double) (Ostream& os, double * t)		
        {os << *t; return os;}						
  ODump& concat(otsoEncode,double) (ODump& od, double * t)
        {od << *t; return od;}						
  IDump& concat(otsoDecode,double) (IDump& id, double * t)
        {id >> *t; return id;}						
  Type* concat(otsoType_,double) = new HardType(
	 String(stringize(double))					
         ,(OtsoPrintFnPointer) concat(otsoPrint,double)			
         ,(OtsoAskFnPointer) concat(otsoAsk,double)			
	 ,(OtsoEncodeFnPointer) concat(otsoEncode,double)
	 ,(OtsoDecodeFnPointer) concat(otsoDecode,double)
	);								
  double concat3(otso,double,Dummy);					


/********** VoidPointer *******************************************/

IMPLEMENT_OTSO_INTERNALS_FOR(VoidPointer,operator<<,0,operator<<,operator>>);
IMPLEMENT_OTSO_RETURN_TYPE(VoidPointer);

Ostream& operator<<(Ostream& os, VoidPointer& p) {	
  //os << hex;
  return os << (long)p.p;
}

//Istream& operator>>(Istream& is, VoidPointer& p) {return is;}

ODump& operator<<(ODump& od, VoidPointer& p) {
  return od << (uint32)p.p;	//?
}

IDump& operator>>(IDump& id, VoidPointer& p) {
  uint32 i;			
  id >> i;			//?
  p.p = (void*)i;		//?
  return id;
}

/******* globals *****************************************************/

DataMember noOtsoMembers("noOtsoMembers",0,0,"");

boolean otsoReadPositiveLong(sint32& i) {
  char c;
  din.get(c);
  if (isdigit(c)) {
    din.putback(c);
    din.istream_withassign::operator>>(i);
    return true;
  }
  else {
    i = 0;
    return false;
  }
}

boolean otsoReadLong(sint32& i) {
  char c;
  while (din.get(c) && isspace(c));		//skip white space
  if (isdigit(c)) {
    din.putback(c);
    return otsoReadPositiveLong(i);
  }
  if (c=='-') {
    sint32 j = 0;
    if (otsoReadPositiveLong(j)) {
      i = -j;
      return true;
    }
    else
      return false;
  }
  else
    return false;
}

/******* otsoType_void ***********************************************/

Ostream& otsoPrintvoid (Ostream& os, void*) {
  os << "void ";
  return os;
}

Istream& otsoAskvoid (Istream& is, void*) {
  return is;
}

ODump& otsoEncodevoid (ODump& os, void*) {
  return os;
}

IDump& otsoDecodevoid (IDump& is, void*) {
  return is;
}

Type* otsoType_void = new HardType(
	 "void"
         ,(OtsoPrintFnPointer) otsoPrintvoid
         ,(OtsoAskFnPointer) otsoAskvoid
         ,(OtsoEncodeFnPointer) otsoEncodevoid
         ,(OtsoDecodeFnPointer) otsoDecodevoid
	);							

/******* otsoType_async ***********************************************/

Type* otsoType_async = new HardType(
	 "async"
         ,(OtsoPrintFnPointer) otsoPrintvoid	//never called for async (?)
         ,(OtsoAskFnPointer) otsoAskvoid	//never called for async (?)
	);							

/*********************************************************************/

String* otsoInitializationErrors;

static char* spaceTab = 
  "                                                                                "; //80 spaces
static String indentF(uint16 ind) {return &spaceTab[sizeof(spaceTab)-ind];} 

/**********************************************************************/

Type::Type(const String& name, ClassMember* memberList)
     : name_(name), firstMember_(memberList)
{
#if 0
#if DEBUGGING_FREE_STORE_MEMORY
#include "memdbgSP.hxx"
#include "memdbg.hxx"
  //
  //see ::operator new() !
  if (::latestIndex) {
    MBlockInfo& mbi = (*memoryWatchdog)[::latestIndex];
    if ((void*)this == mbi.pointer() ||
	mbi.pointer() < (void*)this && 
	(void*)this < (char*)mbi.pointer() + mbi.size()
       ) {
	 mbi.setObject(this);
	 ::latestIndex = 0;
       }
  }
#endif
#endif
  //ClassMember ctor in the same way
}

HardType::HardType(const String&	name, 	
		   OtsoPrintFnPointer	printFn,
		   OtsoAskFnPointer	askFn, 
		   OtsoEncodeFnPointer	encodeFn,
		   OtsoDecodeFnPointer	decodeFn,	   
		   ClassMember* 	memberList)
     : Type(name, memberList)
     , askFn_(askFn)
     , printFn_(printFn)
     , encodeFn_(encodeFn)
     , decodeFn_(decodeFn)
{}

EnumType::EnumType(const String& name, 
		   EnumInfo* info,	
		   OtsoPrintFnPointer printFn,
		   OtsoAskFnPointer askFn)
     : HardType(name, printFn, askFn)
     , info_(info)
{}

/**********************************************************************/

ClassMember::ClassMember(const String& name, 
			 const String& helpText)
     : name_(name)
     , helpText_(helpText)
     , next_(0)			//updated in operator,
     , first_(this)		//updated in operator,
{}

MethodMember::MethodMember(const String& name, 
			   OtsoNewMsgFnPointer newMsgFn, 
			   const String& helpText)
     : ClassMember(name, helpText)
     , newMsgFn_(newMsgFn)
{}

PublicBaseClass::PublicBaseClass(const String& name, 
				 Type** base, 
				 Offset offset, 
				 const String& helpText)
    : ClassMember(name, helpText)
    , type_(base)
    , offset_(offset)
    , isWorthPrinting_(false)
    , isKnownIfWorthPrinting_(false)
{
#if 0	/*obsolete*/
  if (!*type_) {		//can't use dout before initOTSO();
    if (!::otsoInitializationErrors) ::otsoInitializationErrors = new String;
    *::otsoInitializationErrors += 
        "***** OTSO WARNING: " + name + "'s PublicBaseClass constructor:\n"
      + "      Type * == 0\n"
      + "      Probably incorrect initialization order:\n"
      + "      Try rearranging the IMPLEMENT_OTSO_... macro calls!\n\n";
  }
#endif
}

DataMember::DataMember(const String& name, Type** type, Offset offset, 
		       const String& helpText):
	ClassMember(name, helpText),
	type_(type),
	offset_(offset)
{}

AbsoluteDataMember::AbsoluteDataMember(const String& name,
				       Type** type,
				       Offset offset, 
				       const String& helpText)
     : DataMember(name, type, offset, helpText)
{}


/**********************************************************************/

Type* DataMember::type() const {
  if (*type_) 
    return *type_;
  else {
    OTSO_ERROR( "DataMember " << name() << ": Unknown type" );
    return 0; //?
  }
}

Type* PublicBaseClass::type() const {
  if (*type_) 
    return *type_;
  else {
    OTSO_ERROR( "PublicBaseClass " << name() << ": Unknown type" );
    return 0; //?
  }
}

/**********************************************************************/

String ClassMember::name() const {return name_;}

String PublicBaseClass::name() const {return type()->name();}

ClassMember* ClassMember::first() const {
  if (this == &::noOtsoMembers)
    return 0;
  else
    return first_;
}

/**********************************************************************/

boolean DataMember::isWorthPrinting() {return true;}

boolean MethodMember::isWorthPrinting() {return false;}

boolean PublicBaseClass::isWorthPrinting() {
  if (isKnownIfWorthPrinting_)
    return isWorthPrinting_;

  //This is the first time executing this function for this object.
  //Set isWorhtPrinting_ and isKnownIfWorhtPrinting_.
  FOR_EACH_mbr_IN(type()) {
    if (mbr->isWorthPrinting()) {
      isWorthPrinting_ = true;
      break;
    }
  }
  isKnownIfWorthPrinting_ = true;
  return isWorthPrinting_;
}

/**********************************************************************/

void HardType::print(Ostream& os, void* instancePtr) {
  if (printFn_)
    printFn_(os, instancePtr);
  else if (firstMember_)
    Type::print(os, instancePtr);
  else
    OTSO_WARNING("Neither a printing function nor a member list for " << name());
}

void Type::print(Ostream& os, void* structPtr) {
  os << "{\n";
  os.addIndent(+2);
    FOR_EACH_mbr_IN(this) {
      mbr->print(os, structPtr);
    }
  os.addIndent(-2);
  os << INDENT << "}";
}

void DataMember::print(Ostream& os, void* structPtr) {
  os << INDENT << name_ << " ";
  type()->print(os, (char*)structPtr + offset_);
  os << "\n";
}

void MethodMember::print(Ostream&, void*) {}

void PublicBaseClass::print(Ostream& os, void* derivedPtr) {
  if (isWorthPrinting()) {
    os << INDENT << name() << " ";
    type()->Type::print(os, (char*)derivedPtr + offset_);
    os << "\n";
  }
}

void EnumType::print(Ostream& os, void* enumPtr) {
  sint32 i = *(int*)enumPtr; //?, int?
  EnumInfo* info = info_;
  while (info->name) {
    if (info->value == i) {
      os << info->name << " (" << i << ")";
      return;
    }
    info++;
  }
  //i not found in info-array
  os << "out of range (" << i << ")";
}

/**********************************************************************/

Ostream& operator<<(Ostream& os, Type& t) {
  os << t.name();
  //t.print(os,?);
  return os;
}

Istream& operator>>(Istream& is, Type& /*t*/) {
  dout << "op>>(is,Type&) not implemented\n";
  //t.ask(is,?);
  return is;
}

/**********************************************************************/

void HardType::ask(Istream& is, void* instancePtr) {
  if (askFn_)
    askFn_(is, instancePtr);
  else if (firstMember_)
    Type::ask(is, instancePtr);
  else
    OTSO_WARNING("Neither an ask function nor a member list for " << name() );
}

void Type::ask(Istream& is, void* structPtr) {
  Ostream& os = *is.tiedTo(); 
  os << "{\n";
  os.addIndent(+2);
  FOR_EACH_mbr_IN(this) {
    mbr->ask(is, structPtr);
  }
  os.addIndent(-2);
  os << INDENT << "}\n"; 
}

void DataMember::ask(Istream& is, void* structPtr) {
  //test if there is unprocessed text in buffer. This is wrong:
  //if (is.pdevice->pending & ev_read) print the following:
  { 
    Ostream& os = *is.tiedTo();
    os << INDENT << name_;
    if (type()->name() != "Object")	//see otsoAskObject()!  We know the 
                                        //type name more specifically there.
      os << " (" << type()->name() << ") ";
  }
  type()->ask(is, (char*)structPtr + offset_);
}

void MethodMember::ask(Istream&, void*) {}

void PublicBaseClass::ask(Istream& is, void* p) {
  if (isWorthPrinting()) {
    //if (name() == "Object") return;	//?, to avoid "Object {\n}\n"
    *is.tiedTo() << INDENT << name() << " ";
    type()->Type::ask(is, (char*)p + offset_);
  }
}

void EnumType::ask(Istream& is, void* ip) {
  int i; 
  EnumInfo* info = info_;
  *is.tiedTo() << "\n";
  is.tiedTo()->addIndent(+2);
  while (info->name) {
    *is.tiedTo() << INDENT << info->value << ":  " << info->name << "\n";
    info++;
  }
  *is.tiedTo() << INDENT;
  is >> i;
  is.tiedTo()->addIndent(-2);
  *(int*)ip = i; //?
  //check range
}

/**********************************************************************/

void HardType::encode(ODump& od, void* p) {
  if (encodeFn_)
    encodeFn_(od, p);
  else if (firstMember_)
    Type::encode(od, p);
  else
    OTSO_WARNING("Neither an encoding function nor a member list for " << name() );
}

void Type::encode(ODump& od, void* structPtr) {
  FOR_EACH_mbr_IN(this) {
    mbr->encode(od, structPtr);
  }
}

void DataMember::encode(ODump& od, void* structPtr) {
  type()->encode(od, (char*)structPtr + offset_);
}

void MethodMember::encode(ODump&, void*) {}

void PublicBaseClass::encode(ODump& od, void* structPtr) {
  type()->Type::encode(od, (char*)structPtr + offset_);
}

/**********************************************************************/

void HardType::decode(IDump& id, void* p) {
  if (decodeFn_)
    decodeFn_(id, p);
  else if (firstMember_)
    Type::decode(id, p);
  else
    OTSO_WARNING( "Neither a decoding function nor a member list for " << name() );
}

void Type::decode(IDump& id, void* structPtr) {
  FOR_EACH_mbr_IN(this) {
    mbr->decode(id, structPtr);
  }
}

void DataMember::decode(IDump& id, void* structPtr) {
  type()->decode(id, (char*)structPtr + offset_);
}

void MethodMember::decode(IDump&, void*) {}

void PublicBaseClass::decode(IDump& id, void* structPtr) {
  type()->Type::decode(id, (char*)structPtr + offset_);
}

/**********************************************************************/

void Type::printMsgs(Ostream* osp, boolean help) {
  Ostream& os = *osp;
  if (help) os << "{\n";
  else os << "{";
  os.addIndent(+2);
    //if (help) os << INDENT;
    FOR_EACH_mbr_IN(this) {
      mbr->printMsgs(osp, help);
    }
    if (help) os << "\n";
  os.addIndent(-2);
  os << INDENT;
  os << "}\n"; 
}

void DataMember::printMsgs(Ostream* osp, boolean help) {
  if (help) {
    bulletLine(*osp, String(nSpaces(osp->indentLevel())) + name_ + " : ", 
	       helpText_, 25 + osp->indentLevel(), 75);
    *osp << "\n";
  }
  else {
    *osp << name_ << " ";
  }
}

void MethodMember::printMsgs(Ostream* osp, boolean help) {
  if (help) {
    bulletLine(*osp, String(nSpaces(osp->indentLevel())) + name_ + " () : ", 
	       helpText_, 25 + osp->indentLevel(), 75);
    *osp << "\n";
  }
  else {
    *osp << name_ << " ";
  }
}

void PublicBaseClass::printMsgs(Ostream* osp, boolean help) {
  Ostream& os = *osp;
  os << "\n";	//PUBLIC_BASE_CLASSes should be in the end of member list
  String tmp = "(" + name() + " PART) ";
  if (help) {
    bulletLine(*osp, String(nSpaces(osp->indentLevel())) + tmp, helpText_, 
	       25 + osp->indentLevel(), 75);
    // *osp << "\n";
  }
  else {
    *osp << tmp;
  }
  type()->Type::printMsgs(osp, help);
}

void HardType::printMsgs(Ostream* osp, boolean help) {
  if (firstMember_)				//?
    Type::printMsgs(osp, help);
  else {					
    String delimiter = " ";
    if (help) delimiter = "\n";

    *osp << "{";
    if (printFn_) *osp << "print" << delimiter;
    if (askFn_)   *osp << " =" << delimiter;
    *osp << "}\n";
  }
}

/**********************************************************************/

void ClassMember::printMsgHelp(Ostream* osp, sint16 charsPrintedOnThisLine) {
  Ostream& os = *osp;
  static char* tab = "                        : ";
  static sint16 tabLen = strlen(tab);

  if (helpText_) {
    sint16 l = charsPrintedOnThisLine;
    if (l > tabLen-2) os << "\n" << tab;
    else os << &tab[l];
    os << helpText_;
  }
}

/**********************************************************************/

Member HardType::memberObject(String& name, Objectifier& sp) {
  if (firstMember_)	//?
    return Type::memberObject(name, sp);
  else
    return 0;	//HardType::memberObject2 will take care of things
}

Member Type::memberObject(String& name, Objectifier& sp) {
  BUGOUT( this->name() << ".Type::mbO(" << name << "," << sp << ")" );
  Member ret = 0;
  FOR_EACH_mbr_IN(this) {
    if ((ret = mbr->memberObject(name, sp)) != 0)
      return ret;
  }
  return 0;
}

Member HardType::memberObject2(String& na, Objectifier& sp,
				MemberObjectList& l) {
  if (firstMember_) {
    return Type::memberObject2(na, sp, l);
  }

  boolean containsWildCard = false;
  String name(na.length() + 2);			//some extra space ...
  name = na;
  char* cp = name;
  while (*cp) {
    if (*cp++ == '*') containsWildCard = true;
  }
  if (!containsWildCard) {
    *cp = '*'; 
    *++cp = 0; 					//... extra space needed
  }

  if (matches(name,"print"))			//"printToDout" ?
    print(dout, sp.otsoMostDerivedPointer());
  else if (matches(name,"="))			//"askFromDin" ?
    ask(*dinStream, sp.otsoMostDerivedPointer());
  else return 0;	//no match

  BUGOUT( this->name() << "'s HIT HardType::mbO2" );
             //na matched something: return something else than 0
             //so that no further actions are taken for sp
  return &dummyObject;
}

Member Type::memberObject2(String& na, Objectifier& sp,
				 MemberObjectList& mol) {
  boolean containsWildCard = false;
  Member ret = 0;
  String name(na.length() + 2);			//some extra space ...
  name = na;
  char* cp = name;
  while (*cp) {
    if (*cp++ == '*') containsWildCard = true;
  }
  if (!containsWildCard) {
    *cp = '*'; 
    *++cp = 0; 					//... extra space needed
  }

  FOR_EACH_mbr_IN(this) {
    if ((ret = mbr->memberObject2(name, sp, mol)) != 0) {
      ;
      BUGOUT( "   @@@FOUND: " << ", mbr = " << *ret );
      BUGOUT2( "mol now = " << mol << "\n" );
    }
  }
  *--cp = 0;
  return 0; 
}

Member DataMember::memberObject(String& name, Objectifier& sp) {
  BUGOUT( this->name() << ".DataMember::mbO(" << name << "," << sp << ")" );
  if (name == name_) {
    //Objectifier* or = new Objectifier(sp + offset_, type());
    sp.setInstance( (char*)sp.otsoMostDerivedPointer() + offset_ );
    sp.setType(type());
    sp.name_ = name;
    
    BUGOUT( "### updated Objectifier: " << sp );
    BUGOUT( "@@@ returning &sp = " << (long)&sp );
    return &sp;
  }
  else
    return 0;
}

Member DataMember::memberObject2(String& name, Objectifier& sp, 
				  MemberObjectList& mol) {
  if (matches(name, name_)) {
    BUGOUT( this->name() << "'s DataMember::mbO2" );
    Objectifier* ret = 
      new Objectifier((char*)sp.otsoMostDerivedPointer() + offset_, type());
      //deleted in MemberObjectList::runUI (what about msgs?)
    ret->name_ = this->name_;
    BUGOUT( "### NEW Objectifier: " << *ret );
    //Runner* ret = &sp; 
    mol.insert(ret);
    mol.addCount(1);
    return ret;
  }
  else
    return 0;
}

Member AbsoluteDataMember::memberObject(String& name, Objectifier& ) {
  ::nullOtsoObjectifier.setInstance(0);
  return DataMember::memberObject(name, ::nullOtsoObjectifier);
}

Member AbsoluteDataMember::memberObject2(String& name,
					  Objectifier&, 
					  MemberObjectList& mol) {
  ::nullOtsoObjectifier.setInstance(0);
  return DataMember::memberObject2(name, ::nullOtsoObjectifier, mol);
}

Member MethodMember::memberObject(String& name, Objectifier& sp) {
  BUGOUT( this->name() << ".MethodMember::mbO(" << name << "," << sp << ")" );
  if (name == name_) {
    NewMsg* ret = newMsgFn_();
    BUGOUT( ">>> setting handlerPart and dest: " << sp );
    ret->setHandlerPart(sp.otsoMostDerivedPointer());
    ret->setDest(sp.object(), ::thisProcess);
    return ret;
  }
  else
    return 0;
}

Member MethodMember::memberObject2(String& name, Objectifier& sp, MemberObjectList& mol) {
  if (name == "*") //"*" refers only to DataMembers => easy to address them all
    return 0;

  if (matches(name, name_)) {
    NewMsg* msg = newMsgFn_();
    BUGOUT( ">>> setting handlerPart and dest: " << sp );
    msg->setHandlerPart(sp.otsoMostDerivedPointer());
    msg->setDest(sp.object(), ::thisProcess);
    Objectifier* ret = new Objectifier(msg);			//?
    ret->name_ = this->name_;
    ret->setIsMessage(true);
    mol.insert(ret);
    mol.addCount(MemberObjectList::ambiguityLimit);
    return 0; //ret;
  }
  else
    return 0;
}

Member PublicBaseClass::memberObject(String& name, Objectifier& sp) {
  BUGOUT(this->name() << ".PublicBaseClass::mbO(" << name << "," << sp << ")");
  BUGOUT( "   ### offset_ = " << (long)offset_ );

  //First check if name refers to base class name (this->name_)
  if (name == name_) {
    //probably called indirectly from XXXPtr::setSp()
    sp.setInstance( (char*)sp.otsoMostDerivedPointer() + offset_ );
    sp.setType(type());
    sp.name_ = name;
    BUGOUT( "### BASE CLASS NAME MATCHED, updated Objectifier: " << sp );
    BUGOUT( "@@@ returning &sp = " << (long)&sp );
    return &sp;
  }

  //Check if name is a member name.

  //Juha 9.4.92: StatObj default copy-constructor incorrect: don't use it here!
  //Objectifier backup = sp;
  //Use default ctor and (correct) assignment instead.
  Objectifier backup(&dummyObject);
  //Objectifier backup(0);
  backup = sp;

  sp += offset_;
  BUGOUT( "   ### attempting in PublicBC::mbObj sp = " << sp );
  Member ret = type()->memberObject(name, sp);
  if (!ret) {
    //attempt failed, cancel modifications of sp
    sp = backup;
    //ret = &sp;
  }
  else {
    ;
    BUGOUT( "   ### SUCCEEDED!" );
  }
  BUGOUT( "   ### PublicBC::mbObj: at end sp = " << sp );
  BUGOUT( "   @@@ &sp = " << (long)&sp );
  BUGOUT( "   @@@ returning ret = " << (long)ret );
  return ret;
}

Member PublicBaseClass::memberObject2(String& name, Objectifier& sp,
				      MemberObjectList& mol) {

  //Juha 9.4.92: StatObj default copy-constructor incorrect: don't use it here!
  //Objectifier backup = sp;
  //Use default ctor and (correct) assignment instead.
  Objectifier backup(&dummyObject);
  backup = sp;

  backup.setInstance(sp.otsoMostDerivedPointer());
  backup.setType(&sp.otsoType());
  backup.name_ = sp.name();

  sp += offset_;
  BUGOUT( "   ### PublicBC::mbObj2 tries sp = " << sp );
  Member ret = type()->memberObject2(name, sp, mol);

  if (!ret) {
    sp.setInstance(backup.otsoMostDerivedPointer());
    sp.setType(&backup.otsoType());
    sp.name_ = backup.name();
  }
  else {
    ;
    BUGOUT( "   @SUCCEEDED2" );
  }
  BUGOUT( "   ### PublicBC::mbObj2: at exit sp = " << sp );
  BUGOUT( "   @@@ &sp = " << (long)&sp );
  BUGOUT( "   @@@ returning " << (long)ret );
  return ret;
}

/**********************************************************************/

ClassMember& operator,(ClassMember& l, ClassMember& r) {
  l.next_ = &r;
  r.first_ = l.first_;
  return r;
}

ClassMember* Type::firstMember() {
  return firstMember_;
}

