/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.tree.cxx
 * Vers: 5.1    Time: 92/08/04, 15:14:35
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)tree.cxx	5.1 92/08/04";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


//      tree.cxx	- Juha 18.3.92

/**********************************************************************
This file is the combination of llist.cxx and tree.cxx
**********************************************************************/

//#include "channel.hxx"
//#include "tree.hxx"
#include "OTSO.hxx"


#if SIMULATING	/*up to the end of file*/

/*********************** llist.cxx ***********************************/

LinkedList::LinkedList()
{
	fst = cur = lst = 0;
	count = 0;
}

void LinkedList::add(void* obj)
{
	if (!fst) {
		fst = cur = lst = new VLink(obj);
	} else {
		cur = new VLink(obj);
		lst->next = cur;
		lst       = cur;
	}

	++count;
}

void LinkedList::del(void* obj)
{
	VLink*	p  = fst;
	VLink*	p2 = fst;

	for (; p2; p = p2, p2 = p2->next) {
		if (p2->obj == obj) {

			p->next = p2->next;
			if (fst == p2) fst = p2->next;
			if (cur == p2) cur = p2->next;
			if (lst == p2) lst = (p != p2) ? p : 0;

			delete p2;

			--count;

			return;
		}
	}

	OTSO_ERROR("LinkedList::del(" << (long)obj << "); no such object. LinkedList = \n" );
	for (p = fst; p; p = p->next)
	   dout << (long)p->obj << "\t";
	dout << "\n";
	dout.flush();
 	//int nolla = 0; int juha = 1/nolla;
	//exit (1);
}

void* LinkedList::first()
{
	cur = fst;
	return cur ? cur->obj : 0;
}

void* LinkedList::next()
{
	if (cur) {
		cur = cur->next;
		return cur ? cur->obj : 0;
	} else
		return 0;
}

boolean LinkedList::over()
{
  return (cur && cur->next) ? true : false;
}

void LinkedList::reset()
{
  void*   vp;
  for (vp = first(); vp; vp = next()) del(vp);
}


/*********************** tree.cxx **************************************/

void TreeNode::setParent(TreeNode* pp)
{
	if (pp)
		pp->addChild(this);
	else {
		if (parNode) parNode->delChildLink(this);
		parNode = 0;
	}
}

TreeNode* TreeNode::child(uint16 id)
{
	if (!id) {
		dout << "TreeNode::child(); id of the 1st child is 1, not 0\n";
		exit (1);
	}

	if (id > noOfChildren()) {
		dout << "TreeNode::child(); no such child\n";
		exit (1);
	}

	// *E* the following implementation is not optimal
	uint16	j;
	Object*	op;
	for (j = 1, op = (Object*) cldNodes.first();
	     j < id;
	     j++, op = (Object*) cldNodes.next());

	return (TreeNode*) op; 
}

void TreeNode::addChild(TreeNode* cp)
{
	if (cp->parent()) cp->parent()->delChildLink(cp);
	cp->setParentLink(this);

	addChildLink(cp);
}

void TreeNode::delChild(TreeNode* cp)
{
	delChildLink(cp);
	cp->setParentLink(0);
}

void TreeNode::addChildLink(TreeNode* cp)	{ cldNodes.add(cp); }

void TreeNode::delChildLink(TreeNode* cp)	{ cldNodes.del(cp); }

TreeNode::~TreeNode() {}

#endif	/*SIMULATING*/
