/**************************************************************
 *
 *  VALTION TEKNILLINEN TUTKIMUSKESKUS (VTT/TEL/TIV)
 *  Otakaari 7 B
 *  02150 Espoo
 *  FINLAND
 *
 *  DVOPS Source Code Control System, 12.7.89
 *
 *  Name:	/home/users/otso/official/otso/dvops/SCCS/s.timerman.cxx
 *  Version:	1.2
 *  Time:	91/11/14, 11:37:23
 *
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)timerman.cxx	1.2 91/11/14";
#endif

/**********************************************************************
* NAME
*	timerman.cxx
*
* PURPOSE
*	
* BUGS
* MODIFICATIONS
**********************************************************************/

#ifndef TIMERMAN_HXX
#include "timerman.hxx"
#endif

#include <stream.h>

void TimerMan::create (sint id, sint32 interval)
{
  TimerObj *item;

  item = new TimerObj (interval, id);
  stopList.put1 (item);
}

void TimerMan::start (sint id)
{
  TimerObj *item;

  stopList.remove (item, id);
  if (item == NULL)
    runList.remove (item, id);
  if (item == NULL)
    cout << "\nCannot start. Timer does not exist. ";
  else {
    item->elapsing = systime() + item->interval;
    runList.insert (item);
  }
}

void TimerMan::stop (sint id)
{
  TimerObj *item;

  runList.remove (item, id);
  if (item != NULL) {
    item->elapsing = 0;
    stopList.put1 (item);
  }
  else 
    cout << "\nTimer was not running.";
}

void TimerMan::kill (sint id)
{
  TimerObj *item;

  runList.remove (item, id);
  if (item == NULL)
    stopList.remove (item,id);
  if (item)
    delete item;
  else
    cout << "Cannot kill. Timer does not exist. ";
}

Ran TimerMan::run ()
{
  long curTime;
  TimerObj *item;
  curTime = systime();

  while ((runList.readFirst() != -1) && (runList.readFirst() < curTime)) {
    runList.get(item);
    item->elapsing = 0;
    stopList.put1 (item);
    cout << "\nTimeout on timer ";
    cout << item->id;
    cout << "\n";
  }
  return 0;
}

void TimerMan::print (ostream& os)
{
  os << "\nthe stopList: ";
  stopList.print(os);
  os << "\n";
  os << "the runList: ";
  runList.print(os);
  os << "\n";
}
 



