/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.time.cxx
 * Vers: 5.1    Time: 92/08/04, 13:19:12
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)time.cxx	5.1 92/08/04";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* NAME
*       time.cxx
*
* PURPOSE
*       Implements generic Time class, instead of using 
*	Operating specific time system calls.
*
* MODIFICATIONS
**********************************************************************/

// Include these files :
#define	CHANNEL_HXX		1
#define GROUP_HXX		1
#define	OBJECT_HXX		1
#define MULTI_HXX		1
#define NAMEDOBJ_HXX		1
#define	RUNNER_HXX		1
#define SAMPLED_HXX		1
#define STATOBJ_HXX		1
#define STRING_HXX		1
#define	TIME_HXX		1
#define	TYPE_HXX		1
#define OTSO_SELECT_INCLUDES    1	/* take only these headers */
#include "OTSO.hxx"     		/* include them now */


Time	dummyTime;

IMPLEMENT_OTSO_RETURN_TYPE(Time);

Time::Time() {set = false;}

Time::Time(const Time& t) {sec = t.sec; usec = t.usec; set = t.set;}

boolean	Time::operator==(const Time& t)
{
	return (sec == t.sec) && (usec == t.usec);
}

boolean Time::operator!=(const Time& t)
{
	return !(*this == t);
}

boolean Time::operator<(const Time& t)
{
	return (sec < t.sec)
		 ? true
		 : ((sec > t.sec) ? false
				  : ((usec < t.usec) ? true : false));
}

boolean Time::operator>(const Time& t)
{
	return (*this != t) && !(*this < t);
}

boolean Time::operator<=(const Time& t)
{
	return (*this == t) || (*this < t);
}

boolean Time::operator>=(const Time& t)
{
	return (*this == t) || (*this > t);
}

Time Time::operator+(const Time& t)
{
	Time	tt;

	tt.usec	= usec + t.usec;
	tt.sec  = sec  + t.sec;

	if (tt.usec >= 1000000) {
		++tt.sec;
		tt.usec -= 1000000;
	}

	tt.set = true;

	return tt;
}

Time Time::operator-(const Time& t)
{
	Time	tt;

	if (*this < t) {	// *E* *MJS*
		dout << "Time::operator-(); result would be negative!\n";
		exit (1);
	}

	tt.sec	= sec  - t.sec;

	if (usec < t.usec) {
		tt.usec = (1000000 + usec) - t.usec;
		--tt.sec;
	} else
		tt.usec = usec - t.usec;

	tt.set = true;

	return tt;
}

Time Time::operator+=(const Time& t)
{
	return *this = *this + t;
}

Time Time::operator-=(const Time& t)
{
	return *this = *this - t;
}

Time Time::operator*(const long c)
{
	Time	t;

	t.usec	= this->usec * c;
	t.sec	= this->sec * c + t.usec / 1000000;
	t.usec	= t.usec % 1000000;

	t.set	= true;

	return t;
}

Time::operator double()
{
	if (!set) {
		dout << "Time::operator double(); not set\n";
		exit (0);
	}

	return sec + ((double) usec) / 1000000;
}

char* Time::asctime()
{
	long	clock	= (long) sec;
	char*	s	= ::asctime(localtime(&clock));
	char*	cp;

	for (cp = s; *cp; cp++)
		if (*cp == '\n') {
			*cp = '\0';
			break;
		}

	return s;
}

char* Time::hmstime()
{
	static char	buf[80];
	uint32		tmp;

	if (sec >= 999 * 3600 + 59 * 60 + 59) return "XXX:XX:XX.XX";

	tmp = sec % 3600;
	sprintf(buf, "%3.3lu:%2.2lu:%2.2lu.%2.2lu",
		sec / 3600,
		tmp / 60,
		tmp % 60,
		(int) (usec / 10000.0 + 0.5));
	return buf;
}

void Time::print(Ostream& os)
{
	if (set)
		os << "(" << int(sec) << " secs, " << int(usec) << " usecs)";
	else
		os << "(time value not set)";
}

void Time::ask(Istream& is)
{	
  double d;
  din >> d;
  Time tmp = d;
  *this = d;
}

