/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.object.cxx
 * Vers: 5.3    Time: 92/08/04, 12:23:07
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)object.cxx	5.3 92/08/04";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
*  NAME
*	object.cxx
*
*  PURPOSE
*	- Class "Object" is the base class of all other base classes in
*	OTSO.  It contains functions that will be common to all other
*	classes, although many are virtual.  
*	- The purpose of object.cxx is to fill in default values/actions
*	for many of these virtual functions, in case the derived class
*	doesn't derive its own.
*
*  BUGS
*  MODIFICATIONS
***********************************************************************/

#define AGENT_HXX	1	/*inline Message::destProcess()*/
#define CHANNEL_HXX	1
#define DYNDIR_HXX	1	/*::namedObjs*/
#define FIFO_HXX	1	/*MemberObjectList*/
#define GROUP_HXX	1
#define MESSAGE_HXX	1
#define MULTI_HXX	1
#define NAMEDOBJ_HXX	1
#define OBJECT_HXX	1
#define PRIORVEC_HXX	1	/* iff SIMULATING, Heap needed*/
#define PROCESS_HXX	1
#define RUNNER_HXX	1
#define SAMPLED_HXX	1
#define STATOBJ_HXX	1
#define STRING_HXX	1
#define	TIME_HXX	1	/*Time class *MJS* changes - jfr! */
#define TYPE_HXX	1
#define VOIDGRP_HXX	1	/*because of DYNDIR_HXX*/

                                //if SIMULATING:
#define VCLOCK_HXX	1	/*GVClock*/
#define EV_HXX		1	/*vClock*/
#define NORMAL_HXX	1

#define OTSO_SELECT_INCLUDES 1 	/* take only these headers */
#include "OTSO.hxx"		/* include them now */

#if SIMULATING			/* defined only after #including OTSO.hxx */
#define OTSO_SIMU_SELECT_INCLUDES 1
#include "SIMU.hxx"
#endif

/* OTSO tool debugging tracing */
#define BUGOUT(xxx)  /*** dout << "### object.cxx - " << xxx << "\n"; ***/

/* ------ GLOBAL Definitions, Functions, Etc ------ */

boolean otsoJuhaIsDebugging = 0;


//Called by macro 'din' in object.hxx 
Istream& endOfOtsoInputFile() {
  Istream* previousIstream = dinStream;
  if ((dinStream = (Istream*)dinStack->get()) == &dummyRunner)
    systop();
  else
    delete previousIstream;
  return *dinStream;
}

const ConnectionId Object::noConnection = 0;

Object* objectify(Object* o) {
  return o;
}

void otsoSetName(Object* op, char* name) {op->setName(name);}
void otsoSetName(void*, char*) {}

/********************************************************************** 
class Object member functions 
***********************************************************************/

void Object::setName(char*) {}

void Object::setName(const String&) {}

boolean Object::isEmpty() {return false;}

void Object::reset() {}

Object::~Object() {}

//Object::Object() is in /otso/dvops/gend/memdbg.cx

void Object::printMsgs(Ostream* os, boolean help) { 
  otsoType().Type::printMsgs(os, help);
}


VoidPointer Object::memberPointer(String memberName) {
  //Object* o = this;	//?
  Objectifier o = this;
  Object* ret = otsoType().memberObject(memberName, o);
  if (ret)
    return ret->otsoMostDerivedPointer();
  else
    return 0;
}

String Object::className() const {
  return "Object";
}

String Object::name() const {
  return className();		//virtual
}

Process*& Object::process() const {
  return thisProcess;
}

Runner* Object::myScheduler() const {
  OTSO_WARNING("Object::myScheduler() should not be called.");
  return ::scheduler;	//?
}

Object* Object::server() {
  return this;
}

void Object::undefined(char* operation) const {
  OTSO_WARNING( "Undefined " << className() << "::" << operation );
}

async Object::timeout(sint32 id) {
  dout << name() << "::timeout(" << id << ") - no default actions\n";
}

/**********************************************************************/

Ostream& otsoPrintObject(Ostream& os, Object* op) {
  op->print(os);
  return os;
}

#if SIMULATING
class VOstream;
extern Ostream& operator<<(VOstream&, const Object&);
//these because of the following function:
#endif

Ostream& operator<<(Ostream& os, const Object& o) {
  o.print(os); 
  return os;
}

Istream& otsoAskObject(Istream& is, Object* op) {
  if (op->otsoType().name() == "Object")	//see DataMember::ask()!
    *is.tiedTo() << " (" << op->className() << ") ";
  op->ask(is);
  return is;
}

Istream& operator>>(Istream& is, Object& o) {
  o.ask(is);
  return is;
}

ODump& otsoEncodeObject(ODump& od, Object* op) {
  op->to(od);
  return od;
}

ODump& operator<<(ODump& od, Object& o) {
  o.to(od);
  return od;
}

IDump& otsoDecodeObject(IDump& id, Object* op) {
  op->from(id);
  return id;
}

IDump& operator>>(IDump& id, Object& o) {
  o.from(id);
  return id;
}

/**********************************************************************/

void Object::print(Ostream& o) {
  if (!o.isEmpty())
    o << className();
}

void Object::ask(Istream&) {
  OTSO_WARNING( className() << "::ask() not implemented" );
}

void Object::to(ODump&) {
  OTSO_WARNING( className() << "::to() not implemented" );
}

void Object::from(IDump&) {
  OTSO_WARNING( className() << "::from() not implemented" );
}

/**********************************************************************/

// *MJS* added following three functions: - jfr!
Time& Object::time()
{
#if SIMULATING
        return globals->simulating() ? vClock.value() : systime();
#else
        return systime();
#endif
}

//added dummy cpuTime and realTime - Juha 19.3.92

Time& Object::cpuTime() {
  static Time t = 0.0;
  OTSO_WARNING("Sorry, Object::cpuTime() not yet implemented in tel2");
  return t;
}

Time& Object::realTime() {
#if 1	/*Juha 8.5.92*/
  return systime();
#else
  static Time t = 0.0;
  OTSO_WARNING("Sorry, Object::realTime() not yet implemented in tel2");
  return t;
#endif
}

/**********************************************************************/

void Object::asnEncode(Frame&) {
  this -> undefined("asnEncode(Frame&)");
}

void  Object::asnDecode(Frame&) {
  this -> undefined("asnDecode(Frame&)");
}

Ostream& operator<<(Ostream& os, Object*& ptr) {
  OTSO_WARNING("operator<<(Ostream&, Object*&)");
  if (!ptr->server()->process()->local())
    os << ptr->server()->process()->name() << ":";
  os << ptr->server()->name();
  return os;
}

Istream& operator>>(Istream& is, Object*&) {
  OTSO_WARNING( "operator>>(Istream&, Object*&) not implemented" );
  return is;
}

ODump& operator<<(ODump& od, Object*& ptr) {
  OTSO_WARNING("operator<<(ODump&, Object*&)");
  od << ptr->process()->name();
  od << ptr->name();
  return od;
}

IDump& operator>>(IDump& id, Object*& ptr) {
  OTSO_WARNING("operator>>(IDump&, Object*&)");
  String processName;
  id >> processName;
  //BUGOUT("procName = "); BUGOUT(processName);

  // the next type cast gives the correct idea,
  // but compiler does not like it
  Process* tmpProc = (Process*)::namedObjs -> pointer(processName); //=0;
  if (ptr != NULL)
    ptr -> process() = tmpProc; // msg source() or dest()

  String objectName;
  id >> objectName;
  //BUGOUT("objectName = "); BUGOUT(objectName);
  Object* object = ::namedObjs -> pointer(objectName);
  if (object == ::dummyNamedObj)
      OTSO_ERROR( "Unknown object " << objectName );
  else
    ptr = object;

  return id;
}

/**********************************************************************/


void Object::runOrQueue(Runner& r) {
  r.run();
}

Group* Object::inQ() const {
  return 0;
}

void Object::sendOrQueue(Message& msg) {
  msg.send();
}

void* Object::newConnection(ConnectionId& c) {
  c = Object::noConnection;
  return 0; 
}

void* Object::connection(ConnectionId) {
  return 0; 
}

void Object::deleteConnection(ConnectionId) {	
  cout << "Object::deleteConnection ??? \n";
}

void Object::setSender(Agent*) {
  OTSO_WARNING("Object cannot store a pointer to the sender");
}

String Object::sender() const {
  return "unknownSender";
}

ASNHOME* Object::toASNHOME()
{
  this -> undefined("toASNHOME()");
  return NULL; //dummyASNHOME;/*SPARC*/
}

/*********** command interpreter ***************************************/

static char* operationPrompt = "OPERATION: ";

static void skipLine(Istream& is) {
  char c;
  do {
    is.get(c);
  } while (c != '\n' && is);
}

             /*Object here is Istream !? or Objectifier*/
             /* returns always 0 ! ? */
             /* memberName: empty unless called from MemberObjectList::runUI */
             /* memberName "_OTSO_Unique_match_" is special.*/
Member Object::runUI(Objectifier sp, String prompt, String memberName) {
  BUGOUT( "Object::runUI(" << sp << ", " << prompt << ", " << memberName << ")" );
  Member ret = 0;
  boolean memberNameWasGivenByCaller = !memberName.isEmpty();
  boolean isUnique = (memberName == "_OTSO_Unique_match_");

                              //macro 'din' may change the value of dinStream
                              //and delete the old instance of Istream.
                              //Therefore we must use fresh 
                              //dinStream instead of just 'this' when this
                              //used to be an Istream reading a macro (command)
                              //file that exhausted.
                              //Notice that 'sp' must be updated, too!
  boolean useDinStream = (this == (Object*)dinStream);
  Object* thisOrDinStream = this;


  do {
    if (!dinStream->isReadyToRead())
      dout << prompt << ::operationPrompt;
    din >> memberName;
    BUGOUT("Read command word " << memberName);
    if (!din) {OTSO_WARNING("Bad input\n"); return 0;}
    if (useDinStream) {
      thisOrDinStream = dinStream;
      sp = dinStream;	      //the old sp was deleted at end-of-file
    }      
  } while (isspace(memberName[0]));

  BUGOUT( "Handling command word " << memberName );
  Member mb = thisOrDinStream->otsoType().memberObject(memberName, sp);
  BUGOUT( "mb = " << (long)mb );

  if (mb) {
    BUGOUT( "### exact match " << *mb );
    prompt += memberName + " ";
    ret = mb->runUI(mb, prompt, ""); 
  }
  else {
    BUGOUT( "### Not exact match, attempting pattern matching." );
    MemberObjectList* memberList = new MemberObjectList;
    mb  = thisOrDinStream->otsoType().memberObject2(memberName, sp, *memberList);

    if (!mb && memberList->isEmpty()) {	
      //check if built-in command
      BUGOUT("### Checking if built-in command");
      if (memberName[0]=='?') {
	thisOrDinStream->printMsgs(doutStream, true);
	//the next command is given again to this (or dinStream)
	if (memberNameWasGivenByCaller /*!1*/)
	  skipLine(*dinStream);
	else
	  thisOrDinStream->runUI(thisOrDinStream, prompt, "");
      }
      else if (memberNameWasGivenByCaller /*!1*/ && !isUnique ) {
	skipLine(*dinStream);			//no warnings, no actions
      }
      else if (memberName == ".") {
	if (memberNameWasGivenByCaller /*!1*/)
	  skipLine(*dinStream);
	//the next command goes to the root? object
      }
      else { 
        dout << "Unknown " << thisOrDinStream->name() 
	     << " member '" << memberName
	     << "'.  Known members:\n";
	thisOrDinStream->printMsgs(doutStream, false);
	if (memberNameWasGivenByCaller /*!1*/)
	  skipLine(*dinStream);
	//the next command is given again to this (or dinStream)
	thisOrDinStream->runUI(thisOrDinStream, prompt, "");
      }
    }
    else if (memberList->isAmbiguous()) {
      dout << "***** Ambiguous " << memberName << ": " << *memberList << "\n";
      //elements (Objectifiers) not used, delete them :(
      Runner* rp = 0;
      memberList->get(rp);
      while (rp && rp != &dummyRunner) {
	delete rp;
	memberList->get(rp);
      }
      if (memberNameWasGivenByCaller /*!1*/)
	skipLine(*dinStream);
      //the next command is given again to this (or dinStream)
      thisOrDinStream->runUI(thisOrDinStream, prompt, "");
    }
    else if (!mb) {		//ok
      prompt += memberName + " ";
                                //argument 'thisOrDinStream' not used
      memberList->runUI(thisOrDinStream, prompt, ""); 
    }
    else { 			//mb!=0, command has been handled
      ret = 0;			//?
    }
    delete memberList;
  }
  memberName = "";		//consumed

  return 0;                     //return from runUI's when void method 
                                //executed, an async message sent, 
                                //or "." given
}

/*********** Globals member functions *********************************/

String Globals::className() const {return "Globals";}

//Time Globals::time() {return time_;}

boolean Globals::simulating() const {return simulating_;}

void Globals::ask (Istream& is) {
#if 0
  // *MJS* changes - jfr!
  cout << "Enter sys_time.tv_sec ? ";
  is >> this -> sys_time.tv_sec;
  cout << "Enter sys_time.tv_usec ? ";
  is >> this -> sys_time.tv_usec;
#endif
}

void Globals::print(Ostream& os) {
   os << "Globals {\n";
#if 0
  // *MJS* changes - jfr!
     os << "sys_time { tv_sec=" << this -> sys_time.tv_sec
	<< ", tv_usec=" << this -> sys_time.tv_usec << " }\n";
#endif
   os << "}\n";
}

/* Declaration of Globals static data member */
//Time Globals::time_ = 0;
// *MJS* changes - jfr!

Globals::Globals() 
 : simulating_(false)		//set on in main() if true
{
// this -> sys_time.tv_sec = 0;
// this -> sys_time.tv_usec = 0;
// *MJS* changes - jfr!
}

Globals* globals=NULL;




