/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.namedobj.cxx
 * Vers: 5.2    Time: 92/08/03, 13:33:34
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)namedobj.cxx	5.2 92/08/03";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* NAME
*	namedobj.cxx
*
* PURPOSE
*	see namedobj.hxx
*
* MODIFICATIONS
* *SPARC* ::namedObj
*
* BUGS:
*	inefficient, use hashing+dynamic array or B-trees...
**********************************************************************/

#define CHANNEL_HXX	1
#define DYNDIR_HXX	1
#define GROUP_HXX	1
#define MULTI_HXX	1
#define NAMEDOBJ_HXX	1
#define OBJECT_HXX	1
#define RUNNER_HXX	1
#define SAMPLED_HXX	1
#define STATOBJ_HXX	1
#define STRING_HXX	1
#define TIME_HXX	1	/* *MJS* changes */
#define TYPE_HXX	1	/*class Type*/
#define VOIDGRP_HXX	1

#define OTSO_SELECT_INCLUDES	1 /* take only these headers */
#include "OTSO.hxx"	/* include them now */


Istream& operator>>(Istream& is, NamedObj*& no) {
  OTSO_WARNING( "operator>>(Istream&, NamedObj*&) not implemented?" );
  return is;
}

NamedObj::NamedObj() {}

String NamedObj::name() const {
  if (name_ == "")
    return className();	//setName not called
  else
    return name_;
}

void NamedObj::setName(char* s) {
  String tmp(s);
  setName(tmp);
}

void NamedObj::setName(const String& name) {
  if (namedObjs == 0) {
    OTSO_ERROR("Unallocated namedObjs -- NamedObj::setName() cannot insert " << (char*)name << " into namedObjs");
    name_ = name;
  }
  else {
    if (name_ == "") {
      //setName not called for this earlier, insert into list
      name_ = name;
      namedObjs->insert(this);
    }
    else
      name_ = name;  //just change the name
  }
}

void NamedObj::print(Ostream& os) {
  if (className() != name())
    os << className() << " ";
  os << " " << name() << " ";
  otsoType().Type::print(os, otsoMostDerivedPointer());	
  //no 'Type::' => bad case of looping
}

void NamedObj::ask(Istream& is) {
  otsoType().Type::ask(is, otsoMostDerivedPointer());	
}

#if SIMULATING
VThread* NamedObj::vThread() {
  return 0;
}
#endif
