/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.multi.cxx
 * Vers: 5.2    Time: 92/08/03, 13:33:30
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)multi.cxx	5.2 92/08/03";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/******************************************************************
*
* FILE multi.cx
*
******************************************************************/

#define AGENT_HXX	1
#define CHANNEL_HXX	1
#define MULTI_HXX	1
#define NAMEDOBJ_HXX	1
#define OBJECT_HXX	1
#define RUNNER_HXX	1
#define SAMPLED_HXX	1
#define STATOBJ_HXX	1
#define STRING_HXX	1
#define TIME_HXX	1
#define TYPE_HXX	1

#define OTSO_SELECT_INCLUDES	1 /* take only these headers */
#include "OTSO.hxx"	/* include them now */

#define BUGOUT(xxx) /*** dout << "### multi.cxx ### " << xxx << "\n"; ***/

/**********************************************************************
  Multi
**********************************************************************/

void Multi::setSender(Agent* agent) {
  if (senderAgent_ == agent) return;
  if (senderAgent_) senderAgent_->disconnect();
  senderAgent_ = agent;
  if (senderAgent_) senderAgent_->connect();
}

String Multi::sender() const {
  if (senderAgent_)
    return senderAgent_->sourceName();
  else
    return "unknownSource";
}

Multi::Multi() : senderAgent_(0) {}

Multi::~Multi() {
  if (senderAgent_)
    senderAgent_->disconnect();
}

/********************************************************************/

#if 0

Multi::Multi(sint32 maxConns)
     : senderAgent_(0)
     , maxConnectionNumber(maxConns) 
{}

Multi::~Multi() {
  if (senderAgent_)
    senderAgent_->disconnect();
  if (isMulti()) 
    for (ConnectionId i = 0; i < maxConnectionNumber; i++)
      ;
      //deleteConnection(i); // temporarily commented out
}

ConnectionId Multi::freeConnectionId() {
  for (ConnectionId i = 0; i < maxConnectionNumber; i++)
    if (connections[i] == 0) return i;
  OTSO_WARNING("No free connection in " << name() << ", multi instance returned");
  return 0; //no free connections
}

void* Multi::newConnection(ConnectionId& c) {
  c = freeConnectionId();
  if (c == 0)
    return this;
  else {
    connections[c] = (Multi*)(this->clone());
    connections[c]->conId = c;
    return connections[c];
  }
}

void* Multi::connection(ConnectionId c) {
  return (connections[c])? connections[c] : this;
}

void Multi::deleteConnection(ConnectionId c) {
  if (!isMulti()) {
    delete connections[c]; /*==this?*/
    connections[c] = 0;
  }
}

void* Multi::clone() {return new Multi(*this);}

#endif

#if 0
/**********************************************************************
  Pointer
**********************************************************************/

Pointer::Pointer(Object* m, Process* p, ConnectionId con): 
  multi(m), processPtr(p), conId(con) 
{}

Pointer::Pointer(): multi(0), processPtr(thisProcess), conId(0) {
}

Object* Pointer::operator->() {
  if (!multi)
    OTSO_WARNING( "Pointer::operator->() returns 0" );
  return multi;
}
#endif

