/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.frame.cxx
 * Vers: 5.3    Time: 92/08/13, 11:54:04
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)frame.cxx	5.3 92/08/13";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/********************************************************************
* NAME
*	frame.cxx
*
* PURPOSE
*	Implements CVOPS frame abstract data type for OTSO.
*
* BUGS
*	printing of asn.1 frames works only for trivial cases,
*	a real printing algorithm should be added some day,
*	but for now, what the hell.  Maybe we should have an AsnFrame
*	type derived from normal Frames ?
*
* MODIFICATIONS
*	- char* < -> BYTE_TYPE* casting added
*********************************************************************/

#define BYTES_HXX	1
#define CHANNEL_HXX	1
#define FRAME_HXX	1
#define MULTI_HXX	1
#define NAMEDOBJ_HXX	1
#define OBJECT_HXX	1
#define RUNNER_HXX	1
#define SAMPLED_HXX	1
#define STATOBJ_HXX	1
#define STRING_HXX	1
#define TIME_HXX	1
#define TYPE_HXX	1

#define OTSO_SELECT_INCLUDES	1	/* take only these headers */
#include "OTSO.hxx"		/* include them now */


//#include "asntypes.h"		/*not in public release*/



Frame *dummyFrame;

//char * charPtr (Bytes & bs) {return (char *) (bs.st);}	// ?

sint32
Frame::length ()
{
  if (this -> fptr)
    return frameLength (this -> fptr);
  else
    return 0;
}

Frame Frame::copy ()
{
  sint32 l = length();
  if (l > 0xFFFF) l = 0xFFFF;	//?
  Frame f(l);
  f.fptr = copyFrame (this -> fptr);
  return f;
}

Frame & Frame::putPrefix (Byte byte)
{
  putFirstByte (&this -> fptr, byte);
  return *this;
}

Frame & Frame::putPrefix (Bytes & prefix)
{
  putnFirstBytes (&this -> fptr, prefix.bytep(), prefix.length ());
  //if this is long, avoiding copying could make sense (use FrameBlock)
  prefix.reset();
  return *this;
}

FrameBlock::FrameBlock(const FrameBlock&) {
  OTSO_UNDEFINED("FrameBlock::FrameBlock(const FrameBlock&)");
}

void FrameBlock::operator=(const FrameBlock&) {
  OTSO_UNDEFINED("FrameBlock::operator=(const FrameBlock&)");
}

FrameBlock::FrameBlock(sint32 n)
   : size_(n)
   , bytep(frameBlock(n))
{}

sint32 FrameBlock::size() const {return size_;}

FrameBlock::operator Byte* () const {return bytep;}

Frame::Frame(FrameBlock& fb, sint32 usedSize) {
  fptr = fakeFrame(fb, fb.size(), usedSize);
  fb.bytep = 0;
}


/**********************************************************************
FrameBlock destructor is tighly coupled with the implementation 
of the function frameBlock in cframe.c.
PREFIX must be the same in both files!
*********************************************************************/
extern "C" void wfree(void*);
FrameBlock::~FrameBlock() {
  if  (bytep) {
    //A FrameBlock destructed before a Frame was constructed from it.
    //A byte array must be deallocated.
#define PREFIX 0
    wfree(bytep - PREFIX);
  }
}

/*
 * Note: The assignment operator= moves the frame.
 *       It does not copy it -- use copy () for that.
 */
Frame & Frame::operator= (Frame & f) {
  if (this -> fptr != f.fptr) {
    deleteFrame (&this -> fptr);
    this -> fptr = f.fptr;
    f.fptr = NULL;
  }
  return *this;
}

Frame & Frame::operator= (Bytes & bytes) {
  deleteFrame (&fptr);
#if 1
  putnFirstBytes (&fptr, bytes.bytep(), bytes.length ());
  bytes.reset();
#else
  //incorrect 
  putBlockToFrame (&fptr, bytes.bytep(), bytes.length ());
  bytes.st = 0;	//!
#endif
  return *this;
}

Byte & Frame::operator[] (sint32 i) {
  Byte *bp = byteAddress (this -> fptr, i + 1);

  if (bp)
    return *bp;
  else
    return dummyByte;
}

Frame & Frame::putPrefix (Frame & prefix)
{
  combineFrame (&(prefix.fptr), &this -> fptr);
  this -> fptr = prefix.fptr;
  prefix.fptr = NULL;
  return *this;
}

// Frame& Frame::putSuffix (Byte)   {}	// implemented in CASN?
// Frame& Frame::putSuffix (Bytes&) {}	// implemented in CASN?

Frame & Frame::putSuffix (Frame & f)
{
  if (this->fptr == f.fptr)
    OTSO_WARNING("Frame::putSuffix(Frame&) cannot append a Frame to itself; Frame not changed");
  else
    combineFrame (&this -> fptr, &f.fptr);
  return *this;
}

/* chop the CVOPS frame out of OTSO frame */
/* put new one in it's place */
FRAME *
Frame::chop ()
{
  FRAME *cvops = this -> fptr;	/* old FRAME */

  this -> fptr = createFrame (DB_SIZE);	/* new FRAME */
  return cvops;
}

/* delete all bytes in frame */
void 
Frame::reset ()
{
  /* clean out any bytes in frame */
  int len;

  if ((len = this -> length ()) > 0) {
    ::deleteBytes (&this -> fptr, len);
  }
  //this -> length() = 0;		//?
}

void 
Frame::deleteBytes (sint sz)
{
  ::deleteBytes (&this -> fptr, sz);
}

Bytes Frame::getBytes (sint sz)
{
  Bytes b(sz);
  getnFirstBytes (&this -> fptr, b.bytep(), sz);
  return b;
}

Bytes Frame::copyBytes (sint sz)
{
  Bytes b(sz);
  copynBytesToArray (this -> fptr, b.bytep(), sz);
  return b;
}

Frame Frame::getFrame (sint sz)
{
  FRAME *cf = splitFrame (&this -> fptr, sz);
  return &cf;
}


#define ASN_INF_LEN	0x80
#define ASN_UNIV	0x00
#define ASN_APPL	0x40
#define ASN_CNTX	0x80
#define ASN_PRIV	0xc0
#define ASN_CTOR	0x20

#define ASN_EOC		-1

int indent = 0;

void 
print_asn_univ_type (ostream & os, int tag)
{
  char *str = "(Unknown Type)";

  switch (tag & 0x1f) {
  case 1:
    str = "(BOOLEAN)";
    break;
  case 2:
    str = "(INTEGER)";
    break;
  case 3:
    str = "(BIT STRING)";
    break;
  case 4:
    str = "(OCTET STRING)";
    break;
  case 5:
    str = "(NULL)";
    break;
  case 6:
    str = "(OBJECT IDENTIFIER)";
    break;
  case 7:
    str = "(ObjectDescriptor)";
    break;
  case 8:
    str = "(EXTERNAL)";
    break;
  case 9:
    str = "(REAL)";
    break;
  case 10:
    str = "(ENUMERATED)";
    break;
  case 16:
    str = "(SEQUENCE, SEQUENCE OF)";
    break;
  case 17:
    str = "(SET, SET OF)";
    break;
  case 18:
    str = "(NumericString)";
    break;
  case 19:
    str = "(PrintableString)";
    break;
  case 20:
    str = "(TeletexString)";
    break;
  case 21:
    str = "(VideotexString)";
    break;
  case 22:
    str = "(IA5String)";
    break;
  case 23:
    str = "(UTCtime)";
    break;
  case 24:
    str = "(GeneralizedType)";
    break;
  case 25:
    str = "(GraphicsString)";
    break;
  case 26:
    str = "(VisibleString)";
    break;
  case 27:
    str = "(GeneralString)";
    break;
  case 28:
    str = "(CharacterString)";
    break;

  }
  os << " " << str;
}

int 
print_asn_head (ostream & os, Frame & f, int index)
{
  unsigned char byte;
  int tag = 0;

  if (f[index] == 0x00 && f[index + 1] == 0x00)
    return ASN_EOC;

  os << "\n";

  for (int i = 0; i < ::indent; i++)
    os << " ";

  os << "[";

  byte = f[index];
  switch (byte & 0xc0) {
  case ASN_APPL:
    os << "APPL, ";
    break;
  case ASN_UNIV:
    os << "UNIV, ";
    break;
  case ASN_CNTX:
    os << "CNTX, ";
    break;
  case ASN_PRIV:
    os << "PRIV, ";
    break;
  default:
#if COMPILER_GPLUS
    os << form ("%2x", byte);
#else
    os << hex << byte;
#endif
    break;
  }

  if (byte & ASN_CTOR) {
    os << "CTOR, ";
    ::indent++;
  }
  else
    os << "PRIM, ";

  /* tag */
  tag = byte & 0x1f;
  if (tag < 0x1f) {
    os << tag;
    if ((byte & 0xc0) == ASN_UNIV)
      print_asn_univ_type (os, tag);
    os << "] ";
    return 1;			/* one byte */
  }
  else {
    tag = f[index + 1];
    os << tag << "] ";
    return 2;			/* two bytes */
  }
}

int 
print_asn_len (ostream & os, Frame & f, int index)
{
  int length = f[index];

#if COMPILER_GPLUS
  os << "[len=0x" << form("%2x", length) << "] ";
#else
  os << "[len=0x" << hex << length << "] ";
#endif
  return length;
}

void 
print_asn_fixed (ostream & os, Frame & f, int index, int nbytes)
{
  int i = 0;

  os << "{ ";
  if (nbytes != ASN_INF_LEN && nbytes) {
    for (i = 0; i < nbytes; i++) {
#if COMPILER_GPLUS
      os << "0x" << form ("%2x", f[index + i]) << " ";
#else
      os << "0x" << hex << f[index + i] << " ";
#endif
    }
  }
  os << "} ";
}

int 
print_asn_contents (ostream & os, Frame & f, int index = 0, int len = ASN_INF_LEN)
{
  int next_len = 0, head_len = 0, nbytes = 0;

  if (len == ASN_INF_LEN) {	/* indefinite length */
    if ((head_len = print_asn_head (os, f, index)) != ASN_EOC) {
      index += head_len;	/* advance past header */
      next_len = print_asn_len (os, f, index);

      if (next_len != ASN_INF_LEN) {
	print_asn_fixed (os, f, index + 1, next_len);
	nbytes = nbytes + head_len + 1 + next_len;
      }
      else {
	nbytes = nbytes + head_len + 1 /* HDR + LEN bytes */ +
	  print_asn_contents (os, f, index + 1, next_len);
      }

    }
    else {
      ::indent--;
      os << "\n";
      for (int i = 0; i < ::indent; i++)
	os << " ";
      os << "[EOC]\n";
      nbytes = nbytes + 2;
    }
  }
  else {			/* definite length */
    print_asn_fixed (os, f, index, len);
    nbytes = nbytes + len;
  }

  return nbytes;
}

const int fmaxcolumn = 20;	/* 80 columns, 4 columns per byte */

void 
Frame::print (Ostream & oprint)
{
  Byte octet = 0;
  sint32 index = 0, columns = 0;
  sint32 frameLen = this -> length ();

  if (frameLen <= 0) {
    oprint << "Frame { /* null */ } ";
  }
  else {
    /* Print Frame as HEX bytes first */
    oprint << "Frame {\n";
    oprint.addIndent(+2);
    oprint << INDENT << "HEX bytes:\n";
    for (index = 0, columns = 0; index < frameLen; index++, columns++) {
      octet = this -> operator[] (index);
#if COMPILER_GPLUS
      oprint << form ("%2x", octet) << "  ";
#else
      oprint.ostream::operator<<(hex);          //why doesn't "<< hex" work?
      oprint << (int)octet << "  "; 
#endif
      if (columns >= fmaxcolumn - 1) {
	oprint << "\n";
	columns = -1;
      }
    }
    oprint << "\n";
    oprint.ostream::operator<<(dec);

    /* Print Frame as ASCII bytes next */
    oprint << INDENT << "ASCII bytes:\n";
    for (index = 0, columns = 0; index < frameLen; index++, columns++) {
      octet = this -> operator[] (index);

      /* printable char check -- should use isprint() ? */
      if ((char) octet >= ' ' && (char) octet <= '~') {
	oprint.ostream::operator<<((char)octet); oprint << "   ";
      }
      else {
	oprint << "..  ";	/* Not printable */
      }

      if (columns >= fmaxcolumn - 1) {
	oprint << "\n";
	columns = -1;
      }
    }

    if (isAsn) {
      oprint << INDENT << "ASN: {\n";
      ::indent = 0;
      this -> asnPrint (oprint);
      ::indent = 0;
      oprint << "\n" << INDENT << "}\n";
    }

    oprint.addIndent(-2);
    oprint << "\n" << INDENT << "} = " << length() << " bytes ";
  }
}

void 
Frame::asnPrint (Ostream & oprint)
{
  int nbytes = 0;

  while (nbytes < this -> length ()) {
    nbytes += ::print_asn_contents (oprint, *this, nbytes);
  }
}

void 
Frame::ask (Istream & is)
{
  // do this properly sometimes
  Bytes b (999);

  is >> b;
  *this = b;
}

void 
Frame::to (ODump & od)
{
  // do this properly sometimes
  Bytes bs ((int) length ());

  bs = getBytes (length ());
  od << bs;
}

void 
Frame::from (IDump & id)
{
  // do this properly sometimes
  Bytes bs;

  id >> bs;
  *this = bs;
}

/********************************************************************/

// Constructs Frame from another Frame,
// !! Warning: DESTRUCTIVE to caller's argument f !!
Frame::Frame (Frame & f) 
{
  this -> fptr = f.fptr;
  f.fptr = NULL;
  isAsn = 0;
}

// Constructs a OTSO Frame from a CVOPS FRAME.
// !! Warning : DESTRUCTIVE to caller's argument cFrame !!
Frame::Frame (FRAME ** cFrame) 
{
  this -> fptr = *cFrame;
  *cFrame = NULL;
  isAsn = 0;
}

Frame::~Frame ()
{
  deleteFrame (&fptr);
}

Frame::Frame (sint32 dbSize) 
{
  const sint32 limit = 0x7fff;
  if (dbSize > limit) {
    OTSO_WARNING("dbSize in Frame constructor too big: " << sint32(limit) << " used instead of " << dbSize );
    dbSize = limit;
  }
  this -> fptr = createFrame (dbSize);   //int argument!
  isAsn = 0;
}

String Frame::className() const {return "Frame";}
