/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.bytes.cxx
 * Vers: 5.2    Time: 92/08/03, 13:33:04
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)bytes.cxx	5.2 92/08/03";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/*********************************************************************
* NAME
*	bytes.cxx
*
* PURPOSE
*	'String' is a class that provides null-terminated character 
*		strings.  It is best used for printable string manipulation.
*
*	'Bytes' is a class that provides simple byte arrays with
*		no bells and whistles.  It is useful when general
*		purpose byte-oriented arrays are needed, such as in
*		Frames.  A 'Bytes' array may hold any type of info.
*
* Bytes Operations:
* -----------------
*	length - return number of bytes contained in object.
*
*	elem - non-range checking indexing operator. similar to [].
*
*	print, ask - redefined from basic Object class.
*
*	to, from - output to ODump, input from IDump
*
* Bytes Operators:
* -----------------
*	=  ==  []
*
* MODIFICATIONS
* BUGS
*
********************************************************************
*/

// The following #defines specify which header files to include.
#define BYTES_HXX	1
#define CHANNEL_HXX	1
#define MULTI_HXX	1
#define NAMEDOBJ_HXX	1
#define OBJECT_HXX	1
#define RUNNER_HXX	1
#define SAMPLED_HXX	1
#define STATOBJ_HXX	1
#define STRING_HXX	1
#define TIME_HXX	1
#define TYPE_HXX	1

#define OTSO_SELECT_INCLUDES	1 /* take only these headers */
#include "OTSO.hxx"	/* include them now */



Byte dummyByte = '-';

/**********************************************************************/

String Bytes::className() const {return "Bytes";}

Bytes::~Bytes() {delete st;}

// construct from a 'size'
Bytes::Bytes(slong size)
     : btype(BYT_ASCII)
{
  if (size <= 0)  {
    this -> sz = 0;
    this -> st = NULL;
  }
  else 
    this -> st = new char [this -> sz = size];
}

Bytes::Bytes(Bytes& i)
     : sz(i.sz)
     , btype(i.btype)
     , st(i.st)
{
  i.st = 0;	//!
  i.sz = 0;
}

/*Copies data. This is inconsistent.*/
Bytes::Bytes(const Bytes& src, slong first, slong length)
{
  if (src.length() < first + length) 
    length = src.length() - first;
  this -> st = new char[this -> sz = length];
  this -> btype = src.btype;
  memcpy(this->st, &src[first], (int)length);
}

// Make a new copy of a Bytes object
Bytes Bytes::copy()
{
  Bytes cpy (this -> sz);
  cpy.btype = this -> btype;
  memcpy(cpy.st, this->st, (int)this->sz);
  return cpy;
}

//WARNING: Move!
Bytes& Bytes::operator= (Bytes& src)
{
  if (this == &src) 
    return *this;

  delete this -> st;
  this -> btype = src.btype;
  this -> sz = src.sz;
  this -> st = src.st;

  src.sz = 0;
  src.st = 0;
  return *this;
}


// Bytes equivalance operator: == 
//  WARNING: be careful about comparing unsigned bytes to signed bytes.

boolean Bytes::operator==(const Bytes& s1) const {
  return (this->length() == s1.length() &&
	  memcmp(this->st, s1.st, (int)this->length()) == 0
	 );
}

boolean	Bytes::operator!=(const Bytes& r) const {
  return !(*this == r); 
}

// Bytes vector operator: [] 
//  (range checking), may be slow !
Byte& Bytes::operator[](slong i) const {
  if (i >= 0 && i < this -> length())	 /* range checking */
    return ((Byte&)(this -> st[i]));
  else
    return dummyByte;
}


// similar to [] operator, but faster, no range checking
Byte& Bytes::elem(slong i) const {
  return ((Byte&)this -> st[i]);
}


//  output Bytes to ODump
void Bytes::to(ODump& od)
{
  sint32 l = this -> length();
  od << l;
  od.write(this->st, (int)l);
}


//  input Bytes from IDump
void Bytes::from(IDump& id)
{
  sint32 l;
  id >> l;			
  delete this -> st;
  this -> st = new char[this -> sz = l];
  id.read(this->st, (int)l);	
}

// check is a string is all hex digits
static boolean ishexstring (char *str)
{
  for (slong i=0; i<strlen(str); i++) {
    char *st = &str[i];
    if ( !((*st >= '0' && *st <= '9') ||
      (*st >= 'a' && *st <= 'f') ||
      (*st >= 'A' && *st <= 'F')) 
    ) {
      return false;	/* non - hex digit found */
    }
  }
  return true;
}

// check if a string is all binary digits
static boolean isbinstring (char *str)
{
  for (slong i=0; i<strlen(str); i++) {
    char *st = &str[i];
    if ( !(*st >= '0' && *st <= '1') )
      return false;	/* non - binary digit found */
  }
  return true;
}

// Construct from a null-terminated ascii format string.
Bytes::Bytes (char* string)
{
  if (string == NULL) {	// No string
    this -> sz = 0;
    this -> st = NULL;
  } else {
    slong size = ::strlen(string);
    char * s1 = new char [size + 1];
    ::strcpy (s1, string);
    char keep = '\0';

    if (::strlen(s1) > 1) {  /* a single char ('h','b',etc) is ascii */
      /* last char tells if it could be a binary or hex string */
      switch (s1 [size-1]) {
      case 'b': case 'B':
        keep = s1 [--size];
        s1 [size] = '\0';
        if (isbinstring(s1)) {
          this -> sz = size/8 + (size%8 ? 1 : 0);
          this -> st = new char [this -> sz];
          this -> str2bin ((unsigned char*)this -> st, s1, size);

          this -> btype = BYT_BIN;
          delete s1;	/* delete copy of arg string */
          return;
        }
        else {
          s1 [size++] = keep;	// put char back
        }
        break;

      case 'h': case 'H': case 'x': case 'X':
        keep = s1 [--size];
        s1 [size] = '\0';
        if (ishexstring(s1)) {
          this -> sz = size/2 + (size%2 ? 1 : 0);
          this -> st = new char [this -> sz];
          this -> str2hex ((unsigned char*)this -> st, s1, size);

          this -> btype = BYT_HEX;
          delete s1;	/* delete copy of arg string */
          return;
        } else {
          s1 [size++] = keep;	// put char back
        }
        break;
      }
    }

    /* default case just copy ascii string as is */
    this -> sz = size+1;
    this -> st = new char [size+1];
    strcpy(this -> st, s1);
    this -> st[size] = '\0';	// null terminate ascii strings
    this -> btype = BYT_ASCII;
    delete s1;
  }
}

// redefine print for this class
void Bytes::print(Ostream& os)
{
  char *tmp = NULL;
  slong length = 0;

  if (this -> length() > 0) { 
    switch (this -> btype) {
    case BYT_ASCII:
	os << this -> st;
	break;

    case BYT_HEX:
	length = (this -> length() * 2) + 1;
	tmp = new char [length];
	this->hex2str (tmp, (unsigned char*)this -> st, this -> length());
	tmp[length-1] = 'H';
	tmp[length]   = '\0';
	os << (char*)tmp;
	delete (tmp);
	break;

    case BYT_BIN:
	length = (this -> length() * 8) + 1;
	tmp = new char [length];
	this->bin2str (tmp, (unsigned char*)this -> st, this -> length());
	tmp[length-1] = 'B';
	tmp[length]   = '\0';
	os << (char*)tmp;
	delete (tmp);
	break;
    }
  }
}

void Bytes::reset() 
{
  if (this->st) {
    delete this->st;
    this->st = 0;
    this->sz=0;
  }
}

#define MAX_BUF 1024
// redefine ask for this class
void Bytes::ask(Istream& is)
{
  char tmp[MAX_BUF];	// fixed length is BAD ??? 
  is >> tmp;		// read string 
  *this = tmp;
}


/* ------------- Local Variables ---------------- */

static char nib2hex [0x10] = {
    '0', '1', '2', '3', '4', '5', '6', '7',
    '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'
};

static char hex2nib[0x80] = {
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,	/* '0' - '9' */
    0x08, 0x09, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, NULL, 	/* 'A' - 'F' */
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, NULL, 	/* 'A' - 'F' */
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
};



// hex 2 ascii
slong Bytes::hex2str (char *ascii, uint8 *hex, slong hexlen)
{
    register slong i;
    register uint8 byte;

    if (ascii && hex) {	/* bulletproof */
        char * pascii = &ascii[hexlen*2 - 1];

	for (i = 0; i < hexlen; i++) {
	    byte = *hex++;
  	    *pascii-- = nib2hex[(byte & 0x0f)];
	    *pascii-- = nib2hex[(byte & 0xf0) >> 4];
	}
	ascii [hexlen * 2] = NULL;

	return (hexlen * 2);
    }
    else
	return 0;
}

// ascii 2 hex
slong Bytes::str2hex (uint8 *hex, char *ascii, slong asclen)
{
    char		*pascii = &ascii[asclen-1];

    for (slong i = 0; i<asclen; i += 2) {
	*hex++ = (hex2nib[pascii[-1] & 0x7f] << 4)|(hex2nib[pascii[0] & 0x7f]);
	pascii -= 2;
    }

    return (asclen / 2);
}

#define BIT(b, n)	((byte & n) ? '1' : '0')

// bin 2 ascii
slong Bytes::bin2str (char *ascii, uint8 *bin, slong binlen)
{
    register uint8 byte;

    if (ascii && bin) {	/* bulletproof */
        char * pascii = &ascii[binlen*8 - 1];

	for (slong i = 0; i < binlen; i++) {
	    byte = *bin++;
  	    *pascii-- = BIT(byte, 0x01);
  	    *pascii-- = BIT(byte, 0x02);
  	    *pascii-- = BIT(byte, 0x04);
  	    *pascii-- = BIT(byte, 0x08);
  	    *pascii-- = BIT(byte, 0x10);
  	    *pascii-- = BIT(byte, 0x20);
  	    *pascii-- = BIT(byte, 0x40);
  	    *pascii-- = BIT(byte, 0x80);
	}
	ascii [binlen * 8] = NULL;

	return (binlen * 8);
    }
    else
	return 0;
}

// ascii 2 bin
slong Bytes::str2bin (uint8 *bin, char *ascii, slong asclen)
{
    uint8		bit = 0;
    char		*pascii = &ascii[asclen-1];

    bit  = 0;
    *bin = 0;
    for (pascii = &ascii[asclen-1]; pascii >= & ascii[0]; pascii--) {
        if (*pascii == '1')
        	*bin |= (1 << bit);

	if (++bit == 8) {
	    bit = 0;	// next byte
	    *(++bin) = 0;
	}
    }

    return (asclen / 8);
}
