#!/bin/sh
#
#  This script beats the internal table caching code around the ears a
#  few times.  It constantly forces the caches to be rolled and
#  reloaded.  Run it using "cachetest dbname" where dbname is a database
#  that exists and doesn't have tables called test1 test2 or test3 in it.
#
#                                                       bambi

CREATE1="create table test1 ( name char(40), num int)"
CREATE2="create table test2 ( name char(40), num int)"
CREATE3="create table test3 ( name char(40), num int)"
DROP1="drop table test1"
DROP2="drop table test2"
DROP3="drop table test3"

NUM_CYCLES=20
COUNT=0
DB=$1

if test "$DB." = "."
then
        echo
        echo "Bad usage.  Please read the intro to the script."
        echo
        exit 1
fi

while test $COUNT -lt $NUM_CYCLES
do
        echo "$DROP2 \p\g" | (../msql/msql $DB)
        echo "$CREATE1 \p\g" | (../msql/msql $DB)
        ../msql/relshow $DB test1 > /dev/null
        echo "$DROP3 \p\g" | (../msql/msql $DB)
        echo "$CREATE2 \p\g" | (../msql/msql $DB)
        ../msql/relshow $DB test2 > /dev/null
        echo "$DROP1 \p\g" | (../msql/msql $DB)
        echo "$CREATE3 \p\g" | (../msql/msql $DB)
        ../msql/relshow $DB test3 > /dev/null
        COUNT=`expr $COUNT + 1`
done

echo "$DROP1 \p\g" | (../msql/msql $DB)
echo "$DROP2 \p\g" | (../msql/msql $DB)
echo "$DROP3 \p\g" | (../msql/msql $DB)

