/*
** sqbdbn.c
**
** Klaus Thiele (kth@oblib.teuto.de) - June '95
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sql.h>
#include <errsql.h>

#ifndef HOST
#define HOST NULL
#endif

int main( void ) {

SQLTCUR       cur;
SQLTRCD       rcd;
char          errmsg[SQLMERR];
char          db_buf[1000];
char          tb_buf[1000];
char          *d, *t;


   if( (rcd = sqldbn( (SQLTDAP)HOST, (SQLTDAP)db_buf, (SQLTDAL)sizeof(db_buf))) ) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
         return( 1 );
   }

   d = db_buf;
   while( *d != '\0' ) {
      printf("DATABASE: %s\n", d);

      if( (rcd = sqlcnc( &cur, (SQLTDAP)d, 0, (SQLTDAP)HOST)) ) {
            sqlerr(rcd, (SQLTDAP)&errmsg);
            printf("%d: %s\n", rcd, errmsg);
            continue;
      }

      if( sqldbt( cur, (SQLTDAP)tb_buf, (SQLTDAL)sizeof(tb_buf)) == 0 ) {

         t = tb_buf;
         while( *t != '\0' ) {
            printf("\tTABLE: %s\n", t);
            t += strlen(t) + 1;
         }

      }

      sqldis( cur );
      d += strlen(d) + 1;
   }

   return(0);
}
