/*
 * dir_test.c
 *
 * a program used for testing the access to a directory structure
 *
 * (c) 1996 by Dirk Ohme
 */

#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "dirent.h"

/* === main ===
 * input:       int argc
 *                number of arguments
 *              char *argv[]
 *                pointer to list with arguments
 * output:      int
 *                return code
 * description: displays the current or the specified directory
 */
int main( int argc, char *argv[] )
{
  /* --- variables --- */
  DIR              *Catalog;           /* handle for access to directory */
  struct dirent    *CatEntry;          /* pointer to catalog entry */

  /* --- program --- */
  Catalog = opendir( (argc > 1) ? argv[1]
                                : "." );
  while ( NULL != (CatEntry=readdir(Catalog)) )
  {
    printf( "%40s %8d %8d %8d\n", CatEntry->d_name,
                              CatEntry->d_fileno,
                              CatEntry->d_ino,
                              CatEntry->d_reclen );
  }
  closedir( Catalog );
}

/*===| end of file |===*/
