package com.dickimawbooks.jmakepdfx;

public class DefaultProcessListener implements ProcessListener
{
   public DefaultProcessListener(Jmakepdfx application)
   {
      app = application;
   }

   public void setProcess(Process process)
   {
      this.process = process;
   }

   public void setThread(Thread thread)
   {
      this.thread = thread;
   }

   public void error(Exception e)
   {
      app.error(e);
   }

   public void terminateProcess()
   {
      if (thread != null)
      {
         app.debug("Interrupting "+thread);
         thread.interrupt();
      }

      if (process != null)
      {
         app.debug("Destroying "+process);
         process.destroy();
      }
   }

   public void processLine(int lineNum, String line)
   {
   }

   public void processErrorLine(int lineNum, String line)
   {
      System.err.println(line);
   }

   public void setInterruptor(InterruptTimerTask interruptor)
   {
      this.interruptor = interruptor;
   }

   public InterruptTimerTask getInterruptor()
   {
      return interruptor;
   }

   private InterruptTimerTask interruptor;
   private Jmakepdfx app;
   private Process process;
   private Thread thread;
}
