#include <libmidi.h>
#include <libdx7.h>

#define d define
#d u_char	unsigned char
#d u_short	unsigned short
#d error	return MidiError("send_dx7_pc"), -1
#d out(b)	if (midi_out(f,b) == -1) error

dx7SetParameter(f, chan, group, par, data)
	int f;		/* file descriptor to write on */
	u_char chan;	/* midi channel (0 -> ch[1]) */
	u_char group;	/* parameter group # */
	u_short	par;	/* parameter number (0-65535) */
	u_char data;	/* parameter data (0-127) */
/*
 * ***Obsolete***
 * Send parameter change, return '-1' on error, '0' otherwise.
 * This is to tweak an individual dx7 voice parameter
 * (like, if you wanted so change the level of one operator).
 * 'group == 0', common dx7 voice parameter;
 * 'group == 2', dx7 function parameter.
 * 'par' is  a parameter number (see libdx7.h),
 * and 'data' is the new parameter value.
 * See MIDI-spec (section 1.2.4) for more information about parameters.
 */
{
	out(SX_CMD);
	out(ID_DX7);
	out(DX7_SXSS_PC << 4 | (chan & M_CHAN_MASK));
	out((group | ((par>>14)&0x03)) & M_VAL_MASK);
	out((par>>7) & M_VAL_MASK); /* bits 7 - 13 of parameter */
	out(par & M_VAL_MASK);      /* bits 0 - 6 of parameter */
	out(data & M_VAL_MASK);     /* parameter data */
}
