/*
**	RXKEY -- Convert key numbers/names to RX instruments
**		and vice-versa.
**	psl 3/86
*/

struct	keystr	{
	int	num;
	char	*name5;
	char	*name11;
	char	*name15;
	char	*name21;
} keys[]	= {
	24,	"BD1*",		" --",		" --",		" --",
	25,	"SD1*",		" --",		" --",		" --",
	26,	"RIM1*",	" --",		" --",		" --",
	27,	"TOM1*",	" --",		" --",		" --",
	28,	"TOM1*",	" --",		" --",		" --",
	29,	"TOM1*",	" --",		" --",		" --",
	30,	"TOM1*",	" --",		" --",		" --",
	31,	"HHC*",		" --",		" --",		" --",
	32,	"RIDEcup*",	" --",		" --",		" --",
	33,	"CRASH*",	" --",		" --",		" --",
	34,	"CLAPS*",	" --",		" --",		" --",
	35,	"COWBELL*",	" --",		" --",		" --",
	36,	" --",		" --",		" --",		" --",
	37,	" --",		" --",		" --",		" --",
	38,	" --",		" --",		" --",		" --",
	39,	" --",		" --",		" --",		" --",
	40,	"E.TOM4",	" --",		" --",		" --",
	41,	"E.TOM3",	" --",		" --",		" --",
	42,	"E.TOM2",	" --",		" --",		" --",
	43,	"E.TOM1",	" --",		" --",		" --",
	44,	"BD2",		"BD2",		" --",		" --",
	45,	"BD1",		"BD1",		"BD",		" --",
	46,	"RIM2",		" --",		" --",		" --",
	47,	"TOM4",		"TOM4",		" --",		" --",
	48,	"TOM3",		"TOM3",		"TOM3",		" --",
	49,	"SD2",		"SD2",		" --",		" --",
	50,	"TOM2",		"TOM2",		"TOM2",		" --",
	51,	"RIM1",		"RIM",		"RIM",		" --",
	52,	"SD1",		"SD1",		"SD",		" --",
	53,	"TOM1",		"TOM1",		"TOM1",		" --",
	54,	"CLAPS",	"CLAP",		"CLAP",		" --",
	55,	"COWBELL",	"COWB",		"COWB",		" --",
	56,	"SHAKER",	"SHAK",		"SHAK",		" --",
	57,	"HHC",		"HHC",		"HHC",		" --",
	58,	"TAMB",		" --",		" --",		" --",
	59,	"HHO",		"HHO",		"HHO",		" --",
	60,	"CRASH",	"CRSH",		"CRSH",		" --",
	61,	"CHINESE",	" --",		" --",		" --",
	62,	"RIDEcup",	"RIDE",		"RIDE",		" --",
	63,	"RIDEedge",	" --",		" --",		" --",
	64,	" --",		" --",		" --",		"CONGL",
	65,	"SD3*",		" --",		" --",		"CONGO",
	66,	"BD3*",		" --",		" --",		"CONGM",
	67,	"CgaHMT*",	" --",		" --",		"BONGL",
	68,	"CgaHOP*",	" --",		" --",		"BONGH",
	69,	"CgaLO*",	" --",		" --",		"TIMBL",
	70,	"BgoHI*",	" --",		" --",		"TIMBH",
	71,	"BgoLO*",	" --",		" --",		"TAMBO",
	72,	"TimblH*",	" --",		" --",		"COWBL",
	73,	"TimblL*",	" --",		" --",		"CLAVE",
	74,	"AgoHI*",	" --",		" --",		"AGOGL",
	75,	"AgoLO*",	" --",		" --",		"AGOGH",
	76,	"Cuica**",	" --",		" --",		"CUICL",
	77,	"Cstnt*",	" --",		" --",		"CUICH",
	78,	"Whstl*",	" --",		" --",		"WHST1",
	79,	"Timpn*",	" --",		" --",		"WHST2",
	80,	"GlsCsh*",	" --",		" --",		" --",
	81,	"Gun*",		" --",		" --",		" --",
	82,	"FMprc1*",	" --",		" --",		" --",
	83,	"FMprc2*",	" --",		" --",		" --",
	84,	"FMprc3*",	" --",		" --",		" --",
	85,	"EbassH*",	" --",		" --",		" --",
	86,	"EbassL*",	" --",		" --",		" --",
	87,	"DXorch*",	" --",		" --",		" --",
	88,	"DXmrmb*",	" --",		" --",		" --",
	89,	"DXclav*",	" --",		" --",		" --",
	90,	"Hey*",		" --",		" --",		" --",
	91,	"Wao*",		" --",		" --",		" --",
	92,	"Ooo*",		" --",		" --",		" --",
	0,
};

extern	char	*key2name();

main(argc, argv)
char	*argv[];
{
	register int i, j;

	if (argc == 1)
	    rxkey(0);
	else {
	    for (i = 1; i < argc; i++) {
		if (argv[i][0] > '9') {
		    for (j = 0; keys[j].num; j++)
			if (strcmp(keys[j].name5, argv[i]) == 0
			 || strcmp(keys[j].name11, argv[i]) == 0
			 || strcmp(keys[j].name15, argv[i]) == 0
			 || strcmp(keys[j].name21, argv[i]) == 0)
			    break;
		    if (keys[j].num == 0) {
			printf("Unrecognized instrument: %s\n", argv[i]);
			rxkey(0);
			exit(1);
		    }
		    j = keys[j].num;
		} else
		    j = atoi(argv[i]);
		rxkey(j);
	    }
	}
}

rxkey(n)
{
	register int i;

	if (n == 0)
	    printf("RX5      RX11   RX15   RX21  dec note hex\n");
	for (i = 0; keys[i].num; i++) {
	    if (n == 0 || keys[i].num == n) {
		printf("%-8.8s %-6.6s %-6.6s %-5.5s  %2d  %-4.4s %02x\n",
		 keys[i].name5, keys[i].name11, keys[i].name15, keys[i].name21,
		 keys[i].num, key2name(keys[i].num), keys[i].num);
	    }
	}
}
