/*
**	RESID -- Watch mpu residual byte counts
**	psl 3/88
*/
#include	<sys/ioctl.h>
#include	<mpuvar.h>

main(argc, argv)
char	*argv[];
{
	char devbuf[128], *dev = "/dev/mpu0";
	int fh, i, dcnt[MPU_TTR_MAX], ccnt[MPU_TTR_MAX];

	for (i = 0; i < MPU_DTR_NUM; i++)
	    printf("    T%d", i);
	printf("   COM   CND\n");
	for (i = MPU_TTR_MAX; --i >= 0; dcnt[i] = -1);
	for (;;) {
	    if (argc > 1) {
		dev = argv[1];
		if ((fh = open(dev, 1)) < 0) {
		    sprintf(dev = devbuf, "/dev/%s", argv[1]);
		    if (argv[1][0] == '/' || (fh = open(dev, 1)) < 0)
			perror(argv[1]);
		}
	    } else if ((fh = open(dev, 1)) < 0)
		perror(dev);
	    if (fh >= 0) {
		ioctl(fh, MPU_IOC_RESID, ccnt);
		for (i = MPU_TTR_MAX; --i >= 0 && ccnt[i] == dcnt[i]; );
		if (i >= 0) {
		    for (i = 0; i < MPU_TTR_MAX; i++)
			printf("%6d", dcnt[i] = ccnt[i]);
		    printf("\n");
		}
		close(fh);
		sleep(1);
	    } else
		sleep(5);
	}
}
