
#if !defined(lint) && !defined(SABER)
static char XRNrcsid[] = "$Header: /wrld/mnt11/ricks/src/X/xrn/RCS/resources.c,v 1.29 91/12/04 11:32:04 ricks Exp $";
#endif

/*
 * xrn - an X-based NNTP news reader
 *
 * Copyright (c) 1988, 1989, 1990, 1991, Ellen M. Sentovich and Rick L. Spickelmier.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of the University of California not
 * be used in advertising or publicity pertaining to distribution of 
 * the software without specific, written prior permission.  The University
 * of California makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *
 * THE UNIVERSITY OF CALIFORNIA DISCLAIMS ALL WARRANTIES WITH REGARD TO 
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND 
 * FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * resources.c: routines for handling resource management
 */

#include "copyright.h"
#include <X11/Xos.h>
#include "utils.h"
#include "config.h"
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include "avl.h"
#include "xthelper.h"
#include "mesg.h"
#include "xrn.h"
#include "resources.h"
#include "error_hnds.h"
#include "internals.h"
#ifdef VMS
#define index strchr
#endif /* VMS */

/*
 * resources and command list
 */

/* extra name and class specifications */
#define XtCgeometry       "Geometry"
#ifdef VMS
#define XtNgeometry	  "geometry"
#endif
#define XtNversion        "version"
#define XtCversion        "Version"
#define XtNiconGeometry   "iconGeometry"
#define XtCiconGeometry   "IconGeometry"
#define XtNpointerForeground "pointerForeground"
#define XtCPointerForeground "PointerForeground"
#define XtNpointerBackground "pointerBackground"
#define XtCPointerBackground "PointerBackground"
#define XtNnntpServer     "nntpServer"
#define XtCnntpServer     "NntpServer"
#define XtNnewsrcFile     "newsrcFile"
#define XtCnewsrcFile     "NewsrcFile"
#define XtNsaveNewsrcFile "saveNewsrcFile"
#define XtCsaveNewsrcFile "SaveNewsrcFile"
#define XtNsaveDir        "saveDir"
#define XtCsaveDir        "SaveDir"
#define XtNsignatureFile  "signatureFile"
#define XtCsignatureFile  "SignatureFile"
#define XtNtopLines       "topLines"
#define XtCtopLines       "TopLines"
#define XtNsaveMode       "saveMode"
#define XtCsaveMode       "SaveMode"
#define XtNleaveHeaders   "leaveHeaders"
#define XtCleaveHeaders   "LeaveHeaders"
#define XtNstripHeaders   "stripHeaders"
#define XtCstripHeaders   "StripHeaders"
#define XtNdeadLetters    "deadLetters"
#define XtCdeadLetters    "DeadLetters"
#define XtNsavePostings   "savePostings"
#define XtCsavePostings   "SavePostings"
#define XtNminLines       "minLines"
#define XtCminLines       "MinLines"
#define XtNmaxLines       "maxLines"
#define XtCmaxLines       "MaxLines"
#define XtNdefaultLines   "defaultLines"
#define XtCdefaultLines   "DefaultLines"
#define XtNcancelCount    "cancelCount"
#define XtCcancelCount    "CancelCount"
#define XtNmailer         "mailer"
#define XtCmailer         "Mailer"
#define XtNeditorCommand  "editorCommand"
#define XtCeditorCommand  "EditorCommand"
#ifdef WATCH
#define XtNwatchUnread  "watchUnread"
#define XtCwatchUnread  "WatchUnread"
#endif
#define XtNincludeCommand "includeCommand"
#define XtCincludeCommand "IncludeCommand"
#define XtNincludeHeader  "includeHeader"
#define XtCincludeHeader  "IncludeHeader"
#define XtNextraMailHeaders "extraMailHeaders"
#define XtCextraMailHeaders "ExtraMailHeaders"
#define XtNincludePrefix  "includePrefix"
#define XtCincludePrefix  "IncludePrefix"
#define XtNincludeSep     "includeSep"
#define XtCincludeSep     "IncludeSep"
#define XtNupdateNewsrc   "updateNewsrc"
#define XtCupdateNewsrc   "UpdateNewsrc"
#define XtNsortedSubjects "sortedSubjects"
#define XtCsortedSubjects "SortedSubjects"
#define XtNtmpDir         "tmpDir"
#define XtCtmpDir         "TmpDir"
#define XtNsubjectRead    "subjectRead"
#define XtCsubjectRead    "SubjectRead"
#define XtNinfo	  	  "info"
#define XtCInfo	  	  "Info"
#define XtNtypeAhead      "typeAhead"
#define XtCtypeAhead      "TypeAhead"
#define XtNconfirm        "confirm"
#define XtCconfirm        "Confirm"
#define XtNkillFiles      "killFiles"
#define XtCkillFiles      "KillFiles"
#define XtNcalvin         "calvin"
#define XtCcalvin         "Calvin"
#define XtNlineLength     "lineLength"
#define XtClineLength     "LineLength"
#define XtNbreakLength    "breakLength"
#define XtCbreakLength    "BreakLength"
#define XtNrescanTime	  "rescanTime"
#define XtCRescanTime	  "RescanTime"
#define XtNorganization	  "organization"
#define XtCorganization	  "Organization"
#define XtNdistribution   "distribution"
#define XtCdistribution   "Distribution"
#define XtNreplyTo	  "replyTo"
#define XtCreplyTo	  "ReplyTo"
#ifdef XRN_PREFETCH
#define XtNprefetchMax    "prefetchMax"
#define XtCprefetchMax    "PrefetchMax"
#endif

#define XtNaddButtonList  "addButtonList"
#define XtCAddButtonList  "AddButtonList"
#define XtNngButtonList   "ngButtonList"
#define XtCNgButtonList   "NgButtonList"
#define XtNallButtonList  "allButtonList"
#define XtCAllButtonList  "AllButtonList"
#define XtNartButtonList  "artButtonList"
#define XtCArtButtonList  "ArtButtonList"
#define XtNartSpecButtonList  "artSpecButtonList"
#define XtCArtSpecButtonList  "ArtSpecButtonList"

#define XtNaddBindings	  "addBindings"
#define XtCAddBindings	  "AddBindings"
#define XtNngBindings	  "ngBindings"
#define XtCNgBindings	  "NgBindings"
#define XtNartBindings	  "artBindings"
#define XtCArtBindings	  "ArtBindings"
#define XtNallBindings	  "allBindings"
#define XtCAllBindings	  "AllBindings"

#define XtNpageArticles	  "pageArticles"
#define XtCPageArticles	  "PageArticles"
#define XtNprintCommand	  "printCommand"
#define XtCPrintCommand	  "PrintCommand"

#define XtNdumpCore	"dumpCore"
#define XtCDebug	"Debug"

#define XtNcc		"cc"
#define XtNccForward	"ccForward"
#define XtCCC		"CC"


#define XtNverboseKill    "verboseKill"
#define XtCVerboseKill    "VerboseKill"

#define XtNunreadIconName     "unreadIconName"
#define XtCUnreadIconName     "UnreadIconName"

#ifdef MOTIF
#define XtNuseGadgets		"useGadgets"
#define XtCUseGadgets		"UseGadgets"
#endif

#define XtNauthorFullName	"authorFullName"
#define XtCAuthorFullName	"AuthorFullName"

#ifdef REALLY_USE_LOCALTIME
#define XtNdisplayLocalTime	"displayLocalTime"
#define XtCDisplayLocalTime	"DisplayLocalTime"
#endif

#define XtNdisplayLineCount	"displayLineCount"
#define XtCDisplayLineCount	"DisplayLineCount"

#define XtNsaveString	"saveString"
#define XtCSaveString	"SaveString"
#define XtNresetSave	"resetSave"
#define XtCResetSave	"ResetSave"

#define XtNlockFile	"lockFile"
#define XtCLockFile	"LockFile"

#define XtNmhPath         "mhPath"
#define XtCMhPath         "MhPath"

static Boolean defaultFalse = False;
static Boolean defaultTrue  = True;


app_resourceRec app_resources;
static char title[LABEL_SIZE];

/*
 * resources 'xrn' needs to get, rather than ones that the individual
 * widgets will handle
 */
static XtResource resources[] = {
   {XtNgeometry, XtCgeometry, XtRString,  sizeof(char *),
      XtOffset(app_res,geometry), XtRString, (caddr_t) NULL},
   
   {XtNiconGeometry,  XtCiconGeometry,  XtRString,  sizeof(char *),
      XtOffset(app_res,iconGeometry), XtRString, (caddr_t) NULL},
   
   {XtNiconName,  XtCIconName,  XtRString,  sizeof(char *),
      XtOffset(app_res,iconName), XtRString,
#ifdef SHORT_ICONNAME
	(caddr_t) "xrn"},
#else
	(caddr_t) title},
#endif
   {XtNunreadIconName,  XtCUnreadIconName,  XtRString,  sizeof(char *),
      XtOffset(app_res,unreadIconName), XtRString,
#ifdef SHORT_ICONNAME
      (caddr_t) "xrn"},
#else
      (caddr_t) title},
#endif
   
   {XtNtitle,  XtCTitle,  XtRString,  sizeof(char *),
      XtOffset(app_res,title), XtRString, (caddr_t) title},
   
   {XtNpointerBackground, XtCPointerBackground, XtRPixel, sizeof(Pixel),
      XtOffset(app_res,pointer_background), XtRString, XtDefaultBackground},

   {XtNpointerForeground, XtCPointerForeground, XtRPixel, sizeof(Pixel),
      XtOffset(app_res,pointer_foreground), XtRString, XtDefaultForeground},

   {XtNnntpServer, XtCnntpServer, XtRString, sizeof(char *),
      XtOffset(app_res,nntpServer), XtRString, (caddr_t) NULL},
   
   {XtNnewsrcFile, XtCnewsrcFile, XtRString, sizeof(char *),
      XtOffset(app_res,newsrcFile), XtRString, (caddr_t) NEWSRCFILE},
   
   {XtNsaveNewsrcFile, XtCsaveNewsrcFile, XtRString, sizeof(char *),
      XtOffset(app_res,saveNewsrcFile), XtRString, (caddr_t) SAVENEWSRCFILE},
   
   {XtNsaveDir,  XtCsaveDir,  XtRString, sizeof(char *),
      XtOffset(app_res,saveDir), XtRString, (caddr_t) SAVEDIR},
   
   {XtNsignatureFile, XtCsignatureFile, XtRString, sizeof(char *),
      XtOffset(app_res,signatureFile), XtRString, (caddr_t) SIGNATUREFILE},
   
   {XtNtopLines, XtCtopLines, XtRInt, sizeof(int),
      XtOffset(app_res,topLines), XtRString, (caddr_t) TOPLINES},
   
   {XtNsaveMode, XtCsaveMode, XtRString, sizeof(char *),
      XtOffset(app_res,strSaveMode), XtRString, (caddr_t) SAVEMODE},
   
   {XtNleaveHeaders, XtCleaveHeaders, XtRString, sizeof(char *),
      XtOffset(app_res,leaveHeaders), XtRString, (caddr_t) NULL},
   
   {XtNstripHeaders, XtCstripHeaders, XtRString, sizeof(char *),
      XtOffset(app_res,stripHeaders), XtRString, (caddr_t) NULL},
   
   {XtNdeadLetters, XtCdeadLetters, XtRString, sizeof(char *),
      XtOffset(app_res,deadLetters), XtRString, (caddr_t) DEADLETTER},

   {XtNsavePostings, XtCsavePostings, XtRString, sizeof(char *),
      XtOffset(app_res,savePostings), XtRString, (caddr_t) SAVEPOSTINGS},
   
   {XtNminLines, XtCminLines, XtRInt, sizeof(int),
      XtOffset(app_res,minLines), XtRString, (caddr_t) MINLINES},

   {XtNmaxLines, XtCmaxLines, XtRInt, sizeof(int),
      XtOffset(app_res,maxLines), XtRString, (caddr_t) MAXLINES},
   
   {XtNdefaultLines, XtCdefaultLines, XtRInt, sizeof(int),
      XtOffset(app_res,defaultLines), XtRString, (caddr_t) MINLINES},

   {XtNcancelCount, XtCcancelCount, XtRInt, sizeof(int),
      XtOffset(app_res,cancelCount), XtRString, (caddr_t) CANCELCOUNT},

   {XtNmailer, XtCmailer, XtRString, sizeof(char *),
      XtOffset(app_res,mailer), XtRString, (caddr_t) SENDMAIL},
   
   {XtNeditorCommand, XtCeditorCommand, XtRString, sizeof(char *),
      XtOffset(app_res,editorCommand), XtRString, (caddr_t) NULL},

   {XtNincludeCommand, XtCincludeCommand, XtRString, sizeof(char *),
      XtOffset(app_res,includeCommand), XtRString, (caddr_t) NULL},

   {XtNincludeHeader, XtCincludeHeader, XtRBoolean, sizeof(Boolean),
     XtOffset(app_res,includeHeader), XtRBoolean, (caddr_t) &defaultFalse},

   {XtNextraMailHeaders, XtCextraMailHeaders, XtRBoolean, sizeof(Boolean),
     XtOffset(app_res,extraMailHeaders), XtRBoolean, (caddr_t) &defaultFalse},

   {XtNversion, XtCversion, XtRString, sizeof(char *),
     XtOffset(app_res,version), XtRString, (caddr_t) NULL},

   {XtNincludePrefix, XtCincludePrefix, XtRString, sizeof(char *),
      XtOffset(app_res,includePrefix), XtRString, (caddr_t) INCLUDEPREFIX},

   {XtNincludeSep, XtCincludeSep, XtRBoolean, sizeof(Boolean),
      XtOffset(app_res,includeSep), XtRBoolean, (caddr_t) &defaultTrue},

   {XtNupdateNewsrc, XtCupdateNewsrc, XtRBoolean, sizeof(Boolean),
     XtOffset(app_res,updateNewsrc), XtRBoolean, (caddr_t) &defaultFalse},

   {XtNsortedSubjects, XtCsortedSubjects, XtRBoolean, sizeof(Boolean),
     XtOffset(app_res,sortedSubjects), XtRBoolean, (caddr_t) &defaultFalse},

   {XtNtmpDir, XtCtmpDir, XtRString, sizeof(char *),
      XtOffset(app_res,tmpDir), XtRString, (caddr_t) NULL},

   {XtNsubjectRead, XtCsubjectRead, XtRBoolean, sizeof(Boolean),
      XtOffset(app_res,subjectRead), XtRBoolean, (caddr_t) &defaultFalse},
   
   {XtNinfo, XtCInfo, XtRBoolean, sizeof(Boolean),
      XtOffset(app_res,info), XtRBoolean, (caddr_t) &defaultTrue},
   
   {XtNtypeAhead, XtCtypeAhead, XtRBoolean, sizeof(Boolean),
     XtOffset(app_res,typeAhead), XtRBoolean, (caddr_t) &defaultTrue},

   {XtNconfirm, XtCconfirm, XtRString, sizeof(char *),
      XtOffset(app_res,confirm), XtRString, (caddr_t) NULL},

   {XtNkillFiles, XtCkillFiles, XtRBoolean, sizeof(Boolean),
      XtOffset(app_res,killFiles), XtRBoolean, (caddr_t) &defaultTrue},

   {XtNcalvin, XtCcalvin, XtRBoolean, sizeof(Boolean),
      XtOffset(app_res,calvin), XtRBoolean, (caddr_t) &defaultFalse},
   
   {XtNlineLength, XtClineLength, XtRInt, sizeof(int),
      XtOffset(app_res,lineLength), XtRString, (caddr_t) LINELENGTH},
   
   {XtNbreakLength, XtCbreakLength, XtRInt, sizeof(int),
      XtOffset(app_res,breakLength), XtRString, (caddr_t) BREAKLENGTH},
#ifdef WATCH
   {XtNwatchUnread, XtCwatchUnread, XtRString, sizeof(char *),
      XtOffset(app_res,watchList), XtRString, (caddr_t) NULL},
#endif

   {XtNrescanTime, XtCRescanTime, XtRInt, sizeof(int),
      XtOffset(app_res,rescanTime), XtRString, (caddr_t) RESCAN_TIME},

   {XtNorganization, XtCorganization, XtRString, sizeof(char *),
      XtOffset(app_res,organization), XtRString, (caddr_t) NULL},
   
   {XtNdistribution, XtCdistribution, XtRString, sizeof(char *),
      XtOffset(app_res,distribution), XtRString, (caddr_t) NULL},
   
   {XtNreplyTo, XtCreplyTo, XtRString, sizeof(char *),
      XtOffset(app_res,replyTo), XtRString, (caddr_t) NULL},
   
#ifdef XRN_PREFETCH
   {XtNprefetchMax, XtCprefetchMax, XtRInt, sizeof(int),
       XtOffset(app_res,prefetchMax), XtRString, (caddr_t) XRN_PREFETCH_MAX},
#endif

   {XtNaddButtonList, XtCAddButtonList, XtRString, sizeof(char *),
      XtOffset(app_res,addButtonList), XtRString, (caddr_t) NULL},

   {XtNngButtonList, XtCNgButtonList, XtRString, sizeof(char *),
      XtOffset(app_res,ngButtonList), XtRString, (caddr_t) NULL},

   {XtNallButtonList, XtCAllButtonList, XtRString, sizeof(char *),
      XtOffset(app_res,allButtonList), XtRString, (caddr_t) NULL},

   {XtNartButtonList, XtCArtButtonList, XtRString, sizeof(char *),
      XtOffset(app_res,artButtonList), XtRString, (caddr_t) NULL},

   {XtNartSpecButtonList, XtCArtSpecButtonList, XtRString, sizeof(char *),
      XtOffset(app_res,artSpecButtonList), XtRString, (caddr_t) NULL},

   {XtNaddBindings, XtCAddBindings, XtRString, sizeof(char *),
      XtOffset(app_res,addBindings), XtRString, (caddr_t) NULL},

   {XtNngBindings, XtCNgBindings, XtRString, sizeof(char *),
      XtOffset(app_res,ngBindings), XtRString, (caddr_t) NULL},

   {XtNartBindings, XtCArtBindings, XtRString, sizeof(char *),
      XtOffset(app_res,artBindings), XtRString, (caddr_t) NULL},

   {XtNallBindings, XtCAllBindings, XtRString, sizeof(char *),
      XtOffset(app_res,allBindings), XtRString, (caddr_t) NULL},

   {XtNpageArticles, XtCPageArticles, XtRBoolean, sizeof(Boolean),
      XtOffset(app_res,pageArticles), XtRBoolean, (caddr_t) &defaultTrue},

   {XtNprintCommand, XtCPrintCommand, XtRString, sizeof(char *),
      XtOffset(app_res,printCommand), XtRString, (caddr_t) PRINTCOMMAND},

   {XtNdumpCore, XtCDebug, XtRBoolean, sizeof(Boolean),
      XtOffset(app_res,dumpCore), XtRBoolean, (caddr_t)
#ifdef DUMPCORE
							&defaultTrue},
#else
							&defaultFalse},
#endif
   {XtNcc, XtCCC, XtRBoolean, sizeof(Boolean),
     XtOffset(app_res,cc), XtRBoolean, (caddr_t) &defaultFalse},
   {XtNccForward, XtCCC, XtRBoolean, sizeof(Boolean),
     XtOffset(app_res,ccForward), XtRBoolean, (caddr_t) &defaultFalse},
   {XtNverboseKill, XtCVerboseKill, XtRBoolean, sizeof(Boolean),
     XtOffset(app_res,verboseKill), XtRBoolean, (caddr_t) &defaultTrue},
#ifdef MOTIF
   {XtNuseGadgets, XtCUseGadgets, XtRBoolean, sizeof(Boolean),
     XtOffset(app_res,useGadgets), XtRBoolean, (caddr_t) &defaultFalse},
#endif
   {XtNauthorFullName, XtCAuthorFullName, XtRBoolean, sizeof(Boolean),
     XtOffset(app_res,authorFullName), XtRBoolean, (caddr_t) &defaultTrue},
#ifdef REALLY_USE_LOCALTIME
   {XtNdisplayLocalTime, XtCDisplayLocalTime, XtRBoolean, sizeof(Boolean),
     XtOffset(app_res,displayLocalTime), XtRBoolean, (caddr_t) &defaultTrue},
#endif
   {XtNdisplayLineCount, XtCDisplayLineCount, XtRBoolean, sizeof(Boolean),
     XtOffset(app_res,displayLineCount), XtRBoolean, (caddr_t) &defaultTrue},

   {XtNsaveString, XtCSaveString, XtRString, sizeof(char *),
      XtOffset(app_res,saveString), XtRString, (caddr_t) NULL},
   {XtNresetSave, XtCResetSave, XtRBoolean, sizeof(Boolean),
      XtOffset(app_res,resetSave), XtRBoolean, (caddr_t) &defaultTrue},
   {XtNmhPath, XtCMhPath, XtRString, sizeof(String),
      XtOffset(app_res,mhPath), XtRString, (caddr_t) NULL},

   {XtNlockFile, XtCLockFile, XtRString, sizeof(char *),
      XtOffset(app_res,lockFile), XtRString, (caddr_t) "~/.xrnlock"},

};


/*
 * allowed command line options
 */
#ifndef VMS
static XrmOptionDescRec optionList[] = {
    {"-geometry",       XtNgeometry,       XrmoptionSepArg,  (caddr_t) NULL},
    {"-iconGeometry",   XtNiconGeometry,   XrmoptionSepArg,  (caddr_t) NULL},
    {"-pointerBackground", XtNpointerBackground, XrmoptionSepArg, (caddr_t) NULL},
    {"-pointerForeground", XtNpointerForeground, XrmoptionSepArg, (caddr_t) NULL},
    {"-nntpServer",     XtNnntpServer,     XrmoptionSepArg,  (caddr_t) NULL},
    {"-newsrcFile",     XtNnewsrcFile,     XrmoptionSepArg,  (caddr_t) NULL},
    {"-saveNewsrcFile", XtNsaveNewsrcFile, XrmoptionSepArg,  (caddr_t) NULL},
    {"-saveDir",        XtNsaveDir,        XrmoptionSepArg,  (caddr_t) NULL},
    {"-signatureFile",  XtNsignatureFile,  XrmoptionSepArg,  (caddr_t) NULL},
    {"-topLines",       XtNtopLines,       XrmoptionSepArg,  (caddr_t) NULL},
    {"-saveMode",       XtNsaveMode,       XrmoptionSepArg,  (caddr_t) NULL},
    {"-leaveHeaders",   XtNleaveHeaders,   XrmoptionSepArg,  (caddr_t) NULL},
    {"-stripHeaders",   XtNstripHeaders,   XrmoptionSepArg,  (caddr_t) NULL},
    {"-deadLetters",    XtNdeadLetters,    XrmoptionSepArg,  (caddr_t) NULL},
    {"-savePostings",   XtNsavePostings,   XrmoptionSepArg,  (caddr_t) NULL},
    {"-minLines",       XtNminLines,       XrmoptionSepArg,  (caddr_t) NULL},
    {"-maxLines",       XtNmaxLines,       XrmoptionSepArg,  (caddr_t) NULL},
    {"-defaultLines",   XtNdefaultLines,   XrmoptionSepArg,  (caddr_t) NULL},
    {"-cancelCount",    XtNcancelCount,    XrmoptionSepArg,  (caddr_t) NULL},
    {"-mailer",         XtNmailer,         XrmoptionSepArg,  (caddr_t) NULL},
    {"-editorCommand",  XtNeditorCommand,  XrmoptionSepArg,  (caddr_t) NULL},
#ifdef WATCH
    {"-watchUnread",    XtNwatchUnread,    XrmoptionSepArg,  (caddr_t) NULL},
#endif
    {"-includeCommand", XtNincludeCommand, XrmoptionSepArg,  (caddr_t) NULL},
    {"-includeHeader",  XtNincludeHeader,  XrmoptionNoArg,   (caddr_t) "off"},
    {"+includeHeader",  XtNincludeHeader,  XrmoptionNoArg,   (caddr_t) "on"},
    {"-extramailheaders",XtNextraMailHeaders,XrmoptionNoArg, (caddr_t) "off"},
    {"+extramailheaders",XtNextraMailHeaders,XrmoptionNoArg, (caddr_t) "on"},
    {"-includePrefix",  XtNincludePrefix,  XrmoptionSepArg,  (caddr_t) NULL},
    {"-includeSep",     XtNincludeSep,     XrmoptionNoArg,   (caddr_t) "off"},
    {"+includeSep",     XtNincludeSep,     XrmoptionNoArg,   (caddr_t) "on"},
    {"-updateNewsrc",   XtNupdateNewsrc,   XrmoptionNoArg,   (caddr_t) "off"},
    {"+updateNewsrc",   XtNupdateNewsrc,   XrmoptionNoArg,   (caddr_t) "on"},
    {"-sortedSubjects", XtNsortedSubjects, XrmoptionNoArg,   (caddr_t) "off"},
    {"+sortedSubjects", XtNsortedSubjects, XrmoptionNoArg,   (caddr_t) "on"},
    {"-tmpDir",         XtNtmpDir,         XrmoptionSepArg,  (caddr_t) NULL},
    {"-subjectRead",    XtNsubjectRead,    XrmoptionNoArg,   (caddr_t) "off"},
    {"+subjectRead",    XtNsubjectRead,    XrmoptionNoArg,   (caddr_t) "on"},
    {"-info",    	XtNinfo,           XrmoptionNoArg,   (caddr_t) "off"},
    {"+info",    	XtNinfo,           XrmoptionNoArg,   (caddr_t) "on"},
    {"-typeAhead",    	XtNtypeAhead,      XrmoptionNoArg,   (caddr_t) "off"},
    {"+typeAhead",    	XtNtypeAhead,      XrmoptionNoArg,   (caddr_t) "on"},
    {"-confirm",        XtNconfirm,        XrmoptionSepArg,  (caddr_t) NULL},
    {"-killFiles",      XtNkillFiles,      XrmoptionNoArg,   (caddr_t) "off"},
    {"+killFiles",      XtNkillFiles,      XrmoptionNoArg,   (caddr_t) "on"},
    {"-calvin",         XtNcalvin,         XrmoptionNoArg,   (caddr_t) "on"},
    {"-lineLength",     XtNlineLength,     XrmoptionSepArg,  (caddr_t) NULL},
    {"-breakLength",    XtNbreakLength,    XrmoptionSepArg,  (caddr_t) NULL},
    {"-rescanTime",	XtNrescanTime,	   XrmoptionSepArg,  (caddr_t) NULL},
    {"-organization",   XtNorganization,   XrmoptionSepArg,  (caddr_t) NULL},
    {"-replyTo",        XtNreplyTo,        XrmoptionSepArg,  (caddr_t) NULL},
#ifdef XRN_PREFETCH
    {"-prefetchMax",    XtNprefetchMax,    XrmoptionSepArg,  (caddr_t) NULL},
#endif
    {"-addButtonList",  XtNaddButtonList,  XrmoptionSepArg,  (caddr_t) NULL},
    {"-ngButtonList",   XtNngButtonList,   XrmoptionSepArg,  (caddr_t) NULL},
    {"-allButtonList",  XtNallButtonList,  XrmoptionSepArg,  (caddr_t) NULL},
    {"-artButtonList",  XtNartButtonList,  XrmoptionSepArg,  (caddr_t) NULL},
    {"-artSpecButtonList",  XtNartSpecButtonList,  XrmoptionSepArg,  (caddr_t) NULL},
    {"-addBindings",    XtNaddBindings,    XrmoptionSepArg,  (caddr_t) NULL},
    {"-ngBindings",     XtNngBindings,     XrmoptionSepArg,  (caddr_t) NULL},
    {"-artBindings",    XtNartBindings,    XrmoptionSepArg,  (caddr_t) NULL},
    {"-allBindings",    XtNallBindings,    XrmoptionSepArg,  (caddr_t) NULL},
    {"-pageArticles",	XtNpageArticles,   XrmoptionNoArg,   (caddr_t) "off"},
    {"+pageArticles",	XtNpageArticles,   XrmoptionNoArg,   (caddr_t) "on"},
    {"-printCommand",   XtNprintCommand,   XrmoptionSepArg,  (caddr_t) NULL},
    {"-distribution",   XtNdistribution,   XrmoptionSepArg,  (caddr_t) NULL},
    {"-dumpCore",	XtNdumpCore,	   XrmoptionNoArg,   (caddr_t) "off"},
    {"+dumpCore",	XtNdumpCore,	   XrmoptionNoArg,   (caddr_t) "on"},
    {"-cc",		XtNcc,	   	   XrmoptionNoArg,   (caddr_t) "off"},
    {"+cc",		XtNcc,	   	   XrmoptionNoArg,   (caddr_t) "on"},
    {"-ccForward",	XtNccForward,  	   XrmoptionNoArg,   (caddr_t) "off"},
    {"+ccForward",	XtNccForward,  	   XrmoptionNoArg,   (caddr_t) "on"},
    {"-unreadIconName", XtNunreadIconName, XrmoptionSepArg,  (caddr_t) NULL},
    {"-verboseKill",	XtNverboseKill,	   XrmoptionNoArg,   (caddr_t) "off"},
    {"+verboseKill",	XtNverboseKill,	   XrmoptionNoArg,   (caddr_t) "on"},
#ifdef MOTIF
    {"-useGadgets",     XtNuseGadgets,     XrmoptionNoArg,   (caddr_t) "off"},
    {"+useGadgets",     XtNuseGadgets,     XrmoptionNoArg,   (caddr_t) "on"},
#endif
    {"-authorFullName",	XtNauthorFullName, XrmoptionNoArg,   (caddr_t) "off"},
    {"+authorFullName",	XtNauthorFullName, XrmoptionNoArg,   (caddr_t) "on"},
#ifdef REALLY_USE_LOCALTIME
    {"-displayLocalTime",XtNdisplayLocalTime,XrmoptionNoArg, (caddr_t) "off"},
    {"+displayLocalTime",XtNdisplayLocalTime,XrmoptionNoArg, (caddr_t) "on"},
#endif
    {"-displayLineCount",XtNdisplayLineCount,XrmoptionNoArg, (caddr_t) "off"},
    {"+displayLineCount",XtNdisplayLineCount,XrmoptionNoArg, (caddr_t) "on"},
    {"-saveString", XtNsaveString, XrmoptionSepArg,  (caddr_t) NULL},
    {"-resetSave", XtNresetSave, XrmoptionNoArg,  (caddr_t) "off"},
    {"+resetSave", XtNresetSave, XrmoptionNoArg,  (caddr_t) "on"},
    {"-lockFile", XtNlockFile, XrmoptionSepArg,  (caddr_t) NULL},
};    
#else
static XrmOptionDescRec optionList[] = {
    {"-geometry",       XtNgeometry,       XrmoptionSepArg,  (caddr_t) NULL},
    {"-icongeometry",   XtNiconGeometry,   XrmoptionSepArg,  (caddr_t) NULL},
    {"-pointerbackground", XtNpointerBackground, XrmoptionSepArg, (caddr_t) NULL},
    {"-pointerforeground", XtNpointerForeground, XrmoptionSepArg, (caddr_t) NULL},
    {"-nntpserver",     XtNnntpServer,     XrmoptionSepArg,  (caddr_t) NULL},
    {"-newsrcfile",     XtNnewsrcFile,     XrmoptionSepArg,  (caddr_t) NULL},
    {"-savenewsrcfile", XtNsaveNewsrcFile, XrmoptionSepArg,  (caddr_t) NULL},
    {"-savedir",        XtNsaveDir,        XrmoptionSepArg,  (caddr_t) NULL},
    {"-signaturefile",  XtNsignatureFile,  XrmoptionSepArg,  (caddr_t) NULL},
    {"-toplines",       XtNtopLines,       XrmoptionSepArg,  (caddr_t) NULL},
    {"-savemode",       XtNsaveMode,       XrmoptionSepArg,  (caddr_t) NULL},
    {"-leaveheaders",   XtNleaveHeaders,   XrmoptionSepArg,  (caddr_t) NULL},
    {"-stripheaders",   XtNstripHeaders,   XrmoptionSepArg,  (caddr_t) NULL},
    {"-deadletters",    XtNdeadLetters,    XrmoptionSepArg,  (caddr_t) NULL},
    {"-savepostings",   XtNsavePostings,   XrmoptionSepArg,  (caddr_t) NULL},
    {"-minlines",       XtNminLines,       XrmoptionSepArg,  (caddr_t) NULL},
    {"-maxlines",       XtNmaxLines,       XrmoptionSepArg,  (caddr_t) NULL},
    {"-defaultlines",   XtNdefaultLines,   XrmoptionSepArg,  (caddr_t) NULL},
    {"-cancelcount"     XtNcancelCount,    XrmoptionSepArg,  (caddr_t) NULL},
    {"-mailer",         XtNmailer,         XrmoptionSepArg,  (caddr_t) NULL},
    {"-editorcommand",  XtNeditorCommand,  XrmoptionSepArg,  (caddr_t) NULL},
#ifdef WATCH
    {"-watchUnread",    XtNwatchUnread,    XrmoptionSepArg,  (caddr_t) NULL},
#endif
    {"-includecommand", XtNincludeCommand, XrmoptionSepArg,  (caddr_t) NULL},
    {"-includeheader",  XtNincludeHeader,  XrmoptionNoArg,   (caddr_t) "off"},
    {"+includeheader",  XtNincludeHeader,  XrmoptionNoArg,   (caddr_t) "on"},
    {"-extramailheaders",XtNextraMailHeaders,XrmoptionNoArg, (caddr_t) "off"},
    {"+extramailheaders",XtNextraMailHeaders,XrmoptionNoArg, (caddr_t) "on"},
    {"-includesep",     XtNincludeSep,     XrmoptionNoArg,   (caddr_t) "off"},
    {"+includesep",     XtNincludeSep,     XrmoptionNoArg,   (caddr_t) "on"},
    {"-updatenewsrc",   XtNupdateNewsrc,   XrmoptionNoArg,   (caddr_t) "off"},
    {"+updatenewsrc",   XtNupdateNewsrc,   XrmoptionNoArg,   (caddr_t) "on"},
    {"-sortedsubjects", XtNsortedSubjects, XrmoptionNoArg,   (caddr_t) "off"},
    {"+sortedsubjects", XtNsortedSubjects, XrmoptionNoArg,   (caddr_t) "on"},
    {"-tmpdir",         XtNtmpDir,         XrmoptionSepArg,  (caddr_t) NULL},
    {"-subjectread",    XtNsubjectRead,    XrmoptionNoArg,   (caddr_t) "off"},
    {"+subjectread",    XtNsubjectRead,    XrmoptionNoArg,   (caddr_t) "on"},
    {"-info",    	XtNinfo,           XrmoptionNoArg,   (caddr_t) "off"},
    {"+info",    	XtNinfo,           XrmoptionNoArg,   (caddr_t) "on"},
    {"-typeahead",    	XtNtypeAhead,      XrmoptionNoArg,   (caddr_t) "off"},
    {"+typeahead",    	XtNtypeAhead,      XrmoptionNoArg,   (caddr_t) "on"},
    {"-confirm",        XtNconfirm,        XrmoptionSepArg,  (caddr_t) NULL},
    {"-killfiles",      XtNkillFiles,      XrmoptionNoArg,   (caddr_t) "off"},
    {"+killfiles",      XtNkillFiles,      XrmoptionNoArg,   (caddr_t) "on"},
    {"-calvin",         XtNcalvin,         XrmoptionNoArg,   (caddr_t) "on"},
    {"-linelength",     XtNlineLength,     XrmoptionSepArg,  (caddr_t) NULL},
    {"-breaklength",    XtNbreakLength,    XrmoptionSepArg,  (caddr_t) NULL},
    {"-rescantime",	XtNrescanTime,	   XrmoptionSepArg,  (caddr_t) NULL},
    {"-organization",   XtNorganization,   XrmoptionSepArg,  (caddr_t) NULL},
    {"-replyto",        XtNreplyTo,        XrmoptionSepArg,  (caddr_t) NULL},
#ifdef XRN_PREFETCH
    {"-prefetchmax",    XtNprefetchMax,    XrmoptionSepArg,  (caddr_t) NULL},
#endif
    {"-addbuttonlist",  XtNaddButtonList,  XrmoptionSepArg,  (caddr_t) NULL},
    {"-ngbuttonlist",   XtNngButtonList,   XrmoptionSepArg,  (caddr_t) NULL},
    {"-allbuttonlist",  XtNallButtonList,  XrmoptionSepArg,  (caddr_t) NULL},
    {"-artbuttonlist",  XtNartButtonList,  XrmoptionSepArg,  (caddr_t) NULL},
    {"-artspecbuttonlist",  XtNartSpecButtonList,  XrmoptionSepArg,  (caddr_t) NULL},
    {"-addbindings",    XtNaddBindings,    XrmoptionSepArg,  (caddr_t) NULL},
    {"-ngbindings",     XtNngBindings,     XrmoptionSepArg,  (caddr_t) NULL},
    {"-artbindings",    XtNartBindings,    XrmoptionSepArg,  (caddr_t) NULL},
    {"-allbindings",    XtNallBindings,    XrmoptionSepArg,  (caddr_t) NULL},
    {"-pagearticles",	XtNpageArticles,   XrmoptionNoArg,   (caddr_t) "off"},
    {"+pagearticles",	XtNpageArticles,   XrmoptionNoArg,   (caddr_t) "on"},
    {"-printcommand",   XtNprintCommand,   XrmoptionSepArg,  (caddr_t) NULL},
    {"-distribution",   XtNdistribution,   XrmoptionSepArg,  (caddr_t) NULL},
    {"-dumpcore",	XtNdumpCore,	   XrmoptionNoArg,   (caddr_t) "off"},
    {"+dumpcore",	XtNdumpCore,	   XrmoptionNoArg,   (caddr_t) "on"},
    {"-cc",		XtNcc,	   	   XrmoptionNoArg,   (caddr_t) "off"},
    {"+cc",		XtNcc,	   	   XrmoptionNoArg,   (caddr_t) "on"},
    {"-ccforward",	XtNccForward,  	   XrmoptionNoArg,   (caddr_t) "off"},
    {"+ccforward",	XtNccForward,  	   XrmoptionNoArg,   (caddr_t) "on"},
    {"-unreadiconname", XtNunreadIconName, XrmoptionSepArg,  (caddr_t) NULL},
    {"-verbosekill",	XtNverboseKill,	   XrmoptionNoArg,   (caddr_t) "off"},
    {"+verbosekill",	XtNverboseKill,	   XrmoptionNoArg,   (caddr_t) "on"},
#ifdef MOTIF
    {"-usegadgets",     XtNuseGadgets,     XrmoptionNoArg,  (caddr_t) "off"},
    {"+usegadgets",     XtNuseGadgets,     XrmoptionNoArg,  (caddr_t) "on"},
#endif
    {"-authorfullname",	XtNauthorFullName, XrmoptionNoArg,   (caddr_t) "off"},
    {"+authorfullname",	XtNauthorFullName, XrmoptionNoArg,   (caddr_t) "on"},
#ifdef REALLY_USE_LOCALTIME
    {"-displaylocaltime",XtNdisplayLocalTime,XrmoptionNoArg, (caddr_t) "off"},
    {"+displaylocaltime",XtNdisplayLocalTime,XrmoptionNoArg, (caddr_t) "on"},
#endif
    {"-displaylinecount",XtNdisplayLineCount,XrmoptionNoArg, (caddr_t) "off"},
    {"+displaylinecount",XtNdisplayLineCount,XrmoptionNoArg, (caddr_t) "on"},
    {"-savestring", XtNsaveString, XrmoptionSepArg,  (caddr_t) NULL},
    {"-resetsave", XtNresetSave, XrmoptionNoArg,  (caddr_t) "off"},
    {"+resetsave", XtNresetSave, XrmoptionNoArg,  (caddr_t) "on"},
    {"-lockfile", XtNlockFile, XrmoptionSepArg,  (caddr_t) NULL},
};    
#endif

static void
usage(ac, av)
int ac;
char **av;  /* program name */
/*
 * print out the usage message
 *
 */
{
    int i;

    (void) printf("Unknown options:");
    for (i = 1; i <= ac - 1; i++) {
	if (index(av[i], ':') == NIL(char)) {
	    printf(" %s", av[i]);
	}
    }
    printf("\n");
    printf("usage: %s [options] [-display host:display]\n", av[0]);
    printf("\t-geometry WxH+X+Y\tSize and position of window\n");
    printf("\t-iconGeometry +X+Y\tPosition of icon\n");
    printf("\t-pointerBackground color\tbackground color of mouse cursor\n");
    printf("\t-pointerForeground color\tforeground color of mouse cursor\n");
    printf("\t-nntpServer name\tNNTP server\n");
    printf("\t-newsrcFile file\t.newsrc filename\n");
    printf("\t-saveNewsrcFile file\tSaved .newsrc filename\n");
    printf("\t-saveDir directory\tDirectory for saving files\n");
    printf("\t-signatureFile file\tSignature file for posting\n");
    printf("\t-topLines number\tNumber of lines used by the top window\n");
    printf("\t-saveMode mode\t\tMethod of saving articles\n");
    printf("\t-leaveHeaders list\tHeaders to leave\n");
    printf("\t-stripHeaders list\tHeaders to strip\n");
    printf("\t-deadLetters file\tFile to store failed postings/messages\n");
    printf("\t-savePostings file\tFile to save postings/messages\n");
    printf("\t-minLines number\tMinimum number of lines above cursor\n");
    printf("\t-maxLines number\tMaximum number of lines above cursor\n");
    printf("\t-defaultLines number\tDefault number of lines above cursor\n");
    printf("\t-cancelCount number\tNumber of articles to search before popping up the cancel button\n");
    printf("\t-mailer\t\t\tMailer to use\n");
    printf("\t-editorCommand\t\tEditor to use (defaults to the toolkit editor)\n");
#ifdef WATCH
    printf("\t-watchUnread\t\tList of news groups to monitor\n");
#endif
    printf("\t-includeCommand\t\tCommand to use for article insertions (defaults to the toolkit editor)\n");
    printf("\t+/-includeHeader\tInclude original article's header\n");
    printf("\t+/-includeSep\t\tPut prefix in front of included lines\n");
    printf("\t-includePrefix\t\tPrefix [\"%s\"] for included lines\n",
	   INCLUDEPREFIX);
    printf("\t+/-updateNewsrc\t\tUpdate the .newsrc file each time a group is exited\n");
    printf("\t+/-sortedSubjects\tSort or do not sort the subjects\n");
    printf("\t-tmpDir\t\t\tTemporary article directory\n");
    printf("\t+/-subjectRead\t\tChange default from next unread to subject next\n");
    printf("\t+/-info\t\t\tPut all information in the message pane\n");
    printf("\t+/-typeAhead\t\tEnable typeahead\n");
    printf("\t-confirm\t\tTurn on/off confirmation boxes\n");
    printf("\t+/-killFiles\t\tTurn on/off the use of kill files\n");
    printf("\t-lineLength\t\tLength of lines for article postings\n");
    printf("\t-breakLength\t\tLength of line at which line wrapping begins\n");
    printf("\t-rescanTime\t\tIdle time before checking for new articles\n");
    printf("\t-organization\t\tName of your organization\n");
    printf("\t-replyTo\t\tValue used for the Reply-To field\n");
#ifdef XRN_PREFETCH
    printf("\t-prefetchMax\t\tMaximum number of articles to prefetch\n");
#endif
    printf("\t-addButtonList\t\tList of Add mode buttons\n");
    printf("\t-ngButtonList\t\tList of Newsgroup mode buttons\n");
    printf("\t-allButtonList\t\tList of All mode buttons\n");
    printf("\t-artButtonList\t\tList of Article mode buttons (top box)\n");
    printf("\t-artSpecButtonList\tList of Article mode buttons (bottom box)\n");
    printf("\t-addBindings\t\tAdd mode bindings\n");
    printf("\t-ngBindings\t\tNewsgroup mode bindings\n");
    printf("\t-artBindings\t\tArticle mode bindings\n");
    printf("\t-allBindings\t\tAll mode bindings\n");
    printf("\t+/-pageArticles\t\tSpacebar scrolls the current article\n");
    printf("\t-printCommand\t\tCommand to use to print out an article\n");
    printf("\t-distribution\t\tDefault distribution for messages\n");
#ifdef DUMPCORE
    printf("\t+/-dumpCore\t\tDump core on error exit\n");
#endif
    printf("\t+/-cc\t\t\tInclude 'Cc: user' in replies\n");
    printf("\t+/-ccForward\t\tInclude 'Cc: user' in forwarded messages\n");    
    printf("\t+/-verboseKill\t\tList subjects when killing articles\n");
#ifdef MOTIF
    printf("\t+/-useGadgets\t\tUse Motif gadget buttons instead of widgets\n");
#endif
    printf("\t+/-unreadIconName\t\tIcon name used when unread articles\n");
    printf("\t+/-authorFullName\t\tUse author's fullname in article list\n");
#ifdef REALLY_USE_LOCALTIME
    printf("\t+/-displayLocalTime\t\tDisplay local time in the Date: field\n");
#endif
    printf("\t+/-displayLineCount\t\tDisplay line count in the subject index\n");
    printf("\t-saveString\t\tstring to use in the save dialog\n");
    printf("\t+/-resetSave\t\treset the save dialog string upon entering each newsgroup\n");
    printf("\t+/-lockFile\t\tname of the XRN lock file\n");
    exit(0);
}


Widget
Initialize(argc, argv)
int argc;
char **argv;
/*
 * initialize the toolkit, parse the command line, and handle the Xdefaults
 *
 *   returns: top level widget
 *
 */
{
#ifndef XDBBUG
    extern XrmDatabase XtDatabase _ARGUMENTS((Display *));
#endif /* XDBBUG */
    Widget widget;
    char *ptr;
    static Arg shell_args[] = {
	{XtNinput, (XtArgVal)True},
	{XtNiconName, (XtArgVal) NULL},
	{XtNtitle, (XtArgVal) NULL},
    };


    /* set up the program name */
#ifndef VMS
    if ((ptr = rindex(argv[0], '/')) == NIL(char)) {
	(void) strncpy(app_resources.progName, argv[0],
		       sizeof(app_resources.progName));
    } else {
	(void) strncpy(app_resources.progName, ++ptr,
		       sizeof(app_resources.progName));
    }
#else
    (void) strcpy(app_resources.progName, "xrn");
#endif

#ifndef MOTIF
    widget = XtInitialize(app_resources.progName, "XRn",
			  optionList, XtNumber(optionList),
			  &argc, argv);
#else
    widget = XtInitialize(app_resources.progName, "XRnMotif",
			  optionList, XtNumber(optionList),
			  &argc, argv);
#endif

    if (argc > 1) {
	usage(argc, argv);
    }

#if defined(__DATE__) && defined(WANT_DATE)
    (void) sprintf(title, "xrn - version %s (compiled on %s)",
		   XRN_VERSION, __DATE__);
#else
    (void) sprintf(title, "xrn - version %s",
		   XRN_VERSION);
#endif

    /* get the resources needed by xrn itself */
    XtGetApplicationResources(widget, (caddr_t) &app_resources,
			      resources, XtNumber(resources), 0, 0);

    /* 
     * check and set the lock file - must be after the application resources
     * are processed
     */
    checkLock();

    /* set up the titles */
    shell_args[1].value = (XtArgVal) app_resources.iconName;
    shell_args[2].value = (XtArgVal) app_resources.title;

    XtSetValues(widget, shell_args, XtNumber(shell_args));

    /* article saving mode */

    app_resources.saveMode = 0;
    if (utSubstring(app_resources.strSaveMode, "mailbox") == 1) {
	app_resources.saveMode |= MAILBOX_SAVE;
    } else {
	app_resources.saveMode |= NORMAL_SAVE;
    }
    if (utSubstring(app_resources.strSaveMode, "noheaders") == 1) {
	app_resources.saveMode |= NOHEADERS_SAVE;
    } else {
	app_resources.saveMode |= HEADERS_SAVE;
    }

    if (utSubstring(app_resources.strSaveMode, "subdirs") == 1) {
	app_resources.saveMode |= SUBDIRS_SAVE;
    } else if (utSubstring(app_resources.strSaveMode, "onedir") == 1) {
	app_resources.saveMode |= ONEDIR_SAVE;
    } else {
	app_resources.saveMode |= SAVE_DIR_DEFAULT;
    }

    /* header stripping mode */

    /* STRIP_HEADERS with a NIL table will leave all headers (nothing to strip) */
    app_resources.headerTree = avl_init_table(strcmp);
    app_resources.headerMode = STRIP_HEADERS;

    /*
     * A leaveHeaders value of "all" cancels leaveHeaders, and a
     * stripHeaders value of "none" cancels stripHeaders.
     */

    if (app_resources.leaveHeaders) {
	utDowncase(app_resources.leaveHeaders);
        if (! strcmp(app_resources.leaveHeaders, "all"))
	    app_resources.leaveHeaders = NIL(char);
    }
    if (app_resources.stripHeaders) {
	utDowncase(app_resources.stripHeaders);
        if (! strcmp(app_resources.stripHeaders, "none"))
	    app_resources.stripHeaders = NIL(char);
    }

    if ((app_resources.leaveHeaders != NIL(char)) &&
	(app_resources.stripHeaders != NIL(char))) {
	ehErrorExitXRN("Only one of 'stripHeaders, leaveHeaders' allowed\n");
     }  

    if (app_resources.leaveHeaders != NIL(char)) {
	char *ptr, *token;
	
	app_resources.headerMode = LEAVE_HEADERS;
	ptr = app_resources.leaveHeaders;
	while ((token = strtok(ptr, ", \t\n")) != NIL(char)) {
	    utDowncase(token);
	    (void) avl_insert(app_resources.headerTree, token, (char *) 1);
	    ptr = NIL(char);
	}
	
    } else if (app_resources.stripHeaders != NIL(char)) {
	char *ptr, *token;
	
	app_resources.headerMode = STRIP_HEADERS;
	ptr = app_resources.stripHeaders;
	while ((token = strtok(ptr, ", \t\n")) != NIL(char)) {
	    utDowncase(token);
	    (void) avl_insert(app_resources.headerTree, token, (char *) 1);
	    ptr = NIL(char);
	}
    }

    /* confirm boxes */

    app_resources.confirmMode = 0;

    if (app_resources.confirm != NIL(char)) {
	char *ptr, *token;

	ptr = app_resources.confirm;
	while ((token = strtok(ptr, ", \t\n")) != NIL(char)) {
	    if (strcmp(token, "ngQuit") == 0) {
		app_resources.confirmMode |= NG_QUIT;
	    } else if (strcmp(token, "ngExit") == 0) {
		app_resources.confirmMode |= NG_EXIT;
	    } else if (strcmp(token, "ngCatchUp") == 0) {
		app_resources.confirmMode |= NG_CATCHUP;
	    } else if (strcmp(token, "artCatchUp") == 0) {
		app_resources.confirmMode |= ART_CATCHUP;
	    } else if (strcmp(token, "artFedUp") == 0) {
		app_resources.confirmMode |= ART_FEDUP;
	    } else if (strcmp(token, "ngUnsub") == 0) {
		app_resources.confirmMode |= NG_UNSUBSCRIBE;
	    } else if (strcmp(token, "artUnsub") == 0) {
		app_resources.confirmMode |= ART_UNSUBSCRIBE;
	    } else {
		mesgPane(XRN_SERIOUS, "unknown confirm button: %s", token);
	    }
	    ptr = NIL(char);
	}
    }

    /* temporary directory */

    if (app_resources.tmpDir == NIL(char)) {
	char *ptr = getenv("TMPDIR");

	if (ptr == NIL(char)) {
	    /* 
	     * XXX added to deal with a possible compiler problem on
	     * the IBM RT running AOS using the hc2.1s compiler
	     * (reported by Jay Ford <jnford@jay.weeg.uiowa.edu>).
	     */
	    char *tmp_ptr = TEMPORARY_DIRECTORY;
	    app_resources.tmpDir = XtNewString(tmp_ptr);
	} else {
	    app_resources.tmpDir = XtNewString(ptr);
	}
    }

    app_resources.tmpDir = XtNewString(utTildeExpand(app_resources.tmpDir));

    /* line breaking */
    if (app_resources.editorCommand != NIL(char)) {
	app_resources.breakLength = 0;
	app_resources.lineLength = 0;
    }

    return widget;
}

