
/* Bob Ellison <ellison@sei.cmu.edu> */

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifdef SYSV
#include <fcntl.h>
#else
#include <sys/file.h>
#endif
#include <errno.h>
#include "utils.h"
#include "xrn.h"
#include "dialogs.h"
#include "mesg.h"
#include "resources.h"

extern char *strpbrk();

#ifndef S_ISDIR
#define S_ISDIR(mode) (((mode) & S_IFMT) == S_IFDIR)
#endif


/* replacement for MH routine */
static char * m_find(p)
char *p;
{
    FILE *F;
    char *home, *mhprofile;
    char fullname [100];
    static char buf[512];
    char *q,*s;
    char *getenv();
    char *index();

    mhprofile = getenv("MH");
    if (!mhprofile) {
	home = getenv("HOME");
	if (!home) {
	    return 0;
	}
	(void) sprintf(fullname, "%s/.mh_profile", home);
    }
    else	/* either an absolute pathname, or relative to current dir */
	(void) strcpy(fullname, mhprofile);

    F = fopen(fullname, "r");
    if(F == NULL) {
	return 0;
    }
    while (fgets(buf, 512, F) != NULL) {
	q = index(buf,':');
        if(q != 0) {
	    *q = '\0';
	    s = ++q;
	    if (strcasecmp(buf, p) == 0) {
	        q += strspn(q," \t");
	        s = strpbrk(q," \n\t");
	        if(s) {
		    *s = '\0';
		}
	        (void) fclose(F);
	        return q;
	    }
        }
    }
    (void) fclose(F);
    return 0;
}


int refile(folder, artfile)
char *folder;
char *artfile;
{
    char *p,*q;
    char  *userpath;
    char *getenv();
    char *m_find();
    char tmp[512];
    char fullpath[512];
    char fullpath2[512];
    char newfolders[512];
    char msg[512];
    struct stat st;
    extern int errno;

   
    p = getenv("HOME");
    if(p == 0) {
	return 0;
    }
    userpath = m_find("path");
    if(userpath == 0) {
	(void) strcpy(fullpath, p);
    } else if (userpath[0] == '/') {
	(void) strcpy(fullpath, userpath);
    } else {
	if (userpath[0] == '/')
	    (void) strcpy(fullpath, userpath);
	else
	    (void) sprintf(fullpath, "%s/%s", p, userpath);
    }
    if((stat(fullpath,&st) == -1) || !S_ISDIR(st.st_mode)) {
	mesgPane(XRN_SERIOUS, "No Mail directory `%s'", fullpath);      
	return 0;
    }
    (void) sprintf(fullpath2, "%s/%s", fullpath, (folder+1));
    if (stat(fullpath2,&st) == -1 && errno == ENOENT) {
	(void) sprintf(msg,"No such folder - %s - Create it?",fullpath2);
	if (ConfirmationBox(TopLevel, msg)  == XRN_CB_ABORT) {
	    return 0;
	}
	(void) strcpy(newfolders, (folder+1));
	q = strtok(newfolders, "/");
	while (q) {
	    (void) strcat(fullpath, "/");
	    (void) strcat(fullpath, q);
	    if(stat(fullpath, &st) == -1) {
	        if(errno == ENOENT){
		    mkdir(fullpath, 0777);
	        } else {
		    mesgPane(XRN_SERIOUS, 
		      "Can not create folder `%s. Errno: %d'", fullpath, errno);
		    return 0;
	        }
	     } else if (!S_ISDIR(st.st_mode)) {
	        mesgPane(XRN_SERIOUS, 
	 	    "Can not create folder.  Not a directory `%s'", fullpath);
	        return 0;
	    }
	    q = strtok(0, "/");
        }
    } else if (!S_ISDIR(st.st_mode)) {
        mesgPane(XRN_SERIOUS, "Not a folder %s'", fullpath2);
        return 0;
    }
    if (stat(artfile, &st) == -1) {
        return 0;
    }

    if (app_resources.mhPath)
	(void) sprintf(tmp, "%s/refile -f %s %s", app_resources.mhPath,
		       artfile, folder);
    else
	(void) sprintf(tmp, "refile -f %s %s", artfile, folder);

    (void) system(tmp);
    return 1;
}

