/*----------------------------------------------------------------------*
 * Bounds Checking for GCC.						*
 * Copyright (C) 1995 Richard W.M. Jones <rwmj@doc.ic.ac.uk>.		*
 *----------------------------------------------------------------------*
 * This program is free software; you can redistribute it and/or modify	*
 * it under the terms of the GNU General Public License as published by	*
 * the Free Software Foundation; either version 2 of the License, or	*
 * (at your option) any later version.					*
 *									*
 * This program is distributed in the hope that it will be useful,	*
 * but WITHOUT ANY WARRANTY; without even the implied warranty of	*
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	*
 * GNU General Public License for more details.				*
 *									*
 * You should have received a copy of the GNU General Public License	*
 * along with this program; if not, write to the Free Software		*
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		*
 *----------------------------------------------------------------------*
 * File:
 *	lib/alloca.h
 * Summary:
 *	Header file for `alloca' library. If you compile (as recommended)
 *	with -fno-builtin, you will get this implementation of a checked
 *	alloca, with optional checks for stale pointers and so forth.
 * Other notes:
 *	
 * Author      	Date		Notes
 * RWMJ		31/3/95		Initial implementation.
 *----------------------------------------------------------------------*/

#ifndef _ALLOCA_H_
#define _ALLOCA_H_

typedef struct alloca_item {
  struct alloca_item *next;			/* Linked list. */
  void *pointer;				/* Allocation address. */
  size_t size;					/* Size of allocation. */
} alloca_item;

#endif /* _ALLOCA_H_ */
