/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.0/rpc/sources/RCS/kom_broadcast.h,v $
  SHORTNAME      : kom_broadcast
  SNNS VERSION   : 4.0

  PURPOSE        : 
  NOTES          :

  AUTHOR         : Sven Doering
  DATE           : 

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.3 $
  LAST CHANGE    : $Date: 1995/04/21 14:19:11 $

             (c) 1994 by Sven Doering and the SNNS-Group

******************************************************************************/

#ifndef _KOM_BROADCAST_DEFINED_
#define _KOM_BROADCAST_DEFINED_

#define MAX_BROADCAST_SIZE 7168

#define KOM_NOT_SEND 0
#define KOM_SEND     1
#define KOM_RCV      2

typedef struct {
	long 	pakets_recv;   /* the aktual number of Pakets received  */
	long 	last_paket_no; /* the number of the last received Paket */
	u_long  *paket_no;     /* the number of the pakets */
	int 	*status;       /* an Array with the status of the messages */
} send_control;

typedef struct {
	long	prognumber;
	long	versnumber;
	char    inet_addr[16];
} send_define_target;

typedef struct {
	long 	procnumber;
	xdrproc_t xdr_code;	
	xdrproc_t xdr_decode;
	caddr_t	msg_p;
	caddr_t res_p;
} send_define_msg;


typedef bool_t (*result_proc)(int msgNo,caddr_t res);

extern enum clnt_stat kom_clnt_broadcast(u_long prog, u_long vers, u_long proc, xdrproc_t xargs, caddr_t argsp);


extern enum clnt_stat kom_res_broadcast(int noOfTargets, send_define_target *targets, int noOfMsg, send_define_msg *messages, struct timeval timeout, struct timeval retry_timeout,send_control **status,result_proc res_proc);

#endif 





