      SUBROUTINE COMPIL (MAXSP,MAXEQ,MAXEL,MAXENT,NIW1,NIW2,             
     &                   IW1,IW2,LR,PLS,PRS,CW,NCW,KFLAG)                
C                                                                        
C*********************************************************************** 
C                                                                      * 
C DATE OF LATEST CHANGE: MARCH 1, '86                                  * 
C                                                                      * 
C*********************************************************************** 
C                                                                      * 
C  COMPIL IS AN INTERFACE ROUTINE FOR THE CHEMICAL COMPILER CHECOM     * 
C  (FOR DESCRIPTION OF PARAMETER LIST SEE SUBROUTINE CHECOM)           * 
C                                                                      * 
C*********************************************************************** 
C                                                                        
C                                                                        
CI4       INTEGER IW1(NIW1),IW2(NIW2),LR(MAXENT),PLS(MAXEQ),PRS(MAXEQ)   
      INTEGER*2 IW1(NIW1),IW2(NIW2),LR(MAXENT),PLS(MAXEQ),PRS(MAXEQ)     
      INTEGER IFIX,PLIST(10),ELEML,PP1,I,IH,MAXDG,MH,NAMEL,NIWH          
      CHARACTER*1 CW(NCW)                                                
C                                                                        
      REAL FLOAT                                                         
C                                                                        
      INTEGER          ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT  
      COMMON / LUNIT / ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT 
      SAVE /LUNIT/
C                                                                        
C                                                                        
C  DECLARATION OF A LIST OF PRIME NUMBERS FOR HASHING                    
      DATA PLIST(1)/43/ , PLIST(2)/97/ , PLIST(3)/151/ , PLIST(4)/223/ , 
     &   PLIST(5)/307/ , PLIST(6)/419/ , PLIST(7)/541/ , PLIST(8)/691/ , 
     &   PLIST(9)/907/ , PLIST(10)/1151/                                 
C                                                                        
C  DECLARATION OF MAXIMUM LENGTH OF SPECIES NAMES AND ELEMENT NAMES      
      DATA NAMEL/10/ , ELEML/5/                                          
C  NAMES LONGER THAN NAMEL/ELEML ARE TRUNCATED. POSSIBLE LOSS OF         
C  UNIQUENESS.                                                           
C  (IF ALTERED, THE ASSOCIATED FORMAT STATEMENTS AND ARRAY DECLARATIONS  
C   HAVE TO BE CHANGED ALSO (IN THE WHOLE PACKAGE))                      
C                                                                        
      IF(MAXSP.GE.1000) GOTO 20                                          
      IF(MAXEQ.GE.1000) GOTO 30                                          
      MAXDG=MAXSP+2                                                      
      MH=IFIX(FLOAT(MAXSP)*1.1)                                          
      I=1                                                                
10    IF(MH.LE.PLIST(I)) GOTO 12                                         
      I=I+1                                                              
      IF(I.LE.10) GOTO 10                                                
      GOTO 40                                                            
12    PP1=PLIST(I)+1                                                     
C                                                                        
C  CHECK FOR SUFFICIENT STORAGE                                          
      NIWH=NAMEL*MAXSP                                                   
      IF(360.GT.NIWH) NIWH=360                                           
      IF(NIWH.GT.NCW) GOTO 70                                            
      IF(NIWH.GT.NIW2) GOTO 60                                           
      MH=PP1+MAXDG+MAXSP*MAXEL                                           
      IF(MH.GT.NIW1) GOTO 50                                             
C                                                                        
C  REWIND IN-/OUTPUT FILES                                               
      REWIND SIN                                                         
      REWIND CIN                                                         
      REWIND HDS 
C                                                                        
      MH=MAXDG+PP1+1                                                     
C                                                                        
      CALL CHECOM (MAXDG,MAXSP,MAXEQ,MAXEL,MAXENT,NAMEL,ELEML,PP1,NIW2,  
     &     IW1(1),IW1(MAXDG+1),IW1(MH),IW2,LR,PLS,PRS,CW,NCW,KFLAG)      
C                                                                        
C  REWIND IN-/OUTPUT FILES                                                                  
      REWIND SIN                                                         
      REWIND CIN                                                         
      REWIND HDS                                                 
C                                                                        
      RETURN                                                             
C                                                                        
C  ERROR RETURN                                                          
C                                                                        
20    WRITE(ITOUT,9020)                                                  
      GOTO 100                                                           
30    WRITE(ITOUT,9030)                                                  
      GOTO 100                                                           
40    WRITE(ITOUT,9040)                                                  
      GOTO 100                                                           
50    I=MH-NIW1                                                          
      IH=360-NIWH                                                        
      IF(IH.GT.I) I=IH                                                   
      I=I+5                                                              
      WRITE(ITOUT,9050) I                                                
      GOTO 100                                                           
60    I=NIWH-NIW2                                                        
      WRITE(ITOUT,9060) I                                                
      GOTO 100                                                           
70    I=NIWH-NCW                                                         
      WRITE(ITOUT,9070) I                                                
C                                                                        
100   KFLAG=-1                                                           
      RETURN                                                             
C                                                                        
9020  FORMAT(//,' *** ERROR ***',/,' MAXSP GREATER THAN 1000')           
9030  FORMAT(//,' *** ERROR ***',/,' MAXEQ GREATER THAN 1000')           
9040  FORMAT(//,' *** ERROR ***',/,' LARGEST AVAILABLE PRIME',           
     &       ' NUMBER .LT. MAXSP*1.1')                                   
9050  FORMAT(//,' *** ERROR ***',/,' INTEGER WORK SPACE IW EXHAUSTED;'   
     &       ,/,I4,' STORAGE LOCATIONS MISSING',/)                       
9060  FORMAT(//,' *** ERROR ***',/,' INTEGER WORK SPACE IWP EXHAUST',    
     &       'ED;',/,I4,' STORAGE LOCATIONS MISSING',/)                  
9070  FORMAT(//,' *** ERROR ***',/,' CHARACTER WORK SPACE EXHAUSTED;'    
     &       ,/,I4,' STORAGE LOCATIONS MISSING',/)                       
C                                                                        
C----------------------------------------------------------------------- 
C                  END COMPILER INTERFACE                                
C----------------------------------------------------------------------- 
C                                                                        
      END                                                              
      SUBROUTINE CHECOM (MAXDG,MAXSP,MAXEQ,MAXEL,MAXENT,NAMEL,ELEML,PP1, 
     &                   NIW3,IW1,IW2,SPEL,IW3,LR,PLS,PRS,CW,ICW,KFLAG)                                           
C                                                                        
C*********************************************************************** 
C                                                                      * 
C DATE OF LATEST CHANGE: MARCH 1, '86                                  * 
C                                                                      * 
C*********************************************************************** 
C                                                                      * 
C  CHECOM PERFORMS THE INTERPRETATION (COMPILATION) OF CHEMICAL INPUT. * 
C  AN INPUT FILE 'CHEMIN' ( = LOGICAL UNIT CIN) CONSISTING OF THE      * 
C  FOLLOWING SUBBLOCKS (IN THIS ORDER) IS READ:                        * 
C     *HEAD                                                            * 
C     *MODEL                                                           * 
C     *ELEMENTS                                                        * 
C     *SPECIES                                                         * 
C     *NAME OF THIRD BODIES                                            * 
C     *UNIT SYSTEM                                                     * 
C     *TEMPERATURE                                                     * 
C     *PRESSURE                                                        * 
C     *DENSITY                                                         * 
C     *REACTION SYSTEM                                                 * 
C     *INITIAL CONCENTRATIONS                                          * 
C     *ENTHALPY COEFFICIENTS                                           * 
C     *NUMERICAL INPUT CARDS                                           * 
C     *DISCRETISATION METHOD                                           * 
C     *ACCURACY                                                        * 
C     *OUTPUT POINTS                                                   * 
C     *PRINT PARAMETER                                                 * 
C  INTERPRETATION OF THE INPUT WITH SEVERAL (SELF-EXPLANATING)         * 
C  ERROR CHECKS IS DONE. THE OUTPUT IS WRITTEN ON FILE 'INVAL'         * 
C  ( = LOGICAL UNIT SIN), WHICH IS USED AS SIMULATION INPUT BY         * 
C  SUBROUTINE SIMULA.                                                  * 
C                                                                      * 
C*********************************************************************** 
C                                                                      * 
C  INPUT PARAMETERS                                                    * 
C------------------                                                    * 
C                                                                      * 
C  MAXEQ:  MAXIMUM NUMBER OF CHEMICAL EQUATION                         * 
C          (REVERSIBLE EQUATIONS ARE COUNTED BY TWO)                   * 
C          (.LT.1000)                                                  * 
C                                                                      * 
C  MAXSP:  MAXIMUM NUMBER OF DIFFERENT CHEMICAL SPECIES                * 
C          (.LT.1000)                                                  * 
C                                                                      * 
C  MAXDG:  MAXIMUM NUMBER OF DIFFERENTIAL EQUATIONS ( = MAXSP + 2 )    * 
C                                                                      * 
C  MAXEL:  MAXIMUM NUMBER OF DIFFERENT CHEMICAL ELEMENTS               * 
C          (.LE.10)                                                    * 
C                                                                      * 
C  NAMEL:  MAXIMUM NUMBER OF SIGNIFICANT DIGITS FOR THE NAME OF        * 
C          A SPECIES (.LE.10)                                          * 
C                                                                      * 
C  ELEML:  MAXIMUM NUMBER OF SIGNIFICANT DIGITS FOR THE NAME OF        * 
C          AN ELEMENT (.LE.5)                                          * 
C                                                                      * 
C  PP1:    PRIME NUMBER + 1 (.GE. 1.1*MAXSP)                           * 
C                                                                      * 
C  NIW3:   DIMENSION OF WORK ARRAY IW3  (.GE.MAXSP*NAMEL)              * 
C                                                                      * 
C  MAXENT: DIMENSION OF WORK ARRAY LR  (.GE.4*MAXEQ)                   * 
C                                                                      * 
C  IW1,IW2,IW3,SPEL:  INTEGER WORK ARRAYS                              * 
C  CW : CHARACTER WORK ARRAY (CONTAINS SPECIES NAMES)                  * 
C  LR,PLS,PRS:  INTEGER WORK ARRAYS                                    * 
C                                                                      * 
C  KFLAG:  PRINT FLAG                                                  * 
C          = 0  ERROR MESSAGES                                         * 
C          = 1  ERROR MESSAGES AND WARNINGS                            * 
C          = 2  ERROR,WARNINGS AND COMPILER INPUT LISTING              * 
C                                                                      * 
C                                                                      * 
C  OUTPUT PARAMETERS                                                   * 
C-------------------                                                   * 
C                                                                      * 
C  KFLAG:  ERROR FLAG                                                  * 
C          = 0  SUCCESSFULL COMPILATION                                * 
C          =-1  COMPILATION ENDED DUE TO ERROR                         * 
C                                                                      * 
C                                                                      * 
C                                                                      * 
C  DIMENSIONING OF ARRAYS:                                             * 
C-------------------------                                             * 
C     INTEGER  IW1(MAXSP),IW2(PP1),IW3(NIW3),SPEL(MAXSP,MAXEL),        * 
C              LR(MAXENT),PLS(MAXEQ),PRS(MAXEQ)                        * 
C                                                                      * 
C                                                                      * 
C  THE FOLLOWING FILES ARE REQUIRED:                                   * 
C                                                                      * 
C  LOGICAL UNIT               FILE                                     * 
C                                                                      * 
C  FOR INPUT:                                                          * 
C      CIN                    CHEMICAL INPUT                           * 
C      THDAT                  THERMODYNAMICAL DATA (OPTIONAL), MAY BE  * 
C                             SET TO 'DUMMY' IF NOT USED               * 
C                                                                      * 
C  FOR OUTPUT:                                                         * 
C      ITOUT                  COMPILER MESSAGES                        * 
C      SIN                    COMPILER OUTPUT                          * 
C                             (USED AS SIMULATION INPUT)               * 
C      HDS                    TEMPORARY WORK FILE                      * 
C                                                                      * 
C                                                                      * 
C  SUBROUTINES USED (PROVIDED BY LARKIN)                               * 
C-------------------                                                   * 
C                                                                      * 
C      INUM                   CREATES AN INTEGER NUMBER FROM A GIVEN   * 
C                             STRING                                   * 
C      RNUM                   CREATES A REAL NUMBER FROM A GIVEN STRING* 
C      HASH                   PERFORMS INTERNAL CODING OF SPECIES,     * 
C                             USING 'HASHING - TECHNIQUES'             * 
C      GET                    READS POSSIBLE CONTINUATION CARDS, USED  * 
C                             ONLY IN INPUT-BLOCKS *NAME OF.... AND    * 
C                             *REAC.... .                              * 
C                                                                      * 
C*********************************************************************** 
C                                                                        
C                                                                        
      DOUBLE PRECISION ATWS(10),ECO(14),FJ(5),KINPAR(3)                  
CSP       REAL ATWS(10),ECO(14),FJ(5),KINPAR(3)                          
      DOUBLE PRECISION ATW,DENSY,EPS,FJSTOE,GAS1,GAS2,GASH1,GASH2        
CSP       REAL ATW,DENSY,EPS,FJSTOE,GAS1,GAS2,GASH1,GASH2                
      DOUBLE PRECISION GASH3,PRESS,RC,RHOH,RKTEST,RPATM                  
CSP       REAL GASH3,PRESS,RC,RHOH,RKTEST,RPATM                          
      DOUBLE PRECISION SUMC,SUMC0,T,U                                    
CSP       REAL SUMC,SUMC0,T,U                                            
      DOUBLE PRECISION TEMP,TENM3,TENM6,TM60,X,ZERO                      
CSP       REAL TEMP,TENM3,TENM6,TM60,X,ZERO                              
      DOUBLE PRECISION DBLE                                              
CSP       REAL FLOAT                                                     
C                                                                        
      INTEGER PP1,ELEML,MAXDG,NIW3,MAXSP,MAXEL,MAXENT,MAXEQ,ICW,NAMEL    
C                                                                        
CI4       INTEGER IW1(MAXDG),IW2(PP1),IW3(NIW3),SPEL(MAXSP,MAXEL)        
      INTEGER*2 IW1(MAXDG),IW2(PP1),IW3(NIW3),SPEL(MAXSP,MAXEL)          
CI4       INTEGER LR(MAXENT),PRS(MAXEQ),PLS(MAXEQ)                       
      INTEGER*2 LR(MAXENT),PRS(MAXEQ),PLS(MAXEQ)                         
C                                                                        
CI4       INTEGER IBAL(10),IN(10),ICOMPO(5),ICOTST(5)                    
      INTEGER*2 IBAL(10),IN(10),ICOMPO(5),ICOTST(5)                      
CI4       INTEGER LENCO(5)                                               
      INTEGER*2 LENCO(5)                                                 
      INTEGER I, IAI, IAI1, IC01, ICC, ICCA, ICEQ, ICO, ICO4, ICOLLI,    
     & ICOM, IDISC, IEL, IFORM1, IFORM2, IGAS, IH, IH1, IH2, IK, IKIN, IL,   
     & IL1, IL2, ILH, INDEX, INUMB, IP7, IPEL, IPRINT, IR2, ISP, ISPOLD, 
     & ISUM, ITB, ITP, IVAL, IZ, J, J1, J2, JCEQ, JJ, JSTOE, K, KFLAG,   
     & KFRAC, KL, KPR1, KPRINT, KSTOE, L, L1, L2, LENGTH, LH, LH1, LH2,  
     & LRI, LTB1, LTB2, M, MODEL, N, N1, NA, NCEQ, NLR, NLTB, NMSP,      
     & NNZ, NSP, NSP1, NSPJ, NTB, NTBH, NUM5                             
      REAL TEN                                                           
C                                                                        
      CHARACTER*8 ERR1,ERR2                                              
      CHARACTER*1 CW(ICW),ELEM(10,5),LQ(80),KEY(80),SIG(80),CN(10)       
      CHARACTER*1 CHAR,CHAR1,CHAR2,BLANK,PLUS,GREAT,LESS,EQUAL,ERR       
      CHARACTER*1 PARL,PARR,COMMA,STAR,AA,CC,DD,EE,GG,II,MM,NN,OO,PP     
      CHARACTER*1 RR,SS,TT,UU,NAMETB(50)                                 
C                                                                        
CI4       INTEGER PL,PR                                                  
      INTEGER*2 PL,PR                                                    
C                                                                        
      LOGICAL PRM1,PRM2,OVERFL,SPLIST,REV,BN,COTEST,LMOD                 
      LOGICAL STORE,LDTST,LTHERM,LSTOI                                   
C                                                                        
      INTEGER          ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT  
      COMMON / LUNIT / ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT  
C                                                                        
      INTEGER ICOUNT                                                     
      COMMON / CCC / ICOUNT  
      SAVE /LUNIT/, /CCC/
C  DECLARATION OF CHARACTER CONSTANTS                                    
      DATA BLANK/' '/, PLUS/'+'/, GREAT/'>'/, LESS/'<'/,                 
     &     EQUAL/'='/, PARL/'('/, PARR/')'/, COMMA/','/, STAR/'*'/,      
     &     ERR/'$'/ , AA/'A'/ , CC/'C'/ , EE/'E'/ , UU/'U'/ , II/'I'/,   
     &     NN/'N'/ , OO/'O'/ , PP/'P'/ , RR/'R'/ , SS/'S'/ , TT/'T'/ ,   
     &     ERR1/' *** ERR'/ , ERR2/'OR *** '/ , MM/'M'/ , DD/'D'/        
C                                                                        
C  DEFINE CONSTANTS                                                      
      DATA GASH1/8.314D0/ , GASH2/82.05D0/ , GASH3/1.9865D0/             
CSP       DATA GASH1/8.314E0/ , GASH2/82.05E0/ , GASH3/1.9865E0/         
      DATA FJ(2)/2.D0/ , FJ(3)/3.D0/ , FJ(4)/4.D0/ , FJ(5)/5.D0/         
CSP       DATA FJ(2)/2./ , FJ(3)/3./ , FJ(4)/4./ , FJ(5)/5./             
      DATA ZERO/0.D0/ , RKTEST/-1.D+31/ , TENM6/1.D-6/                   
CSP       DATA ZERO/0./ , RKTEST/-1.E+31/ , TENM6/1.E-6/                 
      DATA TEN/1.D1/ , TENM3/1.D-3/ , TM60/1.D-60/                       
CSP       DATA TEN/1.E1/ , TENM3/1.E-3/ , TM60/1.E-60/                   
C                                                                        
      KPRINT=KFLAG                                                       
      KFLAG=0                                                            
      LSTOI=.FALSE.                                                      
      PRM1=.FALSE.                                                       
      PRM2=.FALSE.                                                       
      LTHERM=.FALSE.                                                     
      IF(KPRINT.GE.1) PRM1=.TRUE.                                        
      IF(KPRINT.GE.2) PRM2=.TRUE.                                        
      IF(PRM1) LSTOI=.TRUE.                                              
      MOUT=ITOUT                                                         
      WRITE(ITOUT,9998)                                                  
      NA=NAMEL*MAXSP                                                     
      NLTB=ELEML*NAMEL                                                   
      ICOUNT=0                                                           
C                                                                        
C---------------------------------------------------------------------   
C  READ AND PUSH HEAD                                                    
C  SYNTAX:  HEAD ::= LINE                                                
C---------------------------------------------------------------------   
C                                                                        
      READ(CIN,9000)                                                     
      ICOUNT=ICOUNT+1                                                    
      L1=1                                                               
10    L2=L1+71                                                           
11    READ(CIN,9000,END=11029) (CW(L),L=L1,L2)                           
      ICOUNT=ICOUNT+1                                                    
      IF(CW(L1).EQ.STAR) GOTO 12                                         
      L1=L2+1                                                            
      IF(L1.LE.361) GOTO 10                                              
      GOTO 10031                                                         
12    IF(CW(L1+1).EQ.CC) GOTO 11                                         
      IF(CW(L1+1).NE.MM) GOTO 11029                                      
      L2=L2-72                                                           
      L1=L2/72                                                           
      WRITE(SIN,9005) L1                                                 
      IF(PRM2) WRITE(MOUT,8000)                                          
      IF(L2.EQ.0) GOTO 20                                                
      WRITE(SIN,9000) (CW(L),L=1,L2)                                     
      IF(PRM2) WRITE(MOUT,8002) (CW(L),L=1,L2)                           
C                                                                        
C---------------------------------------------------------------------   
C  READ/PUSH MODEL-PARAMETER                                             
C---------------------------------------------------------------------   
20    READ(CIN,9000,END=11025) (CW(L),L=1,72)                            
      ICOUNT=ICOUNT+1                                                    
      IF(CW(1).EQ.STAR) GOTO 11031                                       
      IF(PRM2) WRITE(MOUT,8015) (CW(L),L=1,72)                           
      CALL INUM (CW,1,72,MODEL,KFLAG)                                    
      IF(KFLAG.NE.0) GOTO 10025                                          
      READ(CIN,9000,END=11025) (CW(L),L=1,72)                            
      ICOUNT=ICOUNT+1                                                    
      IF(CW(2).NE.EE) GOTO 11025                                         
      WRITE(SIN,9006) MODEL                                              
      IF(MODEL.GT.2) LTHERM=.TRUE.                                       
C                                                                        
C  INITIALIZE ARRAYS                                                     
      DO 21 L=1,PP1                                                      
21    IW2(L)=0                                                           
      DO 22 L=1,NA                                                       
22    CW(L)=BLANK                                                        
      DO 23 L=1,MAXEL                                                    
      ATWS(L)=ZERO                                                       
      DO 23 I=1,ELEML                                                    
23    ELEM(L,I)=BLANK                                                    
C                                                                        
C----------------------------------------------------------------------- 
C  READ AND ANALYSE ELEMENT CARDS                                        
C  SYNTAX: ELEMENT CARD ::= ELEMENT ! ELEMENT WEIGHT                     
C               ELEMENT ::= SEQUENCE OF ALPHANUMERIC DIGITS              
C                 (.LE.ELEML DIGITS; 1.DIGIT MUST NOT BE:'(','*' OR 'Q') 
C                WEIGHT ::= REAL NUMBER                                  
C----------------------------------------------------------------------- 
C                                                                        
      IEL=0                                                              
      IF(PRM2) WRITE(MOUT,8004)                                          
30    READ(CIN,9000,END=11017) (LQ(L),L=1,72)                            
      ICOUNT=ICOUNT+1                                                    
      IF(LQ(1).NE.STAR) GOTO 31                                          
      IF(LQ(2).EQ.SS) GOTO 40                                            
      IF(LQ(2).EQ.CC) GOTO 30                                            
      IF(PRM1) WRITE(ITOUT,20002) (LQ(L),L=1,72)                         
      GOTO 30                                                            
31    J=0                                                                
      IF(PRM2) WRITE(MOUT,8002) (LQ(L),L=1,72)                           
32    J=J+1                                                              
      IF(J.GT.72) GOTO 30                                                
      IF(LQ(J).EQ.BLANK) GOTO 32                                         
      L=0                                                                
33    L=L+1                                                              
      KEY(L)=LQ(J)                                                       
      J=J+1                                                              
      IF(LQ(J).NE.BLANK) GOTO 33                                         
      IF(L.LE.ELEML) GOTO 34                                             
      IF(PRM1) WRITE(ITOUT,20003) ELEML,(KEY(I),I=1,ELEML)               
      L=ELEML                                                            
34    IEL=IEL+1                                                          
      IF(IEL.GT.MAXEL) GOTO 10013                                        
      DO 35 I=1,L                                                        
35    ELEM(IEL,I)=KEY(I)                                                 
      CALL RNUM (LQ,J,72,X,KFLAG)                                        
      IF(KFLAG.LT.0) GOTO 10033                                          
      ATWS(IEL)=X                                                        
      GOTO 30                                                            
C                                                                        
40    IF(IEL.GT.0) GOTO 41                                               
      IF(PRM1) WRITE(ITOUT,20001)                                        
      GOTO 50                                                            
41    DO 42 L=1,MAXEL                                                    
      DO 42 I=1,MAXSP                                                    
42    SPEL(I,L)=0                                                        
C                                                                        
50    ISP=0                                                              
      OVERFL=.FALSE.                                                     
      SPLIST=.TRUE.                                                      
      STORE=.TRUE.                                                       
      IF(PRM2) WRITE(MOUT,8006)                                          
C                                                                        
C----------------------------------------------------------------------- 
C READ AND ANALYSE SPECIES LIST                                          
C SYNTAX: SPECIES CARD ::= SPECIES ! SPECIES INTEGER ELEMENT INT. EL. .. 
C     SPECIES ::= SEQUENCE OF ALPHANUMERIC DIGITS                        
C                 (.LE.NAMEL DIGITS; 1.DIGIT MUST NOT BE:'(','*' OR 'Q') 
C     INTEGER ::= INTEGER NUMBER                                         
C     ELEMENT ::= ANY ELEMENT OF THE ELEMENT LIST                        
C----------------------------------------------------------------------- 
C                                                                        
51    READ(CIN,9000,END=11033) (LQ(L),L=1,72)                            
      ICOUNT=ICOUNT+1                                                    
      IF(LQ(1).NE.STAR) GOTO 52                                          
      IF(LQ(2).EQ.NN) GOTO 70                                            
      IF(LQ(2).EQ.CC) GOTO 51                                            
      IF(PRM1) WRITE(ITOUT,20002) (LQ(L),L=1,72)                         
      GOTO 51                                                            
52    J=0                                                                
      IF(PRM2) WRITE(MOUT,8002) (LQ(L),L=1,72)                           
      ISPOLD=ISP                                                         
53    J=J+1                                                              
      IF(J.GT.72) GOTO 51                                                
      IF(LQ(J).EQ.BLANK) GOTO 53                                         
      L=0                                                                
54    L=L+1                                                              
      KEY(L)=LQ(J)                                                       
      J=J+1                                                              
      IF(LQ(J).NE.BLANK) GOTO 54                                         
      CALL HASH (OVERFL,SPLIST,KEY,L,ISP,INDEX,PP1,MAXSP,NAMEL,NA,       
     &           IW1,IW2,CW,PRM1,STORE)                                  
      IF(ISPOLD.EQ.ISP.AND.PRM1) WRITE(ITOUT,20006) (KEY(I),I=1,L)       
      IF(OVERFL) GOTO 999                                                
C  ANALYSE SPECIES COMPOSITION (IF ELEMENT CARDS GIVEN)                  
      IF(IEL.EQ.0) GOTO 51                                               
60    J=J+1                                                              
      IF(J.GE.72) GOTO 51                                                
      IF(LQ(J).EQ.BLANK) GOTO 60                                         
      L=0                                                                
61    L=L+1                                                              
      KEY(L)=LQ(J)                                                       
      J=J+1                                                              
      IF(J.GE.72.AND.PRM1) WRITE(ITOUT,20004) (LQ(I),I=1,72)             
      IF(LQ(J).NE.BLANK) GOTO 61                                         
      KEY(L+1)=BLANK                                                     
      IF(L.LT.ELEML) L=L+1                                               
      IF(L.GT.ELEML) L=ELEML                                             
C  COMPARE ELEMENT                                                       
      DO 63 I=1,IEL                                                      
      IH=I                                                               
      DO 62 K=1,L                                                        
      IF(KEY(K).NE.ELEM(I,K)) GOTO 63                                    
62    CONTINUE                                                           
      GOTO 64                                                            
63    CONTINUE                                                           
      GOTO 10035                                                         
64    J=J+1                                                              
      IF(J.GE.72.AND.PRM1) WRITE(ITOUT,20004) (LQ(I),I=1,72)             
      IF(LQ(J).EQ.BLANK) GOTO 64                                         
      J1=J                                                               
65    J=J+1                                                              
      IF(J.GE.72.AND.PRM1) WRITE(ITOUT,20004) (LQ(I),I=1,72)             
      IF(LQ(J).NE.BLANK) GOTO 65                                         
      CALL INUM (LQ,J1,J,IVAL,KFLAG)                                     
      IF(KFLAG.NE.0.AND.PRM1) WRITE(ITOUT,20004) (LQ(I),I=1,72)          
      SPEL(ISP,IH)=IVAL                                                  
      GOTO 60                                                                                              
C                                                                        
C----------------------------------------------------------------------- 
C  READ AND ANALYSE COMPOSITION OF THIRD - BODIES                        
C  SYNTAX : TB ::= TB ! TB = EFFC SPECIES + ... + EFFC SPECIES           
C                  TB      ::= NAME OF THIRD BODY                        
C                  EFFC    ::= EFFICIENCY (REAL NUMBER)                  
C                  SPECIES ::= SPECIES NAME                              
C  IF ONLY TB IS GIVEN, TB IS ASSUMED TO BE SUM OF ALL (KINETIC AND      
C  INERT) SPECIES (EFFC=1.)                                              
C----------------------------------------------------------------------- 
C                                                                 
70    NTB=0                                                              
      DO 85 I=1,ELEML                                                    
85    ICOMPO(I)=0                                                        
      IF(PRM2) WRITE(MOUT,8019)                                          
      LENGTH=72                                                          
      DO 74 I=1,NLTB                                                     
74    NAMETB(I)=BLANK                                                    
71    READ(CIN,9000,END=11027) (LQ(L),L=1,LENGTH)                        
      ICOUNT=ICOUNT+1                                                    
      IF(LQ(1).NE.STAR) GOTO 75                                          
      IF(LQ(2).EQ.UU) GOTO 90                                            
      IF(LQ(2).EQ.CC) GOTO 71                                            
      IF(PRM1) WRITE(ITOUT,20002) (LQ(L),L=1,72)                         
      GOTO 71                                                            
75    NTB=NTB+1                                                          
      IF(NTB.GT.ELEML) GOTO 10011                                        
      J=0                                                                
      IF(PRM2) WRITE(MOUT,8002) (LQ(L),L=1,LENGTH)                       
76    J=J+1                                                              
      IF(LQ(J).EQ.BLANK) GOTO 76                                         
C  READ/PUSH NAME OF THIRD BODY                                          
      L=0                                                                
77    L=L+1                                                              
      IF(L.LE.10) GOTO 73                                                
      WRITE(MOUT,20024)                                                  
      L=L-1                                                              
      GOTO 72                                                            
73    LH=(NTB-1)*10 + L                                                  
      NAMETB(LH)=LQ(J)                                                   
      J=J+1                                                              
      IF(LQ(J).NE.BLANK) GOTO 77                                         
72    LENCO(NTB)=L                                                       
      L1=(NTB-1)*10 + 1                                                  
      L2=NTB*10                                                          
      WRITE(HDS,9026) (NAMETB(L),L=L1,L2)                                
C  SEARCH FOR '=' - SIGN                                                 
78    J=J+1                                                              
      IF(J.GT.LENGTH) ICOMPO(NTB)=-1                                     
      IF(J.GT.LENGTH) GOTO 71                                            
      IF(LQ(J).EQ.BLANK) GOTO 78                                         
      IF(LQ(J).NE.EQUAL) GOTO 10069                                      
C  ANALYSE EFFICIENCY (REAL NUMBER)                                      
79    J=J+1                                                              
      IF(J.GT.LENGTH) CALL GET (LQ,J,SIG,EQUAL,*10079,*11039,KPRINT)     
      IF(LQ(J).EQ.BLANK) GOTO 79                                         
      L=0                                                                
80    L=L+1                                                              
      KEY(L)=LQ(J)                                                       
      J=J+1                                                              
      IF(J.GT.LENGTH) CALL GET (LQ,J,SIG,EQUAL,*10079,*11039,KPRINT)     
      IF(LQ(J).NE.BLANK) GOTO 80                                         
      CALL RNUM (KEY,1,L,X,KFLAG)                                        
      IF(KFLAG.LT.0) GOTO 999                                            
C  ANALYSE SPECIES-NAME IN DEFINITION OF THIRD BODY                      
81    J=J+1                                                              
      IF(J.GT.LENGTH) CALL GET (LQ,J,SIG,EQUAL,*10079,*11039,KPRINT)     
      IF(LQ(J).EQ.BLANK) GOTO 81                                         
      L=0                                                                
82    L=L+1                                                              
      KEY(L)=LQ(J)                                                       
      J=J+1                                                              
      IF(LQ(J).NE.BLANK) GOTO 82                                         
      ISPOLD=ISP                                                         
      CALL HASH (OVERFL,SPLIST,KEY,L,ISP,INDEX,PP1,MAXSP,NAMEL,NA,       
     &           IW1,IW2,CW,PRM1,STORE)                                  
      IF(ISP.GT.ISPOLD.AND.PRM1) WRITE(MOUT,20025) (KEY(I),I=1,L)        
      IF(ISP.GT.ISPOLD) LSTOI=.FALSE.                                    
      IF(OVERFL) GOTO 999                                                
C  PUSH INDEX/EFFFICIENCY                                                
      WRITE(HDS,9027) INDEX,X                                            
      ICOM=ICOMPO(NTB) + 1                                               
      ICOMPO(NTB)=ICOM                                                   
C  SEARCH FOR '+' - SIGN                                                 
83    J=J+1                                                              
      IF(J.GT.LENGTH) GOTO 71                                            
      IF(LQ(J).EQ.BLANK) GOTO 83                                         
      IF(LQ(J).NE.PLUS) GOTO 10069                                       
      GOTO 79                                                            
C                                                                        
90    J=0                                                                
      DO 401 I=1,ELEML                                                   
      IF(ICOMPO(I).LT.0) J=J+1                                           
401   IF(J.GT.1) GOTO 10027                                                                       
C                                                                                                                                                                
C----------------------------------------------------------------------- 
C  ANALYSE UNIT SYSTEM                                                   
C----------------------------------------------------------------------- 
C                                                                        
C  SET DEFAULT VALUE                                                     
      IGAS=1                                                             
C                                                                        
      IF(PRM2) WRITE(MOUT,8017)                                          
      READ(CIN,9000,END=11001) (KEY(L),L=1,72)                           
      ICOUNT=ICOUNT+1                                                    
      IF(KEY(1).EQ.STAR) GOTO 630                                        
C READ UNIT SYSTEM PARAMETER                                             
      CALL INUM (KEY,1,72,IGAS,KFLAG)                                    
      IF(KFLAG.NE.0) GOTO 10009                                          
      READ(CIN,9000,END=11999) CHAR1,CHAR2                               
      ICOUNT=ICOUNT+1                                                    
      IF(CHAR1.NE.STAR .OR. CHAR2.NE.TT) GOTO 11001                      
630   GOTO (631,632,633,634,635,636,635), IGAS                           
      GOTO 10009                                                         
631   GAS1=GASH1                                                         
      GAS2=GASH1                                                         
      RC=GASH2*TENM6                                                     
      GOTO 639                                                           
632   GAS1=GASH1                                                         
      GAS2=GASH1*TENM3                                                   
      RC=GASH2*TENM6                                                     
      GOTO 639                                                           
633   GAS1=GASH2                                                         
      GAS2=GASH1                                                         
      RC=GASH2                                                           
      GOTO 639                                                           
634   GAS1=GASH2                                                         
      GAS2=GASH1*TENM3                                                   
      RC=GASH2                                                           
      GOTO 639                                                           
635   GAS1=GASH3                                                         
      GAS2=GASH3                                                         
      RC=GASH2*TENM3                                                     
      GOTO 639                                                           
636   GAS1=GASH3                                                         
      GAS2=GASH3*TENM3                                                   
      RC=GASH2*TENM3                                                     
      GOTO 639                                                           
639   RPATM=DLOG(RC)                                                     
CSP 639   RPATM=ALOG(RC)                                                 
      IF(PRM2) WRITE(MOUT,8034) IGAS                                     
      IF(PRM2) WRITE(MOUT,8035) GAS1,GAS2                                
C                                                                        
C----------------------------------------------------------------------- 
C  ANALYSE TEMPERATURE                                                   
C----------------------------------------------------------------------- 
C                                                                        
      TEMP=ZERO                                                          
      READ(CIN,9000,END=11035) (KEY(L),L=1,72)                           
      ICOUNT=ICOUNT+1                                                    
      IF(KEY(1).EQ.STAR) GOTO 603                                        
      IF(PRM2) WRITE(MOUT,8016) (KEY(L),L=1,72)                          
      CALL RNUM (KEY,1,72,TEMP,KFLAG)                                    
      IF(KFLAG.NE.0) GOTO 10007                                          
      IF(TEMP.LT.ZERO) GOTO 10007                                        
      READ(CIN,9000,END=11999) (KEY(L),L=1,72)                           
      ICOUNT=ICOUNT+1                                                    
603   IF(KEY(1).NE.STAR .OR. KEY(2).NE.PP) GOTO 11035                    
      IF(TEMP.EQ.ZERO .AND. MODEL.GT.1) GOTO 10061                       
C                                                                        
C----------------------------------------------------------------------- 
C  ANALYSE PRESSURE                                                      
C----------------------------------------------------------------------- 
C                                                                        
C  READ PRESSURE                                                         
      PRESS=ZERO                                                         
      READ(CIN,9000,END=11019) (KEY(L),L=1,72)                           
      ICOUNT=ICOUNT+1                                                    
      CHAR1=KEY(1)                                                       
      CHAR2=KEY(2)                                                       
      IF(KEY(1).EQ.STAR) GOTO 610                                        
      IF(PRM2) WRITE(MOUT,8014) (KEY(L),L=1,72)                          
      CALL RNUM(KEY,1,72,PRESS,KFLAG)                                    
      IF(KFLAG.NE.0) GOTO 10003                                          
      IF(PRESS.LT.ZERO) GOTO 10003                                       
      READ(CIN,9000,END=11999) CHAR1,CHAR2                               
      ICOUNT=ICOUNT+1                                                    
610   IF(CHAR1.NE.STAR .OR. CHAR2.NE.DD) GOTO 11019                      
      SUMC0=ZERO                                                         
      IF(TEMP.NE.ZERO) SUMC0=PRESS/(GAS1*TEMP)                           
C                                                                        
C----------------------------------------------------------------------- 
C  ANALYSE (OPTIONAL) DENSITY                                            
C----------------------------------------------------------------------- 
C                                                                        
      DENSY=ZERO                                                         
      READ(CIN,9000,END=11023) (KEY(L),L=1,72)                           
      ICOUNT=ICOUNT+1                                                    
      CHAR1=KEY(1)                                                       
      CHAR2=KEY(2)                                                       
      IF(KEY(1).EQ.STAR) GOTO 620                                        
      IF(PRM2) WRITE(MOUT,8013) (KEY(L),L=1,72)                          
      CALL RNUM(KEY,1,72,DENSY,KFLAG)                                    
      IF(KFLAG.NE.0) GOTO 10029                                          
      IF(DENSY.LT.ZERO) GOTO 10029                                       
      READ(CIN,9000,END=11999) (KEY(L),L=1,72)                           
      ICOUNT=ICOUNT+1                                                    
620   IF(KEY(1).NE.STAR .OR. KEY(2).NE.RR) GOTO 11027                                                                                                                                                                                                                                                                                   C                                                                        
C----------------------------------------------------------------------- 
C  ANALYSE CHEMICAL SYSTEM                                               
C  SYNTAX:  CHEQ ::= RTERM RSYMBL RTERM KINPAR                           
C----------------------------------------------------------------------- 
C                                                                        
C  ANALYSE CHEMICAL SYSTEM                                               
      ICEQ=0                                                             
      DO 99 I=1,5                                                        
99    ICOTST(I)=0                                                        
      NSP=ISP                                                            
      LENGTH=72                                                          
      LRI=1                                                              
      IR2=0                                                              
      SPLIST=.FALSE.                                                     
      REV=.FALSE.                                                        
      IF(PRM2) WRITE(MOUT,8008)                                          
C                                                                        
C  READ NEXT INPUT LINE                                                  
101   READ(CIN,9000,END=11015) (LQ(L),L=1,72)                            
      ICOUNT=ICOUNT+1                                                    
      PL=LRI                                                             
      JSTOE=0                                                            
      LENGTH=72                                                          
      IF(LQ(1).NE.STAR) GOTO 102                                         
      IF(LQ(2).EQ.II) GOTO 200                                           
      IF(LQ(2).NE.CC.AND.PRM1) WRITE(ITOUT,20002) (LQ(L),L=1,72)         
      GOTO 101                                                           
C                                                                        
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
C  ANALYSE LEFT-HAND SIDE OF CHEQ(ICEQ)                                  
C  SYNTAX:  RTERM ::= SPECIES ! SPECIES + ... + SPECIES                  
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
C                                                                        
102   ICEQ=ICEQ+1                                                        
      COTEST=.FALSE.                                                     
      ICOLLI=0                                                           
      IF(PRM2) WRITE(MOUT,8003) ICEQ,(LQ(L),L=1,72)                      
      IF(ICEQ.GT.MAXEQ) GOTO 10042                                       
      J=0                                                                
103   J=J+1                                                              
      IF(J.GT.LENGTH) CALL GET (LQ,J,SIG,II,*10001,*11015,KPRINT)        
      IF(LQ(J).EQ.BLANK) GOTO 103                                        
      IF(LQ(J).EQ.EQUAL) GOTO 108                                        
C                                                                        
      L=0                                                                
104   L=L+1                                                              
      KEY(L)=LQ(J)                                                       
      J=J+1                                                              
      IF(J.GT.LENGTH) CALL GET (LQ,J,SIG,II,*10001,*11015,KPRINT)        
      IF(LQ(J).NE.BLANK) GOTO 104                                        
      IF(NTB.EQ.0) GOTO 106                                              
C  CHECK FOR THIRD BODIES                                                
      DO 150 ITB=1,NTB                                                   
      IF(LENCO(ITB).NE.L) GOTO 150                                       
      DO 151 IL=1,L                                                      
      ILH=(ITB-1)*10 + IL                                                
151   IF(KEY(IL).NE.NAMETB(ILH)) GOTO 150                                
      IF(ICOLLI.NE.0) GOTO 10071                                         
      ICOLLI=ITB                                                         
      GOTO 107                                                           
150   CONTINUE                                                           
106   ISPOLD=ISP                                                         
      CALL HASH (OVERFL,SPLIST,KEY,L,ISP,INDEX,PP1,MAXSP,NAMEL,NA,       
     &           IW1,IW2,CW,PRM1,STORE)                                  
      IF(OVERFL) GOTO 999                                                
      IF(ISP.GT.ISPOLD) LSTOI=.FALSE.                                    
      LR(LRI)=INDEX                                                      
      LRI=LRI+1                                                          
      JSTOE=JSTOE-1                                                      
      IF(LRI.GT.MAXENT) GOTO 10044                                       
107   J=J+1                                                              
      IF(J.GT.LENGTH) CALL GET (LQ,J,SIG,II,*10001,*11015,KPRINT)        
      IF(LQ(J).EQ.BLANK) GOTO 107                                        
      IF(LQ(J).NE.PLUS) GOTO 108                                         
      J=J+1                                                              
      IF(J.GT.LENGTH) CALL GET (LQ,J,SIG,II,*10001,*11015,KPRINT)        
      IF(LQ(J).NE.BLANK) GOTO 10037                                      
      GOTO 103                                                           
C                                                                        
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
C  ANALYSE REACTION SYMBOL                                               
C  SYNTAX:  RSYMBL ::= => ! <=>                                          
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
C                                                                        
108   PLS(ICEQ)=LRI-1                                                    
      KSTOE=-JSTOE                                                       
      IF(LQ(J).NE.LESS) GOTO 109                                         
      REV=.TRUE.                                                         
      J=J+1                                                              
      IF(J.GT.LENGTH) CALL GET (LQ,J,SIG,II,*10001,*11015,KPRINT)        
109   IF(LQ(J).NE.EQUAL) GOTO 10037                                      
      J=J+1                                                              
      IF(J.GT.LENGTH) CALL GET (LQ,J,SIG,II,*10001,*11015,KPRINT)        
      IF(LQ(J).NE.GREAT) GOTO 10037                                      
      J=J+1                                                              
      IF(J.GT.LENGTH) CALL GET (LQ,J,SIG,II,*10001,*11015,KPRINT)        
      IF(LQ(J).NE.BLANK) GOTO 10037                                      
C                                                                        
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
C  ANALYSE RIGHT-HAND SIDE OF CHEQ(ICEQ)                                 
C  SYNTAX: RTERM ::= SPECIES ! SPECIES + ... + SPECIES                   
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
C                                                                        
      PR=LRI                                                             
110   J=J+1                                                              
      IF(J.GT.LENGTH) CALL GET (LQ,J,SIG,II,*10001,*11015,KPRINT)        
      IF(LQ(J).EQ.BLANK) GOTO 110                                        
      IF(LQ(J).EQ.PARL) GOTO 116                                         
      L=0                                                                
111   L=L+1                                                              
      KEY(L)=LQ(J)                                                       
      J=J+1                                                              
      IF(J.GT.LENGTH) CALL GET (LQ,J,SIG,II,*10001,*11015,KPRINT)        
      IF(LQ(J).NE.BLANK) GOTO 111                                        
      IF(NTB.EQ.0) GOTO 113                                              
C  CHECK FOR THIRD BODIES                                                
      DO 160 ITB=1,NTB                                                   
      IF(LENCO(ITB).NE.L) GOTO 160                                       
      DO 161 IL=1,L                                                      
      ILH=(ITB-1)*10 + IL                                                
161   IF(KEY(IL).NE.NAMETB(ILH)) GOTO 160                                
      LTB1=(ITB-1)*10 + 1                                                
      LTB2=ITB*10                                                        
      IF(ICOLLI.EQ.0) GOTO 10053                                         
      IF(ICOLLI.NE.ITB) GOTO 10053                                       
      COTEST=.TRUE.                                                      
      GOTO 114                                                           
160   CONTINUE                                                           
113   ISPOLD=ISP                                                         
      CALL HASH (OVERFL,SPLIST,KEY,L,ISP,INDEX,PP1,MAXSP,NAMEL,NA,       
     &           IW1,IW2,CW,PRM1,STORE)                                  
      IF(OVERFL) GOTO 999                                                
      IF(ISP.GT.ISPOLD) LSTOI=.FALSE.                                    
      LR(LRI)=INDEX                                                      
      LRI=LRI+1                                                          
      JSTOE=JSTOE+1                                                      
      IF(LRI.GT.MAXENT) GOTO 10044                                       
114   J=J+1                                                              
      IF(J.GT.LENGTH) CALL GET (LQ,J,SIG,II,*10001,*11015,KPRINT)        
      IF(LQ(J).EQ.BLANK) GOTO 114                                        
      IF(LQ(J).NE.PLUS) GOTO 115                                         
      J=J+1                                                              
      IF(J.GT.LENGTH) CALL GET (LQ,J,SIG,II,*10001,*11015,KPRINT)        
      IF(LQ(J).NE.BLANK) GOTO 10037                                      
      GOTO 110                                                           
115   IF(LQ(J).NE.PARL) GOTO 10037                                       
116   PRS(ICEQ)=LRI-1                                                    
C                                                                        
      IF(NTB.EQ.0) GOTO 120                                              
      IF(.NOT.COTEST .AND. ICOLLI.NE.0) GOTO 10055                       
C                                                                        
C  STOICHIOMETRIC BALANCE CHECK                                          
120   CONTINUE                                                           
      IF(IEL.EQ.0) GOTO 129                                              
      IF(.NOT.LSTOI) GOTO 129                                            
      IL1=IR2+1                                                          
      IL2=PLS(ICEQ)                                                      
      IR2=LRI-1                                                          
      DO 122 I=1,IEL                                                     
      IBAL(I)=0                                                          
      DO 122 L=IL1,IR2                                                   
      IH=LR(L)                                                           
      IF(L.GT.IL2) GOTO 121                                              
      IBAL(I)= IBAL(I) + SPEL(IH,I)                                      
      GOTO 122                                                           
121   IBAL(I)= IBAL(I) - SPEL(IH,I)                                      
122   CONTINUE                                                           
      DO 123 I=1,IEL                                                     
      IF(IBAL(I).NE.0) GOTO 124                                          
123   CONTINUE                                                           
      GOTO 125                                                           
124   IF(PRM1) WRITE(ITOUT,20005) ICEQ,(LQ(L),L=1,72),(IBAL(I),          
     &                            (ELEM(I,L),L=1,5),I=1,IEL)             
125   CONTINUE                                                           
C                                                                        
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
C  ANALYSE KINETIC PARAMETER                                             
C  SYNTAX:  KINPAR ::= (PAR1) ! (PAR1,PAR2) ! (PAR1,PAR2,PAR3)           
C           ( L1 =       1    !      2      !        3)                  
C           PAR1/2/3 ::= NON-NEGATIV REAL VALUE                          
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
C                                                                        
129   KPR1=0                                                             
130   L1=0                                                               
      IF(KPR1.EQ.1.AND.PRM2) WRITE(ITOUT,8009) (LQ(L),L=1,72)            
      KINPAR(1)=RKTEST                                                   
      KINPAR(2)=RKTEST                                                   
      KINPAR(3)=RKTEST                                                   
131   L=0                                                                
132   J=J+1                                                              
      IF(J.GT.LENGTH) CALL GET (LQ,J,SIG,II,*10001,*11015,KPRINT)        
      L=L+1                                                              
      CHAR=LQ(J)                                                         
      KEY(L)=CHAR                                                        
      IF(CHAR.NE.PARR.AND.CHAR.NE.COMMA) GOTO 132                        
      L1=L1+1                                                            
      L=L-1                                                              
      IF(L.LE.0) GOTO 133                                                
      CALL RNUM (KEY,1,L,KINPAR(L1),KFLAG)                               
      IF(KFLAG.EQ.1) GOTO 134                                            
      IF(KFLAG.NE.0) GOTO 10015                                          
133   IF(CHAR.NE.PARR) GOTO 131                                          
C                                                                        
C  PUSH KINETIC PARAMETER(S)                                             
134   CONTINUE                                                           
      IF(IGAS.EQ.7.AND.KINPAR(2).NE.RKTEST) KINPAR(1)=TEN**KINPAR(1)     
      IKIN=1                                                             
      GOTO (146,147,148) , L1                                            
147   IKIN=2                                                             
      IF(KINPAR(2).EQ.ZERO) IKIN=1                                       
      GOTO 146                                                           
148   IKIN=3                                                             
      IF(KINPAR(3).NE.ZERO) GOTO 149                                     
      IKIN=2                                                             
      IF(KINPAR(2).EQ.ZERO) IKIN=1                                       
      GOTO 146                                                           
149   IF(KINPAR(2).EQ.ZERO) IKIN=4                                       
C  USE LN( KINPAR(1) ) = LN(A) INTERNALLY                                
146   IF(IKIN.GT.1.AND.KINPAR(1).NE.RKTEST)KINPAR(1)=DLOG(KINPAR(1))     
CSP 146   IF(IKIN.GT.1.AND.KINPAR(1).NE.RKTEST)KINPAR(1)=ALOG(KINPAR(1)) 
      WRITE(HDS,9001) (KINPAR(L),L=1,3),ICOLLI,IKIN                      
      IF(TEMP.EQ.ZERO .AND. KINPAR(2).NE.RKTEST) GOTO 10073              
      IF(NTB.EQ.0.OR.ICOLLI.EQ.0) GOTO 138                               
      ICOTST(ICOLLI)=ICOTST(ICOLLI) + 1                                  
C                                                                        
C  CHECK FOR CORRECT TYP OF KINETIC PARAMETER(S)                         
138   DO 135 I=1,3                                                       
      IH=4-I                                                             
      IF(KINPAR(IH).NE.RKTEST) GOTO 136                                  
135   CONTINUE                                                           
      IF(PRM1) WRITE(ITOUT,20007) ICEQ                                   
      GOTO 139                                                           
136   IH=IH-1                                                            
      IF(IH.EQ.0) GOTO 139                                               
      IF(KINPAR(IH).EQ.RKTEST) GOTO 10057                                
      GOTO 136                                                           
C                                                                        
C  REACTION EQUATION SUCCESSFULLY ANALYSED                               
139   IF(.NOT.REV) GOTO 101                                              
      REV=.FALSE.                                                        
      L=LRI-1                                                            
      J1=MAXENT-LRI                                                      
      J2=LRI-PL                                                          
      IF(J1.LT.J2) GOTO 10044                                            
      ICEQ=ICEQ+1                                                        
      IF(ICEQ.GT.MAXEQ) GOTO 10042                                       
      JCEQ=ICEQ-1                                                        
      IF(PRM2) WRITE(MOUT,8005) ICEQ,JCEQ                                
      IF(L.LT.PR) GOTO 141                                               
140   LR(LRI)=LR(L)                                                      
      LRI=LRI+1                                                          
      L=L-1                                                              
      IF(L.GE.PR) GOTO 140                                               
141   PLS(ICEQ)=LRI-1                                                    
      IF(L.LT.PL) GOTO 143                                               
142   LR(LRI)=LR(L)                                                      
      LRI=LRI+1                                                          
      L=L-1                                                              
      IF(L.GE.PL) GOTO 142                                               
143   IR2=LRI-1                                                          
      PRS(ICEQ)=IR2                                                      
      KPR1=0                                                             
144   J=J+1                                                              
      IF(J.GT.LENGTH) CALL GET (LQ,J,SIG,II,*10001,*11015,KPR1)          
      IF(LQ(J).NE.PARL) GOTO 152                                         
      KPR1=1                                                             
      GOTO 130                                                           
152   IF(LQ(J).EQ.BLANK) GOTO 144                                        
      BACKSPACE CIN                                                      
      FJSTOE=DBLE(JSTOE)                                                 
CSP       FJSTOE=FLOAT(JSTOE)                                            
      U=KINPAR(1)                                                        
      IF(IKIN.EQ.1) U=DLOG(U)                                            
CSP       IF(IKIN.EQ.1) U=ALOG(U)                                        
C  KINETIC PARAMETERS FOR REVERSE REACTIONS (INTERNAL COMPUTATION)       
      KINPAR(1)=U + FJSTOE*RPATM                                         
      IF(KINPAR(2).EQ.RKTEST) KINPAR(2)=ZERO                             
      IF(KINPAR(3).NE.RKTEST) KINPAR(3)=KINPAR(3) + FJSTOE               
      IF(KINPAR(3).EQ.RKTEST) KINPAR(3)=FJSTOE                           
      NUM5=5                                                             
      LTHERM=.TRUE.                                                      
      WRITE(HDS,9001) (KINPAR(L),L=1,3),ICOLLI,NUM5                      
      GOTO 101                                                           
C                                                                        
C----------------------------------------------------------------------- 
C  CHEMICAL EQUATIONS ANALYSED                                           
C----------------------------------------------------------------------- 
C                                                                        
200   NCEQ=ICEQ                                                          
      NSP=ISP                                                            
      IF(.NOT.LSTOI.AND.PRM1) WRITE(ITOUT,20011)                         
C                                                                        
C  CHECK , IF PREVIOUSLY DEFINED THIRD BODIES APPEAR IN                  
C  REACTION SYSTEM                                                       
      NTBH=NTB                                                           
      IF(NTB.EQ.0) GOTO 213                                              
      DO 212 I=1,NTBH                                                    
      IF(ICOTST(I).GT.0) GOTO 211                                        
      L1=(I-1)*10 + 1                                                    
      L2=I*10                                                            
      IF(PRM1) WRITE(ITOUT,20021) (NAMETB(L),L=L1,L2)                    
      GOTO 212                                                           
211   CONTINUE                                                           
212   CONTINUE                                                           
C                                                                        
C  COMPUTE N (ACTUAL NUMBER OF DIFFERENTIAL EQUATIONS)                   
213   N=NSP                                                              
      IF(MODEL.GE.3) N=NSP+1                                             
      IF(MODEL.GE.5) N=NSP+2                                             
C                                                                                                                                               
C  CONSISTENCY CHECKS                                                    
      IZ=0                                                               
      DO 204 J=1,NSP                                                     
      IF(IW1(J)) 250,204,203                                             
203   IZ=IZ+1                                                            
      GOTO 204                                                           
C  GENERATION OF TRIVIAL DIFFERENTIAL EQUATION FOR SPECIES, WHICH        
C  APPEAR IN ACTUAL SPECIES LIST BUT NOT IN REACTION SYSTEM:             
C       SPECIES     =>                 (0.)                              
250   NCEQ=NCEQ+1                                                        
      IH0=0                                                              
      IH1=1                                                              
      WRITE(HDS,9001) ZERO,RKTEST,RKTEST,IH0,IH1                         
      LR(LRI)=J                                                          
      PLS(NCEQ)=LRI                                                      
      PRS(NCEQ)=LRI                                                      
      LRI=LRI+1                                                          
      L1=(J-1)*NAMEL + 1                                                 
      L2=J*NAMEL                                                         
      IF(PRM1) WRITE(ITOUT,20026) (CW(L),L=L1,L2),NCEQ,(CW(L),L=L1,L2)   
204   CONTINUE                                                                                                                                                                                                    
      IF(IZ.LE.0) GOTO 210                                               
      IF(PRM1) WRITE (ITOUT,20008) IZ                                    
      IF(.NOT.PRM2) GOTO 210                                             
      DO 205 J=1,NSP                                                     
      IF(IW1(J).LT.1) GOTO 205                                           
      JJ=(J-1)*NAMEL                                                     
      L1=JJ+1                                                            
      L2=JJ+NAMEL                                                        
      WRITE(MOUT,8012) (CW(L),L=L1,L2)                                   
205   CONTINUE                                                           
C                                                                        
C  PUSH ELEMENT LIST                                                     
210   WRITE(SIN,9007) IEL                                                
      IF(IEL.GT.0) WRITE(SIN,9008) ((ELEM(L,I),I=1,5),ATWS(L),L=1,IEL)   
      WRITE(SIN,9010) NSP                                                
      ATW=ZERO                                                           
C                                                                        
C----------------------------------------------------------------------- 
C  READ AND ANALYSE INITIAL CONCENTRATIONS                               
C  SYNTAX:  INITIAL CONCENTRATION ::= SPECIES VALUE                      
C           (VALUE ::= CONCENTRATION AT TSTART)                          
C----------------------------------------------------------------------- 
C                                                                        
C  CHECK, WHETHER MOLE FRACTIONS OR MOLAR CONCENTRATIONS ARE GIVEN       
C  (KFRAC=0 : MOLAR CONCENTRATIONS, KFRAC=1 : MOLE FRACTIONS)            
      KFRAC=0                                                            
      L=2                                                                
280   L=L+1                                                              
      IF(L.GT.72) GOTO 290                                               
      IF(LQ(L).EQ.PARL) LH1=L+1                                          
      IF(LQ(L).NE.PARR) GOTO 280                                         
      LH2=L-1                                                            
      IF(LH2.GE.LH1) CALL INUM (LQ,LH1,LH2,KFRAC,KFLAG)                  
      IF(KFRAC.EQ.1.AND.TEMP.EQ.ZERO) GOTO 10061                         
      IF(KFRAC.EQ.1.AND.SUMC0.EQ.ZERO) GOTO 10065                        
C                                                                        
290   LDTST=.FALSE.                                                      
      IF(PRM2) WRITE(MOUT,8010)                                          
      BN=.TRUE.                                                          
      SUMC=ZERO                                                          
      RHOH=ZERO                                                          
C  READ INITIAL CONCENTRATIONS                                           
300   READ(CIN,9000,END=11011) (LQ(L),L=1,72)                            
      ICOUNT=ICOUNT+1                                                    
      IF(LQ(1).NE.STAR) GOTO 301                                         
      IF(LQ(2).EQ.EE) GOTO 312                                           
      GOTO 11011                                                         
301   J=0                                                                
      IF(PRM2) WRITE(MOUT,8002) (LQ(L),L=1,72)                           
302   J=J+1                                                              
      IF(J.GT.72) GOTO 10046                                             
      IF(LQ(J).EQ.BLANK) GOTO 302                                        
C                                                                        
      L=0                                                                
303   L=L+1                                                              
      KEY(L)=LQ(J)                                                       
      J=J+1                                                              
      IF(J.GT.72) GOTO 10005                                             
      IF(LQ(J).NE.BLANK) GOTO 303                                        
      CALL HASH (OVERFL,SPLIST,KEY,L,ISP,INDEX,PP1,MAXSP,NAMEL,NA,       
     &           IW1,IW2,CW,PRM1,STORE)                                  
      IF(ISP.GT.NSP) GOTO 10048                                          
C                                                                        
C  ANALYSE REAL NUMBER FOR INITIAL CONCENTRATION                         
      CALL RNUM (LQ,J,72,X,KFLAG)                                        
      IF(KFLAG.LT.0) GOTO 10005                                          
      IF(KFRAC.EQ.1) X=SUMC0*X                                           
      SUMC=SUMC+X                                                        
      IF(X.NE.ZERO) BN=.FALSE.                                           
C                                                                        
C  PUSH ARRANGEMENT, NON ZERO INITIAL CONCENTRATIONS, MOLECULAR WEIGHT   
C  AND ELEMENT COMPOSITION                                               
      IW1(INDEX)=2                                                       
      JJ=(INDEX-1)*NAMEL                                                 
      L1=JJ+1                                                            
      L2=JJ+NAMEL                                                        
      IF(IEL.EQ.0) GOTO 311                                              
      ATW=ZERO                                                           
      DO 310 I=1,IEL                                                     
310   ATW=ATW+ATWS(I)*SPEL(INDEX,I)                                      
      WRITE(SIN,9002) INDEX,(CW(L),L=L1,L2),X,ATW,                       
     &                (SPEL(INDEX,I),I=1,IEL)                            
      IF(ATW.EQ.ZERO .AND. X.NE.ZERO) LDTST=.TRUE.                       
C  RHOH IS THE INTERNALLY COMPUTED DENSITY, USING INFORMATION FROM       
C  BLOCKS *ELEM... AND *SPEC...                                          
      RHOH=RHOH + ATW*X                                                  
      GOTO 300                                                           
311   WRITE(SIN,9003) INDEX,(CW(L),L=L1,L2),X                            
      GOTO 300                                                           
C                                                                        
C  PUSH ARRANGEMENT AND ZERO INITIAL CONCENTRATIONS                      
312   X=ZERO                                                             
      IF(BN.AND.PRM1) WRITE(ITOUT,20009)                                 
      DO 315 J=1,NSP                                                     
      IF(IW1(J).EQ.2) GOTO 319                                           
      JJ=(J-1)*NAMEL                                                     
      L1=JJ+1                                                            
      L2=JJ+NAMEL                                                        
      IF(IEL.EQ.0) GOTO 314                                              
      ATW=ZERO                                                           
      DO 313 I=1,IEL                                                     
313   ATW=ATW+ATWS(I)*SPEL(J,I)                                          
      WRITE(SIN,9002) J,(CW(L),L=L1,L2),X,ATW,(SPEL(J,I),I=1,IEL)        
      GOTO 315                                                           
314   WRITE(SIN,9003) J,(CW(L),L=L1,L2),X                                
319   IW1(J)=1                                                           
315   CONTINUE                                                           
C                                                                        
      IF(.NOT.PRM2) GOTO 400                                             
      WRITE(MOUT,8100)                                                   
      IF(IEL.EQ.0) WRITE(MOUT,8110)                                      
      IF(IEL.GT.0) WRITE(MOUT,8120) ((ELEM(I,L),L=1,5),I=1,IEL)          
      DO 318 J=1,NSP                                                     
      JJ=(J-1)*NAMEL                                                     
      L1=JJ+1                                                            
      L2=JJ+NAMEL                                                        
      IF(IEL.EQ.0) GOTO 317                                              
      ATW=ZERO                                                           
      DO 316 I=1,IEL                                                     
316   ATW=ATW+ATWS(I)*SPEL(J,I)                                          
      WRITE(MOUT,8130) J,(CW(L),L=L1,L2),ATW,(SPEL(J,I),I=1,IEL)         
      GOTO 318                                                           
317   WRITE(MOUT,8140) J,(CW(L),L=L1,L2)                                 
318   CONTINUE                                                           
C                                                                        
400   CONTINUE                                                           
      IF(DENSY.EQ.ZERO .AND. PRM2) WRITE(MOUT,8023) RHOH                 
      IF(DENSY.EQ.ZERO .AND. LDTST .AND. PRM1) WRITE(ITOUT,20010)        
C                                                                        
C  COMPUTE INITIAL PRESSURE, IF NOT GIVEN BY THE USER                    
      IF(PRESS.GT.ZERO) GOTO 410                                         
      X=GAS1*TEMP*SUMC                                                   
      IF(PRM2) WRITE(MOUT,8025) X                                        
      PRESS=X                                                            
      LMOD=MODEL.EQ.3.OR.MODEL.EQ.4                                      
      IF(PRESS.LE.ZERO.AND.LMOD) GOTO 10065                              
C  PUSH TEMPERATURE,PRESSURE,DENSITY AND GAS-CONSTANTS                   
410   IF(DENSY.EQ.ZERO) DENSY=RHOH                                       
      IF(DENSY.EQ.ZERO .AND. MODEL.GE.4) GOTO 10063                      
      IF(TEMP.EQ.ZERO) TEMP=TM60                                         
      WRITE(SIN,9017) TEMP                                               
      WRITE(SIN,9018) PRESS                                              
      WRITE(SIN,9019) DENSY                                              
      WRITE(SIN,9020) GAS1,GAS2,IGAS                                     
C                                                                        
C----------------------------------------------------------------------- 
C  ANALYSE THERMOCHEMICAL DATA                                           
C  (I.E. COEFFICIENTS FOR THE FOLLWING POLYNOMIALS)                      
C                                                                        
C  MOLAR HEAT CAPACITY FOR SPECIES K:                                    
C     CPK/GAS1 = A1K + ... + A5K*(TEMP**4)                               
C  MOLAR ENTHALPY FOR SPECIES K:                                         
C     HK/GAS1 = A1K*TEMP + ... + (A5K/5)*(TEMP**5) + A0K                 
C  MOLAR ENTROPY FOR SPECIES K:                                          
C     SK/GAS1 = A1K*LN(TEMP) + A2K*TEMP + ... + (A5K/4)*(TEMP**4) + S0K  
C                                                                        
C  FOR EACH SPECIES THE FOLLOWING COEFFICIENTS MUST BE GIVEN             
C  (IN THIS ORDER) :                                                     
C     A1KH  A2KH  A3KH  A4KH  A5KH  A0KH  S0KH                           
C     A1KL  A2KL  A3KL  A4KL  A5KL  A0KL  S0KL                           
C  FIRST DATA SET FOR HIGH TEMP. CASE (I.E. TEMP.GT.1000),               
C  SECOND FOR LOW TEMP. CASE (I.E. TEMP.LE.1000).                        
C                                                                        
C  SYNTAX ::=  SPECIES                                                   
C              5 REAL NUMBERS   FORMAT: 5E15.8                           
C              5 REAL NUMBERS   FORMAT: 5E15.8                           
C              4 REAL NUMBERS   FORMAT: 4E15.8                           
C                                                                        
C  FIRST, DATA IS READ FROM DATABASE 'CHEMIN'. IF COEFFICIENTS FOR ALL   
C  SPECIES ARE FOUND, NO FURTHER SEARCH IS STARTED, ELSE THE MISSING     
C  DATA IS SEARCHED FOR IN DATABASE 'THERMO'. HERE ONLY COEFFICIENTS     
C  FOR SPECIES ARE READ, WHICH ARE NOT ALREADY FOUND IN 'CHEMIN'.        
C                                                                        
C----------------------------------------------------------------------- 
C                                                                        
      ICO=0                                                              
      IF(.NOT.LTHERM.AND.PRM2) WRITE(MOUT,8031)                          
      IF(LTHERM) GOTO 499                                                
498   READ(CIN,9000,END=11003) CHAR1,CHAR2                               
      ICOUNT=ICOUNT+1                                                    
      IF(CHAR1.NE.STAR) GOTO 498                                         
      IF(CHAR2.EQ.NN) GOTO 602                                           
      GOTO 498                                                           
C  READ THERMOCHEMICAL DATA FROM DATA-BASE 'CHEMIN'                      
499   IF(PRM2) WRITE(MOUT,8029)                                          
      ICO=0                                                              
      STORE=.FALSE.                                                      
500   READ(CIN,9000,END=11003) (KEY(L),L=1,72)                           
      ICOUNT=ICOUNT+1                                                    
      IF(KEY(1).EQ.STAR.AND.KEY(2).EQ.NN) GOTO 600                       
      IF(KEY(1).NE.STAR) GOTO 501                                        
      IF(PRM1) WRITE(ITOUT,20002) (KEY(I),I=1,72)                        
      GOTO 500                                                           
501   KL=0                                                               
      J=1                                                                
502   KL=KL+1                                                            
      LQ(KL)=KEY(J)                                                      
      J=J+1                                                              
      IF(KEY(J).NE.BLANK) GOTO 502                                       
      CALL HASH (OVERFL,SPLIST,LQ,KL,ISP,INDEX,PP1,MAXSP,NAMEL,NA,IW1,   
     &           IW2,CW,PRM1,STORE)                                      
      IF(INDEX.GT.0) GOTO 504                                            
      READ(CIN,9033,END=11999)                                           
      ICOUNT=ICOUNT+3                                                    
      GOTO 500                                                           
504   IF(PRM2) WRITE(MOUT,8002) (LQ(L),L=1,KL)                           
      WRITE(HDS,9003) INDEX,(LQ(I),I=1,KL)                               
      IW1(INDEX)=3                                                       
      READ(CIN,9032,END=11999) (ECO(I),I=1,14)                           
      IF(PRM2) WRITE(MOUT,9032) (ECO(I),I=1,14)                          
      ICOUNT=ICOUNT+3                                                    
      DO 503 I=2,5                                                       
      IP7=I+7                                                            
      ECO(I)=ECO(I)/FJ(I)                                                
503   ECO(IP7)=ECO(IP7)/FJ(I)                                            
      WRITE(HDS,9032) ECO(6),(ECO(L),L=1,5),ECO(13),(ECO(L),L=8,12),     
     &                ECO(7),ECO(14)                                     
      ICO=ICO+1                                                          
      GOTO 500                                                           
C                                                                        
C  READ THERMOCHEMICAL DATA FROM DATA-BASE 'THERMO'                      
600   IF(PRM2) WRITE(MOUT,8030)                                          
      IF(ICO.EQ.NSP) GOTO 611                                            
      REWIND THDAT                                                  
616   READ(THDAT,9000,END=611) (KEY(L),L=1,72)                           
      KL=0                                                               
      J=1                                                                
614   KL=KL+1                                                            
      LQ(KL)=KEY(J)                                                      
      J=J+1                                                              
      IF(KEY(J).NE.BLANK) GOTO 614                                       
      CALL HASH (OVERFL,SPLIST,LQ,KL,ISP,INDEX,PP1,MAXSP,NAMEL,NA,IW1,   
     &           IW2,CW,PRM1,STORE)                                      
      IF(INDEX.GT.0) GOTO 615                                            
618   READ(THDAT,9033,END=611)                                           
      GOTO 616                                                           
615   IF(IW1(INDEX).EQ.3) GOTO 618                                       
      LH=(INDEX-1)*10                                                    
      DO 613 IH1=1,10                                                    
613   CN(IH1)=CW(LH+IH1)                                                 
      WRITE(HDS,9003) INDEX,(CN(L),L=1,10)                               
      IW1(INDEX)=3                                                       
      IF(PRM2) WRITE(MOUT,8002) (CN(L),L=1,10)                           
      READ(THDAT,9032,END=611) (ECO(L),L=1,14)                           
      IF(PRM2) WRITE(MOUT,9032) (ECO(L),L=1,14)                          
      DO 617 I=2,5                                                       
      IP7=I+7                                                            
      ECO(I)=ECO(I)/FJ(I)                                                
617   ECO(IP7)=ECO(IP7)/FJ(I)                                            
      WRITE(HDS,9032) ECO(6),(ECO(L),L=1,5),ECO(13),(ECO(L),L=8,12),     
     &                ECO(7),ECO(14)                                     
      ICO=ICO+1                                                          
      IF(ICO.EQ.NSP) GOTO 611                                            
      GOTO 616                                                           
C                                                                        
611   IF(ICO.EQ.NSP .OR. .NOT.LTHERM) GOTO 619                           
      IF(.NOT.PRM1) GOTO 619                                             
      WRITE(ITOUT,20027)                                                 
      DO 612 I=1,NSP                                                     
      IF(IW1(I).EQ.3) GOTO 612                                                        
      L1=(I-1)*10 + 1                                                    
      L2=I*10                                                            
      WRITE(ITOUT,8002) (CW(L),L=L1,L2)                                  
612   CONTINUE                                                           
619   IF(ICO.EQ.0 .AND. MODEL.GT.2) GOTO 10075                           
      IF(ICO.EQ.0 .AND. LTHERM) GOTO 10077                               
C                                                                        
C  CONSISTENCY-CHECK OF INITIAL DATA TO AGREE WITH IDEAL GAS-LAW         
C  ( ON A LEVEL OF TOL=1.E-3 )                                           
602   IF(PRESS.EQ.ZERO) GOTO 604                                         
      IF(TEMP.EQ.ZERO) GOTO 604                                          
      U=GAS1*SUMC*TEMP                                                   
      IF(U.EQ.ZERO) GOTO 604                                             
      X=DABS( (PRESS-U)/PRESS )                                          
CSP       X=ABS( (PRESS-U)/PRESS )                                       
      IF(X.GT.1.D-3 .AND. PRM1) WRITE(ITOUT,20022) PRESS,U               
      GOTO 605                                                           
604   IF(PRM1) WRITE(ITOUT,20023)                                        
C                                                                        
C  PUSH THIRD BODIES                                                     
605   CONTINUE                                                           
      REWIND HDS 
      WRITE(SIN,9028) NTB                                                
      IF(NTBH.EQ.0) GOTO 672                                             
      DO 670 I=1,NTBH                                                    
      IPEL=I+ELEML                                                       
      READ(HDS,9000) CHAR                                                
      M=ICOMPO(I)                                                        
      IF(M.LT.0) ICOMPO(I)=NSP                                           
      IC01=ICOTST(I)                                                     
      IF(IC01.LE.0) ICOMPO(I)=0                                          
      L1=(I-1)*10 + 1                                                    
      L2=I*10                                                            
      WRITE(SIN,9029) M,(NAMETB(L),L=L1,L2)                              
      IF(M.LE.0) GOTO 670                                                
      DO 671 IH=1,M                                                      
      READ(HDS,9027) INDEX,X                                             
      WRITE(SIN,9027) INDEX,X                                            
      SPEL(IH,IPEL)=INDEX                                                
671   CONTINUE                                                           
670   CONTINUE                                                           
672   CONTINUE                                                           
C                                                                        
C  PUSH NCEQ AND KINETIC PARAMETERS                                      
      WRITE(SIN,9012) NCEQ                                               
      DO 640 I=1,NCEQ                                                    
      READ(HDS,9060,END=660) (KINPAR(L),L=1,3)                           
      READ(HDS,9031,END=660) IW3(I),IW3(NCEQ+I)                          
640   WRITE(SIN,9060) (KINPAR(L),L=1,3)                                  
C                                                                        
C  PUSH IDENTIFIERS FOR THIRD-BODIES AND EVALUATION OF KINETIC PAR.      
      WRITE(SIN,9030) (IW3(L),L=1,NCEQ)                                  
      L1=NCEQ+1                                                          
      L2=NCEQ+NCEQ                                                       
      WRITE(SIN,9030) (IW3(L),L=L1,L2)                                   
C                                                                        
C  PUSH THERMOCHEMICAL DATA                                              
      WRITE(SIN,9014) ICO                                                
      IF(ICO.EQ.0) GOTO 655                                              
      ICO4=4*ICO                                                         
      DO 650 I=1,ICO4                                                    
      READ(HDS,8999) (KEY(L),L=1,80)                                     
650   WRITE(SIN,8999) (KEY(L),L=1,80)                                    
655   REWIND HDS 
C                                                                        
C  PUSH DIFFERENTIAL EQUATIONS IN SYMBOLIC FORM                          
660   NLR=LRI-1                                                          
      WRITE(SIN,9015) NLR                                                
      WRITE(SIN,9004) (PLS(L),L=1,NCEQ)                                  
      WRITE(SIN,9004) (PRS(L),L=1,NCEQ)                                  
      WRITE(SIN,9004) (LR(L),L=1,NLR)                                    
C                                                                        
      N1=N+1                                                             
      NSP1=NSP+1                                                         
C                                                                        
C  FROM HERE 'SPEL(.,.)' CONTAINS NO LONGER THE SPECIES LIST             
      DO 699 I=1,NSP                                                     
      DO 699 IH=1,ELEML                                                  
699   SPEL(I,IH)=0                                                       
C                                                                        
C----------------------------------------------------------------------- 
C  GENERATION (AND PUSH) OF SPARSE STRUCTURE OF JACOBIAN IN ROW-         
C  ORIENTED FORM                                                         
C----------------------------------------------------------------------- 
C                                                                        
      NMSP=N-NSP                                                         
C  MAXIMUM STORAGE ESTIMATION FOR JACOBIAN  
      ISUM=N                                                                       
      DO 1001 I=1,NSP                                                    
1001  IW1(I)=1                                                           
      IR2=0                                                              
      DO 1004 K=1,NCEQ                                                   
      IL1=IR2+1                                                          
      IL2=PLS(K)                                                         
      IK=IL2-IR2                                                         
      IH1=IW3(K)                                                         
      IR2=PRS(K)                                                         
      IF(IK.LE.0) GOTO 1004                                              
C     IM=0               WIRD ERST IN SCHLEIFE 1007 BENUTZT              
      DO 1003 I=IL1,IR2                                                  
      IH=LR(I)                                                           
      IF(IH1.NE.0) SPEL(IH,IH1)=1                                        
      IF(I.GT.IL2) GOTO 1002                                             
      IW1(IH)=IW1(IH)+IK-1                                               
      GOTO 1003                                                          
1002  IW1(IH)=IW1(IH)+IK                                                 
1003  CONTINUE                                                           
      ISUM=ISUM + IK*(IR2-IL1)                                           
1004  CONTINUE                                                                                                                     
      IF(NTB.EQ.0) GOTO 1732                                             
      ICCA=0                                                             
      DO 1731 I=1,NSP                                                    
      ICC=0                                                              
      DO 1730 IH1=1,NTBH                                                 
1730  ICC=ICC + SPEL(I,IH1)*ICOMPO(IH1)                                  
      ICCA=ICCA+ICC                                                      
1731  IW1(I)=IW1(I) + ICC                                                
      ISUM=ISUM + ICCA                                                   
1732  ISUM=ISUM + 2*NMSP*NSP + NMSP*NMSP                                 
      IF(ISUM.GT.NIW3) GOTO 10059                                        
      DO 1005 I=1,NSP                                                    
1005  IW1(I)=IW1(I)+NMSP                                                                           
C  UNSORTED/UNCONDENSED ROW ORIENTED JACOBIAN                            
      IW2(1)=1                                                           
      IW3(1)=1                                                           
      IH=1                                                               
      DO 1006 I=2,NSP                                                    
      IH=IH + IW1(I-1)                                                   
      IW2(I)=IH                                                          
1006  IW3(IH)=I                                                          
      IR2=0                                                              
      DO 1010 K=1,NCEQ                                                   
      IL1=IR2+1                                                          
      IL2=PLS(K)                                                         
      IK=IL2-IR2                                                         
      IR2=PRS(K)                                                         
      IF(IK.LE.0) GOTO 1010                                              
      IM=0                                                               
      DO 1007 M=IL1,IR2                                                  
      IM=IM+1                                                            
1007  IN(IM)=LR(M)                                                       
      DO 1009 I=1,IM                                                     
      IH=IN(I)                                                           
      JJ=IW2(IH)                                                         
      DO 1008 J=1,IK                                                     
      IF(I.EQ.J) GOTO 1008                                               
      JJ=JJ+1                                                            
      IW3(JJ)=IN(J)                                                      
1008  CONTINUE                                                           
      IW2(IH)=JJ                                                         
1009  CONTINUE                                                           
1010  CONTINUE                                                                                                                                                                     
C  THE PARTIAL DERIVATIVES DUE TO PRESENCE OF THIRD BODIES               
      IF(NTB.EQ.0) GOTO 1713                                             
      DO 1710 I=1,NSP                                                    
      JJ=IW2(I)                                                          
      DO 1711 IH1=1,NTBH                                                 
      IPEL=IH1+ELEML                                                     
      IF(SPEL(I,IH1).NE.1) GOTO 1711                                     
      INUMB=ICOMPO(IH1)                                                  
      IF(INUMB.EQ.0) GOTO 1711                                           
      IF(INUMB.EQ.NSP) GOTO 1714                                         
      DO 1712 IH2=1,INUMB                                                
      JJ=JJ+1                                                            
1712  IW3(JJ)=SPEL(IH2,IPEL)                                             
      GOTO 1711                                                          
1714  DO 1715 IH2=1,NSP                                                  
      JJ=JJ+1                                                            
1715  IW3(JJ)=IH2                                                        
1711  CONTINUE                                                           
      IW2(I)=JJ                                                          
1710  CONTINUE                                                           
C  THE LAST ONE OR TWO FULL COLUMNS FOR MODEL.GE.3                       
1713  IF(NMSP.EQ.0) GOTO 1750                                            
      DO 1011 I=1,NSP                                                    
      JJ=IW2(I)                                                          
      IW2(I)=IW2(I)+NMSP                                                 
      DO 1011 J=1,NMSP                                                   
      K=JJ+J                                                             
1011  IW3(K)=NSP+J                                                       
C                                                                                                                                        
C  SORTING/CONDENSING                                                    
C  ------------------                                                    
1750  IAI=1                                                              
      J2=0                                                               
      DO 1755 I=1,NSP                                                    
      J1=J2+1                                                            
      J2=IW2(I)                                                          
      IF(J1.EQ.J2) GOTO 1753                                             
      ITEST=J2                                                           
1751  JM=ITEST-1                                                         
      ITEST=0                                                            
      DO 1752 J=J1,JM                                                    
      IF(IW3(J).LE.IW3(J+1)) GOTO 1752                                   
      IH=IW3(J)                                                          
      IW3(J)=IW3(J+1)                                                    
      IW3(J+1)=IH                                                        
      ITEST=J                                                            
1752  CONTINUE                                                           
      IF(ITEST.NE.0) GOTO 1751                                           
1753  IW2(I)=IAI                                                         
      JJ=IW3(J1)                                                         
      IW3(IAI)=JJ                                                        
      IF(JJ.EQ.I) IW1(I)=IAI                                             
      IAI=IAI+1                                                          
1754  J1=J1+1                                                            
      IF(J1.GT.J2) GOTO 1755                                             
      IF(IW3(J1).EQ.JJ) GOTO 1754                                        
      JJ=IW3(J1)                                                         
      IW3(IAI)=JJ                                                        
      IF(JJ.EQ.I) IW1(I)=IAI                                             
      IAI=IAI+1                                                          
      GOTO 1754                                                          
1755  CONTINUE                                                                                            
C  ------------------                                                    
C  THE LAST ONE OR TWO FULL ROWS FOR MODEL.GE.3                          
      IF(NMSP.EQ.0) GOTO 1758                                            
      DO 1757 J=1,NMSP                                                   
      NSPJ=NSP+J                                                         
      IW2(NSPJ)=IAI                                                      
      IAI1=IAI-1                                                         
      DO 1756 K=1,N                                                      
1756  IW3(IAI1+K)=K                                                      
      IW1(NSPJ)=IAI1+NSPJ                                                
1757  IAI=IAI+N                                                          
1758  IW2(N1)=IAI                                                        
      NNZ=IAI-1                                                          
C                                                                        
C  PUSH SPARSE STRUCTURE
      WRITE(SIN,9016) NNZ 
      WRITE(SIN,9004) (IW3(L),L=1,NNZ)                                   
      WRITE(SIN,9004) (IW2(L),L=1,N1)                                    
      WRITE(SIN,9004) (IW1(L),L=1,N)                                   
C                                                                        
C----------------------------------------------------------------------- 
C  INTERPRETATION AND OUTPUT OF NUMERICAL INPUT                          
C----------------------------------------------------------------------- 
C                                                                        
910   T=ZERO                                                             
      ITP=1                                                              
      IF(PRM2) WRITE(MOUT,8018)                                          
      READ(CIN,9000,END=11999) CHAR1,CHAR2                               
      ICOUNT=ICOUNT+1                                                    
      IF(CHAR1.NE.STAR .OR. CHAR2.NE.DD) GOTO 11037                      
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
C  READ/PUSH IDENTIFIER FOR DISCRETISATION METHOD                        
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
C  SET DEFAULT VALUE                                                     
      IDISC=1                                                            
C                                                                        
      IF(PRM2) WRITE(MOUT,8021)                                          
      READ(CIN,9000,END=11999) (KEY(L),L=1,72)                           
      ICOUNT=ICOUNT+1                                                    
      IF(KEY(1).NE.STAR) GOTO 911                                        
      IF(PRM2) WRITE(MOUT,8032) IDISC                                    
      WRITE(SIN,9025) IDISC                                              
      IF(KEY(2).NE.AA) GOTO 11005                                        
      GOTO 912                                                           
911   IF(PRM2) WRITE(MOUT,8002) (KEY(L),L=1,72)                          
      CALL INUM (KEY,1,72,IDISC,KFLAG)                                   
      IF(KFLAG.NE.0) GOTO 10067                                          
      WRITE(SIN,9025) IDISC                                              
      READ(CIN,9000,END=11999) CHAR1,CHAR2                               
      ICOUNT=ICOUNT+1                                                    
      IF(CHAR1.NE.STAR .OR. CHAR2.NE.AA) GOTO 11005                      
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
C  READ/PUSH RELATIVE PRECISION                                          
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
C  SET DEFAULT VALUE                                                     
912   EPS=TENM3                                                          
C                                                                        
      IF(PRM2) WRITE(MOUT,8020)                                          
      READ(CIN,9000,END=11999) (KEY(L),L=1,72)                           
      ICOUNT=ICOUNT+1                                                    
      IF(KEY(1).NE.STAR) GOTO 913                                        
      IF(PRM2) WRITE(MOUT,8033) EPS                                      
      WRITE(SIN,9021) EPS                                                
      IF(KEY(2).NE.OO) GOTO 11007                                        
      GOTO 914                                                           
913   IF(PRM2) WRITE(MOUT,8002) (KEY(L),L=1,72)                          
      CALL RNUM (KEY,1,72,EPS,KFLAG)                                     
      IF(KFLAG.NE.0) GOTO 10017                                          
      WRITE(SIN,9021) EPS                                                
      READ(CIN,9000,END=11999) CHAR1,CHAR2                               
      ICOUNT=ICOUNT+1                                                    
      IF(CHAR1.NE.STAR .OR. CHAR2.NE.OO) GOTO 11007                      
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
C READ/PUSH OUTPUT POINTS                                                
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
914   IF(PRM2) WRITE(MOUT,8022)                                          
      READ(CIN,9000,END=11999) (KEY(L),L=1,72)                           
      ICOUNT=ICOUNT+1                                                    
      IF(PRM2) WRITE(MOUT,8002) (KEY(L),L=1,72)                          
      CALL INUM (KEY,1,72,ITP,KFLAG)                                     
      IF(KFLAG.NE.0) GOTO 10019                                          
      WRITE(SIN,9022) ITP                                                
      IF(PRM2) WRITE(MOUT,8024)                                          
      DO 920 I=1,ITP                                                     
      READ(CIN,9000,END=11999) (KEY(L),L=1,72)                           
      ICOUNT=ICOUNT+1                                                    
      IF(PRM2) WRITE(MOUT,8002) (KEY(L),L=1,72)                          
      IF(KEY(1).EQ.STAR) GOTO 11021                                      
      CALL RNUM (KEY,1,72,T,KFLAG)                                       
      IF(KFLAG.NE.0) GOTO 10021                                          
920   WRITE(SIN,9023) T                                                  
      READ(CIN,9000,END=11999) CHAR1,CHAR2                               
      ICOUNT=ICOUNT+1                                                    
      IF(CHAR1.NE.STAR .OR. CHAR2.NE.PP) GOTO 11009                      
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
C  READ/PUSH PRINT PARAMETER                                             
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
C  SET DEFAULT VALUE                                                     
      IPRINT=0                                                           
C                                                                        
      IF(PRM2) WRITE(MOUT,8028)                                          
      READ(CIN,9000,END=930) (KEY(L),L=1,72)                             
      ICOUNT=ICOUNT+1                                                    
      IF(PRM2) WRITE(MOUT,8002) (KEY(L),L=1,72)                          
      CALL INUM (KEY,1,72,IPRINT,KFLAG)                                  
      IF(KFLAG.NE.0) GOTO 10023                                          
      WRITE(SIN,9024) IPRINT                                             
      GOTO 950                                                           
930   IF(PRM2) WRITE(MOUT,8032) IPRINT                                   
      WRITE(SIN,9024) IPRINT                                             
C                                                                        
C----------------------------------------------------------------------- 
C                 NORMAL RETURN, NO ERROR                                
C ---------------------------------------------------------------------- 
C                                                                        
950   WRITE(ITOUT,9999)                                                  
      KFLAG=0                                                            
      RETURN                                                             
C                                                                        
C----------------------------------------------------------------------- 
C                     ERROR OUTPUT                                       
C----------------------------------------------------------------------- 
C                                                                        
10001 WRITE(ITOUT,10002) ERR1,ERR2,ICEQ,(SIG(L),L=1,72),(LQ(L),L=1,72)   
10002 FORMAT(//,2A8,/,' EQUATION ',I3,' INCORRECT SYNTAX',               
     & 2(/,1X,72A1),/)                                                   
      GOTO 999 
10003 WRITE(ITOUT,10004) ERR1,ERR2                                       
10004 FORMAT(//,2A8,/,' VALUE FOR PRESSURE INVALID',/)                   
      GOTO 999  
10005 WRITE(ITOUT,10006) ERR1,ERR2                                       
10006 FORMAT(//,2A8,/,' INITIAL CONCENTRATION INVALID',/)                
      GOTO 999
10007 WRITE(ITOUT,10008) ERR1,ERR2                                       
10008 FORMAT(//,2A8,/,' VALUE FOR TEMPERATURE INVALID',/)                
      GOTO 999                                                           
10009 WRITE(ITOUT,10010) ERR1,ERR2                                       
10010 FORMAT(//,2A8,/,' VALUE FOR UNIT SYSTEM INVALID',/)                
      GOTO 999 
10011 WRITE(ITOUT,10012) ERR1,ERR2,ELEML                                 
10012 FORMAT(//,2A8,/,' MORE THAN',I3,' THIRD BODIES DEFINED',/)         
      GOTO 999        
10013 WRITE(ITOUT,10014) ERR1,ERR2,MAXEL                                 
10014 FORMAT(//,2A8,/,' MORE THAN ',I4,' ELEMENTS',/)                    
      GOTO 999                                                           
10015 WRITE(ITOUT,10016) ERR1,ERR2,ICEQ                                  
10016 FORMAT(//,2A8,/,' KINETIC PARAMETER(S) IN EQUATION',I4,            
     &       ' INCORRECT',/)                                             
      GOTO 999                                                           
10017 WRITE(ITOUT,10018) ERR1,ERR2                                       
10018 FORMAT(//2A8,/,' VALUE FOR EPS INVALID',/)                         
      GOTO 999
10019 WRITE(ITOUT,10020) ERR1,ERR2                                       
10020 FORMAT(//2A8,/,' VALUE FOR NUMBER OF OUTPUT POINTS INVALID,'/)     
      GOTO 999                                                           
10021 WRITE(ITOUT,10022) ERR1,ERR2                                       
10022 FORMAT(//,2A8,/,' VALUE FOR AN OUTPUT POINT INVALID',/)            
      GOTO 999                                                           
10023 WRITE(ITOUT,10024) ERR1,ERR2                                       
10024 FORMAT(//,2A8,/,' VALUE FOR PRINT PARAMETER INVALID',/)            
      GOTO 999                                                           
10025 WRITE(ITOUT,10026) ERR1,ERR2                                       
10026 FORMAT(//,2A8,/,' VALUE FOR MODEL PARAMETER INVALID',/)            
      GOTO 999
10027 WRITE(ITOUT,10028) ERR1,ERR2                                       
10028 FORMAT(//,2A8,/,' MORE THAN ONE THIRD BODY EQUAL TO SUM OF',       
     &                ' ALL SPECIES DEFINED',/)                          
      GOTO 999  
10029 WRITE(ITOUT,10030) ERR1,ERR2                                       
10030 FORMAT(//,2A8,/,' VALUE FOR DENSITY INVALID',/)                    
      GOTO 999 
10031 WRITE(ITOUT,10032) ERR1,ERR2                                       
10032 FORMAT(//,2A8,/,' TOO MANY LINES FOR HEAD',/)                      
      GOTO 999                                                           
10033 WRITE(ITOUT,10034) ERR1,ERR2                                       
10034 FORMAT(//,2A8,/,' INVALID ATOMIC WEIGHT',/)                        
      GOTO 999                                                           
10035 WRITE(ITOUT,10036) ERR1,ERR2,(LQ(I),I=1,72),(KEY(I),I=1,L)         
10036 FORMAT(//,2A8,/,' INVALID SPECIES CARD:',/,1X,72A1,/,              
     &       ' UNKNOWN ELEMENT NAME FOUND: ',15A1)                       
      GOTO 999                                                           
10037 DO 10038 L=1,72                                                    
10038 SIG(L)=BLANK                                                       
      SIG(J)=ERR                                                         
      WRITE(ITOUT,10039) ICEQ,(LQ(L),L=1,72),(SIG(L),L=1,72)             
10039 FORMAT(' EQUATION ',I3,' INVALID ',/,2(' ',72A1,/))                
      GOTO 999                                                           
10042 WRITE(ITOUT,10043) ERR1,ERR2,MAXEQ                                 
10043 FORMAT(//,2A8,/,' MORE THAN ',I4,' EQUATIONS',/)                   
      GOTO 999                                                           
10044 WRITE(ITOUT,10045) ERR1,ERR2                                       
10045 FORMAT(//,2A8,/,' TABLE OVERFLOW ,ENLARGE MAXENT',/)               
      GOTO 999                                                           
10046 WRITE(ITOUT,10047) ERR1,ERR2                                       
10047 FORMAT(//,2A8,/,' BLANK LINE IN INPUT',/)                          
      GOTO 999                                                           
10048 WRITE(ITOUT,10049) ERR1,ERR2                                       
10049 FORMAT(//,2A8,/,' WRONG NAME IN INPUT OF INITIAL CONCENTRATIONS')  
      GOTO 999
10053 WRITE(ITOUT,10054) ERR1,ERR2,ICEQ,(NAMETB(L),L=LTB1,LTB2)          
10054 FORMAT(//,2A8,/,' WRONG USE OF THIRD BODY IN EQATION',I5           
     &   ,/,1X,10A1,' APPEARS ON RIGHT SIDE BUT NOT ON LEFT SIDE',/)     
      GOTO 999                                                           
10055 WRITE(ITOUT,10056) ERR1,ERR2,ICEQ,(NAMETB(L),L=LTB1,LTB2)          
10056 FORMAT(//,2A8,/,' WRONG USE OF THIRD BODY IN EQATION',I5           
     &   ,/,1X,10A1,' APPEARS ON LEFT SIDE BUT NOT ON RIGHT SIDE',/)     
      GOTO 999                                                           
10057 WRITE(ITOUT,10058) ERR1,ERR2,ICEQ                                  
10058 FORMAT(//,2A8,/,' (MODIFIED) ARRHENIUS TYP FOR RATE CONSTANT',     
     &' DECLARED,',/,' BUT A KINETIC PARAMETER IS MISSING IN',I3,/)      
      GOTO 999                                                           
10059 WRITE(ITOUT,10060) ERR1,ERR2                                       
10060 FORMAT(//,2A8,/,' INTEGER WORK SPACE EXHAUSTED; ENLARGE IW',/)     
      GOTO 999 
10061 WRITE(ITOUT,10062) ERR1,ERR2                                       
10062 FORMAT(//,2A8,/,' MISSING NON ZERO VALUE FOR TEMPERATURE',/)       
      GOTO 999 
10063 WRITE(ITOUT,10064) ERR1,ERR2                                       
10064 FORMAT(//,2A8,/,' MISSING NON ZERO VALUE FOR DENSITY',/)           
      GOTO 999                                                           
10065 WRITE(ITOUT,10066) ERR1,ERR2                                       
10066 FORMAT(//,2A8,/,' MISSING NON-ZERO VALUE FOR PRESSURE.',/)         
      GOTO 999                                                           
10067 WRITE(ITOUT,10068) ERR1,ERR2                                       
10068 FORMAT(//2A8,/,' VALUE FOR NUMBER OF DISCRETISATION METHOD',       
     &                ' INVALID',/)                                      
      GOTO 999                                                           
10069 WRITE(ITOUT,10070) ERR1,ERR2,NTB                                   
10070 FORMAT(//2A8,/,' WRONG SYNTAX IN DEFINITION OF THIRD BODY',I5,/)   
      GOTO 999                                                           
10071 WRITE(ITOUT,10072) ERR1,ERR2,ICEQ                                  
10072 FORMAT(//2A8,/,' MORE THAN ONE THIRD BODY USED IN EQ.',I5,/)       
      GOTO 999                                                           
10073 WRITE(ITOUT,10074) ERR1,ERR2,ICEQ                                  
10074 FORMAT(//,2A8,/,' (MODIFIED) ARRHENIUS TYP FOR RATE CONSTANT',     
     &       ' DECLARED,',/,' BUT TEMPERATURE VALUE IS MISSING',/)       
      GOTO 999                                                           
10075 WRITE(ITOUT,10076) ERR1,ERR2,MODEL                                 
10076 FORMAT(//,2A8,/,                                                   
     &' NO THERMOCHEMICAL DATA GIVEN BUT MODEL',I2,' POSTULATED.',/)     
      GOTO 999                                                           
10077 WRITE(ITOUT,10078) ERR1,ERR2                                       
10078 FORMAT(//,2A8,/,                                                   
     &' COMPUTATION OF REVERSE REACTION CONSTANTS NOT POSSIBLE',/,       
     &' BECAUSE OF MISSING THERMOCHEMICAL DATA.',/)                      
      GOTO 999 
10079 WRITE(ITOUT,10080) ERR1,ERR2,ICOUNT,(SIG(L),L=1,72),(LQ(L),L=1,72) 
10080 FORMAT(//,2A8,/,' LINE ',I3,' OF INPUT INCORRECT SYNTAX',          
     & 2(/,1X,72A1),/)                                                   
      GOTO 999          
C                                                                        
11001 WRITE(ITOUT,11002) ERR1,ERR2                                       
11002 FORMAT(//,2A8,/,' LINE ''*TEMP...'' IN INPUT MISSING',/)           
      GOTO 11999                                                                                                                                
11003 WRITE(ITOUT,11004) ERR1,ERR2                                       
11004 FORMAT(//,2A8,/,' LINE ''*NUME...'' IN INPUT MISSING',/)           
      GOTO 11999                                                         
11005 WRITE(ITOUT,11006) ERR1,ERR2                                       
11006 FORMAT(//,2A8,/,' LINE ''*ACCU...'' IN INPUT MISSING',/)           
      GOTO 11999                                                         
11007 WRITE(ITOUT,11008) ERR1,ERR2                                       
11008 FORMAT(//,2A8,/,' LINE ''*OUTP...'' IN INPUT MISSING',/)           
      GOTO 11999                                                         
11009 WRITE(ITOUT,11010) ERR1,ERR2                                       
11010 FORMAT(//,2A8,/,' LINE ''*PRIN...'' IN INPUT MISSING',/)           
      GOTO 11999                                                         
11011 WRITE(ITOUT,11012) ERR1,ERR2                                       
11012 FORMAT(//,2A8,/,' LINE ''*ENTH...'' IN INPUT MISSING',/)           
      GOTO 11999                                                         
11015 WRITE(ITOUT,11016) ERR1,ERR2                                       
11016 FORMAT(//,2A8,/,' LINE ''*INIT...'' IN INPUT MISSING',/)           
      GOTO 11999                                                         
11017 WRITE(ITOUT,11018) ERR1,ERR2                                       
11018 FORMAT(//,2A8,/,' LINE ''*SPECIES'' IN INPUT MISSING',/)           
      GOTO 11999 
11019 WRITE(ITOUT,11020) ERR1,ERR2                                       
11020 FORMAT(//,2A8,/,' LINE ''*DENSI..'' IN INPUT MISSING',/)           
      GOTO 11999     
11021 WRITE(ITOUT,11022) ERR1,ERR2                                       
11022 FORMAT(//,2A8,/,' INVALID LINE IN OUTPUT POINTS',/)                
      GOTO 999                                                   
11023 WRITE(ITOUT,11024) ERR1,ERR2                                       
11024 FORMAT(//,2A8,/,' LINE ''*REACT..'' IN INPUT MISSING',/)           
      GOTO 11999 
11025 WRITE(ITOUT,11026) ERR1,ERR2                                       
11026 FORMAT(//,2A8,/,' LINE ''*ELEM...'' IN INPUT MISSING',/)           
      GOTO 11999                                                     
11027 WRITE(ITOUT,11028) ERR1,ERR2                                       
11028 FORMAT(//,2A8,/,' LINE ''*GAS ...'' IN INPUT MISSING',/)           
      GOTO 11999 
11029 WRITE(ITOUT,11030) ERR1,ERR2                                       
11030 FORMAT(//,2A8,/,' LINE ''*MODEL..'' IN INPUT MISSING',/)           
      GOTO 11999                                                         
11031 WRITE(ITOUT,11032) ERR1,ERR2                                       
11032 FORMAT(//,2A8,/,' MODEL PARAMETER IN INPUT MISSING',/)             
      GOTO 11999                                                         
11033 WRITE(ITOUT,11034) ERR1,ERR2                                       
11034 FORMAT(//,2A8,/,' LINE ''*NAME...'' IN INPUT MISSING',/)           
      GOTO 11999                                                       
11035 WRITE(ITOUT,11036) ERR1,ERR2                                       
11036 FORMAT(//,2A8,/,' LINE ''*PRESS..'' IN INPUT MISSING',/)           
      GOTO 11999 
11037 WRITE(ITOUT,11038) ERR1,ERR2                                       
11038 FORMAT(//,2A8,/,' LINE ''*DISCR..'' IN INPUT MISSING',/)           
      GOTO 11999 
11039 WRITE(ITOUT,11040) ERR1,ERR2                                       
11040 FORMAT(//,2A8,/,' INVALID GROUPING IN INPUT FILE',/)               
      GOTO 999      
C                                                                        
11999 WRITE(ITOUT,11998)                                                 
11998 FORMAT(/,' INPUT DATASET INCOMPLETE',/)                            
      GOTO 999                                                           
C                                                                        
C----------------------------------------------------------------------- 
C                     ERROR RETURN                                       
C----------------------------------------------------------------------- 
C                                                                        
999   KFLAG=-1                                                           
      WRITE(ITOUT,9996) ICOUNT                                           
      WRITE(ITOUT,9997)                                                  
      RETURN                                                             
C                                                                        
C----------------------------------------------------------------------- 
C                      WARNINGS                                          
C----------------------------------------------------------------------- 
C                                                                        
20001 FORMAT(/' *** WARNING ***',/,' NO STOICHIOMETRIC BALANCE',         
     &        ' CHECK POSSIBLE',/)                                       
20002 FORMAT(/' *** WARNING ***',/,' INPUT LINE STARTS WITH ''*''',      
     &        ' LINE IGNORED',/,' ',72A1,/,                              
     &        ' PERHAPS ESSENTIAL LINE ''*.....'' MISSING',/)            
20003 FORMAT(/' *** WARNING ***',/,' ELEMENT NAME TRUNCATED TO',         
     &        I3,' DIGITS: ',5A1,/)                                      
20004 FORMAT(/' *** WARNING ***',/,' SPECIES CARD INCORRECT',/,          
     &        1X,72A1,/)                                                 
20005 FORMAT(/,' *** WARNING ***',/,' INCORRECT STOICHIOMETRIC IN',      
     &     ' EQUATION ',I4,/,1X,72A1,/,'  MISSING:',5(I5,1X,5A1),/,      
     &     10X,5(I5,1X,5A1),/)                                           
20006 FORMAT(/,' *** WARNING ***',/,' DOUBLY DEFINED SPECIES:',/,        
     &         2X,10A1,/)                                                
20007 FORMAT(/,' *** WARNING ***',/,' NO KINETIC PARAMETER(S) FOR',      
     &     ' EQUATION',I4,/,' RATE CONSTANT SET TO ZERO INTERNALLY',/)   
20008 FORMAT(/,' *** WARNING ***',/,I4,                                  
     &         ' SPECIES DETECTED IN REACTION MECHANISM WHICH ARE',/,    
     &         '     NOT IDENTIFIED IN SPECIESLIST',/)                   
20009 FORMAT(/,' *** WARNING ***',/,                                     
     &         ' NO NON-ZERO INITIAL CONCENTRATION FOUND',/)             
20010 FORMAT(/,' *** WARNING ***',/,                                     
     &         ' INTERNALLY COMPUTED DENSITY POSSIBLY WRONG BECAUSE',    
     &         ' OF INCOMPLETE',/,' ELEMENT- OR SPECIES-LIST',/)         
20011 FORMAT(/,' *** WARNING ***',/,                                     
     &         ' NO STOICHIOMETRIC BALANCE CHECK POSSIBLE BECAUSE OF',   
     &         ' INCOMPLETE',/,' SPECIES LIST.',/)                       
20021 FORMAT(/,' *** WARNING ***',/,                                     
     &         ' PREVIOUSLY DEFINED THIRD BODY ',10A1,                   
     &         ' DOES NOT APPEAR IN',/,' REACTION SYSTEM.',/)            
20022 FORMAT(/,' *** WARNING ***',/,                                     
     &         ' INITIAL DATA NOT CONSISTANT WITH IDEAL GAS-LAW',/,      
     &         ' PRESSURE     =',D21.12,/,                               
CSP      &         13H PRESSURE   =,E21.12,/,                            
     &         13H GAS*TEMP*C =,D21.12,/)                                
CSP      &         13H GAS*TEMP*C =,E21.12,/)                            
20023 FORMAT(/,' *** WARNING ***',/,                                     
     &         ' NO CONSISTENCY CHECK OF INITIAL DATA WITH IDEAL',       
     &         ' GAS-LAW POSSIBLE',/)
20024 FORMAT(/,' *** WARNING ***',/,                                     
     &         ' NAME OF THIRD BODY TOO LONG, TRUNCATED TO 10',          
     &          ' DIGITS.',/,' POSSIBLE LOSS OF UNIQUENESS.',/) 
20025 FORMAT(/,' *** WARNING ***',/,                                     
     &         ' SPECIES HAS NOT APPEARED IN SPECIES LIST:',2X,10A1,/)   
20026 FORMAT(/,' *** WARNING ***',/,                                     
     &    ' SPECIES ',10A1,' HAS APPEARED IN SPECIES LIST BUT',          
     &    ' NOT IN',/,' REACTION SYSTEM. TRIVIAL CHEMICAL EQUATION',     
     &   ' GENERATED:',/,I5,3X,10A1,10X,'=>',20X,'(0.)')   
20027 FORMAT(/,' *** WARNING ***',/,                                     
     &     ' NO THERMOCHEMICAL DATA FOUND FOR THE FOLLOWING SPECIES:'    
     &,/,  ' (ALL COEFFICIENTS INTERNALLY SET TO ZERO)')                 
C                                                                        
C----------------------------------------------------------------------- 
C                   FORMAT - LIST                                        
C----------------------------------------------------------------------- 
C                                                                        
8000  FORMAT(//,19X,' ACTUAL MODEL:',/,20X,13('-'),/)                    
8002  FORMAT(1X,72A1)                                                    
8003  FORMAT(I5,3X,72A1) 
8004  FORMAT(//,19X,' ELEMENT CARDS:',/,20X,14('-'),/)         
8005  FORMAT(I5,3X,'REVERSE REACTION OF',I5)
8006  FORMAT(//,19X,' SPECIES CARDS:',/,20X,14('-'),/)                   
8008  FORMAT(//,19X,' REACTION SYSTEM:',/,20X,16('-'),/)      
8009  FORMAT(' ANALYSE REACHES COLUMN 72, NEXT CARD USED AS',            
     &       ' CONTINUATION CARD:',/,1X,72A1)                                                 
8010  FORMAT(//,19X,' INITIAL CONCENTRATIONS:',/,20X,23('-'),/)          
8012  FORMAT(T5,6(2X,10A1))
8013  FORMAT(//,19X,' INITIAL DENSITY:',/,20X,16('-'),/,1X,72A1)         
8014  FORMAT(//,19X,' INITIAL PRESSURE:',/,20X,17('-'),/,1X,72A1)
8015  FORMAT(//,19X,' MODEL PARAMETER:',/,20X,16('-'),/,1X,72A1)   
8016  FORMAT(//,19X,' INITIAL TEMPERATURE:',/,20X,20('-'),/,1X,72A1)     
8017  FORMAT(//,19X,' UNIT SYSTEM:',/,20X,12('-'))                       
8018  FORMAT(//,19X,' NUMERICAL INPUT CARDS:',/,20X,22('-'),/)           
8019  FORMAT(//,19X,' THIRD BODIES:',/,20X,13('-'),/)                    
8020  FORMAT(/,' FOR REQUIRED RELATIVE ACCURACY:')                       
8021  FORMAT(/,' FOR DISCRETISATION METHOD:')                            
8022  FORMAT(/,' FOR NUMBER OF OUTPUT POINTS:')                          
8023  FORMAT(//,19X,' INITIAL DENSITY (INTERNALLY COMPUTED) :',/,        
     &          20X,39('-'),/,1X,D15.7)                                  
CSP      &          20X,39(1H-),/,1X,E15.7)
8024  FORMAT(/,' FOR VALUES OF OUTPUT POINTS:')  
8025  FORMAT(//,19X,' INITIAL PRESSURE (INTERNALLY COMPUTED) :',/,       
     &          20X,40('-'),/,1X,D15.7)                                  
CSP      &          20X,39(1H-),/,1X,E15.7)                                                    
8028  FORMAT(/,' FOR PRINT PARAMETER:')                                  
8029  FORMAT(//,19X,' THERMOCHEMICAL DATA:',/,20X,20('-'),//,            
     &              ' FROM DATA-BASE CHEMIN:',/)                         
8030  FORMAT(/,' FROM DATA-BASE THERMO:',/)                              
8031  FORMAT(//,' NO THERMOCHEMICAL DATA NEEDED')                        
8032  FORMAT(1X,I2,5X,' (INTERNALLY SET)')                               
8033  FORMAT(1X,D21.12,5X,' (INTERNALLY SET)')
8034  FORMAT(3X,I2)                                                      
8035  FORMAT(' GAS CONSTANTS USED : GAS1 = ',G12.4,/,                    
     &       22X,'GAS2 = ',G12.4)       
8100  FORMAT(//,19X,' *** SPECIES INFO ***',/)                           
8110  FORMAT(/,4X,' NO !     NAME   !')                                  
8120  FORMAT(/,4X,' NO !     NAME   ! MOLECULAR WEIGHT !  ELEMENT ',     
     &       'COMPOSITION',/,40X,5(1X,5A1),/,40X,5(1X,5A1))              
8130  FORMAT(4X,I4,2X,10A1,2X,D13.6,4X,5(I6),/,39X,5(I6))                
CSP 8130  FORMAT(4X,I4,2X,10A1,2X,E13.6,4X,5(I6),/,39X,5(I6))            
8140  FORMAT(4X,I4,2X,10A1,2X,D13.6)                                     
CSP 8140  FORMAT(4X,I4,2X,10A1,E13.6)   
C                                                                        
8999  FORMAT(80A1)                                                       
9000  FORMAT(72A1)                                                       
C  KINETIC PARAMETERS AND THIRD-BODY-IDENTIFIER                          
9001  FORMAT(3E24.14,/,2I5)                                              
CSP 9001  FORMAT(3D24.14,/,2I5)                                          
C  SPECIES INFORMATION                                                   
9002  FORMAT(I4,1X,10A1,1X,D21.12,1X,D21.12,1X,2(I8),/,8(I8))            
CSP 9002  FORMAT(I4,1X,10A1,1X,E21.12,1X,E21.12,1X,2(I8),/,8(I8))        
C  SPECIES INFORMATION (WITHOUT THE ELEMENT COMPOSITION)                 
9003  FORMAT(I5,1X,10A1,2X,D21.12)                                       
CSP 9003  FORMAT(I5,1X,10A1,2X,E21.12)                                   
C  POINTERS                                                              
9004  FORMAT(9I8)                                                        
C  HEAD IDENTIFIER                                                       
9005  FORMAT('*HEAD',14X,I5)                                             
C  MODEL IDENTIFIER                                                      
9006  FORMAT('*MODEL',13X,I5)                                            
C  ELEMENT IDENTIFIER                                                    
9007  FORMAT('*ELEMENTS',10X,I5)                                         
C  ELEMENT INFORMATION                                                   
9008  FORMAT(5A1,3X,D21.12)                                              
CSP 9008  FORMAT(5A1,3X,E21.12)                                          
C  SPECIES IDENTIFIER                                                    
9010  FORMAT('*SPECIES',11X,I5)                                          
C  KIN. PAR. IDENTIFIER                                                  
9012  FORMAT('*KINETIC PARAMETERS',I5)                                   
C  ENTHALPY COEFFICIENTS                                                 
9014  FORMAT('*ENTH.PAR.',9X,I5)                                         
C  IDENTIFIER FOR POINTERS OF FCN                                        
9015  FORMAT('*FCN',15X,I5)                                              
C  IDENTIFIER FOR POINTERS OF JACOBIAN                                   
9016  FORMAT('*JACOBI',12X,I5)                                           
C  TEMPERATURE                                                           
9017  FORMAT('*TEMPERATURE',7X,D21.12)                                   
CSP 9017  FORMAT('*TEMPERATURE',7X,E21.12)                               
C  PRESSURE                                                              
9018  FORMAT('*PRESSURE',10X,D21.12)                                     
CSP 9018  FORMAT('*PRESSURE',10X,E21.12)                                 
C  DENSITY                                                               
9019  FORMAT('*DENSITY',11X,D21.12)                                      
CSP 9019  FORMAT('*DENSITY',11X,E21.12)                                  
C  UNIVERSAL GAS CONSTANTS                                               
9020  FORMAT('*GAS CONSTANTS',5X,2D21.12,I3)                             
CSP 9020  FORMAT('*GAS CONSTANTS',5X,2E21.12,I3)                         
C  REQUIRED RELATIVE ACCURACY                                            
9021  FORMAT('*EPS:',14X,D21.12)                                         
CSP 9021  FORMAT('*EPS:',14X,E21.12)                                     
C  NUMBER OF OUTPUT POINTS WITH IDENTIFER                                
9022  FORMAT('*OUTPUT POINTS:',4X,I5)                                    
C  OUTPUT POINTS                                                         
9023  FORMAT(D21.12)                                                     
CSP 9023  FORMAT(E21.12)                                                 
C  PRINT PARAMETER                                                       
9024  FORMAT('*PRINTPARAM.:',6X,I5)                                      
C  DISCRETISATION IDENTIFIER                                             
9025  FORMAT('*DISCR.METHOD:',5X,I5)                                     
C  NAME OF THIRD BODY                                                    
9026  FORMAT('*THIRD BODY:',7X,10A1)                                     
C  INDEX/WEIGHTS OF THIRD BODY DEFINITION                                
9027  FORMAT(5X,I5,D21.12)                                               
9028  FORMAT('*THIRD BODIES:',5X,I5)                                     
9029  FORMAT('*NAME:',3X,I5,3X,10A1)                                     
9030  FORMAT(36I2)                                                       
9031  FORMAT(2I5)                                                        
9032  FORMAT(5D15.8,/,5D15.8,/,4D15.8)                                   
9033  FORMAT(//)                                                         
9060  FORMAT(3D24.14)                                                    
CSP 9060  FORMAT(3E24.14)                                                
C                                                                        
C                                                                        
9996  FORMAT(/,' COMPILATION STOPPED AT CARD',I6)                        
9997  FORMAT(//,9X,' ***** COMPILER ENDED DUE TO ERROR *****',/)         
9998  FORMAT(/,9X,' ***** COMPILER DIAGNOSTICS *****')                   
9999  FORMAT(//,9X,' ***** CHEMICAL INPUT SUCCESSFULLY COMPILED',        
     &       ' *****',/)                                                 
C                                                                        
C----------------------------------------------------------------------- 
C                 END COMPILER                                           
C----------------------------------------------------------------------- 
C                                                                        
      END  
      SUBROUTINE HASH (OVERFL,SPLIST,IN,L,ISP,IND,PP1,MAXSP,NAMEL,NN,    
     &                 FLAG,P,NAME,PRM1,STORE)                           
C                                                                        
C---------------------------------------------------------------------   
C  SUBROUTINE HASH CHECKS WETHER A GIVEN SPECIES NAME IS ALREADY         
C  CONTAINED IN ACTUAL NAME LIST. IF NOT A NEW SPECIES IS INSERTED.      
C  MOREOVER HASH RETURNS THE POINTERS ISP,IND AND FLAG(MAXSP).           
C---------------------------------------------------------------------   
C                                                                        
C DATE OF LATEST CHANGE: APRIL 27, '82                                   
C                                                                        
C                                                                        
      CHARACTER*1 IN(80), NAME(NN), BLANK                                
      INTEGER IABS,MOD,H,PH,PP1,PRIM                                     
C                                                                        
      LOGICAL OVERFL,SPLIST,PRM1,STORE                                   
C                                                                        
CI4       INTEGER FLAG(MAXSP) , P(PP1)                                   
      INTEGER*2 FLAG(MAXSP) , P(PP1)                                     
      INTEGER I,II,K                                                   
      INTEGER IH                                                         
C                                                                        
      INTEGER          ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT  
      COMMON / LUNIT / ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT
      SAVE /LUNIT/
C                                                                        
      DATA BLANK/' '/                                                    
C                                                                        
C                                                                        
      PRIM=PP1-1                                                         
C  HASHING FUNCTION                                                      
10    H=0                                                                
      DO 20 I=1,L                                                        
20    H=H+I*ICHAR(IN(I))                                                 
      H=MOD(IABS(H),PRIM)+1                                              
C  COMPARE NAME                                                          
      IF(L-NAMEL) 22,30,100                                              
22    L=L+1                                                              
      IN(L)=BLANK                                                        
30    PH=P(H)                                                            
      IF(PH.EQ.0) GOTO 50                                                
      II=(PH-1)*NAMEL                                                    
      DO 32 I=1,L                                                        
      IH=II+I                                                            
      IF(IN(I).NE.NAME(IH)) GOTO 40                                      
32    CONTINUE                                                           
C  NAME POSITION IDENTIFIED                                              
      IND=PH                                                             
      IF(SPLIST) RETURN                                                  
      IF(FLAG(IND).LT.0) FLAG(IND)=0                                     
      RETURN                                                             
C  COLLISION                                                             
40    H=H-1                                                              
      IF(H.EQ.0) H=PP1                                                   
      GOTO 30                                                            
C  COPY IN -> NAME(PH)                                                   
50    IF(STORE) GOTO 51                                                  
      IND=-1                                                             
      RETURN                                                             
51    II=ISP*NAMEL                                                       
      ISP=ISP+1                                                          
      IF(ISP.GT.MAXSP) GOTO 200                                          
      P(H)=ISP                                                           
      IND=ISP                                                            
      FLAG(ISP)=1                                                        
      IF(SPLIST) FLAG(ISP)=-1                                            
      DO 62 I=1,L                                                        
      IH=II+I                                                            
62    NAME(IH)=IN(I)                                                     
      RETURN                                                             
C                                                                        
C  ERROR HANDLING                                                        
100   IF(PRM1) WRITE(ITOUT,101) (IN(K),K=1,L)                            
      L=NAMEL                                                            
      GOTO 10                                                            
200   WRITE(ITOUT,201) MAXSP                                             
      OVERFL=.TRUE.                                                      
      RETURN                                                             
101   FORMAT(/,' *** WARNING ***',/,                                     
     &       ' NAME TRUNCATED TO 10 DIGITS: ',69A1,/)                    
201   FORMAT(/,' *** ERROR ***',/,                                       
     &       ' TABLE OVERFLOW: MORE THAN ',I3,' SPECIES',/)              
C                                                                        
C  END HASHING ROUTINE                                                   
C                                                                        
      END                                                                
      SUBROUTINE GET (IN,J,SAVE,FLLWGP,*,*,KPRINT)                       
C                                                                        
C---------------------------------------------------------------------   
C  SUBROUTINE GET READS CONTINUATION CARD                                
C---------------------------------------------------------------------   
C                                                                        
C DATE OF LATEST CHANGE: APRIL 27, '82                                   
C                                                                        
C                                                                        
      CHARACTER*1 IN(80),SAVE(80),FLLWGP,STAR,CC,EQUAL                   
C                                                                        
      INTEGER          ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT  
      COMMON / LUNIT / ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT  
C                                                                        
      COMMON / CCC / ICOUNT 
      SAVE /LUNIT/, /CCC/
C                                                                        
CI4       INTEGER I,L                                                    
      INTEGER*2 I,L                                                      
      DATA STAR/'*'/ , CC/'C'/ , EQUAL/'='/                              
C                                                                        
C  SAVE IN                                                               
      DO 10 I=1,72                                                       
10    SAVE(I)=IN(I)                                                      
C                                                                        
C  READ CONTINUATION CARD                                                
20    READ(CIN,9000,END=30) (IN(I),I=1,72)                               
      ICOUNT=ICOUNT+1                                                    
      J=1                                                                
      IF(IN(1).NE.STAR.AND.KPRINT.GE.1) WRITE(ITOUT,8002) (IN(L),L=1,72) 
      IF(IN(1).NE.STAR) RETURN                                           
      IF(IN(2).EQ.CC) GOTO 20                                            
      IF(FLLWGP.EQ.EQUAL) RETURN                                         
      IF(IN(2).NE.FLLWGP) GOTO 25                                        
      RETURN                                                             
C                                                                        
C  ERROR RETURN                                                          
25    RETURN 1                                                           
30    RETURN 2                                                           
C                                                                        
8002  FORMAT(' ANALYSE REACHES COLUMN 72, NEXT CARD USED AS',            
     &       ' CONTINUATION CARD:',/,1X,72A1)                            
9000  FORMAT(72A1)                                                       
C                                                                        
C  END SUBROUTINE GET                                                    
C                                                                        
      END                                                               
