/*----------------------------------------------------------------------------
    QRMat.h	QR decomposition by Householder reflections, Mar 18, 1992

    by Andreas Hohmann and Claudia Wulff, ZIB, Hohmann@sc.ZIB-Berlin.DE
-----------------------------------------------------------------------------*/

typedef struct {
    RealMat AUser;
    RealMat A, V, L;
    RealVec d, b;
    RealVec domainScale, imageScale;
    IntVec domainPivot;
    Real cond, condMax, det;
    Int p, m, n, signum;
} QRMat;

extern QRMat *NewQRMat(RealMat A, Int m, Int n);
extern void NewRank(QRMat *qrMat, Int p);
extern void FreeQRMat(QRMat *qrMat);

extern Bool QRDecompose(QRMat *qrMat);
extern Bool QRSolve(QRMat *qrMat, RealVec b, RealVec x);
extern void QRKernelBasis(QRMat *q, RealMat t);
extern Real QRLastResidual(QRMat *q);



