#define INCHTOCM 0.3937
#define CMTOINCH 2.54

#define PENSIZE 1
#define FONTSIZE 2
#define PENCOLOR 3

#define BLACK   0
#define WHITE   1
#define RED     2
#define GREEN   3
#define BLUE    4
#define CYAN    5
#define MAGENTA 6
#define YELLOW  7

#define SMALLSIZE 0
#define MEDIUMSIZE 1
#define BIGSIZE 2
 

struct GRAPHIC
  {
    REAL	maxBottom, maxLeft, maxTop, maxRight;
    REAL	bottom, left, top, right;
    REAL	rotX, rotY, rotZ;
    REAL	cutX1, cutY1, cutX2, cutY2;
	REAL	resolution, fontSize, lineWidth;
	int		boundary, level, triangulation, index, points,
			temperature, layer, ddd, cut, percentage, levels;
	REAL*	levelsAt;
	char*	caption;
  };
typedef struct GRAPHIC GRAPHIC;

struct DRIVER
  {
    PROC	Line, Arc, String, Fill, Settings, NewPict, Show,
			GetXY, GetRXY, OpenPort, Close;
	REAL	maxBottom, maxLeft, maxTop, maxRight;
	REAL	resolution, fontSize, lineWidth;
	int		fillingP, clippingP, colorsP, graysP, noOfColors,
	        noOfGrays, firstGray, windowNo;
	REAL	bottom, left, top, right;
	REAL	bottomMargin, leftMargin, topMargin, rightMargin;
	REAL	xScal, yScal, xTrans, yTrans;
	char	*fontName, *fileName;
	GRAPHIC *graph;
  };
typedef struct DRIVER DRIVER;

extern void DrawFrame(), DrawBound(), DrawTri(), DrawPoint(),
			DrawIndex(), DrawSol(), DrawTemp(), DrawCut(), Draw3D();
extern void ComputeScaling(), AutomaticRedraw();

extern DRIVER *actDriver;
extern GRAPHIC *actGraph;
