/*------------------------------------------------------------------------------

	  Sample.r	-  Resources for the Sample Application

	  Copyright Apple Computer, Inc. 1985-1987
	  All rights reserved.

------------------------------------------------------------------------------*/

#include "Types.r"

/* These define's are used in the MENU resources to disable specific
   menu items. */
#define AllItems	0b1111111111111111111111111111111	/* 31 flags */
#define MenuItem1	0b000000000001
#define MenuItem2	0b000000000010
#define MenuItem3	0b000000000100
#define MenuItem4	0b000000001000
#define MenuItem5	0b000000010000
#define MenuItem6	0b000000100000
#define MenuItem7	0b000001000000
#define MenuItem8	0b000010000000
#define MenuItem9	0b000100000000
#define MenuItem10	0b001000000000
#define MenuItem11	0b010000000000
#define MenuItem12	0b100000000000


resource 'WIND' (500, "Commands") {
	{50, 20, 300, 500},
	zoomDocProc, invisible, GoAway, 0x0, "Commands"
};

resource 'WIND' (501, "Graphic") {
	{16, 0, 768, 1016},
	noGrowDocProc, invisible, NoGoAway, 0x0, "Views"
};

resource 'WIND' (503, "Monitor") {
	{400, 20, 640, 200},
	noGrowDocProc, invisible, GoAway, 0x0, "Monitor"
};

resource 'MENU' (128, "Apple", preload) {
	128, textMenuProc,
	AllItems & ~MenuItem2,	/* Disable item #2 */
	enabled, apple,
	{
		"About Kaskade",
			noicon, nokey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain
	}
};

resource 'MENU' (129, "File", preload) {
	129, textMenuProc,
	AllItems & ~(MenuItem2),
	enabled, "File",
	{   "Do Command File",	noIcon, "D",	nomark, plain; /* 1 */
		"Edit File",		noIcon, nokey,	nomark, plain; /* 2 */
		"-",				noIcon, nokey,	nomark, plain;
		"Show Worksheet",	noIcon, "W",	nomark, plain; /* 4 */
		"Quit",				noIcon, "Q",	nomark, plain  /* 5 */
	}
};

resource 'MENU' (130, "Edit", preload) {
	130, textMenuProc,
	AllItems & ~(MenuItem1 | MenuItem2),	/* Disable items #1 & #2 */
	enabled, "Edit",
	 {
		"Undo",				noicon,	"Z",	nomark,	plain; /* 1 */
		"-",				noicon, nokey,	nomark,	plain; /* 2 */
		"Cut",				noicon, "X",	nomark,	plain; /* 3 */
		"Copy",				noicon,	"C",	nomark,	plain; /* 4 */
		"Paste",			noicon,	"V",	nomark,	plain; /* 5 */
		"Clear",			noicon,	nokey,	nomark,	plain; /* 6 */
		"-",				noicon, nokey,	nomark,	plain; /* 7 */
		"Select All",		noicon,	"A",	nomark, plain  /* 8 */
	}
};


resource 'MENU' (47) {
	47,
	textMenuProc,
	AllItems & ~( MenuItem4 | MenuItem9 ),
	enabled,
	"Selection",
	{	"Select Points",		noIcon, noKey,	noMark, plain,	/* [1] */
		"Select Edges",			noIcon, noKey,	noMark, plain,	/* [2] */
		"Select Triangles",		noIcon,	noKey,	"\$12", plain,	/* [3] */
		"-",					noIcon,	"",		"",		plain,	/* [4] */
		"Refine Red",			noIcon, "R",	noMark, plain,	/* [5] */
		"Refine Orange",		noIcon, noKey,	noMark, plain,	/* [6] */
		"Refine Blue",			noIcon,	noKey,	noMark,	plain,	/* [7] */
		"Delete Triangle",		noIcon, noKey,	noMark, plain,	/* [8] */
		"-",					noIcon,	"",		"",		plain,	/* [9] */
		"List",					noIcon, "L",	noMark, plain,	/*[10] */
		"Dump",					noIcon, "H",	noMark, plain,	/*[11] */
		"Loc Stiff Mat",		noIcon, noKey,	noMark, plain	/*[11] */
	}
};

resource 'MENU' (45) {
	45,
	textMenuProc,
	allEnabled,
	enabled,
	"Geometry",
	{	/* array: 5 elements */
		/* [1] */
		"Read", noIcon, "", "", plain,
		/* [2] */
		"Write", noIcon, "", "", plain,
		/* [3] */
		"Erase all", noIcon, "", "", plain,
		/* [4] */
		"List", noIcon, "", "", plain,
		/* [5] */
		"Dump", noIcon, "", "", plain
	}
};

resource 'MENU' (46) {
	46,
	textMenuProc,
	AllItems & ~( MenuItem7 | MenuItem10 ),
	enabled,
	"Graphics",
	{	"New Graphics Window",	noIcon,	"G",	noMark,	plain,	/* [1] */
		"Boundary",				noIcon, noKey,	noMark, plain,	/* [2] */
		"Triangulation",		noIcon, noKey,	noMark, plain,	/* [3] */
		"Points",				noIcon,	noKey,	noMark, plain,	/* [4] */
		"Level lines",				noIcon, noKey,	noMark, plain,	/* [5] */
		"Index",				noIcon, noKey,	noMark, plain,	/* [6] */
		"-",					noIcon,	"",		"",		plain,	/* [7] */
		"PostScript",			noIcon, "P",	noMark, plain,	/* [8] */
		"New PS-file",			noIcon, noKey,	noMark, plain,	/* [9] */
		"-",					noIcon,	"",		"",		plain,	/*[10] */
		"Zoom",					noIcon, "+",	noMark, plain,	/*[11] */
		"Reset Zoom",			noIcon, "-",	noMark, plain	/*[12] */
	}
};

resource 'MENU' (49) {
	49,
	textMenuProc,
	0x7FFFFFDF,
	enabled,
	"Monitor",
	{	"Basic data",			noIcon, noKey, noMark, plain,	/* [1] */
		"Triangulation data",	noIcon, noKey, noMark, plain	/* [2] */
	}
};

resource 'MENU' (48) {
	48,
	textMenuProc,
	allEnabled,
	enabled,
	"Solve",
	{	
		"Automatic",			noIcon, noKey,	noMark, plain,	/* [1] */
		"Direct",				noIcon, noKey,	noMark, plain,	/* [2] */
		"Next Level",			noIcon, "N",	noMark, plain,	/* [3] */
		"More Iterations",		noIcon, noKey,	noMark, plain,	/* [4] */
		"Error Estimate",		noIcon, noKey,	noMark, plain, 	/* [5] */
		"Quadratic",			noIcon, noKey,	noMark, plain 	/* [5] */
	}
};

type 'KASK' as 'STR ';

resource 'KASK' (0) {
	"Sample C Application - Version 2.0.2"
};

resource 'ICN#' (128, "Triangle") {
	{	/* array: 2 elements */
		/* [1] */
		$"0000 8000 0000 8000 0001 4000 0001 4000"
		$"0002 A000 0002 A000 0004 9000 0004 9000"
		$"0008 8800 0008 8800 0010 8400 0010 8400"
		$"0020 8200 0020 8200 0040 8100 0040 8100"
		$"0080 8080 00FF FF80 0140 8140 0121 4240"
		$"0221 4220 0212 2420 0412 2410 040C 1810"
		$"080F F808 0834 1608 1044 1104 1182 20C4"
		$"2202 2022 2C01 401A 5000 8005 7FFF FFFF",
		/* [2] */
		$"0000 8000 0000 8000 0001 C000 0001 C000"
		$"0003 E000 0003 E000 0007 F000 0007 F000"
		$"000F F800 000F F800 001F FC00 001F FC00"
		$"003F FE00 003F FE00 007F FF00 007F FF00"
		$"00FF FF80 00FF FF80 01FF FFC0 01FF FFC0"
		$"03FF FFE0 03FF FFE0 07FF FFF0 07FF FFF0"
		$"0FFF FFF8 0FFF FFF8 1FFF FFFC 1FFF FFFC"
		$"3FFF FFFE 3FFF FFFE 7FFF FFFF 7FFF FFFF"
	}
};

resource 'BNDL' (128) {
	'KASK',
	0,
	{
		'ICN#',
		{
			0, 128
		},
		'FREF',
		{
			0, 128
		}
	}
};

resource 'FREF' (128) {
	'APPL',
	0,
	""
};

resource 'wctb' (500,"text") {
	0x0,
	0,
	{	/* array ColorSpec: 5 elements */
		/* [1] */
		wContentColor, 65535, 65535, 48401,
		/* [2] */
		wFrameColor, 0, 0, 0,
		/* [3] */
		wTextColor, 0, 0, 0,
		/* [4] */
		wHiliteColor, 32267, 32267, 24201,
		/* [5] */
		wTitleBarColor, 48401, 48401, 36301
	}
};

resource 'wctb' (501,"plot") {
	0x0,
	0,
	{	/* array ColorSpec: 5 elements */
		/* [1] */
		wContentColor, 65535, 65535, 36301,
		/* [2] */
		wFrameColor, 0, 0, 0,
		/* [3] */
		wTextColor, 0, 0, 0,
		/* [4] */
		wHiliteColor, 32267, 32267, 0,
		/* [5] */
		wTitleBarColor, 48401, 48401, 24201
	}
};

resource 'wctb' (503,"monitor") {
	0x0,
	0,
	{	/* array ColorSpec: 5 elements */
		/* [1] */
		wContentColor, 48401, 65535, 65535,
		/* [2] */
		wFrameColor, 0, 0, 0,
		/* [3] */
		wTextColor, 0, 0, 0,
		/* [4] */
		wHiliteColor, 24201, 32267, 32267,
		/* [5] */
		wTitleBarColor, 36301, 48401, 48401
	}
};

resource 'wctb' (502,"alert") {
	0x0,
	0,
	{	/* array ColorSpec: 5 elements */
		/* [1] */
		wContentColor, 65535, 48401, 48401,
		/* [2] */
		wFrameColor, 0, 0, 0,
		/* [3] */
		wTextColor, 0, 0, 0,
		/* [4] */
		wHiliteColor, 32267, 24201, 24201,
		/* [5] */
		wTitleBarColor, 48401, 36301, 36301
	}
};

resource 'pltt' (501) {
	{
		0x0000, 0x0000, 0x0000, pmTolerant, 0, /*  [0] BLACK	*/
		0xffff, 0xffff, 0xffff, pmTolerant, 0, /*  [1] WHITE	*/
		0xdd6a, 0x08c2, 0x06a2, pmTolerant, 0, /*  [2] RED		*/
		0x0000, 0x8000, 0x11b0, pmTolerant, 0, /*  [3| GREEN	*/
		0x0000, 0x0000, 0xd400, pmTolerant, 0, /*  [4] BLUE		*/
		0x0240, 0xab54, 0xeafe, pmTolerant, 0, /*  [5] CYAN		*/
		0xf2d8, 0x0856, 0x84ec, pmTolerant, 0, /*  [6] MAGENTA	*/
		0xfc00, 0xf37c, 0x052e, pmTolerant, 0, /*  [7] YELLOW	*/
		0xbfff, 0xbfff, 0x8fff, pmTolerant, 0, /*  [8] HILITE	*/
		0x0000, 0x0000, 0x0000, pmTolerant, 0, /*  [9] GRAY  0	*/
		0x2600, 0x2600, 0x2600, pmTolerant, 0, /* [10] GRAY  1	*/
		0x3f00, 0x3f00, 0x3f00, pmTolerant, 0, /* [11] GRAY  2	*/
		0x4d00, 0x4d00, 0x4d00, pmTolerant, 0, /* [12] GRAY  3	*/
		0x5f00, 0x5f00, 0x5f00, pmTolerant, 0, /* [13] GRAY  4	*/
		0x6f00, 0x6f00, 0x6f00, pmTolerant, 0, /* [14] GRAY  5	*/
		0x7f00, 0x7f00, 0x7f00, pmTolerant, 0, /* [15] GRAY  6	*/
		0x8f00, 0x8f00, 0x8f00, pmTolerant, 0, /* [16] GRAY  7	*/
		0x9700, 0x9700, 0x9700, pmTolerant, 0, /* [17] GRAY  8	*/
		0x9f00, 0x9f00, 0x9f00, pmTolerant, 0, /* [18] GRAY  9	*/
		0xa600, 0xa600, 0xa600, pmTolerant, 0, /* [19] GRAY 10	*/
		0xab00, 0xab00, 0xab00, pmTolerant, 0, /* [20] GRAY 11	*/
		0xaf00, 0xaf00, 0xaf00, pmTolerant, 0, /* [21] GRAY 12	*/
		0xb400, 0xb400, 0xb400, pmTolerant, 0, /* [22] GRAY 13	*/
		0xb800, 0xb800, 0xb800, pmTolerant, 0, /* [23] GRAY 14	*/
		0xbc00, 0xbc00, 0xbc00, pmTolerant, 0, /* [24] GRAY 15	*/
		0xc000, 0xc000, 0xc000, pmTolerant, 0, /* [25] GRAY 16	*/
		0xc400, 0xc400, 0xc400, pmTolerant, 0, /* [26] GRAY 17	*/
		0xc800, 0xc800, 0xc800, pmTolerant, 0, /* [27] GRAY 18	*/
		0xcc00, 0xcc00, 0xcc00, pmTolerant, 0, /* [28] GRAY 19	*/
		0xd000, 0xd000, 0xd000, pmTolerant, 0, /* [29] GRAY 20	*/
		0xd400, 0xd400, 0xd400, pmTolerant, 0, /* [30] GRAY 21	*/
		0xd800, 0xd800, 0xd800, pmTolerant, 0, /* [31] GRAY 22	*/
		0xdc00, 0xdc00, 0xdc00, pmTolerant, 0, /* [32] GRAY 23	*/
		0xe000, 0xe000, 0xe000, pmTolerant, 0, /* [33] GRAY 24	*/
		0xe400, 0xe400, 0xe400, pmTolerant, 0, /* [34] GRAY 25	*/
		0xe800, 0xe800, 0xe800, pmTolerant, 0, /* [35] GRAY 26	*/
		0xec00, 0xec00, 0xec00, pmTolerant, 0, /* [36] GRAY 27	*/
		0xf000, 0xf000, 0xf000, pmTolerant, 0, /* [37] GRAY 28	*/
		0xf400, 0xf400, 0xf400, pmTolerant, 0, /* [38] GRAY 29	*/
		0xf800, 0xf800, 0xf800, pmTolerant, 0, /* [39] GRAY 30	*/
		0xffff, 0xffff, 0xffff, pmTolerant, 0  /* [40] GRAY 31	*/
	}
};
resource 'SIZE' (0) {
	dontSaveScreen,
	ignoreSuspendResumeEvents,
	enableOptionSwitch,
	cannotBackground,
	notMultiFinderAware,
	backgroundAndForeground,
	dontGetFrontClicks,
	ignoreChildDiedEvents,
	not32BitCompatible,
	reserved,
	reserved,
	reserved,
	reserved,
	reserved,
	reserved,
	reserved,
	4196304,
	393216
};
