
/**********************************************************************


This software module was originally developed by

Gerald Schuller (University of Hannover / ACTS-MoMuSys)

and edited by

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard. ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation. Copyright is not released for non MPEG-2
NBC/MPEG-4 Audio conforming products. ACTS-MoMuSys partners retain
full right to use the code for his/her own purpose, assign or donate
the code to a third party and to inhibit third party from using the
code for non MPEG-2 NBC/MPEG-4 Audio conforming products. This
copyright notice must be included in all copies or derivative works.

Copyright (c) 1997.


**********************************************************************/

#include <stdio.h>
#include <math.h>
#include <stddef.h>
#include <values.h>
/* #include "dct.h" */

#include "tf_main.h"

#include "ldfb.h"

#define Float double   /*mache alles in double precision*/ 
/*#define double float */       /* mache alles in float precision*/
/*int use_dolby_short_win=0;*/  /* def fuer compatibilitaet */


/***for delay = 2*N  ******/

#define addelay 0 /*additional delay for analysis in blocks */

#define max 1024  /* max size of N, the number of channels */
#define maxm 0 /* maximum number of bi-diagonal matrices C */
#define maxfb 5000 /*maximum number of unknown matrix entries, size(fb) */
#define maxn 4  /*maximum number of low delay matrices G */
#define maxc 2 /*maximum number of channels (stereo) */
#define MAX_CHANNELS 2








/*#include "sfb128lm2.dat"*/
extern double sfb128[maxfb];

#include "sfb1024lm2.dat"

#include "sfbiu1lm2.dat"

#include "sfbiu2lm2.dat"

#include "sfbid1lm2.dat"

#include "sfbid2lm2.dat"








void freq2timeaac(long channel_enable_mask, T2M_CHANNEL_INFO ch_info[MAX_CHANNELS])
{
long i,mask;
int ch,N,windowtype;
static int windowtypepre[MAX_CHANNELS]={2,2}, ort[MAX_CHANNELS]={1472,1472},aus[MAX_CHANNELS]={0,0};
Float in[max],*inp,*outp,*ylp,*yhp,sfbd1f_1024_128[maxfb],sfbu1f_1024_128[maxfb];
double *timep,*specp;
static Float           z[maxn*max*maxc]={0},  y[MAX_CHANNELS][3*max],xmem[MAX_CHANNELS][max];
static int windm[MAX_CHANNELS]={0,0};


/* sfbd1f_1024_128 */
ylp=&sfbid1[0];
yhp=&sfbd1f_1024_128[0];
for(i=0;i<1024;i++)
  *yhp++ = *ylp++;

for(i=0;i<448;i++)
  *yhp++ = 1.0;

ylp=&sfbid2[128];
for(i=0;i<64;i++)
  *yhp++ = *ylp++;

ylp=&sfbid1[1536];
for(i=0;i<1536;i++)
  *yhp++ = *ylp++;


/* sfbu1f_1024_128 */

ylp=&sfbiu1[0];
yhp=&sfbu1f_1024_128[0];
for(i=0;i<1024;i++)
  *yhp++ = *ylp++;

ylp=&sfbiu2[1024];
for(i=0;i<512;i++)
  *yhp++ = *ylp++;

ylp=&sfbiu1[1536];
for(i=0;i<1536;i++)
  *yhp++ = *ylp++;

mask=1;
for(ch=0; ch<MAX_CHANNELS; ch++)
   {
   if( (channel_enable_mask & mask) != 0) 
      {/*printf("channel %d \n",ch)*/;
/* 
      windowtype=windm[ch];
      windm[ch]=ch_info[ch].window_type;
      */

      windowtype=ch_info[ch].window_type;
      /*printf("windowtype= %d \n",windowtype);*/

      if(windowtype==1 || windowtype==2)
        N=128;
      else
        N=1024;

      /*type conversion to float */
      specp=ch_info[ch].p_spectrum;
      inp=in;
      for(i=0;i<1024;i++)
         { *inp++= (Float) *specp++;
         }

/* 0 normal, 1 start, 2 short , 3 stop window*/

      
      /*
      sffbmidv(out,sffb1024t128b255d,N,6,in,640,1,ch,z);
normal 1024 
        sffbmidv(out,sfb1024,1024,1024,1,in,3072,1,0,&z[max*maxn*ch]);
short 128 
        sffbmidv(out,sfb128,128,128,1,in,384,1,0,&z[max*maxn*ch]); 
switch up window 1
        sffbmidv(out,sfbiu1,128,1024,1,in,3072,1,0,&z[max*maxn*ch]);
switch up window 2
        sffbmidv(out,sfbiu2,1024,1024,1,in,3072,1,0,&z[max*maxn*ch]);
switch down window 1 
        sffbmidv(out,sfbid1,1024,128,1,in,3072,1,0,&z[max*maxn*ch]);
switch down window 2 
        sffbmidv(out,sfbid2,128,128,1,in,384,1,0,&z[max*maxn*ch]);
      */

      

if ((windowtype==0)||(windowtype==1)) /*normal 1024 bands*/
        {
        if(windowtypepre[ch]==3)  /*switch up window 2*/
          {
          sffbmidv(&y[ch][0],sfb1024,1024,1024,1,in,3072,1,0,&z[max*maxn*ch]);
          aus[ch]=0;
          }
        else  /* normal */
          {
          sffbmidv(&y[ch][0],sfb1024,1024,1024,1,in,3072,1,0,&z[max*maxn*ch]);
          aus[ch]=0;
          }
        }
      else {if (windowtypepre[ch]==1) /*switch down*/
        {
        sffbmidv(&y[ch][0],sfbd1f_1024_128,1024,128,1,in,3072,1,0,&z[max*maxn*ch]);
        sffbmidv(&y[ch][576],sfbid2,128,128,1,&in[128],384,1,0,&z[max*maxn*ch]);
        for(i=0;i<6;i++)   /*short*/
          sffbmidv(&y[ch][576+128+i*128],sfb128,128,128,1,&in[2*128+i*128],384,1,0,&z[max*maxn*ch]);
        ort[ch]=576+7*128;
        aus[ch]=0;
        }
      else {if (windowtype==3) /*switch up */
        {
        sffbmidv(&y[ch][ort[ch]],sfbu1f_1024_128,128,1024,1,in,3072,1,0,&z[max*maxn*ch]);
        if (ort[ch]>1024)
          {aus[ch]=1024;}
        else
          { aus[ch]=0;}
        ort[ch]=0;
        }
      else {if (windowtypepre[ch]==2) /*short 128 bands */
        {
        for(i=0;i<5;i++)
          {
          sffbmidv(&y[ch][ort[ch]],sfb128,128,128,1,&in[i*128],384,1,0,&z[max*maxn*ch]);
          ort[ch]=ort[ch]+128;
          }
        if (ort[ch]>1100)
          {
           yhp=&y[ch][2048];
           ylp=&y[ch][0];
           for(i=0;i<64;i++)
             *ylp++= *yhp++;

           ort[ch]=64;
           aus[ch]=1024;
          }
        else
          {aus[ch]=0;}
        for(i=0;i<3;i++)
          {
          sffbmidv(&y[ch][ort[ch]],sfb128,128,128,1,&in[5*128+i*128],384,1,0,&z[max*maxn*ch]);
          ort[ch]=ort[ch]+128;
          }
	}
      
      }}}




 
      windowtypepre[ch]=windowtype;

      /*type conversion to double */
      timep=ch_info[ch].p_time_signal;

      outp=&y[ch][aus[ch]];
      
      for(i=0;i<1024;i++)
         {*timep++ =(double) *outp++;
         }


      }
   mask=mask<<1;
   }
}



/******************* decoder MP4 interface ****************** */




void freq2bufferLDAAC(double *freqInPtr, /* input: interleaved spectrum */
		double *ftimeOutPtr, /* output: 1/2 block of new time values */
                double p_overlap[],
               WINDOW_TYPE blockType,	       /* input: block type 0-3 */
               int              nlong,            /* shift length for long windows   */
  int              nmed,             /* shift length for medium windows */
  int              nshort,           /* shift length for short windows  */
  Window_shape       wfun_select,      /* offers the possibility to select different window functions */
  Window_shape     wfun_select_prev, /* not used   HP 971113 */
  Imdct_out    	   overlap_select,    /* select imdct output *TK*	*/
 int              num_short_win  /* number of short windows to      */
                                     /* transform: not used!            */
        )	       /* input: channel number */
{
T2M_CHANNEL_INFO ch_info[MAX_CHANNELS];
long channel_enable_mask;
double	       transBuff[1024];
int i;
short ch=0;

/*printf("\n varminmp4lm2: freq2buffer, ch= %d, blockType= %d \n",ch,blockType);*/

ch_info[ch].p_time_signal= ftimeOutPtr; 
ch_info[ch].p_spectrum= freqInPtr;
ch_info[ch].window_type=blockType;
channel_enable_mask= 1<<ch;

freq2timeaac(channel_enable_mask, ch_info);


}


