
/**********************************************************************


This software module was originally developed by

Gerald Schuller (University of Hannover / ACTS-MoMuSys)

and edited by

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard. ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation. Copyright is not released for non MPEG-2
NBC/MPEG-4 Audio conforming products. ACTS-MoMuSys partners retain
full right to use the code for his/her own purpose, assign or donate
the code to a third party and to inhibit third party from using the
code for non MPEG-2 NBC/MPEG-4 Audio conforming products. This
copyright notice must be included in all copies or derivative works.

Copyright (c) 1997.


**********************************************************************/

#include "tf_main.h"
#include "ldfb.h"

extern int LDFB;




void freq2buffer(
  double           p_in_data[], 
  double           p_out_data[],
  double           p_overlap[],
  WINDOW_TYPE block_type,
  int              nlong,            /* shift length for long windows   */
  int              nmed,             /* shift length for medium windows */
  int              nshort,           /* shift length for short windows  */
  Window_shape     wfun_select,      /* offers the possibility to select different window functions */
  Window_shape wfun_select_prev,     /* HP 971113 */
  Imdct_out	   overlap_select,   /* select imdct output *TK*	*/
				     /* switch (overlap_select) {	*/
				     /* case OVERLAPPED:		*/
				     /*   p_out_data[]			*/
				     /*   = overlapped and added signal */
				     /*		(bufferlength: nlong)	*/
				     /* case NON_OVERLAPPED:		*/
				     /*   p_out_data[]			*/
				     /*   = non overlapped signal	*/
				     /*		(bufferlength: 2*nlong)	*/
  int              num_short_win     /* number of short windows to      */
                                     /* transform                       */
  )
{

if(LDFB==0) /*MDCT*/
  {
  freq2bufferMDCT(p_in_data,p_out_data,p_overlap, block_type,nlong,nmed,nshort,wfun_select, wfun_select_prev, overlap_select, num_short_win );
  }
  else /*Low Delay filter bank*/
  {
  if(nlong==2048)  /*Twin-VQ mode*/
    {
    freq2bufferLDTV(p_in_data,p_out_data,p_overlap, block_type,nlong,nmed,nshort,wfun_select, wfun_select_prev, overlap_select, num_short_win );
    }
  else   /*AAC mode */
    {
    freq2bufferLDAAC(p_in_data,p_out_data,p_overlap, block_type,nlong,nmed,nshort,wfun_select, wfun_select_prev, overlap_select, num_short_win );
    }
  }
}
