#!/bin/sh
#
# Installation script for the Tcl Plugin.
#
# This section will be used if Tcl and Tk are installed.
echo invoking wish to install the plugin...
wish -file .install.tk
if [ $? -eq 0 ]; then
    exit 0
else
    echo wish does not seem to be installed, or there was some error in
    echo using it. Do you want to run the shell-based installation? [yes]
    read answer
    if [ $answer ]; then
	silent=1
    else
	answer=yes
    fi
    if [ $answer != yes ]; then
	echo Not installing the Tcl Plugin, bye.
	exit 1
    fi
    /bin/rm -if install.log.*
fi
#
# Attempt to set up a log file
#
nameofuser=$USER
if [ $nameofuser ]; then
    silent=1
else
    set nameofuser `whoami`
fi
nameofhost=$HOSTNAME
if [ $nameofhost ]; then
    silent=1
else
    nameofhost=`hostname`
fi
whereami=`pwd`
uniquifier=`date +%b%d%j`.$nameofuser.$nameofhost
logFileName=$whereami/install.log.$uniquifier
loggingInstall=1
cat < /dev/null > $logFileName
if [ $? -eq 0 ]; then
    silent=1
else
    echo cannot create log file $logFileName
    echo please specify an alternative log file
    read answer
    if [ $answer ]; then
	logFileName=$answer
	cat < /dev/null > $logFileName
	if [ $? -eq 0 ]; then
	    silent=1
	else
	    echo cannot create log file $logFileName, not logging install
	    loggingInstall=0
	fi
    else
	echo not logging this install
	loggingInstall=0
    fi
fi
#
# Record the plugin distribution intended target and information about
# the system on which we're installing. This will allow us to quickly
# detect mismatches.
#
if [ $loggingInstall -eq 1 ]; then
    echo "Installing the plugin distribution for:" $nameofuser on $nameofhost \
		>> $logFileName
    echo "Plugin distribution for OS: " `cat ./targetOS` >> $logFileName
    echo "Installation system parameters:" `uname -a` >> $logFileName
fi
#
# This section will be used if Tcl and Tk are not installed.
#
onlytesting=0
staging=`pwd`
addlibtocsh=0
addobjtocsh=0
install_libs=1
cleanstage=0
siteinstall="private"
libdir=/usr/local/lib/
objdir=$HOME/.netscape/plugins
tclvernum="7.7"
tkvernum="4.3"
tcldirname=tcl
tkdirname=tk
tclversion=tcl7.7
tkversion=tk4.3
#
#
echo "           Welcome to the installation script for the"
echo "    Tcl plugin 1.1 Final Release for Netscape Navigator 3.0"
echo "    -------------------------------------------------------"
echo ""
echo "	Please view the license agreement in:"
echo ""
echo "		$staging/license.terms."
echo ""
echo "NOTE: In order to use this plugin, you must have Navigator 3.0"
echo "      installed. The plugin will not work with an older version of"
echo "      Navigator. Contact Netscape Communications Inc. or visit"
echo "      http://www.netscape.com/ to  obtain Navigator 3.0 for your"
echo "      specific platform."
echo ""
echo "Preamble: collecting information about where to install the plugin."
echo ""
echo "IMPORTANT: You can hit return for any question, to apply the default"
echo "           answer for that question. To answer a question positively"
echo "           use \"yes\" and for a negative answer use \"no\". The install"
echo "           script uses sh, so all  pathnames must be fully expanded,"
echo "           and no special characters should be used."
echo ""
siteinstall="private"
echo "Is this a site-wide or individual user installation? \n\
	[individual|site-wide, default=individual]"
read answer
if [ $answer ]; then
    siteinstall=$answer
fi
if [ $siteinstall = "site-wide" ]; then
    export tclversion
    export tkversion
    export staging
    export onlytesting
    export loggingInstall
    export logFileName
    export nameofhost
    export nameofuser
    export whereami
    sh .install-site.sh
    exit
fi
if [ $loggingInstall -eq 1 ]; then
    echo "Individual install:" 1.1 final $nameofuser $nameofhost `date` \
	>> $logFileName
fi
echo "Doing an installation for an individual user."
echo ""
echo "In  order  to operate  correctly, the  Tcl  Plugin  needs"
echo "access to its libraries, about 400K."
echo ""
libdir=$HOME/.tclplug
echo Where should I install the libraries? [$libdir]
read answer
if [ $answer ]; then
    libdir=$answer
fi
echo "	Will install libraries in $libdir."
if [ -d $libdir ]; then
    if [ $loggingInstall -eq 1 ]; then
	echo Directory $libdir exists, reusing >> $logFileName
    fi
    silent=1
else
    if [ -f $libdir ]; then
	if [ $loggingInstall -eq 1 ]; then
	    echo $libdir exists but is a file, aborting installation. >> $logFileName
	fi
	echo "	$libdir exists but is a file. Aborting installation."
	echo "	Log file is: $logFileName"
	exit 1
    else
	echo "	Making directory $libdir"
	if [ $loggingInstall -eq 1 ]; then
	    echo Making directory: $libdir >> $logFileName
	fi
	mkdir $libdir
	if [ $? -ne 0 ]; then
	    if [ $loggingInstall -eq 1 ]; then
	        echo Could not create directory, aborting: $libdir >> $logFileName
	    fi
	    echo "	mkdir $libdir failed, aborting installation."
	    echo "	Log file is: $logFileName"
	    exit 1
	fi
    fi
fi
if [ -d $libdir/html ]; then
    if [ $loggingInstall -eq 1 ]; then
	echo Directory $libdir/html exists, reusing >> $logFileName
        echo Making $libdir/html contents writable >> $logFileName
    fi
    chmod 644 $libdir/html/*
    chmod 777 $libdir/html
    /bin/rm -f $libdir/html/.licseen.txt
else
    if [ -f $libdir/html ]; then
        if [ $loggingInstall -eq 1 ]; then
	    echo $libdir/html exists but is a file, aborting installation. >> $logFileName
	fi
	echo "	$libdir/html exists but is a file."
	echo "	Aborting installation."
	echo "	Log file is: $logFileName"
	exit 1
    else
	if [ $loggingInstall -eq 1 ]; then
	    echo Making directory: $libdir/html >> $logFileName
	fi
	echo "	Making directory $libdir/html."
	chmod 777 $libdir/html
	mkdir $libdir/html
	if [ $? -ne 0 ]; then
	    if [ $loggingInstall -eq 1 ]; then
	        echo Could not create directory, aborting: $libdir/html >> $logFileName
	    fi
	    echo "	mkdir $libdir/html failed, aborting installation."
	    echo "	Log file is: $logFileName"
	    exit 1
	fi
    fi
fi
if [ -d $libdir/$tclversion ]; then
    if [ $loggingInstall -eq 1 ]; then
	echo Directory $libdir/$tclversion exists, reusing >> $logFileName
        echo Making $libdir/$tclversion contents writable >> $logFileName
    fi
    chmod 644 $libdir/$tclversion/*
else
    if [ -f $libdir/$tclversion ]; then
	if [ $loggingInstall -eq 1 ]; then
	    echo $libdir/$tclversion exists but is a file, aborting installation. >> $logFileName
	fi
	echo "	$libdir/$tclversion exists but is a file."
	echo "	Aborting installation."
	echo "	Log file is: $logFileName"
	exit 1
    else
	if [ $loggingInstall -eq 1 ]; then
	    echo Making directory: $libdir/$tclversion >> $logFileName
	fi
	echo "	Making directory $libdir/$tclversion."
	mkdir $libdir/$tclversion
	if [ $? -ne 0 ]; then
	    if [ $loggingInstall -eq 1 ]; then
	        echo Could not create directory, aborting: $libdir/$tclversion >> $logFileName
	    fi
	    echo "	mkdir $libdir/$tclversion failed, aborting installation."
	    echo "	Log file is: $logFileName"
	    exit 1
	fi
    fi
fi
if [ -d $libdir/$tkversion ]; then
    if [ $loggingInstall -eq 1 ]; then
	echo Directory $libdir/$tkversion exists, reusing >> $logFileName
        echo Making $libdir/$tkversion contents writable >> $logFileName
    fi
    chmod 644 $libdir/$tkversion/*
else
    if [ -f $libdir/$tkversion ]; then
	if [ $loggingInstall -eq 1 ]; then
	    echo $libdir/$tkversion exists but is a file, aborting installation. >> $logFileName
	fi
	echo "	$libdir/$tkversion exists but is a file."
	echo "	Aborting installation."
	echo "	Log file is: $logFileName"
	exit 1
    else
	if [ $loggingInstall -eq 1 ]; then
	    echo Making directory: $libdir/$tkversion >> $logFileName
	fi
	echo "	Making directory $libdir/$tkversion."
	mkdir $libdir/$tkversion
	if [ $? -ne 0 ]; then
	    if [ $loggingInstall -eq 1 ]; then
	        echo Could not create directory, aborting: $libdir/$tkversion >> $logFileName
	    fi
	    echo "	mkdir $libdir/$tkversion failed, aborting installation."
	    echo "	Log file is: $logFileName"
	    exit 1
	fi
    fi
fi
echo ""
if [ $libdir != $HOME/.tclplug ]; then
    addlibtocsh=1
    echo ""
    echo "For the plugin to function  properly, you will have to set an"
    echo "environment variable TCL_PLUGIN_DIR to  tell  Navigator where"
    echo "the Tcl plugin library  is  installed. If  you are using csh,"
    echo "I can add a line  to your .cshrc  to install  the environment"
    echo variable.
    echo ""
    echo "Do you want me to add the following line to your .cshrc? [yes]"
    echo ""
    echo "	setenv TCL_PLUGIN_DIR $libdir"
    echo ""
    read answer
    if [ $answer ]; then
	silent=1
    else
	answer=yes
    fi
    if [ $answer = yes ]; then
	if [ $loggingInstall -eq 1 ]; then
	    echo Will setenv TCL_PLUGIN_DIR $libdir in .cshrc >> $logFileName
	fi
	echo "	Will modify your .cshrc file."
    else
	echo "	OK, you will have to set this variable yourself."
	addlibtocsh=0
    fi
    echo ""
fi
if [ $NPX_PLUGIN_PATH ]; then
    if [ $loggingInstall -eq 1 ]; then
	echo Will install libtclplugin.so in $NPX_PLUGIN_PATH >> $logFileName
    fi
    echo "	You have \$NPX_PLUGIN_PATH set, its value is $NPX_PLUGIN_PATH."
    echo "	Will install plugin objects in $NPX_PLUGIN_PATH."
    objdir=$NPX_PLUGIN_PATH
else
    echo Where should I put the plugin shared library? [$HOME/.netscape/plugins]
    read answer
    if [ $answer ]; then
	objdir=$answer
    fi
    echo "	Will install plugin objects in $objdir."
    if [ -d $objdir ]; then
	if [ $loggingInstall -eq 1 ]; then
	    echo Directory $objdir found, reusing >> $logFileName
	fi
	silent=1
    else
        if [ -f $objdir ]; then
	    if [ $loggingInstall -eq 1 ]; then
	        echo $objdir exists but is a file, aborting >> $logFileName
	    fi
	    echo "	$objdir exists but is a file, not a directory"
	    echo "	Aborting installation."
	    echo "	Log file is: $logFileName"
	    exit 1
	else
	    if [ $loggingInstall -eq 1 ]; then
		echo Making directory $objdir >> $logFileName
	    fi
	    echo "	Making directory $objdir."
	    mkdir $objdir
	    if [ $? -ne 0 ]; then
		if [ $loggingInstall -eq 1 ]; then
		    echo Could not create directory, aborting: $objdir >> $logFileName
		fi
	        echo "	mkdir $objdir failed, aborting installation."
		echo "	Log file is: $logFileName"
	        exit 1
	    fi
	fi
    fi
    if [ $objdir != $HOME/.netscape/plugins ]; then
	addobjtocsh=1
	echo ""
	echo For the plugin to function properly, you  will have to set an
	echo environment variable NPX_PLUGIN_PATH to tell  Navigator where
	echo plugins are installed. If you are using csh, I can add a line
	echo to your .cshrc to install the environment variable.
	echo ""
	echo "Do you want me to add the following line to your .cshrc? [yes]"
	echo ""
	echo "	setenv NPX_PLUGIN_PATH $objdir"
	echo ""
	read answer
	if [ $answer ]; then
	    silent=1
	else
	    answer=yes
	fi
	if [ $answer = yes ]; then
	    if [ $loggingInstall -eq 1 ]; then
		echo Will setenv NPX_PLUGIN_PATH $objdir in .cshrc >> $logFileName
	    fi
	    echo "	Will modify your .cshrc file."
	else
	    echo "	OK, you will have to set this variable yourself."
	    addobjtocsh=0
	fi
    fi
fi
echo ""
echo "Summary:"
echo "	Installing from staging area $staging."
if [ $install_libs = 1 ]; then
    echo "	Will install plugin libraries in $libdir."
fi
echo "	Will install plugin objects in $objdir."
if [ $addobjtocsh = 1 ]; then
    echo "	Will add environment variable NPX_PLUGIN_PATH your .cshrc file."
fi
if [ $addlibtocsh = 1 ]; then
    echo "	Will add environment variable TCL_PLUGIN_DIR your .cshrc file."
fi
if [ $addobjtocsh = 1 ]; then
    echo "	Will back up existing .cshrc as .cshrc.preplug"
fi
if [ $addlibtocsh = 1 ]; then
    if [ $addobjtocsh -eq 0 ]; then
	echo "	Will back up existing .cshrc as .cshrc.preplug"
    fi
fi
echo ""
echo Please confirm that I should do this? [yes]
read answer
if [ $answer ]; then
    silent=1
else
    answer=yes
fi
if [ $answer = yes ]; then
    silent=1
else
    if [ $loggingInstall -eq 1 ]; then
	echo Installation aborted by user, goodbye >> $logFileName
    fi
    echo Installation aborted by user, goodbye.
    exit 1
fi
if [ $loggingInstall -eq 1 ]; then
    echo "" >> $logFileName
    echo Preparations completed, will install: >> $logFileName
    echo ------------------------------------- >> $logFileName
    echo "" >> $logFileName
    echo Installing from staging area $staging >> $logFileName
    echo Will install libraries in $libdir >> $logFileName
    echo Will install libtclplugin.so in $objdir >> $logFileName
    echo "" >> $logFileName
fi
echo ""
if [ $onlytesting = 1 ]; then
    echo only testing, goodbye
    exit 0
fi
echo "Second stage: installing...(This will take between one and five minutes)"
if [ $loggingInstall -eq 1 ]; then
    echo Copying libtclplugin.so to $objdir >> $logFileName
fi
cp -p $staging/libtclplugin.so $objdir
if [ $? -ne 0 ]; then
    if [ $loggingInstall -eq 1 ]; then
	echo Copy of libtclplugin.so to $objdir failed, aborting >> $logFileName
    fi
    echo "	Installing the plugin object failed, aborting."
    echo "	Log file is: $logFileName"
    exit 1
fi
if [ $install_libs = 1 ]; then
    if [ $loggingInstall -eq 1 ]; then
	echo Copying content of $staging/html to $libdir/html >> $logFileName
    fi
    cp -p $staging/html/* $libdir/html
    if [ $? -ne 0 ]; then
	if [ $loggingInstall -eq 1 ]; then
	    echo Copy of $staging/html failed, aborting >> $logFileName
	fi
	echo "	Installing the html pages failed, aborting."
	echo "	Log file is: $logFileName"
	exit 1
    fi
    if [ $loggingInstall -eq 1 ]; then
	echo Making content of $libdir/html non-writable >> $logFileName
    fi
    chmod 444 $libdir/html/*
    if [ $loggingInstall -eq 1 ]; then
	echo Copying content of $staging/$tclversion to $libdir/$tclversion >> $logFileName
    fi
    cp -p $staging/$tclversion/* $libdir/$tclversion
    if [ $? -ne 0 ]; then
	if [ $loggingInstall -eq 1 ]; then
	    echo Copy of $staging/$tclversion failed, aborting >> $logFileName
	fi
	echo "	Installing the Tcl Plugin library failed, aborting."
	echo "	Log file is: $logFileName"
	exit 1
    fi
    if [ $loggingInstall -eq 1 ]; then
	echo Making content of $libdir/$tclversion non-writable >> $logFileName
    fi
    chmod 444 $libdir/$tclversion/*
    if [ $loggingInstall -eq 1 ]; then
	echo Copying content of $staging/$tkversion to $libdir/$tkversion >> $logFileName
    fi
    cp -p $staging/$tkversion/* $libdir/$tkversion
    if [ $? -ne 0 ]; then
	if [ $loggingInstall -eq 1 ]; then
	    echo Copy of $staging/$tkversion failed, aborting >> $logFileName
	fi
	echo "	Installing the Tcl Plugin library failed, aborting."
	echo "	Log file is: $logFileName"
	exit 1
    fi
    if [ $loggingInstall -eq 1 ]; then
	echo Making content of $libdir/$tkversion non-writable >> $logFileName
    fi
    chmod 444 $libdir/$tkversion/*
fi
if [ $addobjtocsh = 1 ]; then
    if [ $loggingInstall -eq 1 ]; then
	echo backing up $HOME/.cshrc to $HOME/.cshrc.preplug >> $logFileName
    fi
    cp -p $HOME/.cshrc $HOME/.cshrc.preplug
fi
if [ $addlibtocsh = 1 ]; then
    if [ $addobjtocsh = 0 ]; then
	if [ $loggingInstall -eq 1 ]; then
	    echo backing up $HOME/.cshrc to $HOME/.cshrc.preplug >> $logFileName
	fi
	cp -p $HOME/.cshrc $HOME/.cshrc.preplug
    fi
fi
if [ $addobjtocsh = 1 ]; then
    if [ $loggingInstall -eq 1 ]; then
	echo setenv NPX_PLUGIN_PATH $objdir \>\> $HOME/.cshrc >> $logFileName
    fi
    echo setenv NPX_PLUGIN_PATH $objdir >> $HOME/.cshrc
    if [ $? -ne 0 ]; then
	if [ $loggingInstall -eq 1 ]; then
	    echo Adding NPX_PLUGIN_PATH to .cshrc failed, nonfatal >> $logFileName
	fi
	echo "	Adding NPX_PLUGIN_PATH to .cshrc failed, nonfatal."
    fi
fi
if [ $addlibtocsh = 1 ]; then
    if [ $loggingInstall -eq 1 ]; then
	echo setenv TCL_PLUGIN_DIR $libdir \>\> $HOME/.cshrc >> $logFileName
    fi
    echo setenv TCL_PLUGIN_DIR $libdir >> $HOME/.cshrc
    if [ $? -ne 0 ]; then
	if [ $loggingInstall -eq 1 ]; then
	    echo Adding TCL_PLUGIN_DIR to .cshrc failed, nonfatal >> $logFileName
	fi
	echo "	Adding TCL_PLUGIN_DIR to .cshrc failed, nonfatal."
    fi
fi
if [ $loggingInstall -eq 1 ]; then
    echo Installation from $staging complete, `date` >> $logFileName
fi
echo ""
echo "Installation from $staging completed successfully."
echo ""
echo "Third stage: cleanup."
echo ""
echo "I can now remove all the files in the staging area. If you want to"
echo "install multiple copies of the plugin from this staging area, e.g."
echo "for  different users  or multiple  machines on  your network, tell"
echo "me  to not remove these  files. If you do  not want to do any more "
echo "installations of the  plugin, you  can safely  answer \"yes\"  and I"
echo "will remove these files:"
echo ""
echo "Should I remove all files in the staging area, $staging? [no]"
read answer
if [ $answer ]; then
    silent=1
else
    answer=no
fi
if [ $answer = yes ]; then
    cleanstage=1
fi
if [ $cleanstage = 1 ]; then
    echo "	Please confirm that you want to remove all files and"
    echo "	directories in $staging [no]?"
    read answer
    if [ $answer ]; then
	silent=1
    else
	answer=no
    fi
    cleanstage=0
    if [ $answer = yes ]; then
	cleanstage=1
    fi
fi
if [ $cleanstage = 1 ]; then
    echo "Removing files...(This should take a minute)"
    rm -rf $staging
    rmdir $staging
    echo ""
fi
echo ""
echo "Do you wish to test the Tcl Plugin now? [yes]"
read answer
if [ $answer ]; then
   silent=1
else
   answer=yes
fi
if [ $answer = yes ]; then
   export logFileName
   sh .install-test.sh
   exit 0
fi
echo "All done, thanks for installing the Tcl Plugin!"
echo ""
echo "Please exit any copies of Navigator that are running now, and restart"
echo "Navigator 3.0. View the Help->About plug-ins menu item and verify that"
echo "the Tcl plugin is found by Netscape Navigator. If it appears in the"
echo "Installed plug-ins page, you can view the demos at the URL:"
echo "	http://www.sunlabs.com/tcl/plugin/index.html"
echo ""
echo "Comments, bug reports, questions --> email to jyl@eng.sun.com"
echo Please include the following log file in bug reports:
echo ""
echo "	$logFileName"
echo ""
exit
