/*
 * Decompiled with CFR 0.152.
 */
package Serpent;

import Serpent.Serpent_BitSlice;
import Serpent.Serpent_Properties;
import java.io.PrintWriter;
import java.security.InvalidKeyException;

public final class Serpent_Algorithm {
    static final String NAME = "Serpent_Algorithm";
    static final boolean IN = true;
    static final boolean OUT = false;
    static final boolean DEBUG = false;
    static final int debuglevel = 0;
    static final PrintWriter err = null;
    static final boolean TRACE = Serpent_Properties.isTraceable("Serpent_Algorithm");
    static final boolean USE_BIT_SLICE_IMPLEMENTATION = true;
    static final int BLOCK_SIZE = 16;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    static void debug(String string) {
        ((PrintWriter)null).println(">>> Serpent_Algorithm: " + string);
    }

    static void trace(boolean bl, String string) {
        if (TRACE) {
            ((PrintWriter)null).println(String.valueOf(bl ? "==> " : "<== ") + NAME + "." + string);
        }
    }

    static void trace(String string) {
        if (TRACE) {
            ((PrintWriter)null).println("<=> Serpent_Algorithm." + string);
        }
    }

    public static synchronized Object makeKey(byte[] byArray) throws InvalidKeyException {
        if (byArray == null) {
            throw new InvalidKeyException("Empty key");
        }
        if (byArray.length % 4 != 0 || byArray.length / 4 > 8) {
            throw new InvalidKeyException("Incorrect key length");
        }
        return Serpent_BitSlice.makeKey(byArray);
    }

    public static byte[] blockEncrypt(byte[] byArray, int n, Object object) {
        return Serpent_BitSlice.blockEncrypt(byArray, n, object);
    }

    public static byte[] blockDecrypt(byte[] byArray, int n, Object object) {
        return Serpent_BitSlice.blockDecrypt(byArray, n, object);
    }

    public static boolean self_test() {
        boolean bl = false;
        try {
            byte[] byArray = new byte[32];
            byte[] byArray2 = Serpent_Algorithm.fromEvenLengthString("00000003000000020000000100000000");
            Object object = Serpent_Algorithm.makeKey(byArray);
            byte[] byArray3 = Serpent_BitSlice.blockEncrypt(byArray2, 0, object);
            byte[] byArray4 = Serpent_BitSlice.blockDecrypt(byArray3, 0, object);
            bl = Serpent_Algorithm.areEqual(byArray2, byArray4);
            if (!bl) {
                throw new RuntimeException("Symmetric operation failed");
            }
            bl = Serpent_Algorithm.self_test(16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static int blockSize() {
        return 16;
    }

    private static boolean self_test(int n) {
        boolean bl = false;
        try {
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[16];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)n2;
                ++n2;
            }
            n2 = 0;
            while (n2 < 16) {
                byArray2[n2] = (byte)n2;
                ++n2;
            }
            Object object = Serpent_Algorithm.makeKey(byArray);
            byte[] byArray3 = Serpent_BitSlice.blockEncrypt(byArray2, 0, object);
            byte[] byArray4 = Serpent_BitSlice.blockDecrypt(byArray3, 0, object);
            bl = Serpent_Algorithm.areEqual(byArray2, byArray4);
            if (!bl) {
                throw new RuntimeException("Symmetric operation failed");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private static boolean areEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static int fromDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Invalid hex digit '" + c + "'");
    }

    private static String toString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = byArray[n2++];
            cArray[n3++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    public static String toReversedString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = n - 1;
        int n3 = 0;
        while (n2 >= 0) {
            byte by = byArray[n2--];
            cArray[n3++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] fromEvenLengthString(String var0) {
        var1_1 = var0.length();
        var2_2 = new byte[(var1_1 + 1) / 2];
        var3_3 = 0;
        if (var1_1 % 2 != 1) ** GOTO lbl7
        throw new IllegalArgumentException("string must have an even number of digits");
lbl-1000:
        // 1 sources

        {
            var2_2[var3_3++] = (byte)(Serpent_Algorithm.fromDigit(var0.charAt(--var1_1)) | Serpent_Algorithm.fromDigit(var0.charAt(--var1_1)) << 4);
lbl7:
            // 2 sources

            ** while (var1_1 > 0)
        }
lbl8:
        // 1 sources

        return var2_2;
    }

    public static void main(String[] stringArray) {
        Serpent_Algorithm.self_test(16);
        Serpent_Algorithm.self_test(24);
        Serpent_Algorithm.self_test(32);
    }
}

