#include <stdio.h>
#include "sql.h"

/*----------------------------------------------------------------*/
/*								  */
/*  Example of compiling and executing				  */
/*  an SQL statement in one function call			  */
/*								  */
/*----------------------------------------------------------------*/

int main( void ) {

SQLTCUR cur;		/* SQLBASE cursor number  */
SQLTRCD rcd;		/* return code		  */

static char ctbcmd[] =	/* CREATE TABLE command   */
"CREATE TABLE EMP (EMP_NAME CHAR(20), EMP_NO INTEGER, EMP_DOB REAL)";

  /*
  ** CONNECT TO THE DATABASE
  */
  if (rcd = sqlcnc(&cur, "SQLBASE", 0, NULL)) {
    printf("FAILURE ON CONNECT %d\n",rcd);
    exit(1);
  }
  else
    printf("Connection Established \n");

  /*
  ** COMPILE AND EXECUTE CREATE TABLE SQL STATEMENT
  */
  if (rcd = sqlcex(cur, ctbcmd, 0))
    printf("FAILURE ON COMPILE AND EXECUTE, rcd = %d\n",rcd);
  else
    printf("TABLE SUCCESSFULLY CREATED \n");

  /*
  ** DISCONNECT FROM THE DATABASE
  */

  if (rcd = sqldis(cur))
    printf("FAILURE ON DISCONNECT %d\n",rcd);
  else
    printf("Disconnect Performed \n");

  return( 0 );
}
